#ifndef XCMP_MSG_VOL_CTRL_H
#define XCMP_MSG_VOL_CTRL_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_vol_cntrl.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Volume Control XCMP message.  It contains
# all the definitions for this specific message.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified   	Tracking Number   Description
* Abhishek Trivedi       09/06/2013     CCMPD01827271     NL-XCMP Host
*
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
/* Opcode */
#define XCMP_MSG_OPCODE_REQUEST_VOL_CNTRL			0x0406
#define XCMP_MSG_OPCODE_REPLY_VOL_CNTRL				0x8406
#define XCMP_MSG_OPCODE_BROADCAST_VOL_CNTRL			0xB406

/* Message sizes */
#define MIN_VOL_CNTRL_RPLY_MSG_SIZE					6
#define MIN_VOL_CNTRL_RQST_MSG_SIZE					5

#define RADIO_VOLUME_CHANGE_MAX_STEPS				256
#define ACCY_VOLUME_CHANGE_MAX_STEPS				8

#define ACCY_VOLUME_ATTE_NUM_ALL_SPKR				0xFFFF

//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T          opcode;
  UINT16_T          attenuator_no;
  UINT8_T           function;
  UINT8_T           volume_data;
}xcmp_msg_volume_ctrl_request_msg_t;

typedef struct 
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T          opcode;
  UINT8_T           result;
  UINT16_T          attenuator_no;
  UINT8_T           function;
  UINT8_T           volume_data;
}xcmp_msg_volume_ctrl_reply_msg_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T          opcode;
  UINT16_T          attenuator_no;
  UINT8_T           volume_data;
  UINT8_T           audio_parameter;
}xcmp_msg_volume_ctrl_broadcast_msg_t;
#if __ICCAVR32__
#pragma pack()
#endif

typedef enum
{
	NO_FUNCTION			= 0x00,
	INCREMENT		        = 0x01,
	DECREMENT			= 0x02,
	MAX_VOLUME			= 0x03,
	MIN_VOLUME			= 0x04,
	SPECIFIED_VALUE			= 0x05,
	SET_INCR_SIZE			= 0x06,
	SET_MIN_USER_VOL		= 0x07,
	SET_ALERT_TONE_OFFSET		= 0x08,
	SET_MAX_USER_VOL		= 0x09,
	REPLY_CURR_VOL_SETTING		= 0x80,
	REPLY_STEPS_PER_INCR		= 0x86,
	REPLY_MIN_USER_VOL		= 0x87,
	REPLY_ALERT_TONE_OFFSET		= 0x88,
	REPLY_MAX_USER_VOL				
}volume_ctrl_func_t;

//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: xcmp_msg_tx_volume_control_request()

	DESCRIPTION: This function sends a Volume Control Request XCMP message .
=============================================================================*/
success_failure_t xcmp_msg_tx_volume_control_request(UINT16_T device_id, volume_ctrl_func_t function, UINT8_T vol_data, UINT8_T send_opt_param);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_volume_control_reply()

	DESCRIPTION: This function sends a Volume Control reply XCMP message.
=============================================================================*/
success_failure_t xcmp_msg_tx_volume_control_reply(UINT16_T device_id, xcmp_reply_result_t result, volume_ctrl_func_t function, UINT8_T volume_data, UINT8_T send_opt_param);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_volume_control_broadcast()

	DESCRIPTION: This function sends a Volume Control broadcast XCMP message.
=============================================================================*/
success_failure_t xcmp_msg_tx_volume_control_broadcast(UINT16_T device_id, UINT8_T volume_data, UINT8_T audio_parameter);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_volume_control_request()

	DESCRIPTION: This function processes the Volume Control Reply 
                     message received from the radio. 
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_volume_control_request(UINT16_T device_id, UINT8_T payload_length);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_volume_control_reply()

	DESCRIPTION: This function processes the Volume Control Reply 
                     message received from the radio. 
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_volume_control_reply(UINT16_T device_id, UINT8_T payload_length);

/* Description: This function receives Volume Control request message. It assumes that the Attenuator_Number is
 *				ALL_SPEAKER. The volume_data field in the message is ignored.
 * Parameters:
 *		function: Specifies the function being requested. See volume_ctrl_func_t.
*/
void received_xcmp_volume_control_msg_rqst(UINT16_T xnl_devid, xcmp_msg_volume_ctrl_request_msg_t vol_ctrl_req, UINT8_T payload_length);

/* Description: This function receives Volume Control reply message. It assumes that the Attenuator_Number is
 *				ALL_SPEAKER. 
 * Parameters:
 *		result: XCMP reply result code. See xcmp_reply_result_t.
 *				If result code is not XCMP_MSG_RESULT_SUCCESS, all other
 *				params should be 0 or NULL.
 *		function: Specifies the function being requested. See volume_ctrl_func_t.
 *		volume_data: Contains the current setting of the specified volume attenuator.
*/
void received_xcmp_volume_control_msg_rply(UINT16_T xnl_devid, xcmp_msg_volume_ctrl_reply_msg_t vol_ctrl_rply, UINT8_T payload_length);
#endif // XCMP_MSG_VOL_CNTRL_H

