#ifndef XNL_H 
#define XNL_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA SOLUTIONS CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xnl.h
#
# --------------------------- General Description -----------------------------
# 
# This file contains the user configurable options for the XNL stack. It is 
# important to understand how modifying the values in this file will affect
# overall system operation.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
#include "xnl_config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
*   AUTHOR              Date Modified         Tracking Number         Description
* Abhishek Trivedi      09/02/2013            CCMPD01827271       XNL Interfaces
* Abhishek Trivedi      11/8/2013             CCMPD01834482       Updates for XNL-XCMP 
* WRN637                01/22/2014            CCMPD01854392       Move XCMP related handling to HSP_XNL_XCMP_MANAGER_TASK to prevent multiple access to XCMP decoder at the same time    
* Abhishek Trivedi      03/18/2014	      CCMPD01873731	  Rework for XNL-XCMP 
* Abhishek Trivedi      04/18/2014            CCMPD01885148       System Ping Timeout
* Abhishek Trivedi      11/11/2014            CCMPD01945832       Edge of Range Support
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/
//------------------------------------------------------------------------------
//      PROTOCAL SPECIFIC DEFINES (User is discouraged to modifying these)
//------------------------------------------------------------------------------

// XNL messages host expects to receive
#define XNL_DEVICE_MASTER_QUERY_OPCODE_0003		0x0003
#define XNL_DEVICE_AUTH_KEY_REQUEST_OPCODE_0004	        0x0004
#define XNL_DEVICE_CONN_REQUEST_OPCODE_0006		0x0006
#define XNL_DEVICE_CONN_REQUEST_PAYLOAD                 0x000C
// XNL messages host sends out to device
#define XNL_MASTER_STATUS_BRDCST_OPCODE_0002	        0x0002
#define XNL_MASTER_STATUS_BRDCST_PAYLOAD		0x0007

#define XNL_DEVICE_AUTH_KEY_REPLY_OPCODE_0005	        0x0005
#define XNL_DEVICE_AUTH_KEY_REPLY_PAYLOAD		0x000A

#define XNL_DEVICE_CONN_REPLY_OPCODE_0007		0x0007
#define XNL_DEVICE_CONN_REPLY_PAYLOAD			0x000E

#define XNL_DEVICE_SYSMAP_REQUEST_OPCODE_0008           0x0008
#define XNL_DEVICE_SYSMAP_BRDCST_OPCODE_0009	        0x0009
#define XNL_DEVICE_SYSMAP_BRDCST_PAYLOAD		0x0002
#define XNL_SIZE_OF_SYSMAP				0x0001

#define XNL_DATA_MSG_OPCODE_000B	                0x000B
//Message Types
#define XNL_DATA_MSG_BRDCST                             0x00
#define XNL_DATA_MSG_REQUEST                            0x01
#define XNL_DATA_MSG_REPLY                              0x02
#define XNL_UNSUPPORTED_REQ                             0x03
#define XNL_DATA_MSG_RELAY                              0x04

#define TRANSACTION_ID_2ND_BYTE		                0x0001

#define XNL_DATA_MSG_ACK_OPCODE_000C                    0x000C
#define XNL_HEADER_SIZE			                12

#define XNL_MASTER_ADDRESS                              0x0001
#define XNL_PROTOCOL_VERSION_NUMBER                     0x01
#define XNL_ADDRESS_NOT_ASSIGNED                        0x0000
#define XNL_FLAGS_UNUSED                                0x00
#define XNL_TRANS_ID_NOT_REQUIRED                       0x0000
#define XNL_NO_PAYLOAD                                  0x0000
#define XNL_PROTO_XNL_CTRL                              0x00
#define XNL_PROTO_XCMP                                  0x01
#define XNL_MASTER_LOGICAL_IDENTIFIER                   0x0005
#define XNL_TEMP_ADDRESS                                0x8888
#define XNL_ADDRESS                                     0x0009

#define XNL_DATA_MSG_SENT                               0x01
#define XNL_ACK_ENABLE                                  0x00
#define XNL_ACK_DISABLE                                 0x01
#define XNL_LOGICAL_ADDRESS                             0xFF
#define XNL_SUCCESS                                     0x01
#define XNL_FAILURE                                     0x00
#define XNL_RX_FLAG_RESET                               0xFF
#define XNL_INVALID_ID                                  0xFF
#define XNL_MIN_ADDRESS                                 0x0002
#define XNL_MAX_ADDRESS                                 0x7FFF
#define XNL_FLAG_MAX_VALUE                              7
#define XNL_FLAG_MIN_VALUE                              0
#define XNL_FLAGS_ACK_NOT_REQUIRED                      0x08

// Timer values in milliseconds. Protocol defaults are listed below
#define XNL_TIMER_DATA_MESSAGE_ACK_VALUE                500 
#define XNL_TIMER_ENUM_DELAY                            1000

typedef enum
{
  WAITING_FOR_DEVICE_KEY_REQUEST_MSG = 0,
  WAITING_FOR_DEVICE_CONN_REQUEST_MSG = 1,
  XNL_INITIALIZATION_COMPLETE = 2,
  XCMP_OVER_XNL_MESSAGING = 3
} xnl_states_t;

typedef enum 
{
  WAITING_FOR_XNL_OPCODE_LO = 0,
  WAITING_FOR_XNL_OPCODE_HI = 1,
  WAITING_FOR_XNL_ADDRESSES = 2,
  WAITING_FOR_XNL_PAYLOAD_SIZE_LO = 3,
  WAITING_FOR_XNL_PAYLOAD_SIZE_HI = 4,
  WAITING_FOR_XNL_COMPLETE_PAYLOAD = 5
} device_state_t;

typedef struct 
{
  // Hardware overhead needed to ensure this
  // device only receives complete messages
  data_buffer_struct_t xnl_receive_buffer_glb;
  UINT8_T xnl_receive_array_glb[XNL_RX_BUFFER_SIZE];
  UINT16_T hw_payload_counter;
  UINT16_T hw_payload_size;
  UINT8_T hw_message_size;
  device_state_t hw_state;
  
  // Addresses
  UINT16_T address;
  
  // Transaction id
  UINT8_T  transaction_id_base;
  UINT8_T  transaction_id_counter;
  UINT16_T transaction_id;
  
  // Device type
  UINT8_T  device_type;
  
  // Transmit and receive flags
  UINT8_T  rx_flag;
  UINT8_T  tx_flag;
  
  // Authentication level
  UINT8_T  auth_level;
  
  // Number of complete messages to parse
  UINT16_T received_message_size;
  
  // Retry message info
  UINT16_T retry_message_size;
  UINT8_T  *retry_buffer_ptr;
  UINT8_T  retry_counter;
  
  // Features enabled/disabled
  BOOL_T   is_ack_feature_enabled;
  BOOL_T   is_xnl_authentication_complete;
  BOOL_T   is_xcmp_authentication_complete;
  BOOL_T   is_ack_pending;
  
  // State
  xnl_states_t state;
  UINT8_T retry_buffer_data[XNL_TX_BUFFER_SIZE];
  UINT8_T xnl_transmit_array_glb[XNL_TX_BUFFER_SIZE];
  UINT8_T xnl_relay_array_glb[XNL_RELAY_BUFFER_SIZE];
  UINT8_T xnl_ack_array[XNL_HEADER_SIZE];
} xnl_device_struct_t;

typedef enum
{
  TX_BUSY,
  TX_SUCCESS,
  TX_FAILURE
}tx_result_t;
// Error code meanings
typedef enum
{
  XNL_CONNECTION_ERROR,       // 5 XNL retries were exhausted, likely caused by a hardware connection issue
  XNL_RECEIVE_OVERFLOW_ERROR, // The hardware layer passed too many bytes at once, overflowing the receive buffer
  XNL_INVALID_PARAMETER,      // Error resulting in a passing of an invalid parameter
  XNL_MEMORY_ALLOC_ERROR,      // Unable to malloc the required bytes needed
  XNL_INIT_ERROR,
  XNL_TOO_MANY_CONNECTIONS
} xnl_error_type_t;

typedef struct  
{
  BOOL_T is_ack_feature_required;
  UINT8_T auth_level;
  // add more here (i.e. device types for XCMP)
} xnl_init_parameters_t;

extern xnl_device_struct_t *xnl_device[];
//------------------------------------------------------------------------------
//    PUBLIC FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
success_failure_t xnl_send_data_msg(UINT16_T xnl_devid, const UINT8_T *payload_data_ptr, const UINT16_T payload_length, UINT8_T msg_type);
void xnl_init_component(void);
void xnl_state_machine(const UINT16_T xnl_devid);
void xnl_set_device_ack_feature(UINT16_T xnl_devid, BOOL_T flag);
UINT16_T xnl_xcmp_new_device_register (xnl_init_parameters_t device_param);
UINT8_T xnl_get_device_index_from_id (const UINT16_T id_to_check);
void xnl_device_disconnected (UINT16_T xnl_devid);
void xnl_xcmp_authentication_complete (const UINT16_T xnl_devid);
void xnl_xcmp_data_store(const UINT16_T xnl_devid, const UINT8_T *data_ptr, const UINT16_T data_length);
success_failure_t xnl_xcmp_data_parser(const UINT16_T xnl_devid, UINT8_T rx_byte);
void xnl_timer_expired (const UINT16_T xnl_devid, UINT8_T msg_id);
void xnl_ack_received(UINT16_T address);
BOOL_T xnl_get_device_ack_feature(const UINT16_T xnl_devid);
void xnl_reset_device_structure(xnl_device_struct_t *reset_device);
void xnl_reset_retry_params(UINT16_T xnl_devid);
#endif
