--
-- ################################ IPDS 2.2.0 OMC ALTER SCRIPT ################################
--

--
-- >>>>>>>>>>>>>>>>>>>>>> UPGRADE FROM VERSION 1.0 >>>>>>>>>>>>>>>>>>>>>>
--

--
-- 1. Table structure for table `ipds_conf_emergency`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_emergency` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `emer_mode` enum('SHOW_TO_SYSTEM','IGNORE_BUTTON','SEND_TO_RADIO') NOT NULL DEFAULT 'SEND_TO_RADIO',
  `emer_volume` int(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 2. Table structure for table `ipds_conf_local`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_local` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `turn_off_lcd_timeout` int(4) unsigned NOT NULL DEFAULT '65535',
  `show_activity_log` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `effective_conn_flag` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `debug_level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `apx_revert_use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `apx_revert_timeout` int(4) unsigned NOT NULL DEFAULT '5',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- >>>>>>>>>>>>>>>>>>>>>> UPGRADE FROM VERSION 2.0 >>>>>>>>>>>>>>>>>>>>>>
--

--
-- 3. Table structure for table `ipds_conf_tetra_alias`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_tetra_alias` (
  `ipds_conf_id` int(11) NOT NULL,
  `table_index` tinyint(4) NOT NULL DEFAULT '0',
  `alias_name` varchar(20) NOT NULL DEFAULT '',
  `message` varchar(150) NOT NULL DEFAULT '',
  `on_flag` tinyint(4) NOT NULL DEFAULT '0',
  `isFindFolderOrFindGroup` tinyint(4) NOT NULL DEFAULT '0',
  `alias_type` enum('SDS','STATUS','CONST') NOT NULL DEFAULT 'SDS',
  `alias_value` int(11) NOT NULL DEFAULT '0',
  `tetra_issi` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`ipds_conf_id`,`table_index`,`alias_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 4. Table structure for table `ipds_conf_tetra_buttons`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_tetra_buttons` (
  `ipds_conf_id` int(11) NOT NULL,
  `button_place_id` tinyint(4) NOT NULL DEFAULT '0',
  `button_type` tinyint(4) NOT NULL DEFAULT '0',
  `sds_table_index` tinyint(4) NOT NULL DEFAULT '0',
  `button_state` tinyint(4) NOT NULL DEFAULT '0',
  `in_use` tinyint(4) NOT NULL DEFAULT '0',
  `tetra_button_type` tinyint(4) NOT NULL DEFAULT '0',
  `table_index` tinyint(4) NOT NULL DEFAULT '0',
   PRIMARY KEY (`ipds_conf_id`,`button_place_id`,`table_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 5. Table structure for table `ssrn_card_config_file_versions`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ssrn_card_config_file_versions` (
  `card_id` int(11) NOT NULL,
  `file_id` int(11) NOT NULL,
  `version_ix` int(11) NOT NULL,
  `install_date` datetime NOT NULL,
  `language_file_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`card_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- >>>>>>>>>>>>>>>>>>>>>> UPGRADE FROM VERSION 2.1 >>>>>>>>>>>>>>>>>>>>>>
--

--
-- 6. Table structure for table `ipds_conf_version_per_client`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_version_per_client` (
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`card_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 7. Table structure for table `ipds_conf_soft_key_buttons_restrictions`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_soft_key_buttons_restrictions` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `disable_connect_btn` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_acthist_btn` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_reset_btn` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_store_btn` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_update_btn` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_quit_btn` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 8. Table structure for table `ipds_conf_volume_config`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_volume_config` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `min_speaker_volume` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_mute_button_disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 9. Table structure for table `ipds_conf_quit_btn_pin`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_quit_btn_pin` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `quit_btn_pin` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- >>>>>>>>>>>>>>>>>>>>>> UPGRADE FROM VERSION 2.1.1 >>>>>>>>>>>>>>>>>>>>>>
--

--
-- 10. Table structure for table `ipds_languages_pack`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_languages_pack` (
  `file_id` int(10) NOT NULL DEFAULT '6',
  `language_id` int(10) NOT NULL DEFAULT '0',
  `version` varchar(32) NOT NULL DEFAULT '0',
  `language` varchar(16) NOT NULL DEFAULT '0',
  `user_name` varchar(16) NOT NULL DEFAULT '0',
  `install_modify_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 11. Table structure for table `ipds_conf_soft_key_unicode`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_soft_key_unicode` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `button_ix` int(10) unsigned NOT NULL DEFAULT '0',
  `button_id` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `button_text` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `button_type` enum('RADIO','IPDS') NOT NULL DEFAULT 'RADIO',
  `language_type` enum('LANGUAGE_A','LANGUAGE_B') NOT NULL DEFAULT 'LANGUAGE_A',
   PRIMARY KEY (`ipds_conf_id`, `button_ix`, `button_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 12. Table structure for table `ipds_conf_tetra_alias_unicode`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_tetra_alias_unicode` (
  `ipds_conf_id` int(11) NOT NULL,
  `table_index` tinyint(4) NOT NULL DEFAULT '0',
  `alias_name` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `message` blob NOT NULL,
  `on_flag` tinyint(4) NOT NULL DEFAULT '0',
  `isFindFolderOrFindGroup` tinyint(4) NOT NULL DEFAULT '0',
  `alias_type` enum('SDS','STATUS','CONST') NOT NULL DEFAULT 'SDS',
  `alias_value` int(11) NOT NULL DEFAULT '0',
  `tetra_issi` binary(24) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `language_type` enum('LANGUAGE_A','LANGUAGE_B') NOT NULL DEFAULT 'LANGUAGE_A',
  PRIMARY KEY (`ipds_conf_id`,`table_index`,`alias_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- 13. Table structure for table `ipds_conf_tetra_buttons_unicode`
--
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `ipds_conf_tetra_buttons_unicode` (
  `ipds_conf_id` int(11) NOT NULL,
  `button_place_id` tinyint(4) NOT NULL DEFAULT '0',
  `button_type` tinyint(4) NOT NULL DEFAULT '0',
  `sds_table_index` tinyint(4) NOT NULL DEFAULT '0',
  `button_state` tinyint(4) NOT NULL DEFAULT '0',
  `in_use` tinyint(4) NOT NULL DEFAULT '0',
  `tetra_button_type` tinyint(4) NOT NULL DEFAULT '0',
  `table_index` tinyint(4) NOT NULL DEFAULT '0',
  `language_type` enum('LANGUAGE_A','LANGUAGE_B') NOT NULL DEFAULT 'LANGUAGE_A',
   PRIMARY KEY (`ipds_conf_id`,`button_place_id` ,`table_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- ################### RUNNING UPDATE PROCEDURE ###################
--

DELIMITER $$

DROP PROCEDURE IF EXISTS upgrade_database $$
CREATE PROCEDURE upgrade_database()
BEGIN
	
    DECLARE old_ver varchar(20) default '2.2.0';
    DECLARE old_ver_index int default 5;
	DECLARE bDone INT default FALSE;
    DECLARE conf_id INT(11);
    DECLARE curs CURSOR FOR SELECT ipds_conf_id FROM ipds_conf;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET bDone = TRUE;
	
	 select db_version into old_ver from ssrn_config;
	 
    if old_ver = '4.6' then set old_ver_index = 1;
       elseif old_ver = '2.0' then set old_ver_index = 2;
       elseif old_ver = '2.1' then set old_ver_index = 3;
       elseif old_ver = '2.11' then set old_ver_index = 4;
    else set old_ver_index = 5;
    end if;

    OPEN curs;

 	SET bDone = 0;
	REPEAT    
		FETCH curs into conf_id;	

		    -- if old db version is ipds 1.0 (4.6)
			if old_ver_index < 2 then
                INSERT IGNORE INTO ipds_conf_emergency VALUES(conf_id,'SHOW_TO_SYSTEM',0);
                INSERT IGNORE INTO ipds_conf_local VALUES(conf_id,0,0,0,0,0,5);
			end if;
			
			 -- if old db version is ipds 1.0 or 2.0
			if old_ver_index < 3 then
				INSERT IGNORE INTO `ipds_conf_tetra_alias` VALUES (conf_id,0,'','',0,0,'SDS',0,''),(conf_id,1,'','',0,0,'SDS',0,''),(conf_id,2,'','',0,0,'SDS',0,''),(conf_id,3,'','',0,0,'SDS',0,''),(conf_id,4,'','',0,0,'SDS',0,''),(conf_id,5,'','',0,0,'SDS',0,''),(conf_id,6,'','',0,0,'SDS',0,''),(conf_id,7,'','',0,0,'SDS',0,''),(conf_id,8,'','',0,0,'SDS',0,''),(conf_id,9,'','',0,0,'SDS',0,''),(conf_id,0,'','',0,0,'STATUS',0,''),(conf_id,1,'','',0,0,'STATUS',0,''),(conf_id,2,'','',0,0,'STATUS',0,''),(conf_id,3,'','',0,0,'STATUS',0,''),(conf_id,4,'','',0,0,'STATUS',0,''),(conf_id,5,'','',0,0,'STATUS',0,''),(conf_id,6,'','',0,0,'STATUS',0,''),(conf_id,7,'','',0,0,'STATUS',0,''),(conf_id,8,'','',0,0,'STATUS',0,''),(conf_id,9,'','',0,0,'STATUS',0,''),(conf_id,0,'Send','',1,0,'CONST',0,''),(conf_id,1,'Find Folder','',1,1,'CONST',0,''),(conf_id,2,'Find Group','',1,2,'CONST',0,''),(conf_id,3,'Received','',1,3,'CONST',0,'');
				INSERT IGNORE INTO `ipds_conf_tetra_buttons` VALUES (conf_id,0,0,0,0,0,0,0),(conf_id,1,0,1,0,1,2,1),(conf_id,2,0,2,0,1,2,2),(conf_id,3,0,0,0,0,0,3),(conf_id,4,0,0,0,0,0,4),(conf_id,5,0,0,0,0,0,5),(conf_id,6,0,0,0,0,0,6),(conf_id,7,0,0,0,0,0,7),(conf_id,8,0,0,0,0,0,8),(conf_id,9,0,0,0,0,0,9),(conf_id,10,0,0,0,0,0,10),(conf_id,11,0,0,0,0,0,11),(conf_id,12,0,0,0,0,0,12),(conf_id,13,0,0,0,0,0,13),(conf_id,14,0,0,0,0,0,14),(conf_id,15,0,0,0,0,0,15),(conf_id,16,0,0,0,0,0,16),(conf_id,17,0,0,0,0,0,17),(conf_id,18,0,0,0,0,0,18),(conf_id,19,0,0,0,0,0,19);

			end if;
			
			 -- if old db version is ipds 1.0 or 2.0 or 2.1
			if old_ver_index < 4 then
				INSERT IGNORE INTO `ipds_conf_soft_key_buttons_restrictions` VALUES (conf_id,0,0,0,0,0,0);
				INSERT IGNORE INTO `ipds_conf_volume_config` VALUES (conf_id,0,0);
				INSERT IGNORE INTO `ipds_conf_quit_btn_pin` VALUES (conf_id,'b4f24U2S3d1hV1\\3');
				
			end if;
			
			-- for all older versions
			INSERT IGNORE INTO `ipds_conf_soft_key_unicode` VALUES (conf_id,0,0,'\0M\0e\0n\0u\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','IPDS','LANGUAGE_A'),(conf_id,1,1,'\0C\0o\0n\0n\0e\0c\0t\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','IPDS','LANGUAGE_A'),(conf_id,2,2,'\0A\0c\0t\0i\0v\0i\0t\0y\0 \0H\0i\0s\0t\0.\0\0\0\0','IPDS','LANGUAGE_A'),(conf_id,3,3,'\0Q\0u\0i\0t\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','IPDS','LANGUAGE_A'),(conf_id,0,0,'\0S\0u\0p\0e\0r\0v\0i\0s\0o\0r\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,1,1,'\0E\0m\0e\0r\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,2,2,'\0D\0i\0s\0c\0o\0n\0n\0e\0c\0t\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,3,8,'\0R\0a\0d\0i\0o\0 \0F\0u\0n\0c\0.\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,4,3,'\0A\0l\0e\0r\0t\0 \01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,5,4,'\0A\0l\0e\0r\0t\0 \02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,6,5,'\0A\0l\0e\0r\0t\0 \03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,7,6,'\0R\0 \0C\0a\0l\0l\0e\0r\0s\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,8,7,'\0T\0x\0 \0M\0o\0n\0i\0t\0o\0r\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,9,9,'\0T\0a\0k\0e\0o\0v\0e\0r\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,10,10,'\0S\0t\0o\0r\0e\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,11,11,'\0D\0i\0a\0l\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,12,12,'\0S\0p\0.\0D\0.\0 \0L\0i\0s\0t\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A'),(conf_id,13,13,'\0P\0a\0g\0i\0n\0g\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','RADIO','LANGUAGE_A');
			INSERT IGNORE INTO `ipds_conf_tetra_alias_unicode` VALUES (conf_id,0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,1,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,2,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,3,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,4,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,5,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,6,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,7,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,8,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,9,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',0,0,'SDS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,1,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,2,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,3,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,4,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,5,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,6,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,7,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,8,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,9,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',0,0,'STATUS',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,0,'\0S\0e\0n\0d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',1,0,'CONST',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,1,'\0F\0i\0n\0d\0 \0F\0o\0l\0d\0e\0r\0\0\0\0\0\0\0\0\0\0','',1,1,'CONST',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,2,'\0F\0i\0n\0d\0 \0G\0r\0o\0u\0p\0\0\0\0\0\0\0\0\0\0\0\0','',1,2,'CONST',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,3,'\0R\0e\0c\0e\0i\0v\0e\0d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',1,3,'CONST',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,4,'\0S\0c\0a\0n\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','',1,4,'CONST',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A'),(conf_id,5,'\0S\0c\0a\0n\0 \0L\0i\0s\0t\0s\0\0\0\0\0\0\0\0\0\0\0\0','',1,5,'CONST',0,'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0','LANGUAGE_A');
			INSERT IGNORE INTO `ipds_conf_tetra_buttons_unicode` VALUES (conf_id,0,0,0,0,0,0,0,'LANGUAGE_A'),(conf_id,1,0,1,0,1,2,1,'LANGUAGE_A'),(conf_id,2,0,2,0,1,2,2,'LANGUAGE_A'),(conf_id,3,0,0,0,0,0,3,'LANGUAGE_A'),(conf_id,4,0,0,0,0,0,4,'LANGUAGE_A'),(conf_id,5,0,0,0,0,0,5,'LANGUAGE_A'),(conf_id,6,0,0,0,0,0,6,'LANGUAGE_A'),(conf_id,7,0,0,0,0,0,7,'LANGUAGE_A'),(conf_id,8,0,0,0,0,0,8,'LANGUAGE_A'),(conf_id,9,0,0,0,0,0,9,'LANGUAGE_A'),(conf_id,10,0,0,0,0,0,10,'LANGUAGE_A'),(conf_id,11,0,0,0,0,0,11,'LANGUAGE_A'),(conf_id,12,0,0,0,0,0,12,'LANGUAGE_A'),(conf_id,13,0,0,0,0,0,13,'LANGUAGE_A'),(conf_id,14,0,0,0,0,0,14,'LANGUAGE_A'),(conf_id,15,0,0,0,0,0,15,'LANGUAGE_A'),(conf_id,16,0,0,0,0,0,16,'LANGUAGE_A'),(conf_id,17,0,0,0,0,0,17,'LANGUAGE_A'),(conf_id,18,0,0,0,0,0,18,'LANGUAGE_A'),(conf_id,19,0,0,0,0,0,19,'LANGUAGE_A');
		
        
    UNTIL bDone END REPEAT;
	CLOSE curs;


	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='sntp_ip' AND TABLE_NAME='omc_server_sites') ) THEN
		 ALTER TABLE `omc_server_sites` ADD COLUMN `sntp_ip` varchar(16) NOT NULL DEFAULT '0.0.0.0' AFTER `dns_name`;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='private_flag' AND TABLE_NAME='radio_details') ) THEN
		 ALTER TABLE `radio_details` ADD COLUMN `private_flag` int(4) NOT NULL DEFAULT '0'  AFTER `receive_only_flag`;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='parallel_con_flag' AND TABLE_NAME='radio_details') ) THEN
		ALTER TABLE `radio_details` ADD COLUMN `parallel_con_flag` int(4) NOT NULL DEFAULT '0'  AFTER `private_flag`;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='sub_type' AND TABLE_NAME='sw_only_res_id') ) THEN
				ALTER TABLE `sw_only_res_id` ADD COLUMN `sub_type` enum('SW_ONLY_SUBT_USUAL','SW_ONLY_SUBT_EOC','SW_ONLY_SUBT_MOBILE') NOT NULL DEFAULT 'SW_ONLY_SUBT_USUAL' AFTER `socket`;	
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='audio_port' AND TABLE_NAME='system_parameters_versions') ) THEN
				ALTER TABLE `system_parameters_versions` ADD COLUMN `audio_port` int(4) NOT NULL DEFAULT '50120'  AFTER `discon_gu_no_answer_ping_timeout`;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='data_port' AND TABLE_NAME='system_parameters_versions') ) THEN
			   ALTER TABLE `system_parameters_versions` ADD COLUMN `data_port` int(10) unsigned NOT NULL DEFAULT '50120'  AFTER `audio_port`;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='sntp_flag' AND TABLE_NAME='system_parameters_versions') ) THEN
			   ALTER TABLE `system_parameters_versions` ADD COLUMN `sntp_flag` tinyint(4) unsigned NOT NULL DEFAULT '0'  AFTER `data_port`;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='mdc_limited_patience_sec' AND TABLE_NAME='system_parameters_versions') ) THEN
			   ALTER TABLE `system_parameters_versions` ADD COLUMN `mdc_limited_patience_sec` tinyint(4) NOT NULL DEFAULT '2' AFTER `sntp_flag` ;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='mdc_retry_constant' AND TABLE_NAME='system_parameters_versions') ) THEN
			   ALTER TABLE `system_parameters_versions` ADD COLUMN `mdc_retry_constant` tinyint(4) NOT NULL DEFAULT '5' AFTER `mdc_limited_patience_sec`;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='talk_extend_time' AND TABLE_NAME='system_parameters_versions') ) THEN
			   ALTER TABLE `system_parameters_versions` ADD COLUMN `talk_extend_time` int(10) NOT NULL DEFAULT '1200' AFTER `mdc_retry_constant`;
	END IF;

	IF NOT EXISTS( (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE()
			AND COLUMN_NAME='language_file_id' AND TABLE_NAME='ssrn_card_config_file_versions') ) THEN
			   ALTER TABLE `ssrn_card_config_file_versions` ADD COLUMN `language_file_id` int(11) NOT NULL DEFAULT '0' AFTER `install_date`;
	END IF;

	IF NOT EXISTS( ( SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE() 
	        AND TABLE_NAME='ipds_conf_tetra_buttons' AND COLUMN_KEY = 'PRI') ) THEN
			  ALTER TABLE ipds_conf_tetra_buttons ADD PRIMARY KEY (`ipds_conf_id`,`button_place_id`,`table_index`);
	END IF;
	

END $$

DELIMITER ;
CALL upgrade_database();
DROP PROCEDURE upgrade_database;


ALTER TABLE `radio_details` CHANGE COLUMN `radio_type` `radio_type` ENUM('FOUR_WIRE_E_AND_M','SPECTRA','MCS200','IDEN_I90','TRC_CONSOLE','BIM_TRC','CDM_RTYPE','XTL_SERIES_5_RTYPE'	,'SP2_RTYPE','MCC7500_RTYPE','SP3_RTYPE','SP4_RTYPE','IDEN_I325_RTYPE','ASTRO_DIU_RTYPE','ACIM_FULL_RTYPE','RS232oIP_RTYPE','MOTOTRBO_RTYPE','ASTRO_DIU_HDLC_RTYPE','TETRA_RTYPE','XTL_SER_05_MIMIC_RTYPE','MARCOM_IVC_CTRL_RTYPE','GM3XX_RTYPE','IDEN_MODULE_RTYPE','MICHLOL_RTYPE'	,'SP17_RTYPE','CONSOLETTE_SPECTRA_W9','GSM_MODULE_RTYPE','BEIT_HAYOZER_RTYPE','APX_CONSOLETTE_RTYPE','SP21_RTYPE') NOT NULL DEFAULT 'FOUR_WIRE_E_AND_M';
ALTER TABLE `ssrn_card` CHANGE COLUMN `card_hw_type` `card_hw_type` ENUM('DIU20_HW_TYPE','DIU80_HW_TYPE','MINI_GU_HW_TYPE','PC_GU_HW_TYPE','SW_ONLY_HW_TYPE','DIU80_VER2_HW_TYPE','DIU40_HW_TYPE','RLS80_HW_TYPE','RLS40_HW_TYPE','AGU_4PORT_HW_TYPE','IPDS_HW_TYPE','AGU_4PORT_HDLC_HW_TYPE','DIU80_VER3_HW_TYPE','DIU40_VER3_HW_TYPE','HW_TYPE_VER3_RGU','HW_TYPE_VER3_IPDS','LAST_HW_TYPE') NOT NULL;
ALTER TABLE `sw_only_res_id` ENGINE=MyISAM;
ALTER TABLE `user` CHANGE COLUMN `user_type` `user_type` ENUM('Statewide Admin','Region Admin','Local Admin','Statewide Dispatcher','Region Dispatcher','Local Dispatcher','Technician 1','Technician 2','Technician 3','Takeover Dispatcher') NOT NULL DEFAULT 'Statewide Admin';
ALTER TABLE `system_session_parm` MODIFY `session_format` tinyint(3) unsigned NOT NULL DEFAULT '0';

UPDATE `system_parameters_versions` SET version_creation_time='2015-10-08 12:00:00';
UPDATE `ssrn_config` SET db_version='2.2.0';













