-- MySQL dump 10.13  Distrib 5.1.48, for redhat-linux-gnu (i686)
--
-- Host: localhost    Database: ipds
-- ------------------------------------------------------
-- Server version	5.1.48-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `active_conferences`
--

DROP TABLE IF EXISTS `active_conferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `active_conferences` (
  `conference_id` int(10) unsigned NOT NULL DEFAULT '0',
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `bridge_id` int(10) unsigned NOT NULL DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`card_id`,`bridge_id`) USING BTREE,
  UNIQUE KEY `Index_3` (`conference_id`),
  CONSTRAINT `FK_active_conferences_1` FOREIGN KEY (`conference_id`) REFERENCES `conference_schedule` (`conference_id`),
  CONSTRAINT `FK_active_conferences_2` FOREIGN KEY (`card_id`) REFERENCES `conference_bridge` (`card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `active_conferences`
--

LOCK TABLES `active_conferences` WRITE;
/*!40000 ALTER TABLE `active_conferences` DISABLE KEYS */;
/*!40000 ALTER TABLE `active_conferences` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `active_pstn_connection`
--

DROP TABLE IF EXISTS `active_pstn_connection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `active_pstn_connection` (
  `con_res_id` int(11) NOT NULL DEFAULT '0',
  `line_id` tinyint(4) NOT NULL DEFAULT '0',
  `sip_phone_num` varchar(20) NOT NULL DEFAULT '',
  `call_id` varchar(30) NOT NULL DEFAULT '',
  `radio_patch_id` int(11) NOT NULL DEFAULT '0',
  `radio_logical_index` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `call_start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `call_create_user_id` int(11) NOT NULL DEFAULT '0',
  `patch_start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `patch_create_user_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`con_res_id`,`line_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `active_pstn_connection`
--

LOCK TABLES `active_pstn_connection` WRITE;
/*!40000 ALTER TABLE `active_pstn_connection` DISABLE KEYS */;
/*!40000 ALTER TABLE `active_pstn_connection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `active_talkpath_statistics`
--

DROP TABLE IF EXISTS `active_talkpath_statistics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `active_talkpath_statistics` (
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `da2radio` int(10) unsigned NOT NULL DEFAULT '0',
  `radio2radio` int(10) unsigned NOT NULL DEFAULT '0',
  `da2da` int(10) unsigned NOT NULL DEFAULT '0',
  `conference` int(10) unsigned NOT NULL DEFAULT '0',
  `da2radioDisconnections` int(10) unsigned NOT NULL DEFAULT '0',
  `radio2radioDisconnections` int(10) unsigned NOT NULL DEFAULT '0',
  `da2daDisconnections` int(10) unsigned NOT NULL DEFAULT '0',
  `conferenceDisconnections` int(10) unsigned NOT NULL DEFAULT '0',
  `bsi` int(10) unsigned NOT NULL DEFAULT '0',
  `bsiDisconnections` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `active_talkpath_statistics`
--

LOCK TABLES `active_talkpath_statistics` WRITE;
/*!40000 ALTER TABLE `active_talkpath_statistics` DISABLE KEYS */;
/*!40000 ALTER TABLE `active_talkpath_statistics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ad_hoc_sbcs`
--

DROP TABLE IF EXISTS `ad_hoc_sbcs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ad_hoc_sbcs` (
  `sbc_ip` varchar(16) NOT NULL DEFAULT '',
  `sbc_domain` varchar(45) NOT NULL DEFAULT '',
  `sbc_port` int(10) unsigned NOT NULL DEFAULT '5060',
  `sbc_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sbc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ad_hoc_sbcs`
--

LOCK TABLES `ad_hoc_sbcs` WRITE;
/*!40000 ALTER TABLE `ad_hoc_sbcs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ad_hoc_sbcs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audio_encryption_key`
--

DROP TABLE IF EXISTS `audio_encryption_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audio_encryption_key` (
  `audio_enc_key_id` int(10) unsigned NOT NULL DEFAULT '0',
  `audio_enc_key` varchar(100) DEFAULT '',
  `audio_key_type` enum('Active','Standby','Regular') NOT NULL DEFAULT 'Active',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `install_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expiration_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`audio_enc_key_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='ssrn rpdfl audio encryption keys';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audio_encryption_key`
--

LOCK TABLES `audio_encryption_key` WRITE;
/*!40000 ALTER TABLE `audio_encryption_key` DISABLE KEYS */;
/*!40000 ALTER TABLE `audio_encryption_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bsi_connection_history`
--

DROP TABLE IF EXISTS `bsi_connection_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bsi_connection_history` (
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `res_logical_index` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `resource_uri` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `creator_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `disconnected_at` datetime DEFAULT '0000-00-00 00:00:00',
  `disconnect_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `line_ix` tinyint(3) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bsi_connection_history`
--

LOCK TABLES `bsi_connection_history` WRITE;
/*!40000 ALTER TABLE `bsi_connection_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `bsi_connection_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bsi_connections`
--

DROP TABLE IF EXISTS `bsi_connections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bsi_connections` (
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `res_logical_index` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `resource_uri` text NOT NULL,
  `created_at` datetime DEFAULT '0000-00-00 00:00:00',
  `creator_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `line_ix` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`line_ix`,`res_id`),
  KEY `FK_bsi_res_id` (`res_id`),
  CONSTRAINT `FK_bsi_res_id` FOREIGN KEY (`res_id`) REFERENCES `res_element` (`res_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bsi_connections`
--

LOCK TABLES `bsi_connections` WRITE;
/*!40000 ALTER TABLE `bsi_connections` DISABLE KEYS */;
/*!40000 ALTER TABLE `bsi_connections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bsi_removed_resources`
--

DROP TABLE IF EXISTS `bsi_removed_resources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bsi_removed_resources` (
  `bsi_id` int(10) unsigned NOT NULL DEFAULT '0',
  `resource_uri` text NOT NULL,
  `removed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bsi_removed_resources`
--

LOCK TABLES `bsi_removed_resources` WRITE;
/*!40000 ALTER TABLE `bsi_removed_resources` DISABLE KEYS */;
/*!40000 ALTER TABLE `bsi_removed_resources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bsi_removed_systems`
--

DROP TABLE IF EXISTS `bsi_removed_systems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bsi_removed_systems` (
  `bsi_id` int(10) unsigned NOT NULL DEFAULT '0',
  `removed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bsi_id`,`removed_at`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bsi_removed_systems`
--

LOCK TABLES `bsi_removed_systems` WRITE;
/*!40000 ALTER TABLE `bsi_removed_systems` DISABLE KEYS */;
/*!40000 ALTER TABLE `bsi_removed_systems` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bsi_resources`
--

DROP TABLE IF EXISTS `bsi_resources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bsi_resources` (
  `bsi_id` int(10) unsigned NOT NULL DEFAULT '0',
  `resource_uri` text NOT NULL,
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bsi_resources`
--

LOCK TABLES `bsi_resources` WRITE;
/*!40000 ALTER TABLE `bsi_resources` DISABLE KEYS */;
/*!40000 ALTER TABLE `bsi_resources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bsi_systems`
--

DROP TABLE IF EXISTS `bsi_systems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bsi_systems` (
  `bsi_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bsi_name` varchar(50) NOT NULL DEFAULT '',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sbc_ip` varchar(16) NOT NULL DEFAULT '',
  `sbc_port` int(10) unsigned NOT NULL DEFAULT '5060',
  PRIMARY KEY (`bsi_id`),
  UNIQUE KEY `bsi_sys_name` (`bsi_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bsi_systems`
--

LOCK TABLES `bsi_systems` WRITE;
/*!40000 ALTER TABLE `bsi_systems` DISABLE KEYS */;
/*!40000 ALTER TABLE `bsi_systems` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `card_session_parm`
--

DROP TABLE IF EXISTS `card_session_parm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `card_session_parm` (
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sessionType` enum('intercom','radio','conference') NOT NULL DEFAULT 'intercom',
  `session_format` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `frame_duration` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`sessionType`,`card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `card_session_parm`
--

LOCK TABLES `card_session_parm` WRITE;
/*!40000 ALTER TABLE `card_session_parm` DISABLE KEYS */;
/*!40000 ALTER TABLE `card_session_parm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `card_versions`
--

DROP TABLE IF EXISTS `card_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `card_versions` (
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `bsp_version` varchar(19) NOT NULL DEFAULT '',
  `bsp_date` varchar(31) NOT NULL DEFAULT '',
  `app_version` varchar(19) NOT NULL DEFAULT '',
  `app_date` varchar(31) NOT NULL DEFAULT '',
  `dsp_version` varchar(19) DEFAULT '',
  `dsp_date` varchar(31) DEFAULT '',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 MAX_ROWS=5000 COMMENT='SSRN Card versions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `card_versions`
--

LOCK TABLES `card_versions` WRITE;
/*!40000 ALTER TABLE `card_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `card_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_bridge`
--

DROP TABLE IF EXISTS `conference_bridge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_bridge` (
  `card_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `card_ip` varchar(16) NOT NULL DEFAULT '',
  `socket` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`card_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_bridge`
--

LOCK TABLES `conference_bridge` WRITE;
/*!40000 ALTER TABLE `conference_bridge` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_bridge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_bridge_name`
--

DROP TABLE IF EXISTS `conference_bridge_name`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_bridge_name` (
  `bridge_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bridge_name` varchar(45) DEFAULT NULL,
  `bridge_email` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`bridge_id`) USING BTREE,
  CONSTRAINT `FK_conference_bridge_name_1` FOREIGN KEY (`bridge_id`) REFERENCES `conference_bridge` (`card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_bridge_name`
--

LOCK TABLES `conference_bridge_name` WRITE;
/*!40000 ALTER TABLE `conference_bridge_name` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_bridge_name` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_participant`
--

DROP TABLE IF EXISTS `conference_participant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_participant` (
  `conference_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` enum('Required','Optional','Leader') NOT NULL DEFAULT 'Required',
  `participant_ip` varchar(16) NOT NULL DEFAULT '',
  `status` enum('Calling','Connected','Rejected','Disconnected') NOT NULL DEFAULT 'Calling',
  `is_approved` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`conference_id`,`user_id`),
  KEY `FK_conference_participant_2` (`user_id`),
  CONSTRAINT `FK_conference_participant_1` FOREIGN KEY (`conference_id`) REFERENCES `conference_schedule` (`conference_id`),
  CONSTRAINT `FK_conference_participant_2` FOREIGN KEY (`user_id`) REFERENCES `conference_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_participant`
--

LOCK TABLES `conference_participant` WRITE;
/*!40000 ALTER TABLE `conference_participant` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_participant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_present_participants`
--

DROP TABLE IF EXISTS `conference_present_participants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_present_participants` (
  `conference_id` int(10) unsigned NOT NULL DEFAULT '0',
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `bridge_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`conference_id`,`card_id`,`bridge_id`,`user_id`),
  KEY `FK_conference_present_participants_2` (`card_id`),
  KEY `FK_conference_present_participants_3` (`user_id`),
  CONSTRAINT `FK_conference_present_participants_1` FOREIGN KEY (`conference_id`) REFERENCES `conference_schedule` (`conference_id`),
  CONSTRAINT `FK_conference_present_participants_2` FOREIGN KEY (`card_id`) REFERENCES `conference_bridge` (`card_id`),
  CONSTRAINT `FK_conference_present_participants_3` FOREIGN KEY (`user_id`) REFERENCES `conference_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_present_participants`
--

LOCK TABLES `conference_present_participants` WRITE;
/*!40000 ALTER TABLE `conference_present_participants` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_present_participants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_schedule`
--

DROP TABLE IF EXISTS `conference_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_schedule` (
  `conference_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(100) NOT NULL DEFAULT '',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `outlook_id` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`conference_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_schedule`
--

LOCK TABLES `conference_schedule` WRITE;
/*!40000 ALTER TABLE `conference_schedule` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_schedule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_schedule_bridge`
--

DROP TABLE IF EXISTS `conference_schedule_bridge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_schedule_bridge` (
  `conference_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bridge_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`conference_id`),
  KEY `FK_conference_schedule_bridge_2` (`bridge_id`),
  CONSTRAINT `FK_conference_schedule_bridge_1` FOREIGN KEY (`conference_id`) REFERENCES `conference_schedule` (`conference_id`),
  CONSTRAINT `FK_conference_schedule_bridge_2` FOREIGN KEY (`bridge_id`) REFERENCES `conference_bridge` (`card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_schedule_bridge`
--

LOCK TABLES `conference_schedule_bridge` WRITE;
/*!40000 ALTER TABLE `conference_schedule_bridge` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_schedule_bridge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_user`
--

DROP TABLE IF EXISTS `conference_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(16) NOT NULL DEFAULT '',
  `full_name` varchar(40) NOT NULL DEFAULT '',
  `work_phone` varchar(20) NOT NULL DEFAULT '',
  `home_phone` varchar(20) NOT NULL DEFAULT '',
  `cell_phone` varchar(20) NOT NULL DEFAULT '',
  `status` enum('Offline','Online','Away','Busy','Do Not Disturb','Be Right Back') NOT NULL DEFAULT 'Online',
  `uri` varchar(45) NOT NULL DEFAULT '',
  `away_reason` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `Index_2` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_user`
--

LOCK TABLES `conference_user` WRITE;
/*!40000 ALTER TABLE `conference_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_user_contact`
--

DROP TABLE IF EXISTS `conference_user_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_user_contact` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `permission_type` enum('Allow','Blocked') NOT NULL DEFAULT 'Allow',
  `show_in_contacts` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`user_id`,`contact_id`),
  KEY `FK_conference_user_contact_2` (`contact_id`),
  CONSTRAINT `FK_conference_user_contact_1` FOREIGN KEY (`user_id`) REFERENCES `conference_user` (`user_id`),
  CONSTRAINT `FK_conference_user_contact_2` FOREIGN KEY (`contact_id`) REFERENCES `conference_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_user_contact`
--

LOCK TABLES `conference_user_contact` WRITE;
/*!40000 ALTER TABLE `conference_user_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_user_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conference_user_socket`
--

DROP TABLE IF EXISTS `conference_user_socket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conference_user_socket` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `socket` int(10) unsigned NOT NULL DEFAULT '0',
  `user_ip` varchar(16) NOT NULL DEFAULT '',
  PRIMARY KEY (`user_id`,`socket`,`user_ip`) USING BTREE,
  CONSTRAINT `FK_conference_user_socket_1` FOREIGN KEY (`user_id`) REFERENCES `conference_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conference_user_socket`
--

LOCK TABLES `conference_user_socket` WRITE;
/*!40000 ALTER TABLE `conference_user_socket` DISABLE KEYS */;
/*!40000 ALTER TABLE `conference_user_socket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `county`
--

DROP TABLE IF EXISTS `county`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `county` (
  `county_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `county_name` varchar(19) NOT NULL DEFAULT '',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `region_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`county_id`),
  UNIQUE KEY `county_name` (`county_name`),
  KEY `region_id` (`region_id`),
  CONSTRAINT `0_43` FOREIGN KEY (`region_id`) REFERENCES `region` (`region_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 MAX_ROWS=200 COMMENT='ssrn county data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `county`
--

LOCK TABLES `county` WRITE;
/*!40000 ALTER TABLE `county` DISABLE KEYS */;
INSERT INTO `county` VALUES (1,'admincounty','2005-08-16 14:54:38',1,0);
/*!40000 ALTER TABLE `county` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `daily_performance_monitor`
--

DROP TABLE IF EXISTS `daily_performance_monitor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `daily_performance_monitor` (
  `connect_pass` int(11) NOT NULL DEFAULT '0',
  `connect_fail` int(11) NOT NULL DEFAULT '0',
  `discon_pass` int(11) NOT NULL DEFAULT '0',
  `discon_fail` int(11) NOT NULL DEFAULT '0',
  `login_pass` int(11) NOT NULL DEFAULT '0',
  `login_fail` int(11) NOT NULL DEFAULT '0',
  `logout_pass` int(11) NOT NULL DEFAULT '0',
  `create_conference` int(11) NOT NULL DEFAULT '0',
  `destroty_conference` int(11) NOT NULL DEFAULT '0',
  `day` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`day`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `daily_performance_monitor`
--

LOCK TABLES `daily_performance_monitor` WRITE;
/*!40000 ALTER TABLE `daily_performance_monitor` DISABLE KEYS */;
/*!40000 ALTER TABLE `daily_performance_monitor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drawer_plan`
--

DROP TABLE IF EXISTS `drawer_plan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `drawer_plan` (
  `plan_id` int(11) NOT NULL DEFAULT '0',
  `src_res` int(10) unsigned NOT NULL DEFAULT '0',
  `src_res_logical_index` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `dest_res` int(10) unsigned NOT NULL DEFAULT '0',
  `dest_res_logical_index` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `connection_type` enum('No Connections','One to One','Regular Conf','Bridge Conf','Bridge to Bridge') NOT NULL DEFAULT 'One to One',
  PRIMARY KEY (`plan_id`,`src_res`,`dest_res`,`src_res_logical_index`,`dest_res_logical_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drawer_plan`
--

LOCK TABLES `drawer_plan` WRITE;
/*!40000 ALTER TABLE `drawer_plan` DISABLE KEYS */;
/*!40000 ALTER TABLE `drawer_plan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drawer_plan_activate`
--

DROP TABLE IF EXISTS `drawer_plan_activate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `drawer_plan_activate` (
  `plan_id` int(10) unsigned NOT NULL DEFAULT '0',
  `next_activate_user` int(10) unsigned DEFAULT NULL,
  `next_activate_time` datetime DEFAULT NULL,
  `job_number` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drawer_plan_activate`
--

LOCK TABLES `drawer_plan_activate` WRITE;
/*!40000 ALTER TABLE `drawer_plan_activate` DISABLE KEYS */;
/*!40000 ALTER TABLE `drawer_plan_activate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drawer_plan_properties`
--

DROP TABLE IF EXISTS `drawer_plan_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `drawer_plan_properties` (
  `plan_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `plan_name` varchar(19) NOT NULL DEFAULT '',
  `plan_type` int(10) unsigned NOT NULL DEFAULT '0',
  `comment` varchar(100) NOT NULL DEFAULT '',
  `last_modify_user` int(10) unsigned NOT NULL DEFAULT '0',
  `last_modify_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_activate_user` int(10) unsigned NOT NULL DEFAULT '0',
  `last_activate_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `psap_id` int(10) unsigned NOT NULL DEFAULT '0',
  `county_id` int(10) unsigned NOT NULL DEFAULT '0',
  `region_id` int(10) unsigned NOT NULL DEFAULT '0',
  `terr_id` int(11) unsigned NOT NULL DEFAULT '0',
  `terr_type` enum('STATE_TER','REGION_TER','COUNTY_TER','PSAP_TER') NOT NULL DEFAULT 'STATE_TER',
  PRIMARY KEY (`plan_id`),
  UNIQUE KEY `plan_name_ix` (`plan_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drawer_plan_properties`
--

LOCK TABLES `drawer_plan_properties` WRITE;
/*!40000 ALTER TABLE `drawer_plan_properties` DISABLE KEYS */;
/*!40000 ALTER TABLE `drawer_plan_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf`
--

DROP TABLE IF EXISTS `ipds_conf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf` (
  `ipds_conf_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `version_name` varchar(20) NOT NULL DEFAULT '',
  `version_desc` varchar(128) NOT NULL DEFAULT '',
  `modified_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf`
--

LOCK TABLES `ipds_conf` WRITE;
/*!40000 ALTER TABLE `ipds_conf` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_alet_auth`
--

DROP TABLE IF EXISTS `ipds_conf_alet_auth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_alet_auth` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `packet_loss_alert_meduim` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `packet_loss_alert_high` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `login_attempts_number` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `cpu_usage_alert_meduim` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `cpu_usage_alert_high` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `turn_of_lcd_timeout` int(10) unsigned NOT NULL DEFAULT '0',
  `time_zone` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_alet_auth`
--

LOCK TABLES `ipds_conf_alet_auth` WRITE;
/*!40000 ALTER TABLE `ipds_conf_alet_auth` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_alet_auth` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_emergency`
--

DROP TABLE IF EXISTS `ipds_conf_emergency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_emergency` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `emer_mode` enum('SHOW_TO_SYSTEM','IGNORE_BUTTON','SEND_TO_RADIO') NOT NULL DEFAULT 'SEND_TO_RADIO',
  `emer_volume` int(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_emergency`
--

LOCK TABLES `ipds_conf_emergency` WRITE;
/*!40000 ALTER TABLE `ipds_conf_emergency` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_emergency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_local`
--

DROP TABLE IF EXISTS `ipds_conf_local`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_local` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `turn_off_lcd_timeout` int(4) unsigned NOT NULL DEFAULT '65535',
  `show_activity_log` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `effective_conn_flag` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `debug_level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `apx_revert_use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `apx_revert_timeout` int(4) unsigned NOT NULL DEFAULT '5',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_local`
--

LOCK TABLES `ipds_conf_local` WRITE;
/*!40000 ALTER TABLE `ipds_conf_local` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_local` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_login_data`
--

DROP TABLE IF EXISTS `ipds_conf_login_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_login_data` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `authentication_flag` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `login_attempts_number` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `error_lock_timeout` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `auto_lock_timeout` smallint(4) unsigned NOT NULL DEFAULT '0',
  `default_username` varchar(16) NOT NULL DEFAULT '',
  `default_password` varchar(16) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_login_data`
--

LOCK TABLES `ipds_conf_login_data` WRITE;
/*!40000 ALTER TABLE `ipds_conf_login_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_login_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_quit_btn_pin`
--

DROP TABLE IF EXISTS `ipds_conf_quit_btn_pin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_quit_btn_pin` (
  `ipds_conf_id`  int(10)      unsigned NOT NULL DEFAULT '0',
  `quit_btn_pin`  varchar(20)  NOT NULL DEFAULT '',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_quit_btn_pin`
--

LOCK TABLES `ipds_conf_quit_btn_pin` WRITE;
/*!40000 ALTER TABLE `ipds_conf_quit_btn_pin` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_quit_btn_pin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_show_componet`
--

DROP TABLE IF EXISTS `ipds_conf_show_componet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_show_componet` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `radio_leds_flag` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `volume_sliders_flag` tinyint(3) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_show_componet`
--

LOCK TABLES `ipds_conf_show_componet` WRITE;
/*!40000 ALTER TABLE `ipds_conf_show_componet` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_show_componet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_soft_key`
--

DROP TABLE IF EXISTS `ipds_conf_soft_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_soft_key` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `button_ix` int(10) unsigned NOT NULL DEFAULT '0',
  `button_id` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `button_text` varchar(16) NOT NULL DEFAULT '',
  `button_type` enum('RADIO','IPDS') NOT NULL DEFAULT 'RADIO'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_soft_key`
--

LOCK TABLES `ipds_conf_soft_key` WRITE;
/*!40000 ALTER TABLE `ipds_conf_soft_key` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_soft_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_soft_key_buttons_restrictions`
--

DROP TABLE IF EXISTS `ipds_conf_soft_key_buttons_restrictions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_soft_key_buttons_restrictions` (
  `ipds_conf_id`         int(10)    unsigned NOT NULL DEFAULT '0',
  `disable_connect_btn`  tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_acthist_btn`  tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_reset_btn`    tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_store_btn`    tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_update_btn`   tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disable_quit_btn`     tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_soft_key_buttons_restrictions`
--

LOCK TABLES `ipds_conf_soft_key_buttons_restrictions` WRITE;
/*!40000 ALTER TABLE `ipds_conf_soft_key_buttons_restrictions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_soft_key_buttons_restrictions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_soft_key_unicode`
--

DROP TABLE IF EXISTS `ipds_conf_soft_key_unicode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_soft_key_unicode` (
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
  `button_ix` int(10) unsigned NOT NULL DEFAULT '0',
  `button_id` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `button_text` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `button_type` enum('RADIO','IPDS') NOT NULL DEFAULT 'RADIO',
  `language_type` enum('LANGUAGE_A','LANGUAGE_B') NOT NULL DEFAULT 'LANGUAGE_A',
   PRIMARY KEY (`ipds_conf_id`, `button_ix`, `button_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_soft_key_unicode`
--

LOCK TABLES `ipds_conf_soft_key_unicode` WRITE;
/*!40000 ALTER TABLE `ipds_conf_soft_key_unicode` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_soft_key_unicode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_tetra_alias`
--

DROP TABLE IF EXISTS `ipds_conf_tetra_alias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_tetra_alias` (
  `ipds_conf_id` int(11) NOT NULL,
  `table_index` tinyint(4) NOT NULL DEFAULT '0',
  `alias_name` varchar(20) NOT NULL DEFAULT '',
  `message` varchar(150) NOT NULL DEFAULT '',
  `on_flag` tinyint(4) NOT NULL DEFAULT '0',
  `isFindFolderOrFindGroup` tinyint(4) NOT NULL DEFAULT '0',
  `alias_type` enum('SDS','STATUS','CONST') NOT NULL DEFAULT 'SDS',
  `alias_value` int(11) NOT NULL DEFAULT '0',
  `tetra_issi` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`ipds_conf_id`,`table_index`,`alias_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_tetra_alias`
--

LOCK TABLES `ipds_conf_tetra_alias` WRITE;
/*!40000 ALTER TABLE `ipds_conf_tetra_alias` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_tetra_alias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_tetra_alias_unicode`
--

DROP TABLE IF EXISTS `ipds_conf_tetra_alias_unicode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_tetra_alias_unicode` (
  `ipds_conf_id` int(11) NOT NULL,
  `table_index` tinyint(4) NOT NULL DEFAULT '0',
  `alias_name` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `message` blob NOT NULL,
  `on_flag` tinyint(4) NOT NULL DEFAULT '0',
  `isFindFolderOrFindGroup` tinyint(4) NOT NULL DEFAULT '0',
  `alias_type` enum('SDS','STATUS','CONST') NOT NULL DEFAULT 'SDS',
  `alias_value` int(11) NOT NULL DEFAULT '0',
  `tetra_issi` binary(24) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `language_type` enum('LANGUAGE_A','LANGUAGE_B') NOT NULL DEFAULT 'LANGUAGE_A',
  PRIMARY KEY (`ipds_conf_id`,`table_index`,`alias_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_tetra_alias_unicode`
--

LOCK TABLES `ipds_conf_tetra_alias_unicode` WRITE;
/*!40000 ALTER TABLE `ipds_conf_tetra_alias_unicode` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_tetra_alias_unicode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_tetra_buttons`
--

DROP TABLE IF EXISTS `ipds_conf_tetra_buttons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_tetra_buttons` (
  `ipds_conf_id` int(11) NOT NULL,
  `button_place_id` tinyint(4) NOT NULL DEFAULT '0',
  `button_type` tinyint(4) NOT NULL DEFAULT '0',
  `sds_table_index` tinyint(4) NOT NULL DEFAULT '0',
  `button_state` tinyint(4) NOT NULL DEFAULT '0',
  `in_use` tinyint(4) NOT NULL DEFAULT '0',
  `tetra_button_type` tinyint(4) NOT NULL DEFAULT '0',
  `table_index` tinyint(4) NOT NULL DEFAULT '0',
   PRIMARY KEY (`ipds_conf_id`,`button_place_id`,`table_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_tetra_buttons`
--

LOCK TABLES `ipds_conf_tetra_buttons` WRITE;
/*!40000 ALTER TABLE `ipds_conf_tetra_buttons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_tetra_buttons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_tetra_buttons_unicode`
--

DROP TABLE IF EXISTS `ipds_conf_tetra_buttons_unicode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_tetra_buttons_unicode` (
  `ipds_conf_id` int(11) NOT NULL,
  `button_place_id` tinyint(4) NOT NULL DEFAULT '0',
  `button_type` tinyint(4) NOT NULL DEFAULT '0',
  `sds_table_index` tinyint(4) NOT NULL DEFAULT '0',
  `button_state` tinyint(4) NOT NULL DEFAULT '0',
  `in_use` tinyint(4) NOT NULL DEFAULT '0',
  `tetra_button_type` tinyint(4) NOT NULL DEFAULT '0',
  `table_index` tinyint(4) NOT NULL DEFAULT '0',
  `language_type` enum('LANGUAGE_A','LANGUAGE_B') NOT NULL DEFAULT 'LANGUAGE_A',
  PRIMARY KEY (`ipds_conf_id`,`button_place_id` ,`table_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_tetra_buttons_unicode`
--

LOCK TABLES `ipds_conf_tetra_buttons_unicode` WRITE;
/*!40000 ALTER TABLE `ipds_conf_tetra_buttons_unicode` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_tetra_buttons_unicode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_version_per_client`
--

DROP TABLE IF EXISTS `ipds_conf_version_per_client`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_version_per_client` (
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ipds_conf_id` int(10) unsigned NOT NULL DEFAULT '0',
   PRIMARY KEY (`card_id`)
)  ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_version_per_client`
--

LOCK TABLES `ipds_conf_version_per_client` WRITE;
/*!40000 ALTER TABLE `ipds_conf_version_per_client` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_version_per_client` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_conf_volume_config`
--

DROP TABLE IF EXISTS `ipds_conf_volume_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_conf_volume_config` (
  `ipds_conf_id`             int(10)    unsigned NOT NULL DEFAULT '0',
  `min_speaker_volume`       tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_mute_button_disabled`  tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ipds_conf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_conf_volume_config`
--

LOCK TABLES `ipds_conf_volume_config` WRITE;
/*!40000 ALTER TABLE `ipds_conf_volume_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_conf_volume_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipds_languages_pack`
--

DROP TABLE IF EXISTS `ipds_languages_pack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipds_languages_pack` (
  `file_id` int(10) NOT NULL DEFAULT '6',
  `language_id`            int(10)    unsigned NOT NULL DEFAULT '0',
  `version`                varchar(32) NOT NULL DEFAULT '0',
  `language`               varchar(16) NOT NULL DEFAULT '0',
  `user_name`              varchar(16) NOT NULL DEFAULT '0',
  `install_modify_date`    timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ipds_languages_pack`
--

LOCK TABLES `ipds_languages_pack` WRITE;
/*!40000 ALTER TABLE `ipds_languages_pack` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipds_languages_pack` ENABLE KEYS */;
UNLOCK TABLES;


--
-- Table structure for table `multicast_proxy`
--

DROP TABLE IF EXISTS `multicast_proxy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `multicast_proxy` (
  `res_id` int(11) NOT NULL DEFAULT '0',
  `res_logical_index` tinyint(4) NOT NULL DEFAULT '0',
  `mcast_group_ip` varchar(16) NOT NULL DEFAULT '0',
  `proxy_res_id` int(11) NOT NULL DEFAULT '0',
  `logger_flag` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `multicast_proxy`
--

LOCK TABLES `multicast_proxy` WRITE;
/*!40000 ALTER TABLE `multicast_proxy` DISABLE KEYS */;
/*!40000 ALTER TABLE `multicast_proxy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `multicast_proxy_temp`
--

DROP TABLE IF EXISTS `multicast_proxy_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `multicast_proxy_temp` (
  `res_id` int(11) NOT NULL DEFAULT '0',
  `res_logical_index` tinyint(4) NOT NULL DEFAULT '0',
  `mcast_group_ip` varchar(16) NOT NULL DEFAULT '0',
  `proxy_res_id` int(11) NOT NULL DEFAULT '0',
  `logger_flag` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `multicast_proxy_temp`
--

LOCK TABLES `multicast_proxy_temp` WRITE;
/*!40000 ALTER TABLE `multicast_proxy_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `multicast_proxy_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_segment`
--

DROP TABLE IF EXISTS `network_segment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `network_segment` (
  `start_ip` varchar(16) NOT NULL DEFAULT '',
  `end_ip` varchar(16) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_segment`
--

LOCK TABLES `network_segment` WRITE;
/*!40000 ALTER TABLE `network_segment` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_segment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `omc_registration`
--

DROP TABLE IF EXISTS `omc_registration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `omc_registration` (
  `id` int(11) NOT NULL DEFAULT '0',
  `host` varchar(20) NOT NULL DEFAULT '',
  `da_sub_type` int(11) NOT NULL DEFAULT '-1',
  `remote_da_ip` varchar(16) NOT NULL DEFAULT '',
  `app_type` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `card_id` int(11) DEFAULT '0',
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `session_id` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`remote_da_ip`,`user_id`,`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `omc_registration`
--

LOCK TABLES `omc_registration` WRITE;
/*!40000 ALTER TABLE `omc_registration` DISABLE KEYS */;
/*!40000 ALTER TABLE `omc_registration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `omc_registration_history`
--

DROP TABLE IF EXISTS `omc_registration_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `omc_registration_history` (
  `id` int(11) NOT NULL DEFAULT '0',
  `host` varchar(20) NOT NULL DEFAULT '',
  `da_sub_type` int(11) NOT NULL DEFAULT '-1',
  `remote_da_ip` varchar(20) NOT NULL DEFAULT '',
  `app_type` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) DEFAULT '0',
  `card_id` int(11) DEFAULT '0',
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `session_id` varchar(255) NOT NULL DEFAULT '',
  `user_logout_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=10000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `omc_registration_history`
--

LOCK TABLES `omc_registration_history` WRITE;
/*!40000 ALTER TABLE `omc_registration_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `omc_registration_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `omc_server_sites`
--

DROP TABLE IF EXISTS `omc_server_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `omc_server_sites` (
  `site_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sys_params_version` int(10) unsigned NOT NULL DEFAULT '0',
  `omc_server_ip` varchar(16) NOT NULL DEFAULT '',
  `omc_server_port` int(10) unsigned NOT NULL DEFAULT '5062',
  `omc_server_status` enum('Idle','Active') NOT NULL DEFAULT 'Idle',
  `last_switch_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `dns_name` varchar(45) NOT NULL DEFAULT '',
  `sntp_ip` varchar(16) NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`sys_params_version`,`site_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `omc_server_sites`
--

LOCK TABLES `omc_server_sites` WRITE;
/*!40000 ALTER TABLE `omc_server_sites` DISABLE KEYS */;
INSERT INTO `omc_server_sites` VALUES (2000,1,'0.0.0.0',5062,'Idle','0000-00-00 00:00:00','','0.0.0.0'),(2001,1,'0.0.0.0',5062,'Idle','0000-00-00 00:00:00','','0.0.0.0');
/*!40000 ALTER TABLE `omc_server_sites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `omc_version_control`
--

DROP TABLE IF EXISTS `omc_version_control`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `omc_version_control` (
  `version_name` varchar(100) NOT NULL DEFAULT '',
  `version_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `username` varchar(100) NOT NULL DEFAULT '',
  `upgrade_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `omc_version_control`
--

LOCK TABLES `omc_version_control` WRITE;
/*!40000 ALTER TABLE `omc_version_control` DISABLE KEYS */;
/*!40000 ALTER TABLE `omc_version_control` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `organization`
--

DROP TABLE IF EXISTS `organization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `organization` (
  `org_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `org_name` varchar(19) NOT NULL DEFAULT '',
  `org_addr` varchar(100) DEFAULT '',
  `org_phone_num` varchar(15) DEFAULT '',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`org_id`),
  UNIQUE KEY `org_name` (`org_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 MAX_ROWS=200 COMMENT='ssrn organization data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `organization`
--

LOCK TABLES `organization` WRITE;
/*!40000 ALTER TABLE `organization` DISABLE KEYS */;
INSERT INTO `organization` VALUES (1,'Motorola','adminadress','1234','2005-08-16 14:55:15',0);
/*!40000 ALTER TABLE `organization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `performance_monitor`
--

DROP TABLE IF EXISTS `performance_monitor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `performance_monitor` (
  `connect_pass` int(11) DEFAULT '0',
  `connect_fail` int(11) DEFAULT '0',
  `connect_avg_processing` float DEFAULT '0',
  `discon_pass` int(11) DEFAULT '0',
  `discon_fail` int(11) DEFAULT '0',
  `discon_avg_processing` float DEFAULT '0',
  `login_pass` int(11) DEFAULT '0',
  `login_fail` int(11) DEFAULT '0',
  `login_avg_processing` float DEFAULT '0',
  `logout_pass` int(11) DEFAULT '0',
  `logout_avg_processing` float DEFAULT '0',
  `create_conference_pass` int(11) DEFAULT '0',
  `create_conference_fail` int(11) DEFAULT '0',
  `create_conf_avg_processing` float DEFAULT '0',
  `destroy_conference` int(11) DEFAULT '0',
  `destroy_conf_avg_processing` float DEFAULT '0',
  `add_res_2_conf` int(11) DEFAULT '0',
  `add_res_2_conf_fail` int(11) DEFAULT '0',
  `total_cpu` float DEFAULT '0',
  `omc_cpu` float DEFAULT '0',
  `total_mem` float DEFAULT '0',
  `omc_mem` float DEFAULT '0',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `performance_monitor`
--

LOCK TABLES `performance_monitor` WRITE;
/*!40000 ALTER TABLE `performance_monitor` DISABLE KEYS */;
/*!40000 ALTER TABLE `performance_monitor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `phonebook`
--

DROP TABLE IF EXISTS `phonebook`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `phonebook` (
  `contact_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_full_name` varchar(50) DEFAULT '_',
  `business_phone` varchar(20) DEFAULT '_',
  `home_phone` varchar(20) DEFAULT '_',
  `mobile_phone` varchar(20) DEFAULT '_',
  `phone_ptt` varchar(20) DEFAULT '_',
  `pager_num` varchar(20) DEFAULT '_',
  `group_num` varchar(20) DEFAULT '_',
  PRIMARY KEY (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='user phonebook';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `phonebook`
--

LOCK TABLES `phonebook` WRITE;
/*!40000 ALTER TABLE `phonebook` DISABLE KEYS */;
/*!40000 ALTER TABLE `phonebook` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `process_debug`
--

DROP TABLE IF EXISTS `process_debug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `process_debug` (
  `process_id` int(10) unsigned NOT NULL DEFAULT '0',
  `Process_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`process_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `process_debug`
--

LOCK TABLES `process_debug` WRITE;
/*!40000 ALTER TABLE `process_debug` DISABLE KEYS */;
INSERT INTO `process_debug` VALUES (1,'Receive'),(2,'Manager'),(3,'Database'),(4,'Transmit'),(5,'Client Disconnect'),(6,'Msg Processing');
/*!40000 ALTER TABLE `process_debug` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `process_debug_priority`
--

DROP TABLE IF EXISTS `process_debug_priority`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `process_debug_priority` (
  `process_id` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `process_debug_priority`
--

LOCK TABLES `process_debug_priority` WRITE;
/*!40000 ALTER TABLE `process_debug_priority` DISABLE KEYS */;
INSERT INTO `process_debug_priority` VALUES (1,2),(1,5),(2,2),(2,5),(3,2),(3,5),(4,2),(4,5),(5,2),(5,5),(6,2),(6,5),(7,2),(7,5),(8,2),(8,5),(9,2),(9,5);
/*!40000 ALTER TABLE `process_debug_priority` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `psap`
--

DROP TABLE IF EXISTS `psap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `psap` (
  `psap_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `psap_name` varchar(19) NOT NULL DEFAULT '',
  `psap_code` int(10) unsigned DEFAULT '0',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `county_id` int(40) unsigned NOT NULL DEFAULT '0',
  `latitude` double DEFAULT NULL,
  `longitude` double DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `bandwidth` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`psap_id`),
  UNIQUE KEY `psap_name` (`psap_name`),
  KEY `county_id` (`county_id`),
  CONSTRAINT `0_46` FOREIGN KEY (`county_id`) REFERENCES `county` (`county_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 MAX_ROWS=200 COMMENT='SSRN PSAP table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `psap`
--

LOCK TABLES `psap` WRITE;
/*!40000 ALTER TABLE `psap` DISABLE KEYS */;
INSERT INTO `psap` VALUES (1,'adminpsap',1,'2005-08-16 14:55:38',1,43,-77.5,0,128);
/*!40000 ALTER TABLE `psap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pstn_connection_hist`
--

DROP TABLE IF EXISTS `pstn_connection_hist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pstn_connection_hist` (
  `con_res_id` int(11) NOT NULL DEFAULT '0',
  `connection_type` enum('REGULAR','PATCH') NOT NULL DEFAULT 'REGULAR',
  `line_id` tinyint(4) NOT NULL DEFAULT '0',
  `sip_phone_num` varchar(20) NOT NULL DEFAULT '',
  `call_id` varchar(30) NOT NULL DEFAULT '',
  `radio_patch_id` int(11) NOT NULL DEFAULT '0',
  `radio_logical_index` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `create_user_id` int(11) NOT NULL DEFAULT '0',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `destroy_user_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pstn_connection_hist`
--

LOCK TABLES `pstn_connection_hist` WRITE;
/*!40000 ALTER TABLE `pstn_connection_hist` DISABLE KEYS */;
/*!40000 ALTER TABLE `pstn_connection_hist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pstn_to_radio_connection`
--

DROP TABLE IF EXISTS `pstn_to_radio_connection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pstn_to_radio_connection` (
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `res_lgcl_index` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `line_ix` int(10) unsigned NOT NULL DEFAULT '0',
  `call_id` text NOT NULL,
  `phone_num` text NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`res_id`,`res_lgcl_index`,`line_ix`),
  CONSTRAINT `FK_res_id` FOREIGN KEY (`res_id`) REFERENCES `res_element` (`res_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pstn_to_radio_connection`
--

LOCK TABLES `pstn_to_radio_connection` WRITE;
/*!40000 ALTER TABLE `pstn_to_radio_connection` DISABLE KEYS */;
/*!40000 ALTER TABLE `pstn_to_radio_connection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pstn_to_radio_connection_history`
--

DROP TABLE IF EXISTS `pstn_to_radio_connection_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pstn_to_radio_connection_history` (
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `res_lgcl_index` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `line_ix` int(10) unsigned NOT NULL DEFAULT '0',
  `call_id` text NOT NULL,
  `phone_num` text NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `disconnected_by` int(10) unsigned NOT NULL DEFAULT '0',
  `disconnected_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`res_id`,`res_lgcl_index`,`line_ix`,`created_at`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pstn_to_radio_connection_history`
--

LOCK TABLES `pstn_to_radio_connection_history` WRITE;
/*!40000 ALTER TABLE `pstn_to_radio_connection_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `pstn_to_radio_connection_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `radio_active_alias_db`
--

DROP TABLE IF EXISTS `radio_active_alias_db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `radio_active_alias_db` (
  `res_id` int(11) NOT NULL DEFAULT '0',
  `adbname` varchar(50) NOT NULL DEFAULT '',
  `file_time_stamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`res_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `radio_active_alias_db`
--

LOCK TABLES `radio_active_alias_db` WRITE;
/*!40000 ALTER TABLE `radio_active_alias_db` DISABLE KEYS */;
/*!40000 ALTER TABLE `radio_active_alias_db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `radio_alias_db_versions`
--

DROP TABLE IF EXISTS `radio_alias_db_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `radio_alias_db_versions` (
  `ver_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ver_name` varchar(100) NOT NULL DEFAULT '',
  `ver_status` enum('ACTIVE','STANDBY','REGULAR') NOT NULL DEFAULT 'ACTIVE',
  `created_by` int(11) NOT NULL DEFAULT '0',
  `last_modified_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hex_type_flag` tinyint(4) NOT NULL DEFAULT '0',
  `radio_type` tinyint(4) NOT NULL DEFAULT '0',
  `ver_description` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`ver_id`),
  UNIQUE KEY `ver_name` (`ver_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `radio_alias_db_versions`
--

LOCK TABLES `radio_alias_db_versions` WRITE;
/*!40000 ALTER TABLE `radio_alias_db_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `radio_alias_db_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `radio_details`
--

DROP TABLE IF EXISTS `radio_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `radio_details` (
  `res_id` int(4) unsigned NOT NULL DEFAULT '0',
  `radio_type` enum('FOUR_WIRE_E_AND_M','SPECTRA','MCS200','IDEN_I90','TRC_CONSOLE','BIM_TRC','CDM_RTYPE','XTL_SERIES_5_RTYPE','SP2_RTYPE','MCC7500_RTYPE','SP3_RTYPE','SP4_RTYPE','IDEN_I325_RTYPE','ASTRO_DIU_RTYPE','ACIM_FULL_RTYPE','RS232oIP_RTYPE','MOTOTRBO_RTYPE','ASTRO_DIU_HDLC_RTYPE','TETRA_RTYPE','XTL_SER_05_MIMIC_RTYPE','MARCOM_IVC_CTRL_RTYPE','GM3XX_RTYPE','IDEN_MODULE_RTYPE','MICHLOL_RTYPE','SP17_RTYPE','CONSOLETTE_SPECTRA_W9','GSM_MODULE_RTYPE','BEIT_HAYOZER_RTYPE','APX_CONSOLETTE_RTYPE','SP21_RTYPE') NOT NULL DEFAULT 'FOUR_WIRE_E_AND_M',
  `radio_interface` enum('NO_PROTOCOL','PROTOCOL_SB9600','PROTOCOL_RALP','PROTOCOL_ESBEP_CDM','PROTOCOL_AT_CMD','PROTOCOL_MCC7500','PROTOCOL_CM400','PROTOCOL_ACIM','PROTOCOL_MOTOTRBO','PROTOCOL_V24oIP','PROTOCOL_RS232oIP','PROTOCOL_GM3XX','PROTOCOL_IDEN_MODULE','PROTOCOL_MICHLOL') NOT NULL DEFAULT 'NO_PROTOCOL',
  `radio_ptt_mode` enum('DIRECT_PTT','PROTOCOL_BASED_PTT','TRC_PTT','NO_PTT') NOT NULL DEFAULT 'DIRECT_PTT',
  `audio_recognition_mode` enum('DIRECT_COR_REC','VAD_REC','PROTOCOL_BASED_REC','TRC_REC','FREE_REC') NOT NULL DEFAULT 'DIRECT_COR_REC',
  `radio_encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `radio_ptt_priority` smallint(6) NOT NULL DEFAULT '3',
  `radio_rf_mode` enum('CONVENTIONAL','TRUNKED') NOT NULL DEFAULT 'CONVENTIONAL',
  `cellular_gateway_flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sms_gateway_flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cell_phone_number` varchar(30) NOT NULL DEFAULT '',
  `radio_connected_flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `full_duplex_flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `silence_ms` smallint(6) NOT NULL DEFAULT '100',
  `selected_call_flag` tinyint(4) NOT NULL DEFAULT '0',
  `cross_mute_table_idx` smallint(6) NOT NULL DEFAULT '0',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(11) DEFAULT '0',
  `voter_sample_duration` int(11) NOT NULL DEFAULT '0',
  `voter_mode` enum('VTR_MODE_CROSS_BUSY','VTR_MODE_RETRANSMISSION','VTR_MODE_DONOR_REDUNDANT') NOT NULL DEFAULT 'VTR_MODE_CROSS_BUSY',
  `mdc1200_flag` tinyint(4) NOT NULL DEFAULT '0',
  `mdc_port_id` int(4) unsigned NOT NULL DEFAULT '0',
  `rad_to_rad_con_limitation` tinyint(4) unsigned NOT NULL DEFAULT '15',
  `connectivity_masks` tinyint(4) unsigned NOT NULL DEFAULT '1',
  `receive_only_flag` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `private_flag` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `parallel_con_flag` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`res_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='ssrn radio details';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `radio_details`
--

LOCK TABLES `radio_details` WRITE;
/*!40000 ALTER TABLE `radio_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `radio_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `region` (
  `region_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `region_name` varchar(19) NOT NULL DEFAULT '',
  `region_code` int(10) unsigned DEFAULT '0',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `state_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`region_id`),
  UNIQUE KEY `region_name` (`region_name`),
  KEY `state_id` (`state_id`),
  CONSTRAINT `0_49` FOREIGN KEY (`state_id`) REFERENCES `state` (`state_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 MAX_ROWS=200 COMMENT='ssrn region data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` VALUES (1,'adminregion',0,'2005-08-16 14:49:09',1,0);
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `removed_card`
--

DROP TABLE IF EXISTS `removed_card`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `removed_card` (
  `rem_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `remove_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `removed_card`
--

LOCK TABLES `removed_card` WRITE;
/*!40000 ALTER TABLE `removed_card` DISABLE KEYS */;
/*!40000 ALTER TABLE `removed_card` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `removed_county`
--

DROP TABLE IF EXISTS `removed_county`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `removed_county` (
  `rem_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `remove_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `removed_county`
--

LOCK TABLES `removed_county` WRITE;
/*!40000 ALTER TABLE `removed_county` DISABLE KEYS */;
/*!40000 ALTER TABLE `removed_county` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `removed_group`
--

DROP TABLE IF EXISTS `removed_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `removed_group` (
  `rem_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `remove_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `removed_group`
--

LOCK TABLES `removed_group` WRITE;
/*!40000 ALTER TABLE `removed_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `removed_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `removed_organization`
--

DROP TABLE IF EXISTS `removed_organization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `removed_organization` (
  `rem_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `remove_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `removed_organization`
--

LOCK TABLES `removed_organization` WRITE;
/*!40000 ALTER TABLE `removed_organization` DISABLE KEYS */;
/*!40000 ALTER TABLE `removed_organization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `removed_psap`
--

DROP TABLE IF EXISTS `removed_psap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `removed_psap` (
  `rem_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `remove_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `removed_psap`
--

LOCK TABLES `removed_psap` WRITE;
/*!40000 ALTER TABLE `removed_psap` DISABLE KEYS */;
/*!40000 ALTER TABLE `removed_psap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `removed_region`
--

DROP TABLE IF EXISTS `removed_region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `removed_region` (
  `rem_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `remove_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rem_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `removed_region`
--

LOCK TABLES `removed_region` WRITE;
/*!40000 ALTER TABLE `removed_region` DISABLE KEYS */;
/*!40000 ALTER TABLE `removed_region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `removed_res_element`
--

DROP TABLE IF EXISTS `removed_res_element`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `removed_res_element` (
  `rem_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `remove_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 MAX_ROWS=10000;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `removed_res_element`
--

LOCK TABLES `removed_res_element` WRITE;
/*!40000 ALTER TABLE `removed_res_element` DISABLE KEYS */;
/*!40000 ALTER TABLE `removed_res_element` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `removed_voter_res`
--

DROP TABLE IF EXISTS `removed_voter_res`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `removed_voter_res` (
  `voter_id` int(10) unsigned NOT NULL,
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `removed_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`voter_id`,`res_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `removed_voter_res`
--

LOCK TABLES `removed_voter_res` WRITE;
/*!40000 ALTER TABLE `removed_voter_res` DISABLE KEYS */;
/*!40000 ALTER TABLE `removed_voter_res` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `res_element`
--

DROP TABLE IF EXISTS `res_element`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_element` (
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `res_name` varchar(19) NOT NULL DEFAULT '',
  `special_attr` varchar(100) DEFAULT 'NULL',
  `res_type` enum('R_GU','WS_GU','3','4','5','6','7','8','9','VOTER') NOT NULL DEFAULT 'WS_GU',
  `sip_phone_num` varchar(23) DEFAULT 'NULL',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned DEFAULT NULL,
  `bsi_enabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `voter_radio_system_topology` enum('Wide-area','Multicast','Cross-busy') NOT NULL DEFAULT 'Wide-area',
  PRIMARY KEY (`res_id`),
  UNIQUE KEY `res_name` (`res_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 MAX_ROWS=10000 COMMENT='ssrn resource element data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `res_element`
--

LOCK TABLES `res_element` WRITE;
/*!40000 ALTER TABLE `res_element` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_element` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `res_element_logical`
--

DROP TABLE IF EXISTS `res_element_logical`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_element_logical` (
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `logical_index` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `logical_alias` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`res_id`,`logical_index`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `res_element_logical`
--

LOCK TABLES `res_element_logical` WRITE;
/*!40000 ALTER TABLE `res_element_logical` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_element_logical` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `res_groups`
--

DROP TABLE IF EXISTS `res_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_groups` (
  `resource_id` int(10) unsigned NOT NULL DEFAULT '0',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `group_id` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`resource_id`,`group_id`),
  KEY `group_id` (`group_id`),
  KEY `resource_id` (`resource_id`),
  CONSTRAINT `0_52` FOREIGN KEY (`group_id`) REFERENCES `ssrn_group` (`group_id`),
  CONSTRAINT `res_groups_ibfk_2` FOREIGN KEY (`resource_id`) REFERENCES `res_element` (`res_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='ssrn resource groups';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `res_groups`
--

LOCK TABLES `res_groups` WRITE;
/*!40000 ALTER TABLE `res_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `res_speed_dial`
--

DROP TABLE IF EXISTS `res_speed_dial`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_speed_dial` (
  `speed_dial_num` int(10) unsigned NOT NULL DEFAULT '0',
  `res_id` int(10) unsigned DEFAULT NULL,
  `pstn_phone_num` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`speed_dial_num`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `res_speed_dial`
--

LOCK TABLES `res_speed_dial` WRITE;
/*!40000 ALTER TABLE `res_speed_dial` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_speed_dial` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `res_speed_dial_versions`
--

DROP TABLE IF EXISTS `res_speed_dial_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_speed_dial_versions` (
  `version_id` int(11) NOT NULL DEFAULT '0',
  `version_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `res_speed_dial_versions`
--

LOCK TABLES `res_speed_dial_versions` WRITE;
/*!40000 ALTER TABLE `res_speed_dial_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_speed_dial_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sbc_config`
--

DROP TABLE IF EXISTS `sbc_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sbc_config` (
  `sbc_ip` varchar(16) NOT NULL DEFAULT '',
  `sbc_port` int(10) unsigned NOT NULL DEFAULT '5060',
  `type` enum('Internal','External') NOT NULL DEFAULT 'Internal'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sbc_config`
--

LOCK TABLES `sbc_config` WRITE;
/*!40000 ALTER TABLE `sbc_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sbc_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `server_access`
--

DROP TABLE IF EXISTS `server_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `server_access` (
  `server_ip` varchar(20) NOT NULL DEFAULT '',
  `passwd` varchar(20) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `server_access`
--

LOCK TABLES `server_access` WRITE;
/*!40000 ALTER TABLE `server_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `server_access` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `session_attr`
--

DROP TABLE IF EXISTS `session_attr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `session_attr` (
  `source_res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dest_res_id` int(11) NOT NULL DEFAULT '0',
  `encoder_type` enum('type1','type2') NOT NULL DEFAULT 'type1',
  `frame_length` smallint(5) unsigned NOT NULL DEFAULT '0',
  `dtx` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `energy_threashold` smallint(5) unsigned NOT NULL DEFAULT '0',
  `cng` tinyint(1) NOT NULL DEFAULT '0',
  `trc` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`source_res_id`,`dest_res_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Session Attributes';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `session_attr`
--

LOCK TABLES `session_attr` WRITE;
/*!40000 ALTER TABLE `session_attr` DISABLE KEYS */;
/*!40000 ALTER TABLE `session_attr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sms_authorized_mobiles`
--

DROP TABLE IF EXISTS `sms_authorized_mobiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sms_authorized_mobiles` (
  `mobile_phone_number` varchar(20) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sms_authorized_mobiles`
--

LOCK TABLES `sms_authorized_mobiles` WRITE;
/*!40000 ALTER TABLE `sms_authorized_mobiles` DISABLE KEYS */;
/*!40000 ALTER TABLE `sms_authorized_mobiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sms_credits`
--

DROP TABLE IF EXISTS `sms_credits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sms_credits` (
  `mobile_phone_number` varchar(20) NOT NULL DEFAULT '',
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sms_credits`
--

LOCK TABLES `sms_credits` WRITE;
/*!40000 ALTER TABLE `sms_credits` DISABLE KEYS */;
/*!40000 ALTER TABLE `sms_credits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sms_registration`
--

DROP TABLE IF EXISTS `sms_registration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sms_registration` (
  `mobile_phone_number` varchar(20) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `last_action_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`mobile_phone_number`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sms_registration`
--

LOCK TABLES `sms_registration` WRITE;
/*!40000 ALTER TABLE `sms_registration` DISABLE KEYS */;
/*!40000 ALTER TABLE `sms_registration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snmp_trap_manager`
--

DROP TABLE IF EXISTS `snmp_trap_manager`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `snmp_trap_manager` (
  `snmp_trap_manager_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `snmp_trap_manager_ip` varchar(16) NOT NULL DEFAULT '',
  `snmp_trap_manager_community_string` varchar(100) NOT NULL DEFAULT 'public',
  `snmp_trap_manager_port` int(11) NOT NULL DEFAULT '162',
  `snmp_trap_manager_enable` tinyint(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`snmp_trap_manager_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snmp_trap_manager`
--

LOCK TABLES `snmp_trap_manager` WRITE;
/*!40000 ALTER TABLE `snmp_trap_manager` DISABLE KEYS */;
/*!40000 ALTER TABLE `snmp_trap_manager` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `soft_phone_connection_hist`
--

DROP TABLE IF EXISTS `soft_phone_connection_hist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `soft_phone_connection_hist` (
  `src_res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dest_sip_phone` varchar(19) NOT NULL DEFAULT '0',
  `call_id` varchar(29) NOT NULL DEFAULT '',
  `line_id` int(11) NOT NULL DEFAULT '0',
  `connection_type` enum('One to One','Regular Conf','Bridge Conf','Bridge to Bridge') NOT NULL DEFAULT 'One to One',
  `create_user_id` int(10) unsigned DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `destroy_user_id` int(10) unsigned DEFAULT '0',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `soft_phone_connection_hist`
--

LOCK TABLES `soft_phone_connection_hist` WRITE;
/*!40000 ALTER TABLE `soft_phone_connection_hist` DISABLE KEYS */;
/*!40000 ALTER TABLE `soft_phone_connection_hist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `soft_phone_connections`
--

DROP TABLE IF EXISTS `soft_phone_connections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `soft_phone_connections` (
  `src_res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dest_sip_phone` varchar(19) NOT NULL DEFAULT '0',
  `call_id` varchar(29) NOT NULL DEFAULT '',
  `line_id` int(10) unsigned NOT NULL DEFAULT '0',
  `connection_type` enum('One to One','Regular Conf','Bridge Conf','Bridge to Bridge') NOT NULL DEFAULT 'One to One',
  `user_id` int(10) unsigned DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `soft_phone_connections`
--

LOCK TABLES `soft_phone_connections` WRITE;
/*!40000 ALTER TABLE `soft_phone_connections` DISABLE KEYS */;
/*!40000 ALTER TABLE `soft_phone_connections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_active_connections`
--

DROP TABLE IF EXISTS `ssrn_active_connections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_active_connections` (
  `src_res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `src_res_logical_index` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `dest_res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dest_res_logical_index` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `connection_type` enum('One to One','Regular Conf','Bridge Conf','Bridge to Bridge') NOT NULL DEFAULT 'One to One',
  `user_id` int(10) unsigned DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `multicast_con_type` enum('NO_MCAST','PROXY_WS_NOT_ACTIVATED','PROXY_WS_ACTIVATED','LISTENER_MCAST') DEFAULT 'NO_MCAST',
  PRIMARY KEY (`src_res_id`,`dest_res_id`,`src_res_logical_index`,`dest_res_logical_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_active_connections`
--

LOCK TABLES `ssrn_active_connections` WRITE;
/*!40000 ALTER TABLE `ssrn_active_connections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_active_connections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_alarms`
--

DROP TABLE IF EXISTS `ssrn_alarms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_alarms` (
  `psap_id` int(10) unsigned NOT NULL DEFAULT '0',
  `organization_id` int(10) unsigned NOT NULL DEFAULT '0',
  `alarm_type` int(10) unsigned NOT NULL DEFAULT '0',
  `alarm_description` varchar(199) NOT NULL DEFAULT '',
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `alarm_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `alarm_level` enum('Fatal','Warning','Info') DEFAULT 'Info',
  `alarm_source` enum('Board','Resource','SIP','OMC','DA','ACP','WMS') DEFAULT 'Board',
  KEY `alarm_time` (`alarm_time`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_alarms`
--

LOCK TABLES `ssrn_alarms` WRITE;
/*!40000 ALTER TABLE `ssrn_alarms` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_alarms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_card`
--

DROP TABLE IF EXISTS `ssrn_card`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_card` (
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `card_ip` varchar(16) NOT NULL DEFAULT '127.0.0.1',
  `psap_id` int(10) unsigned NOT NULL DEFAULT '1',
  `organization_id` int(10) unsigned NOT NULL DEFAULT '0',
  `card_hw_type` enum('DIU20_HW_TYPE','DIU80_HW_TYPE','MINI_GU_HW_TYPE','PC_GU_HW_TYPE','SW_ONLY_HW_TYPE','DIU80_VER2_HW_TYPE','DIU40_HW_TYPE','RLS80_HW_TYPE','RLS40_HW_TYPE','AGU_4PORT_HW_TYPE','IPDS_HW_TYPE','AGU_4PORT_HDLC_HW_TYPE','DIU80_VER3_HW_TYPE','DIU40_VER3_HW_TYPE','HW_TYPE_VER3_RGU','HW_TYPE_VER3_IPDS','LAST_HW_TYPE') NOT NULL,
  `card_name` varchar(45) NOT NULL DEFAULT '',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(10) unsigned DEFAULT NULL,
  `net_sub_area` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`card_id`),
  KEY `psap_id` (`psap_id`),
  KEY `organization_id` (`organization_id`),
  CONSTRAINT `0_55` FOREIGN KEY (`psap_id`) REFERENCES `psap` (`psap_id`),
  CONSTRAINT `0_56` FOREIGN KEY (`organization_id`) REFERENCES `organization` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 MAX_ROWS=5000 COMMENT='ssrn card data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_card`
--

LOCK TABLES `ssrn_card` WRITE;
/*!40000 ALTER TABLE `ssrn_card` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_card` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_card_config_file_versions`
--

DROP TABLE IF EXISTS `ssrn_card_config_file_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_card_config_file_versions` (
  `card_id` int(11) NOT NULL,
  `file_id` int(11) NOT NULL,
  `version_ix` int(11) NOT NULL,
  `install_date` datetime NOT NULL,
  `language_file_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`card_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_card_config_file_versions`
--

LOCK TABLES `ssrn_card_config_file_versions` WRITE;
/*!40000 ALTER TABLE `ssrn_card_config_file_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_card_config_file_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_card_status`
--

DROP TABLE IF EXISTS `ssrn_card_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_card_status` (
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `card_status` enum('Connected','Disconnected') NOT NULL DEFAULT 'Disconnected',
  `connected_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `bridge_status` tinyint(1) NOT NULL DEFAULT '0',
  `last_connect_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_disconnect_time` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_card_status`
--

LOCK TABLES `ssrn_card_status` WRITE;
/*!40000 ALTER TABLE `ssrn_card_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_card_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_card_versions`
--

DROP TABLE IF EXISTS `ssrn_card_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_card_versions` (
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `audio_enc_key_id` int(10) NOT NULL DEFAULT '0',
  `system_parms_key_id` int(10) unsigned NOT NULL DEFAULT '0',
  `system_parms_install_date` datetime DEFAULT '0000-00-00 00:00:00',
  `sw_da_ver_name` varchar(19) DEFAULT NULL,
  `sw_da_ver_install_date` datetime DEFAULT '0000-00-00 00:00:00',
  `sw_ver_name` varchar(19) DEFAULT NULL,
  `sw_ver_install_date` datetime DEFAULT '0000-00-00 00:00:00',
  `speed_dial_version_id` int(10) unsigned NOT NULL DEFAULT '0',
  `speed_dial_install_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `radio_alias_db_ver_id` int(10) unsigned NOT NULL DEFAULT '0',
  `radio_alias_db_ver_install_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`card_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_card_versions`
--

LOCK TABLES `ssrn_card_versions` WRITE;
/*!40000 ALTER TABLE `ssrn_card_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_card_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_conference`
--

DROP TABLE IF EXISTS `ssrn_conference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_conference` (
  `bridge_id` int(10) unsigned NOT NULL DEFAULT '0',
  `conf_name` varchar(19) NOT NULL DEFAULT '',
  `user_id` int(10) unsigned DEFAULT '0',
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`bridge_id`),
  UNIQUE KEY `conf_name_ix` (`conf_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_conference`
--

LOCK TABLES `ssrn_conference` WRITE;
/*!40000 ALTER TABLE `ssrn_conference` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_conference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_conference_history`
--

DROP TABLE IF EXISTS `ssrn_conference_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_conference_history` (
  `bridge_id` int(10) unsigned NOT NULL DEFAULT '0',
  `conf_name` varchar(100) NOT NULL DEFAULT '',
  `create_user_id` int(10) unsigned DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `destroy_user_id` int(10) unsigned DEFAULT '0',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_conference_history`
--

LOCK TABLES `ssrn_conference_history` WRITE;
/*!40000 ALTER TABLE `ssrn_conference_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_conference_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_config`
--

DROP TABLE IF EXISTS `ssrn_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_config` (
  `conf_id` int(10) unsigned NOT NULL DEFAULT '1',
  `db_version` varchar(20) NOT NULL DEFAULT '2.11',
  `db_log_level` int(10) unsigned NOT NULL DEFAULT '6',
  `sys_log_level` int(10) unsigned NOT NULL DEFAULT '6',
  `state_id` int(10) unsigned NOT NULL DEFAULT '9',
  `max_alarms_num` int(10) unsigned NOT NULL DEFAULT '100000',
  `max_bands_num` int(10) unsigned NOT NULL DEFAULT '10000',
  `max_res_in_system` int(10) unsigned NOT NULL DEFAULT '10000',
  `max_gus_in_psap` int(10) unsigned NOT NULL DEFAULT '20',
  `max_psap_in_county` int(10) unsigned NOT NULL DEFAULT '40',
  `max_county_in_region` int(10) unsigned NOT NULL DEFAULT '40',
  `max_region_in_state` int(10) unsigned NOT NULL DEFAULT '30',
  `max_active_cons_num` int(11) unsigned NOT NULL DEFAULT '64000',
  `max_history_num` int(11) unsigned NOT NULL DEFAULT '10000',
  `max_user_login` int(11) unsigned NOT NULL DEFAULT '100',
  `max_acp_clients` int(11) unsigned NOT NULL DEFAULT '20',
  `max_csc_clients` int(10) unsigned NOT NULL DEFAULT '3',
  `msg_version` int(11) NOT NULL DEFAULT '6',
  `msg_sub_version` int(10) unsigned NOT NULL DEFAULT '0',
  `sms_actions_quota` int(11) NOT NULL DEFAULT '10',
  `sms_minutes_quota` int(11) NOT NULL DEFAULT '5',
  PRIMARY KEY (`conf_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_config`
--

LOCK TABLES `ssrn_config` WRITE;
/*!40000 ALTER TABLE `ssrn_config` DISABLE KEYS */;
INSERT INTO `ssrn_config` VALUES (1,'2.2.0',1,1,1,100000,10000,10000,20,40,40,30,64000,10000,100,20,3,6,0,10,5);
/*!40000 ALTER TABLE `ssrn_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_connection_history`
--

DROP TABLE IF EXISTS `ssrn_connection_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_connection_history` (
  `src_res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `src_res_logical_index` tinyint(4) NOT NULL DEFAULT '0',
  `dest_res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dest_res_logical_index` tinyint(4) NOT NULL DEFAULT '0',
  `connection_type` enum('One to One','Regular Conf','Bridge Conf','Bridge to Bridge') NOT NULL DEFAULT 'One to One',
  `create_user_id` int(10) unsigned DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `destroy_user_id` int(10) unsigned DEFAULT '0',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_connection_history`
--

LOCK TABLES `ssrn_connection_history` WRITE;
/*!40000 ALTER TABLE `ssrn_connection_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_connection_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_da_versions`
--

DROP TABLE IF EXISTS `ssrn_da_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_da_versions` (
  `version_name` varchar(19) NOT NULL DEFAULT '',
  `load_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version_type` enum('Active','Standby','Regular') NOT NULL DEFAULT 'Active',
  `description` varchar(128) NOT NULL DEFAULT '',
  `user_name` varchar(16) NOT NULL DEFAULT '',
  `user_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`version_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 MAX_ROWS=10;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_da_versions`
--

LOCK TABLES `ssrn_da_versions` WRITE;
/*!40000 ALTER TABLE `ssrn_da_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_da_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_group`
--

DROP TABLE IF EXISTS `ssrn_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_group` (
  `group_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(39) NOT NULL DEFAULT '',
  `group_code` int(11) unsigned DEFAULT '0',
  `modify_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `groupNameIndx` (`group_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 MAX_ROWS=1000 COMMENT='SSRN Groups List';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_group`
--

LOCK TABLES `ssrn_group` WRITE;
/*!40000 ALTER TABLE `ssrn_group` DISABLE KEYS */;
INSERT INTO `ssrn_group` VALUES (1,'admingroup',1,0,'2005-08-16 14:57:22');
/*!40000 ALTER TABLE `ssrn_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_gu_bandwidth_usage`
--

DROP TABLE IF EXISTS `ssrn_gu_bandwidth_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_gu_bandwidth_usage` (
  `card_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sector_netmask` varchar(16) NOT NULL DEFAULT '',
  `sector_max_bps_sent` int(10) unsigned NOT NULL DEFAULT '0',
  `sector_avg_bps_sent` int(10) unsigned NOT NULL DEFAULT '0',
  `report_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_gu_bandwidth_usage`
--

LOCK TABLES `ssrn_gu_bandwidth_usage` WRITE;
/*!40000 ALTER TABLE `ssrn_gu_bandwidth_usage` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_gu_bandwidth_usage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_history`
--

DROP TABLE IF EXISTS `ssrn_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_history` (
  `comment` varchar(200) NOT NULL DEFAULT '',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `action_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_history`
--

LOCK TABLES `ssrn_history` WRITE;
/*!40000 ALTER TABLE `ssrn_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_ipsec_params`
--

DROP TABLE IF EXISTS `ssrn_ipsec_params`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_ipsec_params` (
  `ipsec_id` int(11) NOT NULL DEFAULT '0',
  `ipsec_use_flag` tinyint(1) NOT NULL DEFAULT '0',
  `ike_encription_algorothm` tinyint(4) NOT NULL DEFAULT '0',
  `ike_hash_algorithm` tinyint(4) NOT NULL DEFAULT '0',
  `sa_encription_algorothm` tinyint(4) NOT NULL DEFAULT '0',
  `sa_hash_algorithm` tinyint(4) NOT NULL DEFAULT '0',
  `sa_security_protocol` tinyint(4) NOT NULL DEFAULT '0',
  `sys_params_version` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ipsec_id`,`sys_params_version`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_ipsec_params`
--

LOCK TABLES `ssrn_ipsec_params` WRITE;
/*!40000 ALTER TABLE `ssrn_ipsec_params` DISABLE KEYS */;
INSERT INTO `ssrn_ipsec_params` VALUES (0,0,0,0,1,0,0,1);
/*!40000 ALTER TABLE `ssrn_ipsec_params` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_sip_proxy_status`
--

DROP TABLE IF EXISTS `ssrn_sip_proxy_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_sip_proxy_status` (
  `sip_proxy_ip` varchar(16) NOT NULL DEFAULT '',
  `sip_proxy_port` int(10) unsigned DEFAULT '5090',
  `sip_proxy_alarm_num` tinyint(4) NOT NULL DEFAULT '0',
  `proxy_last_failure_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `proxy_last_test_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sip_proxy_status` enum('Active','InActive') NOT NULL DEFAULT 'InActive',
  PRIMARY KEY (`sip_proxy_ip`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_sip_proxy_status`
--

LOCK TABLES `ssrn_sip_proxy_status` WRITE;
/*!40000 ALTER TABLE `ssrn_sip_proxy_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_sip_proxy_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_system_sites`
--

DROP TABLE IF EXISTS `ssrn_system_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_system_sites` (
  `site_id` int(10) unsigned NOT NULL DEFAULT '0',
  `site_name` varchar(19) NOT NULL DEFAULT '',
  `sip_proxy_ip` varchar(16) NOT NULL DEFAULT '',
  `sip_proxy_port` int(10) unsigned DEFAULT '5060',
  `firewall_ip` varchar(16) NOT NULL DEFAULT '',
  `firewall_ipsec_psk` varchar(100) NOT NULL DEFAULT '',
  `firewall_ipsec_life_tm` int(10) unsigned NOT NULL DEFAULT '3600',
  `latitude` double NOT NULL DEFAULT '0',
  `longitude` double NOT NULL DEFAULT '0',
  `firewall_ike_life_tm` int(10) unsigned NOT NULL DEFAULT '86400',
  `enc_domain_net` varchar(16) NOT NULL DEFAULT '',
  `enc_domain_subnet` tinyint(4) NOT NULL DEFAULT '0',
  `support_key_exchange` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `sys_params_version` int(10) unsigned NOT NULL DEFAULT '0',
  `dns_name` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`sys_params_version`,`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 MAX_ROWS=200;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_system_sites`
--

LOCK TABLES `ssrn_system_sites` WRITE;
/*!40000 ALTER TABLE `ssrn_system_sites` DISABLE KEYS */;
INSERT INTO `ssrn_system_sites` VALUES (1,'adminregion','0.0.0.0',5060,'1.1.1.1','itsasecret',3600,0,0,86400,'0.0.0.0',0,0,1,''),(2000,'main','0.0.0.0',5060,'1.1.1.1','itsasecret',3600,0,0,86400,'0.0.0.0',0,0,1,''),(2001,'second','0.0.0.0',5060,'1.1.1.1','itsasecret',3600,0,0,86400,'0.0.0.0',0,0,1,'');
/*!40000 ALTER TABLE `ssrn_system_sites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ssrn_versions`
--

DROP TABLE IF EXISTS `ssrn_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ssrn_versions` (
  `version_name` varchar(19) NOT NULL DEFAULT '',
  `load_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version_type` enum('Active','Standby','Regular') NOT NULL DEFAULT 'Active',
  `user_id` int(10) unsigned DEFAULT NULL,
  `description` varchar(150) NOT NULL DEFAULT '',
  PRIMARY KEY (`version_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 MAX_ROWS=10;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ssrn_versions`
--

LOCK TABLES `ssrn_versions` WRITE;
/*!40000 ALTER TABLE `ssrn_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ssrn_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `state`
--

DROP TABLE IF EXISTS `state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `state` (
  `state_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `state_name` varchar(19) NOT NULL DEFAULT '',
  `state_abbriviation` char(2) DEFAULT '',
  `l_latitude` double DEFAULT '0',
  `l_longitude` double DEFAULT '0',
  `r_latitude` double DEFAULT '0',
  `r_longitude` double DEFAULT '0',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`state_id`),
  UNIQUE KEY `state_name` (`state_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 MAX_ROWS=200 COMMENT='ssrn state info';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `state`
--

LOCK TABLES `state` WRITE;
/*!40000 ALTER TABLE `state` DISABLE KEYS */;
INSERT INTO `state` VALUES (1,'adminstate','as',31.3,-87.7,23,-79.5,'2005-08-16 14:58:34',0);
/*!40000 ALTER TABLE `state` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sw_gu_license`
--

DROP TABLE IF EXISTS `sw_gu_license`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sw_gu_license` (
  `max_sw_gu` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sw_gu_license`
--

LOCK TABLES `sw_gu_license` WRITE;
/*!40000 ALTER TABLE `sw_gu_license` DISABLE KEYS */;
/*!40000 ALTER TABLE `sw_gu_license` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sw_only_res_id`
--

DROP TABLE IF EXISTS `sw_only_res_id`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sw_only_res_id` (
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `mac_address` varchar(20) NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `start_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `socket` int(10) NOT NULL DEFAULT '0',
  `sub_type` enum('SW_ONLY_SUBT_USUAL','SW_ONLY_SUBT_EOC','SW_ONLY_SUBT_MOBILE') NOT NULL DEFAULT 'SW_ONLY_SUBT_USUAL',
  PRIMARY KEY (`res_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sw_only_res_id`
--

LOCK TABLES `sw_only_res_id` WRITE;
/*!40000 ALTER TABLE `sw_only_res_id` DISABLE KEYS */;
INSERT INTO `sw_only_res_id` VALUES (4109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(4989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(5997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(6989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(7997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(8989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(9997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(10989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(11997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(12989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(13997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(14989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(15997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(16989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(17997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(18989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(19997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(20989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(21997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(22989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(23997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(24989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(25997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(26989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(27997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(28989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(29997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(30989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(31997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(32989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(33997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(34989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(35997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(36989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(37997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(38989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(39997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(40989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(41997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(42989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(43997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(44989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(45997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(46989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(47997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(48989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(49997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(50989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(51997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(52989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(53997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(54989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(55997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(56989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(57997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(58989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(59997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(60989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(61997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(62989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63533,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63549,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63565,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63581,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63597,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63613,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63629,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63645,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63661,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63677,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63693,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63709,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63725,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63741,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63757,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63773,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63789,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63805,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63821,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63837,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63853,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63869,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63885,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63901,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63917,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63933,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63949,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63965,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63981,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(63997,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64013,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64029,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64045,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64061,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64077,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64093,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64109,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64125,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64141,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64157,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64173,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64189,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64205,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64221,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64237,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64253,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64269,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64285,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64301,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64317,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64333,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64349,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64365,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64381,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64397,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64413,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64429,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64445,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64461,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64477,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64493,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64509,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64525,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64541,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64557,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64573,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64589,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64605,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64621,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64637,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64653,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64669,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64685,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64701,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64717,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64733,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64749,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64765,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64781,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64797,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64813,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64829,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64845,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64861,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64877,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64893,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64909,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64925,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64941,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64957,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64973,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(64989,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65005,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65021,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65037,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65053,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65069,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65085,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65101,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65117,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65133,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65149,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65165,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65181,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65197,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65213,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65229,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65245,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65261,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65277,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65293,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65309,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65325,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65341,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65357,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65373,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65389,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65405,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65421,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65437,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65453,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65469,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65485,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65501,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL'),(65517,'0',0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,'SW_ONLY_SUBT_USUAL');
/*!40000 ALTER TABLE `sw_only_res_id` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sw_only_user_profile`
--

DROP TABLE IF EXISTS `sw_only_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sw_only_user_profile` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `db_version` int(10) unsigned NOT NULL DEFAULT '0',
  `db_revision` int(10) unsigned NOT NULL DEFAULT '0',
  `db_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wan_jitter` int(10) unsigned NOT NULL DEFAULT '100',
  `lan_jitter` int(10) unsigned NOT NULL DEFAULT '50',
  `ws_bsi` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ws_audio_recognition_mode` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `voice_threshold` int(10) unsigned NOT NULL DEFAULT '40',
  `silence_ms` int(10) unsigned NOT NULL DEFAULT '1000',
  `mic_on_flag` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `standalone_mode` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `connect_through_omc` tinyint(3) NOT NULL DEFAULT '1',
  `connect_through_sip` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sw_only_user_profile`
--

LOCK TABLES `sw_only_user_profile` WRITE;
/*!40000 ALTER TABLE `sw_only_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `sw_only_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_log`
--

DROP TABLE IF EXISTS `sys_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_log` (
  `comment` varchar(200) NOT NULL DEFAULT '',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tid` bigint(20) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_log`
--

LOCK TABLES `sys_log` WRITE;
/*!40000 ALTER TABLE `sys_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_parameters_versions`
--

DROP TABLE IF EXISTS `system_parameters_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_parameters_versions` (
  `sys_params_version` int(10) unsigned NOT NULL DEFAULT '1',
  `version_creation_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `QOS_audioTOS` smallint(5) unsigned NOT NULL DEFAULT '0',
  `QOS_cmdTOS` smallint(5) unsigned NOT NULL DEFAULT '0',
  `version_type` enum('Active','Standby','Regular') NOT NULL DEFAULT 'Active',
  `version_name` varchar(100) NOT NULL DEFAULT '',
  `version_description` varchar(150) NOT NULL DEFAULT '',
  `bsi_rtcp_keepalive_interval` int(10) unsigned NOT NULL DEFAULT '5',
  `bsi_rtcp_keepalive_timeout` int(10) unsigned NOT NULL DEFAULT '5',
  `rtp_dtmf_payload_type_flag` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `rtp_dtmf_payload_type` int(10) unsigned NOT NULL DEFAULT '101',
  `dns_enabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `dns_server_ip1` varchar(16) NOT NULL DEFAULT '0.0.0.0',
  `dns_server_ip2` varchar(16) NOT NULL DEFAULT '0.0.0.0',
  `discon_swonly_no_answer_timeout` tinyint(3) unsigned NOT NULL DEFAULT '15',
  `discon_gu_no_answer_ping` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `discon_gu_no_answer_ping_timeout` int(10) unsigned NOT NULL DEFAULT '60',
  `audio_port` int(4) NOT NULL DEFAULT '50120',
  `data_port` int(10) unsigned NOT NULL DEFAULT '50120',
  `sntp_flag` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `mdc_limited_patience_sec` tinyint(4) NOT NULL DEFAULT '2',
  `mdc_retry_constant` tinyint(4) NOT NULL DEFAULT '5',
  `talk_extend_time` int(10) NOT NULL DEFAULT '1200',
  PRIMARY KEY (`sys_params_version`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_parameters_versions`
--

LOCK TABLES `system_parameters_versions` WRITE;
/*!40000 ALTER TABLE `system_parameters_versions` DISABLE KEYS */;
INSERT INTO `system_parameters_versions` VALUES (1,'2015-08-18 13:30:02',1,0,0,'Active','default_version','',5,5,1,101,0,'0.0.0.0','0.0.0.0',15,0,60,50120,50120,0,2,5,1200);
/*!40000 ALTER TABLE `system_parameters_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_session_parm`
--

DROP TABLE IF EXISTS `system_session_parm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_session_parm` (
  `sessionType` enum('intercom','radio','conference','phone','bsi') NOT NULL DEFAULT 'intercom',
  `session_format` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `frame_duration` tinyint(3) unsigned NOT NULL DEFAULT '20',
  `sys_params_version` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`sessionType`,`sys_params_version`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_session_parm`
--

LOCK TABLES `system_session_parm` WRITE;
/*!40000 ALTER TABLE `system_session_parm` DISABLE KEYS */;
INSERT INTO `system_session_parm` VALUES ('intercom',8,20,1),('radio',18,20,1),('conference',8,20,1),('phone',8,20,1),('bsi',8,20,1);
/*!40000 ALTER TABLE `system_session_parm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_sip_timer`
--

DROP TABLE IF EXISTS `system_sip_timer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_sip_timer` (
  `sip_timer_info_id` int(10) unsigned NOT NULL DEFAULT '0',
  `first_retransmit_intrv` int(10) unsigned NOT NULL DEFAULT '0',
  `max_retransmit_intrv` int(10) unsigned NOT NULL DEFAULT '0',
  `resp_tm_intrv` int(10) unsigned NOT NULL DEFAULT '0',
  `resp_tm_after_prov_resp_intrv` int(10) unsigned NOT NULL DEFAULT '0',
  `resp_tm_after_ring_resp_intrv` int(10) unsigned NOT NULL DEFAULT '0',
  `live_after_intrv_invite` int(10) unsigned NOT NULL DEFAULT '0',
  `live_after_completed_intrv` int(10) unsigned NOT NULL DEFAULT '0',
  `max_live_intrv` int(10) unsigned NOT NULL DEFAULT '0',
  `live_after_confirmed_intrv` int(10) unsigned NOT NULL DEFAULT '0',
  `sys_params_version` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`sip_timer_info_id`,`sys_params_version`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 MAX_ROWS=5;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_sip_timer`
--

LOCK TABLES `system_sip_timer` WRITE;
/*!40000 ALTER TABLE `system_sip_timer` DISABLE KEYS */;
INSERT INTO `system_sip_timer` VALUES (0,500,4000,32000,50000,60000,32000,10000,300000,32000,1);
/*!40000 ALTER TABLE `system_sip_timer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `table_rotate_index`
--

DROP TABLE IF EXISTS `table_rotate_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `table_rotate_index` (
  `table_name` varchar(150) NOT NULL DEFAULT '',
  `table_index` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `table_rotate_index`
--

LOCK TABLES `table_rotate_index` WRITE;
/*!40000 ALTER TABLE `table_rotate_index` DISABLE KEYS */;
INSERT INTO `table_rotate_index` VALUES ('system_parameters_versions',1),('speed_dial_versions',1),('radio_alias_db_versions',1);
/*!40000 ALTER TABLE `table_rotate_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(16) NOT NULL DEFAULT '',
  `user_password` varchar(41) NOT NULL DEFAULT '',
  `user_type` enum('Statewide Admin','Region Admin','Local Admin','Statewide Dispatcher','Region Dispatcher','Local Dispatcher','Technician 1','Technician 2','Technician 3','Takeover Dispatcher') NOT NULL DEFAULT 'Statewide Admin',
  `ptt_priority` tinyint(3) unsigned NOT NULL DEFAULT '5',
  `status` int(2) unsigned NOT NULL DEFAULT '0',
  `host` varchar(40) DEFAULT '',
  `last_modify` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_login` datetime DEFAULT '0000-00-00 00:00:00',
  `last_logout` datetime DEFAULT '0000-00-00 00:00:00',
  `last_login_failed_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_failed_counter` tinyint(4) NOT NULL DEFAULT '0',
  `last_password_update_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `NameIdx` (`user_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` VALUES (1,'admin','b)4[öŸ–Ý3…WîG¯¢C','Statewide Admin',1,1,'host','2012-06-03 17:41:05','2012-06-03 20:42:25','2012-06-03 20:42:21','0000-00-00 00:00:00',0,'2012-04-03 17:41:05');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_actions`
--

DROP TABLE IF EXISTS `user_actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_actions` (
  `action_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `action_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`action_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_actions`
--

LOCK TABLES `user_actions` WRITE;
/*!40000 ALTER TABLE `user_actions` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_bsi_system`
--

DROP TABLE IF EXISTS `user_bsi_system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_bsi_system` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `bsi_sys_id` int(11) NOT NULL DEFAULT '0',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_bsi_system`
--

LOCK TABLES `user_bsi_system` WRITE;
/*!40000 ALTER TABLE `user_bsi_system` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_bsi_system` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_groups`
--

DROP TABLE IF EXISTS `user_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_groups` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `last_modify` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_priv` enum('Read','Read Write') NOT NULL DEFAULT 'Read',
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `0_65` FOREIGN KEY (`group_id`) REFERENCES `ssrn_group` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_groups`
--

LOCK TABLES `user_groups` WRITE;
/*!40000 ALTER TABLE `user_groups` DISABLE KEYS */;
INSERT INTO `user_groups` VALUES (1,1,'2005-05-23 15:09:44','Read Write');
/*!40000 ALTER TABLE `user_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_info`
--

DROP TABLE IF EXISTS `user_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_info` (
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_full_name` varchar(39) DEFAULT '',
  `psap_id` int(10) unsigned NOT NULL DEFAULT '0',
  `organization_id` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(39) DEFAULT '',
  `phone_num1` varchar(19) DEFAULT NULL,
  `phone_num2` varchar(19) DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  KEY `psap_id` (`psap_id`),
  KEY `organization_id` (`organization_id`),
  CONSTRAINT `0_67` FOREIGN KEY (`organization_id`) REFERENCES `organization` (`org_id`),
  CONSTRAINT `0_68` FOREIGN KEY (`psap_id`) REFERENCES `psap` (`psap_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='user information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_info`
--

LOCK TABLES `user_info` WRITE;
/*!40000 ALTER TABLE `user_info` DISABLE KEYS */;
INSERT INTO `user_info` VALUES (1,'adminfull',1,1,'admin@motorola.com','123456789','987654321');
/*!40000 ALTER TABLE `user_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_password`
--

DROP TABLE IF EXISTS `user_password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_password` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_password` varchar(100) NOT NULL DEFAULT '',
  `update_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_password`
--

LOCK TABLES `user_password` WRITE;
/*!40000 ALTER TABLE `user_password` DISABLE KEYS */;
INSERT INTO `user_password` VALUES (1,'b)4[ï¿½ï¿½ï¿½ï¿½3ï¿½Wï¿½Gï¿½ï¿½C','2012-04-03 17:20:30');
/*!40000 ALTER TABLE `user_password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_privileges`
--

DROP TABLE IF EXISTS `user_privileges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_privileges` (
  `user_type` enum('State Admin','Region Admin','Local Admin','State Dispatcher','Region Dispatcher','Local Dispatcher','Technician 1','Technician 2','Technician 3') NOT NULL DEFAULT 'State Admin',
  `action_id` int(10) unsigned NOT NULL DEFAULT '0',
  `action_priv` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_type`,`action_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_privileges`
--

LOCK TABLES `user_privileges` WRITE;
/*!40000 ALTER TABLE `user_privileges` DISABLE KEYS */;
INSERT INTO `user_privileges` VALUES ('Technician 1',0,0),('Local Dispatcher',0,0),('Region Dispatcher',0,0),('State Dispatcher',0,0),('Local Admin',0,0),('State Admin',0,0),('Technician 2',0,0),('Technician 3',0,0),('State Admin',1,1),('State Admin',2,1),('Region Admin',3,3);
/*!40000 ALTER TABLE `user_privileges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vault`
--

DROP TABLE IF EXISTS `vault`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vault` (
  `user_name` varchar(100) NOT NULL DEFAULT '',
  `user_type` enum('DATABASE','SYSTEM') NOT NULL DEFAULT 'DATABASE',
  `user_password` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`user_name`,`user_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vault`
--

LOCK TABLES `vault` WRITE;
/*!40000 ALTER TABLE `vault` DISABLE KEYS */;
INSERT INTO `vault` VALUES ('ssrnadmin','DATABASE','m‡™pj<\nuõã·N²´0¿ˆÞ·¿Ôåé'),('replicuser','DATABASE','m‡™pj<\nuõã·N²´0¿ˆÞ·¿Ôåé'),('ssrn','SYSTEM','m‡™pj<\nuõã·N²´0¿ˆÞ·¿Ôåé');
/*!40000 ALTER TABLE `vault` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `voter_res`
--

DROP TABLE IF EXISTS `voter_res`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `voter_res` (
  `voter_id` int(10) unsigned NOT NULL DEFAULT '0',
  `res_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` enum('TX_RX','TX','RX') NOT NULL DEFAULT 'TX_RX',
  `broadcast` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rx_related_transmitter` int(11) NOT NULL DEFAULT '0',
  `modified_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`voter_id`,`res_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `voter_res`
--

LOCK TABLES `voter_res` WRITE;
/*!40000 ALTER TABLE `voter_res` DISABLE KEYS */;
/*!40000 ALTER TABLE `voter_res` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `voter_res_corrupt`
--

DROP TABLE IF EXISTS `voter_res_corrupt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `voter_res_corrupt` (
  `voter_id` int(11) NOT NULL DEFAULT '0',
  `res_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`voter_id`,`res_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `voter_res_corrupt`
--

LOCK TABLES `voter_res_corrupt` WRITE;
/*!40000 ALTER TABLE `voter_res_corrupt` DISABLE KEYS */;
/*!40000 ALTER TABLE `voter_res_corrupt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ws_neighbours`
--

DROP TABLE IF EXISTS `ws_neighbours`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ws_neighbours` (
  `ws_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ws_neighbour_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ws_id`,`ws_neighbour_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ws_neighbours`
--

LOCK TABLES `ws_neighbours` WRITE;
/*!40000 ALTER TABLE `ws_neighbours` DISABLE KEYS */;
/*!40000 ALTER TABLE `ws_neighbours` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ws_sessions`
--

DROP TABLE IF EXISTS `ws_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ws_sessions` (
  `session_id` varchar(255) NOT NULL DEFAULT '',
  `session_expires` int(10) unsigned NOT NULL DEFAULT '0',
  `session_data` text,
  `current_page` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ws_sessions`
--

LOCK TABLES `ws_sessions` WRITE;
/*!40000 ALTER TABLE `ws_sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ws_sessions` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2013-07-31 17:38:05
