#ifndef CONTROLOPCODES_H_
#define CONTROLOPCODES_H_

/* COMMAND OPCODES */
#define CMD_READ 0x11
#define CMD_WRITE_INFO 0x12
#define CMD_ENTER_BSL_MODE 0x13
#define CMD_RESET 0x14
#define CMD_SELF_TEST 0x15
#define CMD_SEND_KEY_SIG 0x16
#define CMD_SEND_BYTE 0x17

/* RESPONSE OPCODES */
#define RSP_ERROR 0x20
#define RSP_READ 0x21
#define RSP_WRITE_INFO 0x22
#define RSP_ENTER_BSL_MODE 0x23
#define RSP_RESET 0x24
#define RSP_SELF_TEST 0x25
#define RSP_SEND_KEY_SIG 0x26
#define RSP_SEND_BYTE 0x27

/* BROADCAST OPCODES */
#define BCST_RECEIVE_BYTE 0x31

/* READ OPCODES */
#define READ_AP_VER 0x01
#define READ_FW_VER 0x02
#define READ_UNIQUE_ID 0x03
#define READ_MODEL_ID 0x04
#define READ_HW_REV 0x05
#define READ_SER_NUM 0x06

/* WRITE OPCODES */
#define WRITE_MDL_REV 0x01
#define WRITE_SER 0x02

/* ERROR OPCODES */
#define ERR_OTHER 0x00
#define ERR_INVALID_CMD_LENGTH 0x01
#define ERR_INVALID_CMD_OPCODE 0x02
#define ERR_INVALID_READ_OPCODE 0x03
#define ERR_READ_FAILED 0x04
#define ERR_INVALID_WRITE_OPCODE 0x05
#define ERR_WRITE_FAILED 0x06

#endif /* CONTROLOPCODES_H_ */