# 1 "c:\\Users\\natalie\\codestuff\\KFDTool-fork\\fw\\ino\\kfd-avr\\kfd-avr.ino"
# 2 "c:\\Users\\natalie\\codestuff\\KFDTool-fork\\fw\\ino\\kfd-avr\\kfd-avr.ino" 2
# 3 "c:\\Users\\natalie\\codestuff\\KFDTool-fork\\fw\\ino\\kfd-avr\\kfd-avr.ino" 2
# 4 "c:\\Users\\natalie\\codestuff\\KFDTool-fork\\fw\\ino\\kfd-avr\\kfd-avr.ino" 2
# 5 "c:\\Users\\natalie\\codestuff\\KFDTool-fork\\fw\\ino\\kfd-avr\\kfd-avr.ino" 2
# 6 "c:\\Users\\natalie\\codestuff\\KFDTool-fork\\fw\\ino\\kfd-avr\\kfd-avr.ino" 2
# 7 "c:\\Users\\natalie\\codestuff\\KFDTool-fork\\fw\\ino\\kfd-avr\\kfd-avr.ino" 2
# 8 "c:\\Users\\natalie\\codestuff\\KFDTool-fork\\fw\\ino\\kfd-avr\\kfd-avr.ino" 2

uint16_t cmdCount;
uint8_t cmdData[128];
uint16_t rxReady;
uint8_t rxTemp;

void setup()
{
    halInit();
    spConnect();

    twiInit();

    halActLedOn();
}

void loop()
{
    cmdCount = spRxData(cmdData);

    if (cmdCount > 0)
    {
        if (cmdData[0] == 0x11) // read
        {
            if (cmdCount == 2)
            {
                if (cmdData[1] == 0x01) // read adapter protocol version
                {
                    uint8_t rspData[5];

                    rspData[0] = 0x21;
                    rspData[1] = 0x01;
                    rspData[2] = 0x02;
                    rspData[3] = 0x00;
                    rspData[4] = 0x00;

                    spTxDataWait(rspData, sizeof(rspData));
                }
                else if (cmdData[1] == 0x02) // read firmware version
                {
                    uint8_t rspData[5];

                    rspData[0] = 0x21;
                    rspData[1] = 0x02;
                    rspData[2] = 0x01;
                    rspData[3] = 0x04;
                    rspData[4] = 0x00;

                    spTxDataWait(rspData, sizeof(rspData));
                }
                else if (cmdData[1] == 0x03) // read unique id
                {
                    uint8_t ser0;
                    uint8_t ser1;
                    uint8_t ser2;
                    uint8_t ser3;
                    uint8_t ser4;
                    uint8_t ser5;
                    uint8_t ser6;
                    uint8_t ser7;

                    getUID8(&ser0, &ser1, &ser2, &ser3, &ser4, &ser5, &ser6, &ser7);

                    uint8_t rspData[12];

                    rspData[0] = 0x21;
                    rspData[1] = 0x03;
                    rspData[2] = 0x09; // id length
                    rspData[3] = 0x10; // id source
                    rspData[4] = ser0;
                    rspData[5] = ser1;
                    rspData[6] = ser2;
                    rspData[7] = ser3;
                    rspData[8] = ser4;
                    rspData[9] = ser5;
                    rspData[10] = ser6;
                    rspData[11] = ser7;

                    spTxDataWait(rspData, sizeof(rspData));
                }
                else if (cmdData[1] == 0x04) // read model id
                {
                    uint16_t status;
                    uint8_t hwId;

                    status = idReadModelId(&hwId);

                    if (status) // check if available
                    {
                        uint8_t rspData[3];

                        rspData[0] = 0x21;
                        rspData[1] = 0x04;
                        rspData[2] = hwId;

                        spTxDataWait(rspData, sizeof(rspData));
                    }
                    else // no model id available
                    {
                        uint8_t rspData[3];

                        rspData[0] = 0x21;
                        rspData[1] = 0x04;
                        rspData[2] = 0x00;

                        spTxDataWait(rspData, sizeof(rspData));
                    }
                }
                else if (cmdData[1] == 0x05) // read hardware revision
                {
                    uint16_t status;
                    uint8_t hwRevMaj;
                    uint8_t hwRevMin;

                    status = idReadHwRev(&hwRevMaj, &hwRevMin);

                    if (status == 1) // check if available
                    {
                        uint8_t rspData[4];

                        rspData[0] = 0x21;
                        rspData[1] = 0x05;
                        rspData[2] = hwRevMaj;
                        rspData[3] = hwRevMin;

                        spTxDataWait(rspData, sizeof(rspData));
                    }
                    else // no hardware revision available
                    {
                        uint8_t rspData[4];

                        rspData[0] = 0x21;
                        rspData[1] = 0x05;
                        rspData[2] = 0x00;
                        rspData[3] = 0x00;

                        spTxDataWait(rspData, sizeof(rspData));
                    }
                }
                else if (cmdData[1] == 0x06) // read serial number
                {
                    uint16_t status;
                    uint8_t ser0;
                    uint8_t ser1;
                    uint8_t ser2;
                    uint8_t ser3;
                    uint8_t ser4;
                    uint8_t ser5;

                    status = idReadSerNum(&ser0, &ser1, &ser2, &ser3, &ser4, &ser5);

                    if (status == 1) // check if available
                    {
                        uint8_t rspData[9];

                        rspData[0] = 0x21;
                        rspData[1] = 0x06;
                        rspData[2] = 0x06; // serial length
                        rspData[3] = ser0;
                        rspData[4] = ser1;
                        rspData[5] = ser2;
                        rspData[6] = ser3;
                        rspData[7] = ser4;
                        rspData[8] = ser5;

                        spTxDataWait(rspData, sizeof(rspData));
                    }
                    else // no serial number available
                    {
                        uint8_t rspData[3];

                        rspData[0] = 0x21;
                        rspData[1] = 0x06;
                        rspData[2] = 0x00; // serial length

                        spTxDataWait(rspData, sizeof(rspData));
                    }
                }
                else // invalid read opcode
                {
                    uint8_t rspData[2];

                    rspData[0] = 0x20;
                    rspData[1] = 0x03;

                    spTxDataWait(rspData, sizeof(rspData));
                }
            }
            else // invalid command length
            {
                uint8_t rspData[2];

                rspData[0] = 0x20;
                rspData[1] = 0x01;

                spTxDataWait(rspData, sizeof(rspData));
            }
        }
        else if (cmdData[0] == 0x12) // write info
        {
            if (cmdCount > 1)
            {
                if (cmdData[1] == 0x01) // write model id and hardware revision
                {
                    if (cmdCount == 5)
                    {
                        uint16_t result;

                        result = idWriteModelIdHwRev(cmdData[2], cmdData[3], cmdData[4]);

                        if (result == 1)
                        {
                            uint8_t rspData[1];

                            rspData[0] = 0x22;

                            spTxDataWait(rspData, sizeof(rspData));
                        }
                        else // write failed
                        {
                            uint8_t rspData[2];

                            rspData[0] = 0x20;
                            rspData[1] = 0x06;

                            spTxDataWait(rspData, sizeof(rspData));
                        }
                    }
                    else // invalid command length
                    {
                        uint8_t rspData[2];

                        rspData[0] = 0x20;
                        rspData[1] = 0x01;

                        spTxDataWait(rspData, sizeof(rspData));
                    }
                }
                else if (cmdData[1] == 0x02) // write serial number
                {
                    if (cmdCount == 8)
                    {
                        uint16_t result;

                        result = idWriteSerNum(cmdData[2], cmdData[3], cmdData[4], cmdData[5], cmdData[6], cmdData[7]);

                        if (result == 1)
                        {
                            uint8_t rspData[1];

                            rspData[0] = 0x22;

                            spTxDataWait(rspData, sizeof(rspData));
                        }
                        else // write failed
                        {
                            uint8_t rspData[2];

                            rspData[0] = 0x20;
                            rspData[1] = 0x06;

                            spTxDataWait(rspData, sizeof(rspData));
                        }
                    }
                    else // invalid command length
                    {
                        uint8_t rspData[2];

                        rspData[0] = 0x20;
                        rspData[1] = 0x01;

                        spTxDataWait(rspData, sizeof(rspData));
                    }
                }
                else // invalid write opcode
                {
                    uint8_t rspData[2];

                    rspData[0] = 0x20;
                    rspData[1] = 0x05;

                    spTxDataWait(rspData, sizeof(rspData));
                }
            }
            else // invalid command length
            {
                uint8_t rspData[2];

                rspData[0] = 0x20;
                rspData[1] = 0x01;

                spTxDataWait(rspData, sizeof(rspData));
            }
        }
        else if (cmdData[0] == 0x13) // enter bsl mode
        {
            if (cmdCount == 1)
            {
                uint8_t rspData[1];

                rspData[0] = 0x23;

                spTxDataWait(rspData, sizeof(rspData));

                halDelayMs(1000); // wait 1 second

                spDisconnect(); // disconnect usb

                halDelayMs(3000); // wait 3 seconds

                halActLedOff();

                halEnterBsl();
            }
            else // invalid command length
            {
                uint8_t rspData[2];

                rspData[0] = 0x20;
                rspData[1] = 0x01;

                spTxDataWait(rspData, sizeof(rspData));
            }
        }
        else if (cmdData[0] == 0x14) // reset
        {
            if (cmdCount == 1)
            {
                uint8_t rspData[1];

                rspData[0] = 0x24;

                spTxDataWait(rspData, sizeof(rspData));

                halDelayMs(1000); // wait 1 second

                spDisconnect(); // disconnect usb

                halDelayMs(3000); // wait 3 seconds

                halActLedOff();

                halReset();
            }
            else // invalid command length
            {
                uint8_t rspData[2];

                rspData[0] = 0x20;
                rspData[1] = 0x01;

                spTxDataWait(rspData, sizeof(rspData));
            }
        }
        else if (cmdData[0] == 0x15) // self test
        {
            if (cmdCount == 1)
            {
                uint8_t rspData[2];

                uint8_t result;
                result = twiSelfTest();

                rspData[0] = 0x25;
                rspData[1] = result;

                spTxDataWait(rspData, sizeof(rspData));
            }
            else // invalid command length
            {
                uint8_t rspData[2];

                rspData[0] = 0x20;
                rspData[1] = 0x01;

                spTxDataWait(rspData, sizeof(rspData));
            }
        }
        else if (cmdData[0] == 0x16) // send key signature
        {
            if (cmdCount == 2)
            {
                twiSendKeySig();

                uint8_t rspData[1];

                rspData[0] = 0x26;

                spTxDataWait(rspData, sizeof(rspData));
            }
            else // invalid command length
            {
                uint8_t rspData[2];

                rspData[0] = 0x20;
                rspData[1] = 0x01;

                spTxDataWait(rspData, sizeof(rspData));
            }
        }
        else if (cmdData[0] == 0x17) // send byte
        {
            if (cmdCount == 3)
            {
                twiSendPhyByte(cmdData[2]);

                uint8_t rspData[1];

                rspData[0] = 0x27;

                spTxDataWait(rspData, sizeof(rspData));
            }
            else // invalid command length
            {
                uint8_t rspData[2];

                rspData[0] = 0x20;
                rspData[1] = 0x01;

                spTxDataWait(rspData, sizeof(rspData));
            }
        }
        else // invalid command opcode
        {
            uint8_t rspData[2];

            rspData[0] = 0x20;
            rspData[1] = 0x02;

            spTxDataWait(rspData, sizeof(rspData));
        }
    }

    rxReady = twiReceiveByte(&rxTemp);

    if (rxReady == 1)
    {
        uint8_t bcstData[3];

        bcstData[0] = 0x31;
        bcstData[1] = 0x00; // reserved (set to 0x00)
        bcstData[2] = rxTemp;

        spTxDataBack(bcstData, sizeof(bcstData));
    }
}
