@echo off

rem -----------------------------------------------------------------------------
rem |                                                                           |
rem |                 Copyright 2021-2025 Motorola Solutions Inc.               |
rem |                          All Rights Reserved.                             |
rem |                                                                           |
rem -----------------------------------------------------------------------------

set itmClientRunning=0
set CPSPlusRunning=0

%WINDIR%\System32\WindowsPowerShell\v1.0\powershell.exe -NoProfile -ExecutionPolicy Bypass -Command ^
" ^
$processes = Get-WmiObject Win32_Process ^| Where-Object { $_.Name -eq 'iTMClient.exe' }; ^
foreach ($process in $processes) ^
{ ^
  Write-Host 'ITMClient is running...'; ^
  exit 1; ^
} ^
"

if "%ERRORLEVEL%" == "1" (
  set itmClientRunning=1
)

%WINDIR%\System32\WindowsPowerShell\v1.0\powershell.exe -NoProfile -ExecutionPolicy Bypass -Command ^
" ^
$processes = Get-WmiObject Win32_Process ^| Where-Object { $_.Name -eq 'CPSPlus.exe' -and $_.CommandLine -like '*iTMClient*' }; ^
foreach ($process in $processes) ^
{ ^
  Write-Host 'CPSPlus is running...'; ^
  exit 1; ^
} ^
"

if "%ERRORLEVEL%" == "1" (
  set CPSPlusRunning=2
)

set /A "result= itmClientRunning | CPSPlusRunning"
exit /B %result%