@echo off
rem -----------------------------------------------------------------------------------------------
rem |                                                                                             |
rem |                       Copyright 2011 - 2025 Motorola Solutions Inc.                         |
rem |                                   All Rights Reserved.                                      |
rem |                                                                                             |
rem -----------------------------------------------------------------------------------------------
rem |                                                                                             |
rem |                     Integrated Terminal Management                                          |
rem |                                                                                             |
rem | provisioningTool.bat                                                                        |
rem |                                                                                             |
rem | This script will import radios and jobs from an XML or csv file.                            |
rem |                                                                                             |
rem | Usage for systems without Extended Agency Partitioning:                                     |
rem |    provisioningTool.bat <userid> <password> <fullFileName>                                  |
rem |                                                                                             |
rem | Usage for systems with Extended Agency Partitioning:                                        |
rem |    provisioningTool.bat <userid> <password> <fullFileName> -AgencyName <agencyName>         |
rem | In case of radio update -Update parameter should be used, update is possible only for       |
rem |    csv files, valid usage:                                                                  |
rem |    provisioningTool.bat <userid> <password> <fullFileName> -AgencyName <agencyName> -Update |
rem |    provisioningTool.bat <userid> <password> <fullFileName> -Update                          |
rem |                                                                                             |
rem |    where <userid> user id of the iTM user                                                   |
rem |    and   <password> is password of the iTM user                                             |
rem |    where <fullFileName> is the full path and name of the XML or csv                         |
rem |    import file.                                                                             |
rem |    and <agencyName> is the name of Agency                                                   |
rem | Examples:                                                                                   |
rem |    provisioningTool.bat myUserName myPassword "c:\temp\import.xml"                          |
rem |    provisioningTool.bat myUserName myPassword "c:\temp\import.csv"                          |
rem |    provisioningTool.bat myUserName myPassword "c:\temp\import.csv" -Update                  |
rem |                                                                                             |
rem |    provisioningTool.bat myUserName myPassword "c:\temp\import.xml" -AgencyName Agency3      |
rem -----------------------------------------------------------------------------------------------

set CURRENT_DIR=%cd%
cd /D %~dp0

for /F "tokens=* delims=" %%a in (iTMClient.ini) do (
  for /F "tokens=1,2 delims==" %%b in ("%%a") do (
    if "%%b" == "-DlogDir" set logdir="%%c"
  )
)

rem Call a java class that will import the radios and jobs from the xml file.
call jdk\jre\bin\java -DlogDir=%logdir% -Dlog4j.configurationFile="configuration\\client_log4j2.xml" -Xmx512M -classpath .\plugins\* com.mot.dm.client.dmImpl.util.ImportRadiosAndJobsFromFile %*

cd /D %CURRENT_DIR%
