@ECHO OFF

rem ---------------------------------------------------------------------------
rem |                                                                         |
rem |               Copyright 2021-2025 Motorola Solutions Inc.               |
rem |                            All Rights Reserved.                         |
rem |                                                                         |
rem ---------------------------------------------------------------------------
rem |                                                                         |
rem |                     Integrated Terminal Management                      |
rem |                                                                         |
rem | DataBackupPerAgency.bat                                                 |
rem |                                                                         |
rem | The script starts the backup for chosen agency and localization.        |
rem |                                                                         |
rem | Parameters:                                                             |
rem |   backup location                                                       |
rem |   agency identifier (uuid or name)                                      |
rem |                                                                         |
rem | Supported error codes:                                                  |
rem | Code    Explanation                                                     |
rem | 0       Backup completed successful                                     |
rem | X       If not 0, the backup failed.                                    |
rem ---------------------------------------------------------------------------

set EXIT_CODE=0
set CURRENT_DIR=%cd%
set JAVA_HOME=%CURRENT_DIR%\jdk
set BACKUP_PATH=%~1
set AGENCY_IDENTIFIER=%~2

IF "%BACKUP_PATH%" EQU "" (
	echo Backup path must be provided
	set EXIT_CODE=1
	goto END
)

IF "%AGENCY_IDENTIFIER%" EQU "" (
	echo "Agency identifier (uuid or name) must be provided"
	set EXIT_CODE=1
    goto END
)

REM Check if the server is running
REM ----------------------------------------------------------------
net start | find /i "Apache Tomcat">NUL 
IF %ERRORLEVEL% NEQ 0 (
    set EXIT_CODE=1
    echo The Server is not running, please start server before running backup.
    echo.
    goto END
)
echo %CURRENT_DIR%
rem Get the data repository location
rem ----------------------------------------------------------------
"%JAVA_HOME%\jre\bin\java" -cp "%CURRENT_DIR%\Tomcat\webapps\dms\WEB-INF\classes;%CURRENT_DIR%\Tomcat\webapps\dms\WEB-INF\lib\*" -Xmx512m com.mot.dm.server.util.ServerUtil "backupServerPerAgency" "%BACKUP_PATH%" "%AGENCY_IDENTIFIER%"
set EXIT_CODE=%ERRORLEVEL%

:END
cd %CURRENT_DIR%\
exit /B %EXIT_CODE%