@echo off
rem Copyright 2013-2025 Motorola Solutions, Inc.
rem All Rights Reserved.
rem Motorola Solutions Confidential Restricted

set UPGRADE_FILE_PATH=%~1
set TEMP_LOCATION=%3
set SERVER_UPGRADE_PATH=%UPGRADE_FILE_PATH:Upgrade.bat=%
set DATA_UPGRADE_PATH=%~4
set CURRENT_DIR=%cd%

set LogFile="%temp%\m_server_log.txt"

type nul>"%LogFile%"
echo %1%>>%LogFile%
echo %2%>>%LogFile%
echo %3%>>%LogFile%
echo %4%>>%LogFile%
echo --------------->>%LogFile%
echo %~1>>%LogFile%
echo %~2>>%LogFile%
echo %~3>>%LogFile%
echo %~4>>%LogFile%
echo %~5>>%LogFile%

::@set >>"%LogFile%"
::cd >>"%LogFile%"
PUSHD %SERVER_UPGRADE_PATH%

echo SERVER_UPGRADE_PATH: %SERVER_UPGRADE_PATH%>>"%LogFile%"
set SERVER_PATH=%SERVER_UPGRADE_PATH:\Tools\Upgrade\=%\
echo SERVER_PATH: %SERVER_PATH%>>"%LogFile%"

echo DATA_UPGRADE_PATH: %DATA_UPGRADE_PATH%>>"%LogFile%"

echo ***** START to apply SPU *****>>"%LogFile%"
echo Current directory: %CURRENT_DIR%>>"%LogFile%"
echo Server directory is: %SERVER_PATH%>>"%LogFile%"
echo Server temporary directory is: %TEMP_LOCATION%>>"%LogFile%"
echo Server upgrade directory is: %SERVER_UPGRADE_PATH%>>"%LogFile%"
echo Data upgrade directory is: %DATA_UPGRADE_PATH%>>"%LogFile%"

if NOT exist "%TEMP_LOCATION%" (
    echo Temp dir does not exist, create it and grant full access level>>"%LogFile%"
    md %TEMP_LOCATION%
    cacls %TEMP_LOCATION% /E /D everyone
    cacls %TEMP_LOCATION% /E /G everyone:F
)

rem Create backup dir
set BACKUP_DIR=%TEMP_LOCATION%\SPUBackup
md "%BACKUP_DIR%"
echo BACKUP_DIR directory is: %BACKUP_DIR%>>"%LogFile%"

set BACKUP_DIR_SERVER=%TEMP_LOCATION%\SPUBackup_server
md "%BACKUP_DIR_SERVER%"
echo BACKUP_DIR_SERVER directory is: %BACKUP_DIR_SERVER%>>"%LogFile%"

set BACKUP_DIR_DATA=%TEMP_LOCATION%\SPUBackup_data
md "%BACKUP_DIR_DATA%"
echo BACKUP_DIR_DATA directory is: %BACKUP_DIR_DATA%>>"%LogFile%"

rem Single rollback operation
if "%~2"=="rollback" goto ROLLBACK

rem Back up the files specified in the spu_copy_file_list.txt file
rem The file is a "property" file with format:
rem <file name>=<relative path>
rem where <file name> is just the file name and <relative path> is the path from within the iTMServer directory, e.g.:
rem ServerUtil.class=Tomcat\webapps\dms\WEB-INF\classes\com\mot\dm\server\util\ServerUtil.class
rem %%a is the <file name> and %%b is <relative path>
echo Begin to backup files>>"%LogFile%"
for /F "tokens=*" %%a in (%TEMP_LOCATION%\spu_copy_file_list.txt) do (
    echo Backup file "%SERVER_PATH%\%%a" to "%BACKUP_DIR%\%%a"
    echo Backup file "%SERVER_PATH%\%%a" to "%BACKUP_DIR%\%%a">>"%LogFile%"
    
	if exist "%SERVER_PATH%%%a\" (
        xcopy /Y /R /S /E "%SERVER_PATH%\%%a" "%BACKUP_DIR%\%%a\">nul 2>nul|| goto BACKUPFAIL
        echo Backup folder "%%a" - successful>>"%LogFile%"
    ) else if exist "%SERVER_PATH%\%%a" (
		xcopy /Y /I /F "%SERVER_PATH%\%%a" "%BACKUP_DIR%\%%a*">nul 2>nul|| goto BACKUPFAIL
		echo Backup file [%%a] - successful >> "%LogFile%"
	) else (
        rem New file need no backup
		echo New file "%%a" will be added>>"%LogFile%"
    )

    echo Backup file "%%a" - successful>>"%LogFile%"
)

rem Also backup the xml files
copy "%SERVER_UPGRADE_PATH%\upgrade_scripts\*upgrade.xml" "%BACKUP_DIR_SERVER%\">nul 2>nul|| goto BACKUPFAIL
copy "%DATA_UPGRADE_PATH%*upgrade.xml" "%BACKUP_DIR_DATA%\">nul 2>nul|| goto BACKUPFAIL
echo Backup files "*upgrade.xml" - successful>>"%LogFile%"

echo --- Backup necessary files successfully completed--->>"%LogFile%"

rem Copy the files
rem %%a is the <file name> and %%b is <relative path> (see above for backup)
for /F "tokens=*" %%a in (%TEMP_LOCATION%\spu_copy_file_list.txt) do (
    echo Copy file %%a
    echo Copy file "%TEMP_LOCATION%%%a" to "%SERVER_PATH%%%a">>"%LogFile%"
    
	if exist "%SERVER_PATH%\%%a" (
	    xcopy /Y /R /S /E /F "%TEMP_LOCATION%%%a" "%SERVER_PATH%%%a">nul 2>nul|| goto ROLLBACK
    ) else (
        md "%SERVER_PATH%%%a"
        rd "%SERVER_PATH%%%a"      
	    copy /y "%TEMP_LOCATION%%%a" "%SERVER_PATH%%%a">nul 2>nul|| goto ROLLBACK 
    )

    echo Copy SPU file "%%a" - successful>>"%LogFile%"
)

rem copy MenuItem
rem prepare path
rem set ChangeServerPortFolder=%Server_Path%Tools\ChangeServerPort\
rem set ChangeServerPortPath=%ChangeServerPortFolder%ChangeServerPort.bat
rem echo ChangeServerPortPath:%ChangeServerPortPath%>>"%LogFile%"
rem read lnkPath from registry
rem for /f "tokens=1,2,3,4,*" %%i in ('reg QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders" ^|rem find /i "Common Programs"') do set SecOne=%%l
rem for /f "tokens=1,2,3,4,*" %%i in ('reg QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders" ^|rem find /i "Common Programs"') do set SecTwo=%%m
rem set lnkPath=%SecOne% %SecTwo%\Motorola\iTMServer\Change Server Port.lnk
rem echo lnkPath:%lnkPath%>>"%LogFile%"
rem create shortcut
rem "%TEMP_LOCATION%\SHORTCUT.EXE" -f -t "%ChangeServerPortPath%" -n "%lnkPath%" -i "%Server_Path%Shortcut.ico" -x 0 -d rem "%ChangeServerPortFolder%\"

rem Copy xml files
copy %TEMP_LOCATION%\Tools\Upgrade\upgrade_scripts\*upgrade.xml "%SERVER_UPGRADE_PATH%\upgrade_scripts\" || goto ROLLBACK
copy %TEMP_LOCATION%\Tools\Upgrade\upgrade_scripts\*_spu_*.psql "%SERVER_UPGRADE_PATH%\upgrade_scripts\" || goto ROLLBACK
copy %TEMP_LOCATION%\Tools\Upgrade\upgrade_scripts\*upgrade.xml "%DATA_UPGRADE_PATH%" || goto ROLLBACK
copy %TEMP_LOCATION%\Tools\Upgrade\upgrade_scripts\*_spu_*.psql "%DATA_UPGRADE_PATH%" || goto ROLLBACK
copy %TEMP_LOCATION%\*upgrade.xml "%DATA_UPGRADE_PATH%" || goto ROLLBACK

echo --- Copy of the necessary files successfully completed--->>"%LogFile%"

rem Upgrade the database
echo --- Executing database upgrade operation. Please wait a moment ---
start "Upgrade of the database" /wait "%UPGRADE_FILE_PATH%" %2%
set EXIT_CODE=%ERRORLEVEL%
IF %EXIT_CODE% NEQ 0 (
    echo Upgrade of the database failed. Please restore the last backed up database!>>"%LogFile%"
    goto ROLLBACK
)

echo --- Database upgrade successfully completed--->>"%LogFile%"

rem Update iTM Otap

if NOT exist %TEMP_LOCATION%\iTMOtap.exe (
	goto EXITSUCCESS
)
echo --- Updating iTM Otap. Please wait a moment ---
start /wait %TEMP_LOCATION%\iTMOtap.exe /S /v"/qn
set EXIT_CODE=%ERRORLEVEL%
IF %EXIT_CODE% NEQ 0 (
    echo Installation of iTM Otap failed>>"%LogFile%"
    goto ROLLBACK
)

echo --- Update of iTM Otap successfully completed---

rem Update iTM Configuration Job

if not exist %TEMP_LOCATION%\iTMConfigurationJob.msi (
    goto EXITSUCCESS
)
echo --- Updating iTM Configuration Job. Please wait a moment ---
echo --- Uninstall current iTM Configuration Job ---

start /wait msiexec /x {D48009C8-7EBA-46DC-B18A-1A49CE27E046} /qn
set EXIT_CODE=%ERRORLEVEL%
IF %EXIT_CODE% NEQ 0 (
    echo Uninstalling iTM Configuration Job failed>>"%LogFile%"
    goto ROLLBACK
)

start /wait %TEMP_LOCATION%\iTMConfigurationJob.msi /qn
set EXIT_CODE=%ERRORLEVEL%
IF %EXIT_CODE% NEQ 0 (
    echo Installation of iTM Configuration Job failed>>"%LogFile%"
    goto ROLLBACK
)
echo --- Update of iTM Configuration Job successfully completed---

rem Finally upgrade the CPS Plus Editor
rem This is the last step as it cannot be rolled back if something fails are this step

if NOT exist %TEMP_LOCATION%\CPSPlusInstaller32Setup.exe (
	goto EXITSUCCESS
)

echo --- Updating Codeplug Editor. Please wait a moment ---
set CPS_PLUS_PATH=%SERVER_PATH%\iTMCPSPlusEditor
echo CPS_PLUS_PATH: %CPS_PLUS_PATH%>>"%LogFile%"
%TEMP_LOCATION%\CPSPlusInstaller32Setup.exe /instance=2 /s /v"/qn INSTALLDIR=\"%CPS_PLUS_PATH%\" ARPSYSTEMCOMPONENT=1\"
set EXIT_CODE=%ERRORLEVEL%
IF %EXIT_CODE% NEQ 0 (
    echo Installation of CPS Plus Editor failed>>"%LogFile%"
    goto ROLLBACK
)

echo --- Update of CPS successfully completed---

goto EXITSUCCESS

:ROLLBACK

echo ERROR: Error happened during installation, error code=%ERRORLEVEL%, will proceed with roll back action>>"%LogFile%"
rem Rollback server files
for /F "tokens=*" %%a in (%TEMP_LOCATION%\spu_copy_file_list.txt) do (
    echo Rollback file %BACKUP_DIR%\%%a to "%SERVER_PATH%\%%a"
	
    if exist "%BACKUP_DIR%\%%a\" (
        xcopy /Y /R /S /E "%BACKUP_DIR%\%%a" "%SERVER_PATH%\%%a\">nul 2>nul
		echo Rollback folder "%%a" - successful>>"%LogFile%"
    ) else if exist "%BACKUP_DIR%%%a" (
		copy "%BACKUP_DIR%\%%a" "%SERVER_PATH%\%%a">nul 2>nul
		echo Rollback file "%%a" - successful>>"%LogFile%"
	)
)

rem Rollback xml files
copy /y "%BACKUP_DIR_SERVER%\*upgrade.xml" "%SERVER_UPGRADE_PATH%\upgrade_scripts\"
copy /y "%BACKUP_DIR_DATA%\*upgrade.xml" "%DATA_UPGRADE_PATH%"

echo Roll back finished, the SPU has not been applied>>"%LogFile%"
goto EXITFAIL

:BACKUPFAIL

echo ERROR: Error happens during backup files, error code=%ERRORLEVEL%, the SPU will not be applied>>"%LogFile%"

:EXITFAIL
rd /s /q "%BACKUP_DIR%"
rd /s /q "%BACKUP_DIR_SERVER%"
rd /s /q "%BACKUP_DIR_DATA%"
echo ERROR: Apply Server SPU failed>>"%LogFile%"
echo *****END*****
POPD
exit /B -1

:EXITSUCCESS
echo --- Apply Server SPU successfully completed--->>"%LogFile%"
echo *****END*****
POPD
exit /B 0