@ECHO OFF
REM -----------------------------------------------------------------------
REM          CMDPLUS harddrive installation routine   (3 1/2 in. disk)
REM -----------------------------------------------------------------------
REM
REM          This batch file installs the following files:
REM
REM          DISK#          FILE NAME             DESTINATION
REM         -------        -----------           -------------
REM         DISK 1         CMDPLUS.TAB           C:\CMDPLUS.BAT
REM         DISK 1         CPA03.DAT             C:\MRSS\CMDPLUS\ARCHIVE
REM         DISK 1         CPA03.K01             C:\MRSS\CMDPLUS\ARCHIVE
REM         DISK 1         CP.EXE                C:\MRSS\CMDPLUS
REM         ----------------------------------------------------


CLS
IF NOT EXIST %1:\*.* GOTO HDDRVERR
GOTO INTRO
:LB_INT
GOTO CRTDIR
:LB_CRT

REM -----------------------------------------------------------------------
REM                Ensure DISK #1 is in Floppy Drive and Copy Files
REM -----------------------------------------------------------------------

IF EXIST CP.EXE GOTO IN_DSK1
GOTO DISK1
:LB_DSK1
IF EXIST CP.EXE GOTO IN_DSK1
GOTO DISK1
:LB_DSK1
IF EXIST CP.EXE GOTO IN_DSK1
GOTO DSK1_ERR

:IN_DSK1
CLS
ECHO    ͻ
ECHO                       CommandPLUS Radio Service Software                   
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                           
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                                                                            
ECHO                  Copying the contents of DISK #1 to hard disk.             
ECHO                                                                            
ECHO                                                                           
ECHO                                                                            
ECHO                                                                           
ECHO                                                                            
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO    ĺ
ECHO         Press Ctrl-C, at any time, to ABORT the installation process.     
ECHO    ͼ
ECHO 
ECHO 
ECHO 
REM IF NOT EXIST C:\MRSS\CMDPLUS\ARCHIVE\CPA03.DAT  COPY CPA03.* C:\MRSS\CMDPLUS\ARCHIVE /V >NUL
IF NOT EXIST %1:\CMDPLUS.BAT COPY CMDPLUS.TAB %1:\CMDPLUS.BAT /V >NUL
CP -o %1:\MRSS\CMDPLUS >NUL
if not errorlevel 1 goto CONTINUE
if errorlevel 50 goto BAD_FULL
if errorlevel 13 goto BAD_EXE
if errorlevel 9 goto BAD_INSTALL
if errorlevel 4 goto BAD_MEM
if errorlevel 3 goto BAD_NOEXE
if errorlevel 1 goto BAD_INSTALL
:CONTINUE
REM copy %1:\MRSS\CMDPLUS\CP?03.* %1:\MRSS\CMDPLUS\ARCHIVE > NUL

GOTO ENDSUC


REM -----------------------------------------------------------------------
REM         INTRODUCTION SCREEN -- SHOULD MATCH BANNER SCREEN OF RSS
REM -----------------------------------------------------------------------

:INTRO
CLS
ECHO 
ECHO 
ECHO                                     HARD DISK
ECHO 
ECHO                                   INSTALLATION
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO 
ECHO                              RADIO SERVICE SOFTWARE
ECHO                                     for the
ECHO                                CommandPLUS Console
ECHO 
ECHO             VERSION   R03.03.00                             22-APR-97
ECHO 
ECHO          (C) Copyright MOTOROLA Inc. 1992-97.      All Rights Reserved.
ECHO 
PAUSE
GOTO LB_INT

REM -----------------------------------------------------------------------
REM         VERIFY EXISTENCE AND/OR CREATE NECESSARY SUB-DIRECTORIES
REM -----------------------------------------------------------------------

:CRTDIR
CLS
ECHO    ͻ
ECHO                       CommandPLUS Radio Service Software                   
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                           
ECHO                                                                            
ECHO         The following SUB-DIRECTORIES will be created on your system:     
ECHO                                                                           
ECHO                             %1:\MRSS                                        
ECHO                             %1:\MRSS\CMDPLUS                                
ECHO                             %1:\MRSS\CMDPLUS\ARCHIVE                        
ECHO                                                                           
ECHO                                                                            
ECHO                                                                           
ECHO                                                                            
ECHO         A BATCH file, CMDPLUS.BAT, will be placed in the root directory    
ECHO        to enable the user to execute the program from %1:\.                
ECHO                                                                           
ECHO    ĺ
ECHO         Press Ctrl-C, at any time, to ABORT the installation process.     
ECHO    ͼ
ECHO 
ECHO 
PAUSE
REM Confirm existence or create sub-directories
MD %1:\MRSS > NUL
MD %1:\MRSS\CMDPLUS > NUL
MD %1:\MRSS\CMDPLUS\ARCHIVE  > NUL
CLS
ECHO    ͻ
ECHO                       CommandPLUS Radio Service Software                   
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                           
ECHO                                                                            
ECHO                         The following SUB-DIRECTORIES:                    
ECHO                                                                           
ECHO                             %1:\MRSS                                        
ECHO                             %1:\MRSS\CMDPLUS                                
ECHO                             %1:\MRSS\CMDPLUS\ARCHIVE                        
ECHO                                                                           
ECHO                                                                            
ECHO               ... have been verified/created on the hard disk.            
ECHO                                                                            
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO    ĺ
ECHO         Press Ctrl-C, at any time, to ABORT the installation process.     
ECHO    ͼ
ECHO 
ECHO 
PAUSE
GOTO LB_CRT

REM -----------------------------------------------------------------------
REM                          Begin DISK PROMPT Section
REM -----------------------------------------------------------------------

:DISK1
CLS
ECHO    ͻ
ECHO                       CommandPLUS Radio Service Software                   
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                      Insert DISK #1 into floppy drive now.                 
ECHO                                                                           
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
PAUSE
GOTO LB_DSK1

REM -----------------------------------------------------------------------
REM                             Begin ERROR Section
REM -----------------------------------------------------------------------

:HDDRVERR
CLS
ECHO    ͻ
ECHO                       CommandPLUS Radio Service Software                   
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                     ERROR:  HARD DISK DRIVE %1: NOT FOUND                   
ECHO                                                                           
ECHO                   Modify HDINSTAL.BAT to Reflect That Drive.               
ECHO                                                                           
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:DSK1_ERR
ECHO 
CLS
ECHO    ͻ
ECHO                       CommandPLUS Radio Service Software                   
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                       ERROR:  FILE NOT FOUND ON DISK #1.                   
ECHO                                                                           
ECHO                                                                            
ECHO                      INSTALLATION PROCESS IS TERMINATED.                  
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:ENDSUC
CLS
ECHO    ͻ
ECHO                       CommandPLUS Radio Service Software                   
ECHO                        HARD DISK INSTALLATION PROCEDURE                    
ECHO    ͹
ECHO                                                                           
ECHO                                                                            
ECHO                                                                           
ECHO                      CommandPLUS Radio Service Software                   
ECHO                                                                            
ECHO            HARD DISK INSTALLATION PROCEDURE COMPLETED SUCCESSFULLY!        
ECHO                                                                            
ECHO                                                                           
ECHO                                                                            
ECHO                                                                           
ECHO                                                                            
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO    ĺ
ECHO                To start the program, type %1: {enter} and CMDPLUS          
ECHO    ͼ
ECHO 
ECHO 
PAUSE
GOTO ENDFAIL

:BAD_INSTALL 
ECHO 
CLS
ECHO    ͻ
ECHO                      CommandPlus Radio Service Software                    
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                         ERROR EXTRACTING PROGRAM FILES                     
ECHO                                                                           
ECHO                                                                            
ECHO                      INSTALLATION PROCESS IS TERMINATED.                  
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:BAD_FULL
ECHO 
CLS
ECHO    ͻ
ECHO                      CommandPlus Radio Service Software                    
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                         ERROR EXTRACTING PROGRAM FILES                     
ECHO                              DISK %1: IS FULL                              
ECHO                                                                            
ECHO                      INSTALLATION PROCESS IS TERMINATED.                  
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:BAD_NOEXE
ECHO 
CLS
ECHO    ͻ
ECHO                      CommandPlus Radio Service Software                    
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                         ERROR EXTRACTING PROGRAM FILES                     
ECHO                           CANNOT FIND FILE CP.EXE                         
ECHO                                                                            
ECHO                      INSTALLATION PROCESS IS TERMINATED.                  
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:BAD_EXE
ECHO 
CLS
ECHO    ͻ
ECHO                      CommandPlus Radio Service Software                    
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                         ERROR EXTRACTING PROGRAM FILES                     
ECHO                             ERROR IN FILE CP.EXE                          
ECHO                                                                            
ECHO                      INSTALLATION PROCESS IS TERMINATED.                  
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:BAD_MEM
ECHO 
CLS
ECHO    ͻ
ECHO                      CommandPlus Radio Service Software                    
ECHO                  HARD DISK INSTALLATION PROCEDURE TERMINATED.              
ECHO    ͹
ECHO                                                                            
ECHO                                                                           
ECHO                                                                           
ECHO                         ERROR EXTRACTING PROGRAM FILES                     
ECHO                             INSUFFICIENT MEMORY                           
ECHO                                                                            
ECHO                      INSTALLATION PROCESS IS TERMINATED.                  
ECHO                                                                           
ECHO                                                                           
ECHO    ͼ
GOTO ENDFAIL

:ENDFAIL
ECHO ON
