const yargs=require("yargs"),path=require("path"),_=require("lodash"),log=require("../../utils/loggerFactory.js"),commonCliParametersDefinition={"bts-username":{describe:"BTS username",type:"string",coerce:isDuplicate,demand:!0,requiresArg:!0,nargs:1},"bts-password":{describe:"BTS password",type:"string",coerce:isDuplicate,demand:!0,requiresArg:!0,nargs:1},"bts-host":{describe:"BTS host",type:"string",coerce:isDuplicate,demand:!0,requiresArg:!0,nargs:1},"bts-port":{describe:"BTS port",type:"number",coerce:toNumber,demand:!0,requiresArg:!0,nargs:1},"cli-host":{describe:"CLI socket server host",type:"string",coerce:isDuplicate,default:"localhost",requiresArg:!0,nargs:1},"cli-port":{describe:"CLI socket server port",type:"number",coerce:toNumber,requiresArg:!0,nargs:1},data:{describe:"JSON format request",type:"string",coerce:isDuplicate,requiresArg:!0,nargs:1},"input-file":{describe:"File to be included into the request message",type:"string",coerce:toAbsPath,requiresArg:!0,nargs:1},"plan-scf-file":{describe:"Plan scf file to be included into the request message",type:"string",coerce:toAbsPath,requiresArg:!0,nargs:1},"rat-scf-file":{describe:"rat scf file to be included into the request message",type:"string",coerce:toAbsPath,requiresArg:!0,nargs:1},"output-file":{describe:"Payload file extracted from the response message",type:"string",coerce:toAbsPath,requiresArg:!0,nargs:1},"output-json":{describe:"Redirects JSON responses to a specified file",type:"string",coerce:toAbsPath,requiresArg:!0,nargs:1},debug:{describe:"Log file",type:"string",coerce:isDuplicate,requiresArg:!0,nargs:1},"bundles-dir":{describe:"Bundles directory",type:"string",coerce:toAbsPath,default:path.join(__dirname,"../bundles"),requiresArg:!0,nargs:1},format:{describe:"Output format",type:"string",coerce:toFormat,requiresArg:!0,nargs:1,default:"compact"},timeout:{describe:"Specifies procedure timeout in milliseconds",type:"number",coerce:toNumber,requiresArg:!0,nargs:1}};function initYargs(e,r){yargs.options(e).version(r).help("h","Show help").alias("h","help").alias("v","version").wrap(yargs.terminalWidth())}function isDuplicate(e){if(_.isArray(e))throw new Error("Parse error: Duplicated arguments passed.");return e}function toFormat(e){const r=isDuplicate(e);if("compact"!==r&&"human"!==r)throw new Error(`Parse error: '${e}' is not a valid format (compact|human).`);return r}function toNumber(e){const r=Number(isDuplicate(e));if(!_.isNumber(r))throw new Error(`Parse error: '${e}' is not a number.`);return r}function toAbsPath(e){const r=isDuplicate(e);return path.resolve(process.cwd(),r)}function checkForArgv(){const e=yargs.argv;if(!e||_.isUndefined(e.cliPort)&&!e.data)return r="Not enough arguments passed, define if admin-cli should work as server or pass data directly.",yargs.showHelp(),log.error(r),!1;var r;return e}module.exports={commonCliParametersDefinition:commonCliParametersDefinition,checkForArgv:checkForArgv,initYargs:initYargs,isDuplicate:isDuplicate,toNumber:toNumber,toAbsPath:toAbsPath};