/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class BackupFileSystemView
extends FileSystemView {
    private static final String NEW_FOLDER_NAME = UIManager.getString("FileChooser.other.newFolder");
    private static final String NEW_FOLDER_NEXT_NAME = UIManager.getString("FileChooser.other.newFolder.subsequent");

    @Override
    public File getChild(File parent, String fileName) {
        return this.createFileObject(parent, fileName);
    }

    @Override
    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    @Override
    public String getSystemDisplayName(File file) {
        String name = null;
        if (file != null) {
            name = this.isRoot(file) ? file.getAbsolutePath() : file.getName();
        }
        return name;
    }

    @Override
    public Icon getSystemIcon(File file) {
        if (file != null) {
            return UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
        }
        return null;
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, NEW_FOLDER_NAME);
        int idx = 2;
        while (newFolder.exists() && idx < 100) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(NEW_FOLDER_NEXT_NAME, idx));
            ++idx;
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        newFolder.mkdirs();
        return newFolder;
    }

    @Override
    public File[] getRoots() {
        return File.listRoots();
    }

    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        Vector<File> files = new Vector<File>();
        File[] names = dir.listFiles();
        int nameCount = names == null ? 0 : names.length;
        int i = 0;
        while (i < nameCount) {
            if (Thread.currentThread().isInterrupted()) break;
            File f = names[i];
            if (!useFileHiding || !this.isHiddenFile(f)) {
                files.addElement(f);
            }
            ++i;
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public File getParentDirectory(File dir) {
        File psf;
        if (dir != null && dir.exists() && (psf = dir.getParentFile()) != null) {
            if (this.isFileSystem(psf)) {
                File ppsf;
                File f = psf;
                if (!(f == null || f.exists() || (ppsf = psf.getParentFile()) != null && this.isFileSystem(ppsf))) {
                    f = this.createFileSystemRoot(f);
                }
                return f;
            }
            return psf;
        }
        return null;
    }

    @Override
    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    @Override
    public boolean isComputerNode(File dir) {
        return false;
    }

    @Override
    public boolean isFileSystem(File file) {
        return true;
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        return false;
    }
}

