/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetPanelBorder;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.borders.NetButtonBorder;
import com.nokia.laf.borders.NetComboBoxBorder;
import com.nokia.laf.borders.NetComboBoxButtonBorder;
import com.nokia.laf.borders.NetPopupMenuBorder;
import com.nokia.laf.borders.NetTextAreaBorder;
import com.nokia.laf.borders.NetTextFieldBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.tabbutton.TabButtonPanel;
import com.nokia.widgets.toggle.ToggleBorder;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.table.JTableHeader;

public class NetBorderFactory {
    private static Map theCustomBasicNetBorders = new HashMap();
    private static Border theButtonBorder;
    private static Border theToggleButtonBorder;
    private static Border theToggleBorder;
    private static Border thePopupMenuBorder;
    private static Border theBasicNetBorder;
    private static Border theTextFieldBorder;
    private static Border theTextAreaBorder;
    private static Border theComboBoxBorder;
    private static Border theComboBoxEditorBorder;
    private static Border theComboBoxButtonBorder;
    private static Border theShadowBorder;
    private static Border theShadowInnerBorder;
    private static Border theMenuBarBorder;
    private static Border theMenuBorder;
    private static Border theMenuItemBorder;
    private static Border thePanelBorder;
    private static Border theToolButtonBorder;
    private static Border theToggleToolButtonBorder;
    private static Border theToolBarBorder;
    private static Border theSortableTableHeaderBorder;
    private static BorderSnapshot theBorderSnapshot;
    private static Border theTableBorder;
    private static Border theSortedColumnBorder;
    private static Border theTabbedPaneScrollButtonBorder;
    private static Border theEditableComboBoxTableBorder;
    private static Border theFocusedListCellBorder;
    private static Border theProgressBarBorder;
    private static Border theInternalFrameBorder;
    private static Border theDashedBorder;

    private NetBorderFactory() {
    }

    public static Border getButtonBorder() {
        if (theButtonBorder == null) {
            theButtonBorder = new BorderUIResource.CompoundBorderUIResource(new NetButtonBorder(), new BasicBorders.MarginBorder());
        }
        return theButtonBorder;
    }

    public static Border getDashedBorder() {
        if (theDashedBorder == null) {
            theDashedBorder = new DashedBorder();
        }
        return theDashedBorder;
    }

    public static Border getInternalFrameBorder() {
        if (theInternalFrameBorder == null) {
            theInternalFrameBorder = new BorderUIResource(new InternalFrameBorder());
        }
        return theInternalFrameBorder;
    }

    public static Border getListCellBorder() {
        if (theFocusedListCellBorder == null) {
            theFocusedListCellBorder = new FocusedListCellBorder();
        }
        return theFocusedListCellBorder;
    }

    public static Border getToggleButtonBorder() {
        if (theToggleButtonBorder == null) {
            theToggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(null, null), new BasicBorders.MarginBorder());
        }
        return theToggleButtonBorder;
    }

    public static Border getToggleBorder() {
        if (theToggleBorder == null) {
            theToggleBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleBorder(), new BasicBorders.MarginBorder());
        }
        return theToggleBorder;
    }

    public static Border getPopupMenuBorder() {
        if (thePopupMenuBorder == null) {
            thePopupMenuBorder = new BorderUIResource(new NetPopupMenuBorder());
        }
        return thePopupMenuBorder;
    }

    public static Border getProgressBarBorder() {
        if (theProgressBarBorder == null) {
            theProgressBarBorder = new ProgressBarBorder();
        }
        return theProgressBarBorder;
    }

    public static Border getTabbedPaneScrollButtonBorder() {
        if (theTabbedPaneScrollButtonBorder == null) {
            theTabbedPaneScrollButtonBorder = new CompoundBorder(new TabbedPaneScrollButtonBorder(), new BasicBorders.MarginBorder());
        }
        return theTabbedPaneScrollButtonBorder;
    }

    public static Border getComboBoxEditableTableBorder() {
        if (theEditableComboBoxTableBorder == null) {
            theEditableComboBoxTableBorder = new CompoundBorder(new EditableComboBoxTableBorder(), new BasicBorders.MarginBorder());
        }
        return theEditableComboBoxTableBorder;
    }

    public static Border getBasicNetBorder() {
        if (theBasicNetBorder == null) {
            theBasicNetBorder = new BorderUIResource(PBorderFactory.getBasicNetBorder(NetTheme.getComponentOutlineColor()));
        }
        return theBasicNetBorder;
    }

    public static Border getShadowInnerBorder() {
        if (theShadowInnerBorder == null) {
            theShadowInnerBorder = BorderFactory.createEmptyBorder();
        }
        return theShadowInnerBorder;
    }

    public static Border getBasicNetBorder(Color color) {
        if (!theCustomBasicNetBorders.containsKey(color)) {
            theCustomBasicNetBorders.put(color, new BorderUIResource(PBorderFactory.getBasicNetBorder(color)));
        }
        return (Border)theCustomBasicNetBorders.get(color);
    }

    public static Border getTextFieldBorder() {
        if (theTextFieldBorder == null) {
            theTextFieldBorder = new BorderUIResource.CompoundBorderUIResource(new NetTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return theTextFieldBorder;
    }

    public static Border getTextAreaBorder() {
        if (theTextAreaBorder == null) {
            theTextAreaBorder = new BorderUIResource.CompoundBorderUIResource(new NetTextAreaBorder(), new BasicBorders.MarginBorder());
        }
        return theTextAreaBorder;
    }

    public static Border getComboBoxBorder() {
        if (theComboBoxBorder == null) {
            theComboBoxBorder = new BorderUIResource.CompoundBorderUIResource(new NetComboBoxBorder(), new BasicBorders.MarginBorder());
        }
        return theComboBoxBorder;
    }

    public static Border getComboBoxEditorBorder() {
        if (theComboBoxEditorBorder == null) {
            theComboBoxEditorBorder = new CompoundBorder(BorderFactory.createEmptyBorder(), new BasicBorders.MarginBorder());
        }
        return theComboBoxEditorBorder;
    }

    public static Border getComboBoxButtonBorder() {
        if (theComboBoxButtonBorder == null) {
            theComboBoxButtonBorder = BorderFactory.createCompoundBorder(new NetComboBoxButtonBorder(), new BasicBorders.MarginBorder());
        }
        return theComboBoxButtonBorder;
    }

    public static Border getShadowBorder() {
        if (theShadowBorder == null) {
            theShadowBorder = new CompoundBorder(new ShadowPopupMenuBorder(), NetBorderFactory.getShadowInnerBorder());
        }
        return theShadowBorder;
    }

    public static Border getMenuBorder() {
        if (theMenuBorder == null) {
            theMenuBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBorder(), new BasicBorders.MarginBorder());
        }
        return theMenuBorder;
    }

    public static Border getMenuItemBorder() {
        if (theMenuItemBorder == null) {
            theMenuItemBorder = new BorderUIResource(new BasicBorders.MarginBorder());
        }
        return theMenuItemBorder;
    }

    public static Border getMenuBarBorder() {
        if (theMenuBarBorder == null) {
            theMenuBarBorder = new MenuBarBorder();
        }
        return theMenuBarBorder;
    }

    public static Border getPanelBorder() {
        if (thePanelBorder == null) {
            thePanelBorder = new BorderUIResource(new NetPanelBorder());
        }
        return thePanelBorder;
    }

    public static Border getToolButtonBorder() {
        if (theToolButtonBorder == null) {
            theToolButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToolButtonBorder(), new BasicBorders.MarginBorder());
        }
        return theToolButtonBorder;
    }

    public static Border getToggleToolButtonBorder() {
        if (theToggleToolButtonBorder == null) {
            theToggleToolButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleToolButtonBorder(), new RolloverMarginBorder());
        }
        return theToggleToolButtonBorder;
    }

    public static Border getToolBarBorder() {
        if (theToolBarBorder == null) {
            theToolBarBorder = new BorderUIResource.CompoundBorderUIResource(new ToolBarBorder(), new BasicBorders.MarginBorder());
        }
        return theToolBarBorder;
    }

    public static Border getSortableTableHeaderBorder() {
        if (theSortableTableHeaderBorder == null) {
            theSortableTableHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new SortableTableHeaderBorder(), new EmptyBorder(0, 3, 0, 3));
        }
        return theSortableTableHeaderBorder;
    }

    public static BorderSnapshot getBorderSnapshot() {
        if (theBorderSnapshot == null) {
            theBorderSnapshot = new BorderSnapshot();
        }
        return theBorderSnapshot;
    }

    public static Border getTableBorder() {
        if (theTableBorder == null) {
            theTableBorder = new TableBorder();
        }
        return theTableBorder;
    }

    public static Border getSortedColumnBorder() {
        if (theSortedColumnBorder == null) {
            theSortedColumnBorder = new BorderUIResource.CompoundBorderUIResource(new SortedColumnBorder(), new EmptyBorder(0, 3, 0, 3));
        }
        return theSortedColumnBorder;
    }

    public static class BorderSnapshot {
        private BufferedImage myBeneathBg;
        private BufferedImage myRightwardBg;
        private int myWidth;
        private Component oldc;
        private Point oldPoint;

        public void clearSnapshot() {
            this.myBeneathBg = null;
            this.myRightwardBg = null;
        }

        public Image getRightwardSnapshot() {
            return this.myRightwardBg;
        }

        public Image getBeneathSnapshot() {
            return this.myBeneathBg;
        }

        public void setWidth(int width) {
            this.myWidth = width;
        }

        public void makeSnapshot(JWindow window) {
            try {
                Robot robot = new Robot();
                int x = window.getX();
                int y = window.getY();
                Dimension dim = window.getPreferredSize();
                this.myBeneathBg = robot.createScreenCapture(new Rectangle(x, y + dim.height - this.myWidth, dim.width, this.myWidth));
                this.myRightwardBg = robot.createScreenCapture(new Rectangle(x + dim.width - this.myWidth, y, this.myWidth, dim.height - this.myWidth));
                Point point = new Point(x, y);
                if (window.equals(this.oldc) && point.equals(this.oldPoint)) {
                    return;
                }
                this.oldc = window;
                this.oldPoint = point;
            }
            catch (Exception e) {
                this.clearSnapshot();
            }
        }
    }

    private static class DashedBorder
    extends AbstractBorder {
        private DashedBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.BLACK);
            NetUtils.drawDash(g, 1, 1, width - 2, height - 2);
        }
    }

    private static class EditableComboBoxTableBorder
    extends BaseBorder {
        public EditableComboBoxTableBorder() {
            super(new Insets(1, 1, 1, 1));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JComponent button = (JComponent)c;
            if (button.isEnabled()) {
                g.setColor(UIManager.getColor("ComboBox.Table.EditableBorder"));
                RectangularShape outlineShape = NetUtils.getRoundedRect(button, x - 1000, 1, 1000 + w - 1, h - 2, 10);
                ((Graphics2D)g).draw(outlineShape);
            }
        }
    }

    private static class FocusedListCellBorder
    extends BaseBorder {
        public FocusedListCellBorder() {
            super(new Insets(6, 9, 6, 11));
        }

        @Override
        public Insets getBorderInsets(Component comp) {
            return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component comp, Insets insets) {
            JComponent list = (JComponent)comp;
            if (ComponentUtils.isSmall(list)) {
                insets.top = 4;
                insets.left = 6;
                insets.bottom = 4;
                insets.right = 6;
                return insets;
            }
            return super.getBorderInsets(comp, insets);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(NetLookAndFeel.getCurrentTheme().getFocusColor());
            g.drawRect(x, x, width - 1, height - 1);
        }
    }

    private static class InternalFrameBorder
    extends AbstractBorder {
        private InternalFrameBorder() {
        }

        @Override
        public Insets getBorderInsets(Component comp) {
            return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component comp, Insets insets) {
            insets.left = 2;
            insets.bottom = 2;
            insets.right = 2;
            insets.top = 1;
            return insets;
        }

        @Override
        public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
            JInternalFrame frame = (JInternalFrame)comp;
            g.translate(x, y);
            Color oldColor = g.getColor();
            if (frame != null && frame.isSelected() && frame.isEnabled()) {
                NetBorderFactory.getBasicNetBorder(NetTheme.getComponentOutlineColor()).paintBorder(comp, g, 0, 0, width, height);
                g.setColor(NetTheme.COLOR_GRAY_55);
                g.drawLine(1, 1, 1, height - 2);
                g.setColor(NetTheme.COLOR_WHITE_20);
                g.drawLine(2, height - 2, width - 2, height - 2);
            } else {
                NetBorderFactory.getBasicNetBorder(NetTheme.getDisabledComponentOutlineColor()).paintBorder(comp, g, 0, 0, width, height);
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private static class MenuBarBorder
    extends BaseBorder {
        private Color myShadowColor;
        private Color myLightShadowColor;

        public MenuBarBorder() {
            super(new Insets(0, 0, 2, 16));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (this.myShadowColor == null) {
                this.myShadowColor = UIManager.getColor("MenuBar.borderShadow");
                this.myLightShadowColor = UIManager.getColor("MenuBar.borderLightShadow");
            }
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(this.myShadowColor);
            g.drawLine(0, h - 2, w - 1, h - 2);
            g.setColor(this.myLightShadowColor);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private static class MenuBorder
    extends AbstractBorder {
        private static int ROUNDING = 14;

        private MenuBorder() {
        }

        @Override
        public Insets getBorderInsets(Component comp) {
            return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component comp, Insets newInsets) {
            JMenu menu = (JMenu)comp;
            if (menu.isTopLevelMenu()) {
                newInsets.bottom = 2;
                newInsets.top = 2;
                newInsets.bottom = 0;
                newInsets.left = ROUNDING / 2;
                newInsets.right = ROUNDING;
            } else {
                newInsets.top = 0;
                newInsets.bottom = 0;
                newInsets.right = 0;
                newInsets.left = 0;
            }
            return newInsets;
        }

        @Override
        public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
            JMenu menu = (JMenu)comp;
            ButtonModel model = menu.getModel();
            if (menu.isTopLevelMenu() && (model.isArmed() || model.isSelected() || model.isRollover()) && menu.isPopupMenuVisible()) {
                Object oldAa = NetUtils.antiAliasingOn(g);
                Color[] colors = (Color[])UIManager.get("PopupMenu.shadow");
                NetUtils.drawDropShadow((Graphics2D)g, colors, new Insets(1, 4, 8, 4), x, y, width - ROUNDING / 2, height + 1000, ROUNDING);
                g.setColor(menu.getBackground());
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, 0.0f);
                path.lineTo(0.0f, ROUNDING);
                path.lineTo(ROUNDING, ROUNDING);
                path.quadTo(0.0f, ROUNDING, 0.0f, 0.0f);
                path.transform(AffineTransform.getTranslateInstance(width - ROUNDING + 3, height - ROUNDING));
                Color[] lineColors = (Color[])UIManager.get("PopupMenu.cornerShadow");
                NetUtils.drawShadowRounding((Graphics2D)g, lineColors, width - 11, height - 7, 16, 9);
                ((Graphics2D)g).fill(path);
                NetUtils.setAntialiasing(g, oldAa);
            }
        }
    }

    private static class ProgressBarBorder
    extends AbstractBorder
    implements UIResource {
        private ProgressBarBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            boolean percentsPainted;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            JProgressBar comp = (JProgressBar)c;
            if (comp.getOrientation() == 1) {
                return insets;
            }
            boolean stringPaintedOnTrack = ClientPropertyUtil.booleanValue(comp, "OrangeTouch.stringPaintedOnTrack", true);
            FontMetrics fm = comp.getFontMetrics(comp.getFont());
            if (!stringPaintedOnTrack) {
                insets.top += fm.getHeight() + 3;
            }
            if (percentsPainted = ClientPropertyUtil.booleanValue(comp, "OrangeTouch.percentPainted")) {
                if (stringPaintedOnTrack) {
                    insets.right = 5 + comp.getFontMetrics(comp.getFont()).stringWidth("100%");
                } else {
                    insets.bottom = 6 + fm.getDescent() + fm.getHeight();
                }
            }
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }
    }

    private static class RolloverMarginBorder
    extends EmptyBorder {
        private RolloverMarginBorder() {
            super(6, 6, 6, 6);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                margin = ((AbstractButton)c).getMargin();
            }
            if (margin == null || margin instanceof UIResource) {
                if (ComponentUtils.isSmall(c)) {
                    insets.left = 3;
                    insets.top = 3;
                    insets.right = 3;
                    insets.bottom = 3;
                } else {
                    insets.left = this.left;
                    insets.top = this.top;
                    insets.right = this.right;
                    insets.bottom = this.bottom;
                }
            } else {
                insets.left = margin.left;
                insets.top = margin.top;
                insets.right = margin.right;
                insets.bottom = margin.bottom;
            }
            return insets;
        }
    }

    public static class ShadowPopupMenuBorder
    extends BaseBorder {
        private int myShadowSize;
        private static final int DEFAULT_ALPHA = 160;
        private static final int ALPHA_STEP = 40;

        public ShadowPopupMenuBorder(int shadowSize) {
            super(new Insets(0, 0, shadowSize, shadowSize));
            this.myShadowSize = shadowSize;
            NetBorderFactory.getBorderSnapshot().setWidth(shadowSize);
        }

        public ShadowPopupMenuBorder() {
            this(3);
        }

        @Override
        public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (NetBorderFactory.getBorderSnapshot().getBeneathSnapshot() != null) {
                g.drawImage(NetBorderFactory.getBorderSnapshot().getBeneathSnapshot(), x, y + h - this.myShadowSize, component);
            }
            if (NetBorderFactory.getBorderSnapshot().getRightwardSnapshot() != null) {
                g.drawImage(NetBorderFactory.getBorderSnapshot().getRightwardSnapshot(), x + w - this.myShadowSize, y, component);
            }
            g.setColor(this.getShadowWithAlpha(160));
            int k = 0;
            int i = this.myShadowSize;
            while (i >= 0) {
                if (i < 4) {
                    int alpha;
                    if ((alpha = 160 - ++k * 40) < 0) {
                        alpha = 0;
                    }
                    Color color = this.getShadowWithAlpha(alpha);
                    g.setColor(color);
                }
                g.drawLine(this.myShadowSize - 1 + k, h - i, w - i - 2, h - i);
                g.drawLine(w - i - 1, h - i, w - i - 1, h - i - 1);
                g.drawLine(w - i, this.myShadowSize - 1 + k, w - i, h - i - 1);
                --i;
            }
        }

        private Color getShadowWithAlpha(int alpha) {
            return new Color(NetTheme.COLOR_SHADOW.getRed(), NetTheme.COLOR_SHADOW.getGreen(), NetTheme.COLOR_SHADOW.getBlue(), alpha);
        }
    }

    private static class SortableTableHeaderBorder
    extends BaseBorder {
        public SortableTableHeaderBorder() {
            super(new Insets(2, 2, 2, 2));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            NetUtils.drawRoundedRect(g, NetTheme.getComponentOutlineColor(), x, y, width - 1, height - 1);
            NetUtils.draw3DShadowRect(g, NetLookAndFeel.getWhite(), NetTheme.COLOR_GRAY_13, x + 1, y + 1, width - 3, height - 3);
        }
    }

    private static class SortedColumnBorder
    extends BaseBorder {
        public SortedColumnBorder() {
            super(new Insets(2, 2, 2, 2));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Container parent = c.getParent();
            NetUtils.drawPressed3DBorder(g, parent.getBackground(), x, y, width, height);
        }
    }

    private static class TabbedPaneScrollButtonBorder
    extends BaseBorder {
        public TabbedPaneScrollButtonBorder() {
            super(new Insets(1, 1, 1, 1));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource lowerShadow;
            ColorUIResource upperShadow;
            JButton button = (JButton)c;
            ButtonModel model = button.getModel();
            boolean isPressed = model.isPressed() && model.isArmed();
            ColorUIResource lightShadow = NetLookAndFeel.getWhite();
            if (isPressed) {
                upperShadow = NetLookAndFeel.getControlDarkShadow();
                lowerShadow = lightShadow;
            } else {
                upperShadow = lightShadow;
                lowerShadow = NetTheme.COLOR_GRAY_13;
            }
            NetUtils.draw3DShadowRect(g, upperShadow, lowerShadow, x, y, w - 1, h - 1);
            g.setColor(lowerShadow);
            g.drawLine(0, h - 1, 0, h - 1);
        }
    }

    private static class TableBorder
    extends AbstractBorder
    implements UIResource {
        private static Insets DUMMY_IMSETS = new Insets(0, 0, 0, 0);

        private TableBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets ins) {
            ins.bottom = 1;
            ins.right = 1;
            ins.left = 1;
            ins.top = 0;
            if (!(c instanceof JTable)) {
                return ins;
            }
            if (c.getParent() instanceof JViewport) {
                ins.left = 0;
                ins.right = 0;
                ins.bottom = 0;
                ins.top = 0;
                return DUMMY_IMSETS;
            }
            JTable table = (JTable)c;
            if (table.getTableHeader() == null) {
                ins.top = 1;
                return ins;
            }
            JTableHeader header = table.getTableHeader();
            ins.top = header.isVisible() && header.getHeight() > 0 && header.getWidth() > 0 && header.isDisplayable() ? 0 : 1;
            return ins;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JTable table;
            if (c.getParent() instanceof JViewport) {
                return;
            }
            g.translate(x, y);
            Object oldAa = NetUtils.antiAliasingOn(g);
            Color oldColor = g.getColor();
            g.setColor(UIManager.getColor("Table.UnEditableRowBackground2"));
            g.fillRect(0, height - 1, 1, 1);
            g.fillRect(width - 1, height - 1, 1, 1);
            g.setColor(UIManager.getColor("TableHeader.outlineColor"));
            g.drawLine(0, 0, 0, height - 1);
            g.drawLine(width - 1, 0, width - 1, height - 1);
            if (this.getBorderInsets((Component)c, (Insets)TableBorder.DUMMY_IMSETS).top > 0) {
                g.drawLine(0, 0, width - 1, 0);
            }
            if ((table = (JTable)c).getRowCount() == 0) {
                Insets insets = table.getInsets();
                if (insets.left > 0) {
                    g.setColor(UIManager.getColor("Table.UnEditableGridVertical"));
                } else {
                    g.setColor(UIManager.getColor("Table.bottomRuleColor"));
                }
                g.drawLine(0, height - 1, width - 1, height - 1);
            }
            g.translate(-x, -y);
            NetUtils.setAntialiasing(g, oldAa);
            g.setColor(oldColor);
        }
    }

    private static class ToggleButtonBorder
    extends NetButtonBorder {
        private ToggleButtonBorder() {
        }

        @Override
        public Insets getBorderInsets(Component comp) {
            return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component comp, Insets newInsets) {
            Insets result = super.getBorderInsets(comp, newInsets);
            boolean isHorizontal = true;
            if (!(comp instanceof JComponent)) {
                return result;
            }
            isHorizontal = ClientPropertyUtil.integerValue((JComponent)comp, "OceanTouch.segmentOrientation", 0) == 0;
            if (isHorizontal) {
                return result;
            }
            Object position = ((JComponent)comp).getClientProperty("JToggleButton.segmentPosition");
            boolean isFirstButton = "first".equals(position);
            boolean isMiddleButton = "middle".equals(position);
            boolean isLastButton = "last".equals(position);
            if (isFirstButton) {
                newInsets.bottom = 1;
            } else if (isMiddleButton) {
                newInsets.bottom = 1;
                newInsets.top = 1;
            } else if (isLastButton) {
                newInsets.top = 1;
            }
            return newInsets;
        }

        @Override
        public void paintBorder(Component comp, Graphics graphics, int x, int y, int w, int h) {
            Graphics2D g2d = (Graphics2D)graphics;
            AbstractButton button = (AbstractButton)comp;
            ButtonModel model = button.getModel();
            Object type = button.getClientProperty("OrangeTouch.visualVariant");
            boolean isPressed = model.isPressed() && model.isArmed();
            boolean isSelected = model.isSelected();
            boolean isHover = model.isRollover();
            boolean isFocus = button.isFocusOwner() && button.isFocusPainted();
            boolean isAlternate = "alternate1".equals(type) || "alternate2".equals(type);
            Object position = button.getClientProperty("JToggleButton.segmentPosition");
            boolean isFirstButton = "first".equals(position);
            boolean isMiddleButton = "middle".equals(position);
            boolean isLastButton = "last".equals(position);
            boolean isHorizontal = ClientPropertyUtil.integerValue(button, "OceanTouch.segmentOrientation", 0) == 0;
            Color outlineColor = UIManager.getColor("Button.outlineColor");
            outlineColor = model.isEnabled() ? ToggleButtonBorder.getOutlineColor(type, isPressed, isSelected, isHover, isFocus) : NetTheme.getDisabledComponentOutlineColor();
            int width = button.getWidth();
            int height = button.getHeight();
            int xPos = 0;
            int yPos = 0;
            int highlightX = 0;
            int highlightWidth = w - 1;
            int heightOffset = 12;
            if (isFirstButton) {
                if (isHorizontal) {
                    width += 1000;
                    highlightX = 5;
                    highlightWidth -= highlightX;
                } else {
                    height += heightOffset;
                    highlightX = 5;
                    highlightWidth -= highlightX;
                }
            } else if (isMiddleButton) {
                if (isHorizontal) {
                    xPos -= 1000;
                    width += 2000;
                } else {
                    yPos -= heightOffset;
                    height += 2 * heightOffset;
                }
            } else if (isLastButton) {
                if (isHorizontal) {
                    xPos -= 1000;
                    width += 1000;
                    highlightWidth -= ComponentUtils.isSmall(button) ? 5 : 6;
                } else {
                    yPos -= heightOffset;
                    height += heightOffset;
                    highlightWidth -= ComponentUtils.isSmall(button) ? 5 : 6;
                }
            } else {
                highlightX += 6;
                highlightWidth -= 12;
            }
            this.paintHighlight(graphics, model, isPressed, isSelected, isAlternate, isFirstButton, isHorizontal, width, highlightX, highlightWidth);
            if (outlineColor == null) {
                NetUtils.drawButtonOutline(graphics, (JComponent)button, xPos, yPos, width, height, (Color[])UIManager.get("Button.pressedOutlineGradient"));
            } else {
                NetUtils.drawButtonOutline(graphics, (JComponent)button, xPos, yPos, width, height, outlineColor);
            }
            this.paintDropShadow(x, y, w, h, g2d, button, isFirstButton, isMiddleButton, isLastButton, isHorizontal);
            this.paintAdditionalBorders(button, graphics, h, outlineColor, isFirstButton, isMiddleButton, isLastButton, isHorizontal);
        }

        private static Color getOutlineColor(Object type, boolean isPressed, boolean isSelected, boolean isHover, boolean isFocus) {
            if (isHover) {
                return NetTheme.getHoverColor();
            }
            if (isFocus) {
                return UIManager.getColor("ToggleButton.focusOutline");
            }
            if (isPressed || isSelected) {
                if ("alternate1".equals(type)) {
                    return UIManager.getColor("ToggleButton.alternate1PressedOutline");
                }
                if ("alternate2".equals(type)) {
                    return UIManager.getColor("ToggleButton.alternate2PressedOutline");
                }
                return null;
            }
            return UIManager.getColor("Button.outlineColor");
        }

        private void paintHighlight(Graphics graphics, ButtonModel model, boolean isPressed, boolean isSelected, boolean isAlternate, boolean isFirstButton, boolean isHorizontal, int width, int highlightX, int highlightWidth) {
            if (!isAlternate && (isPressed || isSelected)) {
                if (model.isEnabled()) {
                    if (isHorizontal) {
                        graphics.setColor(UIManager.getColor("Button.pressedHighlight1"));
                        graphics.drawLine(highlightX, 2, highlightX + highlightWidth, 2);
                        graphics.setColor(UIManager.getColor("Button.pressedHighlight2"));
                        graphics.drawLine(highlightX - 1, 3, highlightX + highlightWidth + 2, 3);
                    } else {
                        int offset = isFirstButton ? 1 : 0;
                        int xOffset = isFirstButton ? 2 : 0;
                        graphics.setColor(UIManager.getColor("Button.pressedHighlight1"));
                        graphics.drawLine(2 + xOffset, 1 + offset, width - 3 - 2 * xOffset, 1 + offset);
                        graphics.setColor(UIManager.getColor("Button.pressedHighlight2"));
                        if (isFirstButton) {
                            graphics.drawLine(2 + xOffset, 2 + offset, width - 1 - 2 * xOffset, 2 + offset);
                        } else {
                            graphics.drawLine(2 + xOffset, 2 + offset, width - 4 - 2 * xOffset, 2 + offset);
                        }
                    }
                } else {
                    graphics.setColor(UIManager.getColor("ToggleButton.disabledPressedHighlight1"));
                    graphics.drawLine(highlightX, 2, highlightX + highlightWidth, 2);
                }
            }
        }

        private void paintAdditionalBorders(AbstractButton comp, Graphics graphics, int height, Color outlineColor, boolean isFirstButton, boolean isMiddleButton, boolean isLastButton, boolean isHorizontal) {
            boolean isMiddleOrLast;
            ButtonModel model = comp.getModel();
            boolean isHover = model.isRollover();
            boolean isFocus = comp.isFocusOwner() && comp.isFocusPainted();
            graphics.setColor(outlineColor == null ? NetTheme.getComponentOutlineColor() : outlineColor);
            int width = comp.getWidth();
            boolean isFirstOrMiddle = isFirstButton || isMiddleButton;
            boolean bl = isMiddleOrLast = isMiddleButton || isLastButton;
            if (isHorizontal) {
                this.paintHorizontalAdditionalBorders(comp, graphics, height, isHover, isFocus, width, isFirstOrMiddle, isMiddleOrLast);
            } else {
                this.paintVerticalAdditionalBorders(comp, graphics, height, isHover, isFocus, width, isFirstOrMiddle, isMiddleOrLast);
            }
        }

        protected void paintVerticalAdditionalBorders(AbstractButton comp, Graphics graphics, int height, boolean isHover, boolean isFocus, int width, boolean isFirstOrMiddle, boolean isMiddleOrLast) {
            if (isFirstOrMiddle) {
                if (isHover) {
                    graphics.drawLine(2, height - 1, width - 3, height - 1);
                } else if (isFocus && this.isInTabPanelAndNextButtonHovered(comp)) {
                    graphics.drawLine(2, height - 1, width - 3, height - 1);
                }
            }
            if (isMiddleOrLast) {
                if (comp.isSelected()) {
                    Color upper = ((Color[])UIManager.get("Button.pressedOutlineGradient"))[0];
                    graphics.setColor(upper);
                }
                graphics.drawLine(2, 0, width - 3, 0);
            }
        }

        protected void paintHorizontalAdditionalBorders(AbstractButton comp, Graphics graphics, int height, boolean isHover, boolean isFocus, int width, boolean isFirstOrMiddle, boolean isMiddleOrLast) {
            if (isFirstOrMiddle) {
                if (isHover) {
                    graphics.drawLine(width - 1, 1, width - 1, height - 4);
                } else if (isFocus && this.isInTabPanelAndNextButtonHovered(comp)) {
                    graphics.drawLine(width - 1, 1, width - 1, height - 4);
                }
            }
            if (isMiddleOrLast) {
                graphics.drawLine(0, 1, 0, height - 4);
            }
        }

        private boolean isInTabPanelAndNextButtonHovered(AbstractButton comp) {
            Container parent = comp.getParent();
            return parent instanceof TabButtonPanel && !((TabButtonPanel)parent).isNextButtonHovered((JToggleButton)comp);
        }

        private void paintDropShadow(int x, int y, int w, int h, Graphics2D g2d, AbstractButton button, boolean isFirstButton, boolean isMiddleButton, boolean isLastButton, boolean isHorizontal) {
            int tempX = x;
            int tempY = y;
            int tempW = w;
            int tempH = h;
            if (!button.isEnabled()) {
                return;
            }
            if (isFirstButton) {
                if (isHorizontal) {
                    tempW += 1000;
                } else {
                    tempH += 1000;
                }
            } else if (isMiddleButton) {
                if (isHorizontal) {
                    tempX -= 1000;
                    tempW += 2000;
                } else {
                    tempY -= 1000;
                    tempH += 2000;
                }
            } else if (isLastButton) {
                if (isHorizontal) {
                    tempX -= 1000;
                    tempW += 1000;
                } else {
                    tempY -= 1000;
                    tempH += 1000;
                }
            }
            NetUtils.paintDropShadow(g2d, button, tempX, tempY, tempW, tempH);
        }

        /* synthetic */ ToggleButtonBorder(ToggleButtonBorder toggleButtonBorder, ToggleButtonBorder toggleButtonBorder2) {
            this();
        }
    }

    public static class ToggleToolButtonBorder
    extends ToggleButtonBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            boolean isToolButton;
            if (!(c instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)c;
            boolean bl = isToolButton = Boolean.TRUE.equals(button.getClientProperty("toolButton")) || c.getParent() instanceof JToolBar;
            if (!isToolButton) {
                super.paintBorder(c, g, x, y, width, height);
                return;
            }
            ButtonModel model = button.getModel();
            boolean isPressed = model.isPressed() && model.isArmed();
            boolean isHovered = model.isRollover();
            boolean isSelected = model.isSelected();
            if (isHovered || isPressed || isSelected) {
                super.paintBorder(c, g, x, y, width, height);
            }
        }
    }

    private static class ToolBarBorder
    extends AbstractBorder {
        private ToolBarBorder() {
        }

        @Override
        public Insets getBorderInsets(Component comp) {
            return this.getBorderInsets(comp, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component comp, Insets insets) {
            insets.top = 1;
            insets.bottom = 0;
            insets.left = 2;
            insets.right = 2;
            return insets;
        }
    }

    public static class ToolButtonBorder
    extends NetButtonBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            boolean isToolButton;
            if (!(c instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)c;
            boolean bl = isToolButton = Boolean.TRUE.equals(button.getClientProperty("toolButton")) || c.getParent() instanceof JToolBar;
            if (!isToolButton) {
                super.paintBorder(c, g, x, y, width, height);
                return;
            }
            ButtonModel model = button.getModel();
            boolean isPressed = model.isPressed() && model.isArmed();
            boolean isHovered = model.isRollover();
            if (isHovered || isPressed) {
                super.paintBorder(c, g, x, y, width, height);
            }
        }
    }
}

