/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.BasicNetButtonListener;
import com.nokia.laf.NetHelpButtonUI;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;

public class NetButtonUI
extends MetalButtonUI {
    private static final NetButtonUI theButtonUI = new NetButtonUI();
    protected String myGradientKey = "Button.nsnGradient";
    protected String myPressedGradientKey = "Button.nsnPressedGradient";
    protected String myRolloverGradientKey = "Button.nsnRolloverGradient";
    protected String myDefaultButtonGradientKey = "Button.nsnDefaultButtonGradient";
    protected String myDefaultButtonRolloverGradientKey = "Button.nsnDefaultButtonRolloverGradient";
    protected String myDisabledButtonGradientKey = "Button.nsnDisabledButtonGradient";
    protected String myPressedDefaultGradientKey = "Button.nsnPressedDefaultButtonGradient";
    protected String myDisabledDefaultButtonGradientKey = "Button.nsnDisabledDefaultButtonGradient";
    protected DefaultButtonHandler myDefaultButtonHandler;
    protected SearchButtonHandler mySearchButtonHandler;

    public static ComponentUI createUI(JComponent comp) {
        if (Boolean.TRUE.equals(comp.getClientProperty("help"))) {
            return NetHelpButtonUI.createUI(comp);
        }
        return theButtonUI;
    }

    @Override
    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        NetUtils.setCursor(button);
        LookAndFeel.installProperty(button, "iconTextGap", 7);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        if (Boolean.TRUE.equals(button.getClientProperty("toolButton"))) {
            LookAndFeel.installBorder(button, String.valueOf(this.getPropertyPrefix()) + "toolBorder");
            LookAndFeel.installColors(button, "ToolBar.background", String.valueOf(this.getPropertyPrefix()) + "foreground");
            button.setFocusable(false);
        }
        NetUtils.setMarginAndFont(button, this.getPropertyPrefix());
    }

    @Override
    protected void installListeners(AbstractButton button) {
        BasicButtonListener listener = this.createButtonListener(button);
        if (listener != null) {
            if (!ComponentUtils.isReadOnly(button) || !this.isReadOnlyEnabled(button)) {
                button.addMouseListener(listener);
                button.addMouseMotionListener(listener);
                button.addFocusListener(listener);
            }
            button.addPropertyChangeListener(listener);
            button.addChangeListener(listener);
        }
        if (this.myDefaultButtonHandler == null) {
            this.myDefaultButtonHandler = this.createDefaultButtonHandler();
        }
        button.addPropertyChangeListener("OrangeTouch.defaultButton", this.myDefaultButtonHandler);
        if (this.mySearchButtonHandler == null) {
            this.mySearchButtonHandler = this.createSearchButtonHandler();
        }
        button.addPropertyChangeListener("OceanTouch.searchButton", this.mySearchButtonHandler);
        ReadOnlyHandler.getInstance().installTo(button);
    }

    @Override
    protected void installKeyboardActions(AbstractButton b) {
        if (!ComponentUtils.isReadOnly(b)) {
            super.installKeyboardActions(b);
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        super.uninstallListeners(button);
        button.removePropertyChangeListener("OrangeTouch.defaultButton", this.myDefaultButtonHandler);
        button.removePropertyChangeListener("OceanTouch.searchButton", this.mySearchButtonHandler);
        ReadOnlyHandler.getInstance().uninstallFrom(button);
    }

    protected DefaultButtonHandler createDefaultButtonHandler() {
        return new DefaultButtonHandler();
    }

    protected SearchButtonHandler createSearchButtonHandler() {
        return new SearchButtonHandler();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        AbstractButton btn = (AbstractButton)c;
        ButtonModel model = btn.getModel();
        if (model.isRollover() && !model.isPressed() && btn.getClientProperty("BlueTouch.rolloverHighlightDisabled") == null) {
            this.paintRolloverHighlight(btn, g);
        }
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        Icon icon = b.getIcon();
        if (this.createFocusIcon(b, icon) && SystemUtils.isFocusedIconAutoCreated()) {
            ImageIcon focusedIcon = ImageUtils.createFocusedIcon(c, icon);
            focusedIcon.paintIcon(b, g, iconRect.x, iconRect.y);
            return;
        }
        super.paintIcon(g, b, iconRect);
    }

    protected boolean createFocusIcon(AbstractButton b, Icon icon) {
        return icon != null && (b.isFocusOwner() && b.isFocusPainted() || this.hasDarkBackground(b));
    }

    @Override
    public Dimension getPreferredSize(JComponent button) {
        AbstractButton b = (AbstractButton)button;
        return NetUtils.getPreferredButtonSize(b, b.getIconTextGap());
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension size = super.getMaximumSize(c);
        AbstractButton b = (AbstractButton)c;
        if ((ClientPropertyUtil.booleanValue(c, "toolButton") || c.getParent() instanceof JToolBar) && b.getBorder() instanceof UIResource) {
            Insets insets = b.getInsets();
            int minimumMaxSize = 16 + insets.top + insets.bottom;
            if (size.height < minimumMaxSize) {
                size.height = minimumMaxSize;
            }
        }
        return size;
    }

    protected void paintRolloverHighlight(AbstractButton btn, Graphics g) {
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton btn, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton comp) {
        if (comp.isContentAreaFilled()) {
            String gradientKey = this.myPressedGradientKey;
            if (this.hasDarkBackground(comp)) {
                gradientKey = this.myPressedDefaultGradientKey;
            }
            GradientUtils.drawVerticalGradient((JComponent)comp, g, gradientKey, this.getOutlineForFill(comp));
        } else {
            super.paintButtonPressed(g, comp);
        }
        this.setTextShiftOffset();
    }

    @Override
    protected void paintText(Graphics g, JComponent comp, Rectangle textRect, String text) {
        AbstractButton button = (AbstractButton)comp;
        ButtonModel model = button.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = button.getDisplayedMnemonicIndex();
        Color textColor = button.getForeground();
        Color offsetColor = NetTheme.getTextShadowColor();
        int offset = 1;
        boolean isDefault = this.hasDarkBackground(button);
        boolean isReadOnly = ClientPropertyUtil.booleanValue(button, "OrangeTouch.readOnly");
        if (isDefault) {
            textColor = button.getForeground() instanceof UIResource ? NetLookAndFeel.getWhite() : button.getForeground();
            offsetColor = UIManager.getColor("Button.defaultButtonTextColor");
            offset = -1;
        }
        if (model.isEnabled() && !isReadOnly) {
            g.setColor(button.getForeground());
            NetUtils.paintText(g, text, mnemIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset(), textColor, offsetColor, offset);
        } else {
            textColor = isDefault ? UIManager.getColor("Button.disabledDefaultButtonText") : this.getDisabledTextColor();
            NetUtils.paintText(g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset(), textColor, null, offset);
        }
    }

    protected boolean isReadOnlyEnabled(AbstractButton button) {
        return true;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton button) {
        return new BasicNetButtonListener(button, this.getPropertyPrefix());
    }

    @Override
    public void update(Graphics g, JComponent comp) {
        boolean isToolButton;
        if (comp.isOpaque()) {
            if (comp.getBackground() instanceof UIResource) {
                GradientUtils.drawVerticalBackgroundGradient(comp, g);
            } else {
                g.setColor(comp.getBackground());
                g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
            }
        }
        NetLookAndFeel.toggleTextAntialiasing(g);
        AbstractButton btn = (AbstractButton)comp;
        ButtonModel model = btn.getModel();
        Color background = btn.getBackground();
        boolean bl = isToolButton = Boolean.TRUE.equals(btn.getClientProperty("toolButton")) || btn.getParent() instanceof JToolBar;
        if (isToolButton && model.isRollover()) {
            if (btn.isContentAreaFilled()) {
                String gradientKey = btn.isFocusOwner() ? this.myDefaultButtonRolloverGradientKey : this.myRolloverGradientKey;
                GradientUtils.drawVerticalGradient(comp, g, gradientKey, NetUtils.getButtonOutlineForFill(comp));
            }
            this.paint(g, comp);
            return;
        }
        Shape fill = this.getOutlineForFill(comp);
        if (!isToolButton && (!btn.isEnabled() || ComponentUtils.isReadOnly(btn)) && NetUtils.isInDialog(btn)) {
            GradientUtils.drawVerticalBackgroundGradient(comp, g);
            g.setColor(UIManager.getColor("TextComponent.disabledFill"));
            ((Graphics2D)g).fill(fill);
            this.paint(g, comp);
            return;
        }
        if (model.isRollover() && !this.hasDarkBackground(btn) && btn.isContentAreaFilled()) {
            Color oldColor = g.getColor();
            if (background instanceof UIResource) {
                GradientUtils.drawVerticalGradient(comp, g, this.myRolloverGradientKey, fill);
            } else {
                g.setColor(NetLookAndFeel.getWhite());
                g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
            }
            this.paint(g, comp);
            g.setColor(oldColor);
        } else if (background instanceof UIResource) {
            Color oldColor = g.getColor();
            String gradient = this.getBackgroundGradientKey(btn, isToolButton);
            if (!(isToolButton && gradient.equals(this.myGradientKey) || !btn.isContentAreaFilled())) {
                GradientUtils.drawVerticalGradient(comp, g, gradient, fill);
            }
            this.paint(g, comp);
            g.setColor(oldColor);
        } else {
            super.update(g, btn);
        }
    }

    private String getBackgroundGradientKey(AbstractButton btn, boolean isToolButton) {
        ButtonModel model = btn.getModel();
        String gradient = this.myGradientKey;
        boolean isPressed = this.isPressed(btn);
        boolean isDefault = this.hasDarkBackground(btn);
        if (!(btn.isEnabled() && !ComponentUtils.isReadOnly(btn) || isToolButton)) {
            gradient = isDefault ? this.myDisabledDefaultButtonGradientKey : this.myDisabledButtonGradientKey;
        } else if (isPressed && !isDefault) {
            gradient = this.myPressedGradientKey;
        } else if (isDefault) {
            if (isPressed) {
                gradient = this.myPressedDefaultGradientKey;
            } else {
                String string = gradient = model.isRollover() ? "Button.nsnDefaultButtonRolloverGradient" : this.myDefaultButtonGradientKey;
            }
        }
        if (btn.isFocusOwner()) {
            gradient = btn.isEnabled() ? (model.isRollover() ? "Button.nsnDefaultButtonRolloverGradient" : this.myDefaultButtonGradientKey) : this.myDisabledDefaultButtonGradientKey;
        }
        return gradient;
    }

    protected boolean isPressed(AbstractButton button) {
        ButtonModel model = button.getModel();
        return model.isPressed() && model.isArmed();
    }

    protected Shape getOutlineForFill(JComponent comp) {
        if (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.isStraightBottomEdge")) {
            return NetUtils.getRoundedRect(comp, 2, 1, comp.getWidth() - 3, comp.getHeight() - 3, 14, 5);
        }
        if (ClientPropertyUtil.booleanValue(comp, "OrangeTouch.isStraightTopEdge")) {
            return NetUtils.getRoundedRect(comp, 2, 1, comp.getWidth() - 3, comp.getHeight() - 3, 14, 1);
        }
        if (ClientPropertyUtil.booleanValue(comp, "OceanTouch.searchButton")) {
            return NetUtils.getRoundedRect(comp, 0, 0, comp.getWidth() - 1, comp.getHeight() - 1, comp.getHeight() - 4, 7);
        }
        return NetUtils.getButtonOutlineForFill(comp);
    }

    protected boolean hasDarkBackground(AbstractButton button) {
        return NetUtils.isNegative(button);
    }

    protected static class DefaultButtonHandler
    implements PropertyChangeListener,
    HierarchyListener {
        protected DefaultButtonHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            JComponent source = (JComponent)event.getSource();
            if ("OrangeTouch.defaultButton".equals(event.getPropertyName())) {
                boolean isDefaultButton = Boolean.TRUE.equals(event.getNewValue());
                JRootPane root = SwingUtilities.getRootPane(source);
                if (isDefaultButton) {
                    if (root != null) {
                        JComponent previousDefaultButton = (JComponent)root.getClientProperty("initialDefaultButton");
                        if (previousDefaultButton != null && previousDefaultButton != source) {
                            previousDefaultButton.putClientProperty("OrangeTouch.defaultButton", null);
                        }
                        if (root.getDefaultButton() != null && root.getDefaultButton() != source && root.getDefaultButton().isFocusOwner()) {
                            root.putClientProperty("initialDefaultButton", source);
                        } else {
                            root.setDefaultButton((JButton)source);
                        }
                    }
                    if (!ComponentUtils.containsListener(source, HierarchyListener.class, this)) {
                        source.addHierarchyListener(this);
                    }
                } else if (root != null) {
                    if (root.getDefaultButton() == source) {
                        root.setDefaultButton(null);
                    }
                } else if (!ComponentUtils.containsListener(source, HierarchyListener.class, this)) {
                    source.addHierarchyListener(this);
                }
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            JButton button;
            JRootPane root;
            if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(button = (JButton)e.getComponent())) != null) {
                if (ClientPropertyUtil.booleanValue(button, "OrangeTouch.defaultButton")) {
                    JButton previousDefaultButton = root.getDefaultButton();
                    if (previousDefaultButton != null && previousDefaultButton != button) {
                        previousDefaultButton.putClientProperty("OrangeTouch.defaultButton", null);
                    }
                    root.setDefaultButton(button);
                } else if (root.getDefaultButton() == button) {
                    root.setDefaultButton(null);
                }
            }
        }
    }

    protected static class SearchButtonHandler
    implements PropertyChangeListener {
        protected SearchButtonHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            AbstractButton button = (AbstractButton)event.getSource();
            if ("OceanTouch.searchButton".equals(event.getPropertyName()) && ClientPropertyUtil.booleanValue(button, "OceanTouch.searchButton")) {
                Insets margin = button.getMargin();
                button.setMargin(new Insets(0, margin.left, 1, margin.right));
                button.revalidate();
                button.repaint();
            }
        }
    }
}

