/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetButtonUI;
import com.nokia.laf.NetTheme;
import com.nokia.laf.combobox.NetComboBoxButton;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class NetComboBoxButtonUI
extends NetButtonUI {
    private static NetComboBoxButtonUI theComboBoxButtonUI = new NetComboBoxButtonUI();
    private static Border theComboBoxBorder;

    public NetComboBoxButtonUI() {
        this.myGradientKey = "ComboBox.nsnGradient";
        this.myRolloverGradientKey = "Button.nsnRolloverGradient";
        this.myPressedGradientKey = "ComboBox.nsnPressedGradient";
    }

    public static ComponentUI createUI(JComponent comp) {
        return theComboBoxButtonUI;
    }

    @Override
    protected String getPropertyPrefix() {
        return "ComboBox.Button.";
    }

    @Override
    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        NetComboBoxButton cmbButton = (NetComboBoxButton)button;
        if (theComboBoxBorder == null) {
            theComboBoxBorder = UIManager.getBorder("ComboBox.Button.border");
        }
        cmbButton.setRolloverEnabled(true);
        cmbButton.setBorder(theComboBoxBorder);
    }

    @Override
    protected boolean hasDarkBackground(AbstractButton button) {
        NetComboBoxButton comboButton = (NetComboBoxButton)button;
        JComboBox<Object> combo = comboButton.getComboBox();
        return NetUtils.isFocused(combo);
    }

    @Override
    protected Shape getOutlineForFill(JComponent comp) {
        String segmentPosition;
        NetComboBoxButton button = (NetComboBoxButton)comp;
        JComboBox<Object> combo = button.getComboBox();
        int h = comp.getHeight();
        int w = comp.getWidth();
        int x = 0;
        if (combo.isEditable() && !ComponentUtils.isReadOnly(combo)) {
            x -= 1000;
            w += 1000;
        }
        if ((segmentPosition = (String)combo.getClientProperty("JToggleButton.segmentPosition")) != null) {
            int rounding = NetTheme.getComponentOutlineRounding(button);
            if ("first".equals(segmentPosition)) {
                return NetUtils.getRoundedRect(button, x, 0, w, h, rounding, 5, 7);
            }
            if ("middle".equals(segmentPosition)) {
                return new Rectangle(x, -1, w - 1, h + 1);
            }
            if ("last".equals(segmentPosition)) {
                return combo.isPopupVisible() ? new Rectangle(x, -1, w - 1, h + 1) : NetUtils.getRoundedRect(button, x, 0, w, h + 1, rounding, 1, 7);
            }
            if ("only".equals(segmentPosition)) {
                boolean popupAboveCombo = ClientPropertyUtil.booleanValue(combo, "OrangeTouch.popupAboveCombo");
                return combo.isPopupVisible() ? (popupAboveCombo ? NetUtils.getRoundedRect(button, x, 0, w, h + 1, rounding, 7, 1) : NetUtils.getRoundedRect(button, x, 0, w, h + 1, rounding, 7, 5)) : NetUtils.getRoundedRect(button, x, 0, w, h + 1, rounding, 7);
            }
        }
        RectangularShape outlineForFill = NetUtils.getOutline(comp);
        outlineForFill.setFrame(x, 1.0, w, h - 1);
        if (combo.isPopupVisible()) {
            boolean popupAboveCombo = ClientPropertyUtil.booleanValue(combo, "OrangeTouch.popupAboveCombo");
            int y = popupAboveCombo ? 0 : h / 2;
            Rectangle2D.Double bottomRect = new Rectangle2D.Double(0.0, y, w, h / 2);
            Area result = new Area(bottomRect);
            result.add(new Area(outlineForFill));
            return result;
        }
        return outlineForFill;
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton comp) {
        NetComboBoxButton button = (NetComboBoxButton)comp;
        String gradientKey = comp.getParent().isFocusOwner() ? this.myPressedDefaultGradientKey : this.myPressedGradientKey;
        JComboBox<Object> combo = button.getComboBox();
        if (combo.isEditable() && combo.getEditor().getEditorComponent().isFocusOwner()) {
            gradientKey = this.myPressedDefaultGradientKey;
        }
        GradientUtils.drawVerticalGradient((JComponent)comp, g, gradientKey, this.getOutlineForFill(comp));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        NetComboBoxButton btn = (NetComboBoxButton)c;
        JComboBox<Object> comboBox = btn.getComboBox();
        ComboBoxUI ui = comboBox.getUI();
        if (btn.isOpaque()) {
            if (!btn.isEnabled() || ComponentUtils.isReadOnly(comboBox)) {
                g.setColor(NetUtils.getParentBackground(comboBox));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            } else if (!(comboBox.getBackground() instanceof UIResource)) {
                g.setColor(comboBox.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
        if (ui.isPopupVisible(comboBox)) {
            this.paintButtonPressed(g, btn);
        }
    }
}

