/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.combobox.NetComboBoxButton;
import com.nokia.laf.combobox.NetComboBoxRenderer;
import com.nokia.laf.combobox.NetComboPopup;
import com.nokia.laf.table.FilterCombo;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.status.ModifiedStatusHandler;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class NetComboBoxUI
extends MetalComboBoxUI
implements PropertyChangeListener,
PopupMenuListener,
FocusListener {
    protected static final Icon theNormalArrowIcon = NetUtils.loadIcon("combo_editor_arrow_normal.gif");
    public static final int ICON_AREA_MIN_WIDTH = 13;
    public static final float ICON_AREA_HEIGHT_TO_WIDTH_RATIO = 0.7123288f;
    public ListCellRenderer myDefaultRenderer;
    private MouseListener myEditorMouseHandler = new EditorMouseHandler();
    protected ModifiedStatusHandler myModifiedValueHandler = null;
    private static final Insets EDITOR_MARGIN = new Insets(0, 3, 0, 6);

    protected NetComboBoxUI() {
    }

    public static ComponentUI createUI(JComponent comp) {
        return new NetComboBoxUI();
    }

    @Override
    public void installUI(final JComponent component) {
        component.putClientProperty("OrangeTouch.mandatoryAsteriskXOffset", -7);
        super.installUI(component);
        this.myModifiedValueHandler = ModifiedStatusHandler.create(this.comboBox);
        if (this.comboBox.isEditable() && this.comboBox.getEditor().getEditorComponent() instanceof JComponent) {
            ((JComponent)this.comboBox.getEditor().getEditorComponent()).putClientProperty("OrangeTouch.openRightEdge", true);
        }
        this.arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                component.repaint();
            }
        });
        Object sizeVariant = component.getClientProperty("JComponent.sizeVariant");
        this.getArrowButton().putClientProperty("JComponent.sizeVariant", sizeVariant);
        this.putEditorClientProperty("JComponent.sizeVariant", sizeVariant);
        if (this.getComboPopup() != null) {
            this.getComboPopup().getList().putClientProperty("JComponent.sizeVariant", sizeVariant);
        }
        this.comboBox.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.myModifiedValueHandler.uninstallFrom(this.comboBox);
        super.uninstallUI(c);
        this.myDefaultRenderer = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBox.addPropertyChangeListener(this);
        this.comboBox.addPopupMenuListener(this);
        this.comboBox.addFocusListener(this);
        if (this.comboBox.getEditor() != null) {
            this.comboBox.getEditor().getEditorComponent().addMouseListener(this.myEditorMouseHandler);
            this.comboBox.getEditor().getEditorComponent().addFocusListener(this);
        }
        ReadOnlyHandler.getInstance().installTo(this.comboBox);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(this);
        this.comboBox.removePopupMenuListener(this);
        this.comboBox.removeFocusListener(this);
        if (this.comboBox.getEditor() != null) {
            this.comboBox.getEditor().getEditorComponent().removeMouseListener(this.myEditorMouseHandler);
            this.comboBox.getEditor().getEditorComponent().removeFocusListener(this);
        }
        ReadOnlyHandler.getInstance().uninstallFrom(this.comboBox);
    }

    @Override
    protected void installKeyboardActions() {
        if (ComponentUtils.isReadOnly(this.comboBox)) {
            return;
        }
        super.installKeyboardActions();
        KeyStroke space = KeyStroke.getKeyStroke(32, 0);
        this.comboBox.getInputMap(0).put(space, "openPopup");
        this.comboBox.getActionMap().put("openPopup", new OpenPopupAction());
    }

    @Override
    protected void selectNextPossibleValue() {
        NetComboPopup comboPopup = this.getComboPopup();
        if (comboPopup != null && comboPopup.isSearchSupported()) {
            this.selecteNextOrPreviousPossibleValue(true);
        } else {
            super.selectNextPossibleValue();
        }
    }

    @Override
    protected void selectPreviousPossibleValue() {
        NetComboPopup comboPopup = this.getComboPopup();
        if (comboPopup != null && comboPopup.isSearchSupported()) {
            this.selecteNextOrPreviousPossibleValue(false);
        } else {
            super.selectPreviousPossibleValue();
        }
    }

    private void selecteNextOrPreviousPossibleValue(boolean forwardNext) {
        int selectedIndex = this.comboBox.isPopupVisible() ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (forwardNext && selectedIndex < this.comboBox.getModel().getSize() - 1) {
            this.listBox.setSelectedIndex(selectedIndex + 1);
            this.listBox.ensureIndexIsVisible(selectedIndex + 1);
            this.comboBox.repaint();
        } else if (!forwardNext && selectedIndex > 0) {
            this.listBox.setSelectedIndex(selectedIndex - 1);
            this.listBox.ensureIndexIsVisible(selectedIndex - 1);
            this.comboBox.repaint();
        }
    }

    @Override
    protected JButton createArrowButton() {
        Icon icon = this.getArrowIcon(NetUtils.isTableCellEditor(this.comboBox));
        NetComboBoxButton comboBoxButton = new NetComboBoxButton(this.comboBox, icon, this.comboBox.isEditable(), this.currentValuePane, this.listBox, false);
        this.comboBox.addPropertyChangeListener(comboBoxButton);
        this.initArrowButton(comboBoxButton, NetUtils.isTableCellEditor(this.comboBox));
        return comboBoxButton;
    }

    @Override
    public void unconfigureArrowButton() {
        super.unconfigureArrowButton();
        if (this.arrowButton instanceof PropertyChangeListener) {
            this.comboBox.removePropertyChangeListener((PropertyChangeListener)((Object)this.arrowButton));
        }
    }

    protected void initArrowButton(JButton jArrowButton, boolean isTableCellEditor) {
        jArrowButton.setBorder(UIManager.getBorder("ComboBox.Button.border"));
        jArrowButton.setMargin(UIManager.getInsets("ComboBox.Button.margin"));
        jArrowButton.setFocusPainted(true);
        if (ClientPropertyUtil.booleanValue(this.comboBox, "OrangeTouch.readOnly")) {
            jArrowButton.putClientProperty("OrangeTouch.readOnly", Boolean.TRUE);
        }
        jArrowButton.putClientProperty("JComponent.sizeVariant", this.comboBox.getClientProperty("JComponent.sizeVariant"));
    }

    protected Icon getArrowIcon(boolean isTableCellEditor) {
        Icon icon = UIManager.getIcon("ComboBox.Button.icon");
        if (isTableCellEditor) {
            icon = UIManager.getIcon("ComboBox.Button.Table.icon");
        } else if (ComponentUtils.isSmall(this.comboBox)) {
            icon = UIManager.getIcon("ComboBox.Button.Small.icon");
        }
        return new CoordCorrectIcon(icon);
    }

    public JButton getArrowButton() {
        return this.arrowButton;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new NetComboBoxEditor();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new NetComboBoxLayoutManager();
    }

    @Override
    protected ComboPopup createPopup() {
        NetComboPopup combopopup = new NetComboPopup(this.comboBox);
        this.comboBox.addPropertyChangeListener(combopopup);
        combopopup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return combopopup;
    }

    protected ListCellRenderer createRenderer() {
        return new NetComboBoxRenderer.UIResource(this.comboBox);
    }

    @Override
    public void update(Graphics g, JComponent comp) {
        if (comp.isOpaque()) {
            if (comp.getParent() instanceof CellRendererPane || comp.getParent() instanceof JTableHeader) {
                super.update(g, comp);
                return;
            }
            if (comp.getParent() instanceof JTable) {
                JTable table = (JTable)comp.getParent();
                g.setColor(table.getSelectionBackground());
                g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
            } else {
                GradientUtils.drawVerticalBackgroundGradient(comp, g);
                NetUtils.paintTableCellBackground(g, comp);
            }
        }
        this.paint(g, comp);
    }

    @Override
    protected Dimension getDefaultSize() {
        if (this.myDefaultRenderer == null) {
            this.myDefaultRenderer = new NetComboBoxRenderer.UIResource(this.comboBox);
        }
        Dimension size = this.getSizeForComponent(this.myDefaultRenderer.getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(size.width, size.height);
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    public NetComboPopup getComboPopup() {
        if (this.popup instanceof NetComboPopup) {
            return (NetComboPopup)this.popup;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("JComboBox.isTableCellEditor".equals(evt.getPropertyName()) || "JComboBox.isFileChooserCombo".equals(propertyName) || "editable".equals(propertyName)) {
            MetalComboBoxButton btn = (MetalComboBoxButton)this.arrowButton;
            Icon icon = this.getArrowIcon(NetUtils.isTableCellEditor(this.comboBox));
            btn.setComboIcon(icon);
            this.initArrowButton(btn, NetUtils.isTableCellEditor(this.comboBox));
            this.isMinimumSizeDirty = true;
        } else if ("enabled".equals(propertyName)) {
            this.comboBox.revalidate();
            this.comboBox.repaint();
        } else if ("ancestor".equals(propertyName)) {
            if (this.comboBox.getParent() instanceof JTable) {
                this.comboBox.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new BasicBorders.MarginBorder()));
                if (this.comboBox.isEditable() && this.comboBox.getEditor().getEditorComponent() instanceof JTextComponent) {
                    ((JTextComponent)this.comboBox.getEditor().getEditorComponent()).setMargin(new Insets(1, 1, 2, 0));
                }
            }
        } else {
            this.handlePropertyChangeEventWithNewValue(evt);
        }
    }

    private void handlePropertyChangeEventWithNewValue(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if ("editor".equals(propertyName)) {
            ComboBoxEditor oldEditor = (ComboBoxEditor)newValue;
            oldEditor.getEditorComponent().removeFocusListener(this);
            oldEditor.getEditorComponent().removeMouseListener(this.myEditorMouseHandler);
            ComboBoxEditor newEditor = (ComboBoxEditor)newValue;
            Component newEditorComponent = newEditor.getEditorComponent();
            newEditorComponent.addFocusListener(this);
            newEditorComponent.addMouseListener(this.myEditorMouseHandler);
            if (newEditorComponent instanceof JTextComponent) {
                JTextComponent textComponent = (JTextComponent)newEditorComponent;
                textComponent.putClientProperty("OrangeTouch.openRightEdge", true);
                if (textComponent.getBorder() instanceof UIResource) {
                    textComponent.setBorder(UIManager.getBorder("ComboBox.Editor.border"));
                }
            }
        } else if ("OrangeTouch.readOnly".equals(propertyName)) {
            this.comboBox.setFocusable(!ClientPropertyUtil.booleanValue(this.comboBox, "OrangeTouch.readOnly"));
        } else if ("JComponent.sizeVariant".equals(propertyName)) {
            this.getArrowButton().putClientProperty("JComponent.sizeVariant", newValue);
            this.putEditorClientProperty("JComponent.sizeVariant", newValue);
            if (this.getComboPopup() != null) {
                this.getComboPopup().getList().putClientProperty("JComponent.sizeVariant", newValue);
            }
        } else if ("mandatoryEntry".equals(propertyName)) {
            this.putEditorClientProperty("mandatoryEntry", newValue);
            this.comboBox.repaint();
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.putEditorClientProperty("OrangeTouch.openBottomEdge", true);
        this.comboBox.repaint();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.putEditorClientProperty("OrangeTouch.openBottomEdge", false);
        this.comboBox.repaint();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        JTable table;
        TableCellEditor cellEditor;
        this.putEditorClientProperty("OrangeTouch.openBottomEdge", false);
        this.comboBox.repaint();
        if (this.comboBox.getParent() instanceof JTable && (cellEditor = (table = (JTable)this.comboBox.getParent()).getCellEditor()) != null) {
            cellEditor.cancelCellEditing();
        }
    }

    private void putEditorClientProperty(Object key, Object value) {
        ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
        if (comboBoxEditor.getEditorComponent() instanceof JComponent) {
            ((JComponent)comboBoxEditor.getEditorComponent()).putClientProperty(key, value);
        }
    }

    public boolean isFocusTraversable(JComboBox c) {
        if (ComponentUtils.isReadOnly(c)) {
            return false;
        }
        return !this.comboBox.isEditable();
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component source = e.getComponent();
        if (source == this.comboBox.getEditor().getEditorComponent()) {
            this.comboBox.repaint();
            return;
        }
        if (this.comboBox.getParent() instanceof JTable && e.getSource() == this.comboBox && !this.comboBox.isEditable()) {
            this.setPopupVisible(this.comboBox, true);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component source = e.getComponent();
        if (this.comboBox != null && this.comboBox.getEditor() != null && source == this.comboBox.getEditor().getEditorComponent()) {
            this.comboBox.repaint();
            return;
        }
    }

    public static class CoordCorrectIcon
    implements Icon {
        private Icon myIcon;

        public CoordCorrectIcon(Icon icon) {
            this.myIcon = icon;
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            int tempX = x;
            int tempY = y;
            NetComboBoxButton btn = (NetComboBoxButton)comp;
            JComboBox<Object> comboBox = btn.getComboBox();
            boolean tableCellEditor = NetUtils.isTableCellEditor(comboBox);
            if (tableCellEditor) {
                tempX += comboBox.isEditable() ? 3 : 5;
            }
            if (!comboBox.isEditable()) {
                tempY += tableCellEditor ? 2 : 1;
            } else {
                --tempX;
            }
            if (comboBox.isEditable() && !comp.isEnabled()) {
                ++tempY;
                ++tempX;
            }
            if (tableCellEditor) {
                --tempY;
            }
            if (ComponentUtils.isSmall(comp) && !tableCellEditor) {
                tempX += 3;
            }
            this.myIcon.paintIcon(comp, g, tempX, tempY);
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }
    }

    private class EditorMouseHandler
    extends MouseAdapter {
        private EditorMouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            NetComboBoxUI.this.getArrowButton().repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NetComboBoxUI.this.getArrowButton().repaint();
        }
    }

    public class NetComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource {
        public NetComboBoxEditor() {
            this.editor = new PTextField("", 9){

                @Override
                public void setText(String text) {
                    if (this.getText().equals(text)) {
                        return;
                    }
                    super.setText(text);
                }
            };
            this.editor.addMouseListener(NetComboBoxUI.this.myEditorMouseHandler);
            this.editor.setMargin(EDITOR_MARGIN);
            this.editor.setBorder(UIManager.getBorder("ComboBox.Editor.border"));
            this.editor.putClientProperty("OrangeTouch.openRightEdge", true);
            this.editor.putClientProperty("BlueTouch.unmodifiedValue", NetComboBoxUI.this.comboBox.getClientProperty("BlueTouch.unmodifiedValue"));
            this.editor.putClientProperty("mandatoryEntry", NetComboBoxUI.this.comboBox.getClientProperty("mandatoryEntry"));
            this.editor.addFocusListener(NetComboBoxUI.this);
            this.editor.putClientProperty("JComponent.sizeVariant", NetComboBoxUI.this.comboBox.getClientProperty("JComponent.sizeVariant"));
        }

        @Override
        public Component getEditorComponent() {
            Integer alignment = ClientPropertyUtil.integerValue(NetComboBoxUI.this.comboBox, "Combobox.horizontalAlignment");
            if (!ClientProperties.UNKNOWN_VALUE.equals(alignment)) {
                this.editor.setHorizontalAlignment(alignment);
            }
            return super.getEditorComponent();
        }
    }

    private class NetComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private NetComboBoxLayoutManager() {
            super(NetComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            if (cb.isEditable() && cb.isEnabled() && !ComponentUtils.isReadOnly(cb)) {
                int width = cb.getWidth();
                int height = cb.getHeight();
                Insets insets = NetComboBoxUI.this.getInsets();
                int buttonHeight = height - (insets.top + insets.bottom);
                int buttonWidth = buttonHeight;
                if (buttonWidth < 12) {
                    buttonWidth = 12;
                }
                if (NetComboBoxUI.this.arrowButton != null) {
                    if (ComponentUtils.isLeftToRight(cb)) {
                        if (NetComboBoxUI.this.comboBox.getParent() instanceof JTable || NetComboBoxUI.this.comboBox instanceof FilterCombo) {
                            int tableButtonWidth = 15;
                            if (NetComboBoxUI.this.comboBox instanceof FilterCombo) {
                                tableButtonWidth += 2;
                            }
                            NetComboBoxUI.this.arrowButton.setBounds(width - tableButtonWidth - insets.right, insets.top, tableButtonWidth, buttonHeight);
                        } else {
                            NetComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                        }
                    } else {
                        NetComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                    }
                    if (ClientPropertyUtil.booleanValue(NetComboBoxUI.this.comboBox, "OrangeTouch.comboBoxButtonHidden")) {
                        NetComboBoxUI.this.arrowButton.setBounds(-100, -100, 0, 0);
                    }
                }
                if (NetComboBoxUI.this.editor != null) {
                    Rectangle cvb = NetComboBoxUI.this.rectangleForCurrentValue();
                    if (NetComboBoxUI.this.comboBox.getParent() instanceof JTable) {
                        ++cvb.width;
                    }
                    NetComboBoxUI.this.editor.setBounds(cvb);
                }
            } else if (NetComboBoxUI.this.arrowButton != null) {
                Insets insets = NetComboBoxUI.this.comboBox.getInsets();
                NetComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, NetComboBoxUI.this.comboBox.getWidth() - (insets.left + insets.right), NetComboBoxUI.this.comboBox.getHeight() - (insets.top + insets.bottom));
            }
        }
    }

    private class OpenPopupAction
    extends AbstractAction {
        private OpenPopupAction() {
        }

        @Override
        public boolean isEnabled() {
            return !NetComboBoxUI.this.comboBox.isEditable() && !NetComboBoxUI.this.comboBox.isPopupVisible();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!NetComboBoxUI.this.comboBox.isEditable()) {
                if (NetUtils.isTableCellEditor(NetComboBoxUI.this.comboBox) && NetComboBoxUI.this.comboBox.getParent() instanceof JTable) {
                    JTable table = (JTable)NetComboBoxUI.this.comboBox.getParent();
                    Rectangle rect = table.getCellRect(table.getSelectedRow(), table.getSelectedColumn(), true);
                    table.scrollRectToVisible(rect);
                }
                NetComboBoxUI.this.comboBox.setPopupVisible(true);
            }
        }
    }
}

