/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.BackupFileSystemView;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.layout.PButtonRowLayout;
import com.nokia.widgets.table.PTableHeaderRenderer;
import com.nokia.widgets.text.PMandatoryStateHandler;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ScaleUtils;
import com.nokia.widgets.util.SystemUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import sun.swing.FilePane;

public class NetFileChooserUI
extends MetalFileChooserUI
implements PropertyChangeListener {
    private static boolean theUseBackupFileSystemView = false;
    protected JPanel myButtonPanel;
    protected JPanel myControlButtonPanel;
    protected JTextField myTextField;
    private JList myFileList;
    private JTable myTable;

    static {
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().contains("win") && (osName.toLowerCase().contains("2000") || osName.toLowerCase().contains("7"))) {
            try {
                FileSystemView.getFileSystemView().getDefaultDirectory();
            }
            catch (Exception exc) {
                theUseBackupFileSystemView = true;
            }
        }
    }

    protected NetFileChooserUI(JFileChooser chooser) {
        super(chooser);
    }

    public static ComponentUI createUI(JComponent c) {
        return new NetFileChooserUI((JFileChooser)c);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        if (theUseBackupFileSystemView) {
            fc.setFileSystemView(new BackupFileSystemView());
            fc.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        }
        super.installComponents(fc);
        Component[] c = fc.getComponents();
        int i = 0;
        while (i < 3) {
            if (c[i] instanceof FilePane) {
                this.installFileViewTypeChangeListener((FilePane)c[i], fc);
            } else if (c[i] instanceof JPanel) {
                ((JPanel)c[i]).setBorder(BorderFactory.createEmptyBorder(10, 18, 0, i == 0 ? 18 : 0));
            }
            ++i;
        }
        this.configureComponents(fc);
        this.getBottomPanel().setBorder(new EmptyBorder(1, 18, 12, 18));
        this.getButtonPanel().setLayout(new PButtonRowLayout());
        fc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JButton approveButton = this.getApproveButton(fc);
        approveButton.putClientProperty("OrangeTouch.defaultButton", Boolean.TRUE);
        approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
        if (this.myFileList != null) {
            this.myFileList.putClientProperty("OrangeTouch.wholeRowActiveInTree", false);
            this.myFileList.setLayoutOrientation(0);
        }
        fc.setPreferredSize(new Dimension(740, 500));
    }

    private void installFileViewTypeChangeListener(FilePane filePane, final JFileChooser fc) {
        filePane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("viewType".equals(evt.getPropertyName())) {
                    NetFileChooserUI.this.rescanCurrentDirectory(fc);
                }
            }
        });
    }

    @Override
    protected MetalFileChooserUI.DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new PatchedDirectoryComboBoxModel();
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        InputMap inputMap = fc.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelSelection");
        if (this.myFileList != null) {
            this.myFileList.addPropertyChangeListener(this);
        }
    }

    @Override
    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        if (this.myFileList != null) {
            this.myFileList.removePropertyChangeListener(this);
        }
    }

    @Override
    protected JPanel createDetailsView(JFileChooser fc) {
        JPanel panel = super.createDetailsView(fc);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.configureDetailsTable(panel);
        return panel;
    }

    @Override
    protected JPanel createList(JFileChooser fc) {
        JPanel panel = super.createList(fc);
        if (panel.getComponentCount() > 0 && panel.getComponent(0) instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)panel.getComponent(0);
            scroll.putClientProperty("OrangeTouch.curvedSheet", true);
            Component view = scroll.getViewport().getView();
            if (view instanceof JList) {
                this.myFileList = (JList)view;
                this.myFileList.setLayoutOrientation(0);
            }
        }
        this.myFileList.setVisibleRowCount(6);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 18, 0, 3));
        return panel;
    }

    @Override
    protected void addControlButtons() {
        this.myControlButtonPanel = new JPanel();
        this.myControlButtonPanel.setLayout(new BoxLayout(this.myControlButtonPanel, 1));
        this.myControlButtonPanel.add(this.getBottomPanel());
        this.myControlButtonPanel.add(this.getButtonPanel());
        this.getFileChooser().add((Component)this.myControlButtonPanel, "South");
    }

    @Override
    protected void removeControlButtons() {
        if (this.myControlButtonPanel != null) {
            this.myControlButtonPanel.remove(this.getButtonPanel());
        }
    }

    @Override
    public JPanel getButtonPanel() {
        if (this.myButtonPanel == null) {
            this.myButtonPanel = new JPanel(new FlowLayout(1, 12, 5));
            this.myButtonPanel.setBorder(PBorderFactory.getButtonBarBorder());
            this.myButtonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        }
        return this.myButtonPanel;
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        PropertyChangeListener origListener = super.createPropertyChangeListener(fc);
        return new PropertyChangeDecorator(origListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("requiredButMissing".equals(evt.getPropertyName())) {
            this.getApproveButton(this.getFileChooser()).setEnabled(!Boolean.TRUE.equals(evt.getNewValue()));
        } else if (evt.getSource() == this.myFileList && "layoutOrientation".equals(evt.getPropertyName())) {
            this.myFileList.removePropertyChangeListener(this);
            this.myFileList.setLayoutOrientation(0);
            this.myFileList.addPropertyChangeListener(this);
        } else if (evt.getSource() == this.myTable && "tableCellEditor".equals(evt.getPropertyName())) {
            if (evt.getNewValue() instanceof DefaultCellEditor && this.myTable != null) {
                ((DefaultCellEditor)evt.getNewValue()).getComponent().requestFocusInWindow();
            }
        } else if (evt.getSource() == this.myTable && "ancestor".equals(evt.getPropertyName()) && evt.getNewValue() != null && this.myTable != null) {
            this.myTable.setRowHeight(ScaleUtils.scale(ComponentUtils.isSmall(this.getFileChooser()) ? 20 : 26));
        }
    }

    protected void configureDetailsTable(Container cont) {
        int idx = 0;
        while (idx < cont.getComponentCount()) {
            Component comp = cont.getComponent(idx);
            if (comp instanceof JTable) {
                this.myTable = (JTable)comp;
                this.myTable.addPropertyChangeListener(this);
                this.myTable.putClientProperty("OrangeTouch.emptyText", WidgetResources.getString("FileChooser.EmptyText"));
                this.myTable.putClientProperty("OrangeTouch.paintEditRectOnTableCell", false);
                if (SystemUtils.isAfterJava15()) {
                    this.myTable.putClientProperty("OrangeTouch.tableSortableLook", Boolean.TRUE);
                }
                this.myTable.setShowHorizontalLines(true);
                TableCellRenderer renderer = this.myTable.getDefaultRenderer(Object.class);
                if (renderer instanceof JComponent) {
                    ((JComponent)((Object)renderer)).setPreferredSize(new Dimension(10000, 10000));
                    if (SystemUtils.isAfterJava15()) {
                        this.myTable.setDefaultRenderer(Object.class, new DelegateFileRenderer(renderer));
                    }
                }
                PTableHeaderRenderer headerRenderer = new PTableHeaderRenderer();
                headerRenderer.setHorizontalAlignment(4);
                this.myTable.getColumnModel().getColumn(1).setHeaderRenderer(headerRenderer);
                TableCellEditor editor = this.myTable.getDefaultEditor(File.class);
                if (editor instanceof DefaultCellEditor && ((DefaultCellEditor)editor).getComponent() instanceof JComponent) {
                    JComponent editorComp = (JComponent)((DefaultCellEditor)editor).getComponent();
                    editorComp.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                }
                this.myTable.setAutoResizeMode(2);
                this.myTable.setRowMargin(1);
                this.myTable.setShowVerticalLines(true);
                return;
            }
            if (comp instanceof Container) {
                this.configureDetailsTable((Container)comp);
            }
            ++idx;
        }
    }

    private void configureComponents(Container lc) {
        Component[] c = lc.getComponents();
        boolean firstAdded = false;
        int i = 0;
        while (i < c.length) {
            Component component = c[i];
            if (component instanceof JTextField) {
                this.myTextField = (JTextField)component;
                new PMandatoryStateHandler(this.myTextField);
                this.myTextField.putClientProperty("mandatoryEntry", Boolean.TRUE);
                this.myTextField.addPropertyChangeListener(this);
                this.getApproveButton(this.getFileChooser()).setEnabled(!Boolean.TRUE.equals(this.myTextField.getClientProperty("requiredButMissing")));
            } else if (component instanceof JComboBox) {
                JComboBox combo = (JComboBox)component;
                combo.putClientProperty("JComboBox.isFileChooserCombo", Boolean.TRUE);
                combo.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0), combo.getBorder()));
            } else if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                if (component instanceof JToggleButton) {
                    JToggleButton toggleButton = (JToggleButton)component;
                    toggleButton.putClientProperty("JToggleButton.segmentPosition", firstAdded ? "last" : "first");
                    firstAdded = true;
                }
                if (button.getText() == null || "".equals(button.getText())) {
                    button.setMargin(ComponentUtils.isSmall(button) ? UIManager.getInsets("Button.smallIconOnlyMargin") : UIManager.getInsets("Button.iconOnlyMargin"));
                }
            } else if (component instanceof Container && !(component instanceof JComboBox)) {
                this.configureComponents((Container)component);
            }
            ++i;
        }
    }

    private static class DelegateFileRenderer
    implements TableCellRenderer {
        private TableCellRenderer myOriginalRenderer;

        public DelegateFileRenderer(TableCellRenderer renderer) {
            this.myOriginalRenderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.myOriginalRenderer instanceof JComponent) {
                ((JComponent)((Object)this.myOriginalRenderer)).putClientProperty("OrangeTouch.isFileChooserRenderer", Boolean.TRUE);
                Boolean b = ComponentUtils.isRolloveredCell(table, row, column);
                ((JComponent)((Object)this.myOriginalRenderer)).putClientProperty("OrangeTouch.automaticTooltipEnabled", b);
            }
            return this.myOriginalRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private final class PatchedDirectoryComboBoxModel
    extends MetalFileChooserUI.DirectoryComboBoxModel {
        private PatchedDirectoryComboBoxModel() {
            super(NetFileChooserUI.this);
        }

        @Override
        public int getSize() {
            return this.getElementsWithoutShortcuts().size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.getElementsWithoutShortcuts().get(index);
        }

        private List<Object> getElementsWithoutShortcuts() {
            ArrayList<Object> elementsWithoutShortcuts = new ArrayList<Object>();
            int i = 0;
            while (i < super.getSize()) {
                Object element = super.getElementAt(i);
                if (element != null && element.getClass().getSimpleName().contains("ShellFolder")) {
                    try {
                        Method linkGetter = element.getClass().getMethod("isLink", new Class[0]);
                        linkGetter.setAccessible(true);
                        Object isLink = linkGetter.invoke(element, new Object[0]);
                        if (!Boolean.TRUE.equals(isLink)) {
                            elementsWithoutShortcuts.add(element);
                        }
                    }
                    catch (Exception e) {
                        elementsWithoutShortcuts.add(element);
                    }
                } else {
                    elementsWithoutShortcuts.add(element);
                }
                ++i;
            }
            return elementsWithoutShortcuts;
        }
    }

    private class PropertyChangeDecorator
    implements PropertyChangeListener {
        PropertyChangeListener myOrigListener;

        public PropertyChangeDecorator(PropertyChangeListener orig) {
            this.myOrigListener = orig;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean missing;
            JButton approveButton = NetFileChooserUI.this.getApproveButton((JFileChooser)e.getSource());
            boolean bl = missing = NetFileChooserUI.this.myTextField != null && Boolean.TRUE.equals(NetFileChooserUI.this.myTextField.getClientProperty("requiredButMissing"));
            if (e.getPropertyName().equals("DialogTypeChangedProperty")) {
                approveButton.setMnemonic(NetFileChooserUI.this.getApproveButtonMnemonic((JFileChooser)e.getSource()));
            }
            if (e.getPropertyName().equals("SelectedFileChangedProperty")) {
                approveButton.setMnemonic(NetFileChooserUI.this.getApproveButtonMnemonic((JFileChooser)e.getSource()));
                NetFileChooserUI.this.getApproveButton(NetFileChooserUI.this.getFileChooser()).setEnabled(NetFileChooserUI.this.isDirectorySelected() || !missing);
            }
            if (e.getPropertyName().equals("directoryChanged")) {
                approveButton.setEnabled(NetFileChooserUI.this.isDirectorySelected() || !missing);
                NetFileChooserUI.this.setDirectorySelected(false);
            }
            this.myOrigListener.propertyChange(e);
        }
    }
}

