/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.RolloverHandler;
import com.nokia.laf.text.NetCaret;
import com.nokia.laf.text.NetFieldView;
import com.nokia.laf.text.NetTextComponentHandler;
import com.nokia.laf.text.ReadOnlyKeymap;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.text.status.ModifiedStatusHandler;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.View;

public class NetFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    protected NetTextComponentHandler myHandler;
    protected RolloverHandler myRolloverHandler;
    protected ModifiedStatusHandler myModifiedValueHandler = null;
    protected KeyListener myKeyHandler = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            NetFormattedTextFieldUI.this.getComponent().repaint();
        }
    };

    public static ComponentUI createUI(JComponent comp) {
        return new NetFormattedTextFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.getComponent().setOpaque(false);
        if (this.getComponent().getClientProperty("TextField.validateOnFocusLost") == null) {
            this.getComponent().putClientProperty("TextField.validateOnFocusLost", UIManager.get("TextField.validateOnFocusLost"));
        }
        if (this.getComponent() != null) {
            this.myModifiedValueHandler = ModifiedStatusHandler.create(this.getComponent());
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.myModifiedValueHandler != null) {
            this.myModifiedValueHandler.uninstallFrom(this.getComponent());
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.myHandler = new NetTextComponentHandler(this.getPropertyPrefix(), this.getComponent());
        ReadOnlyHandler.getInstance().installTo(this.getComponent());
        this.myRolloverHandler = new RolloverHandler();
        this.myRolloverHandler.installTo(this.getComponent());
        this.getComponent().addKeyListener(this.myKeyHandler);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        NetUtils.installReadOnlyFocusInputMap(this.getComponent());
    }

    @Override
    protected Keymap createKeymap() {
        Keymap keyMap = super.createKeymap();
        if (ComponentUtils.isReadOnly(this.getComponent())) {
            keyMap = new ReadOnlyKeymap(keyMap);
        }
        return keyMap;
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.myHandler.uninstallFrom(this.getComponent());
        ReadOnlyHandler.getInstance().uninstallFrom(this.getComponent());
        this.myRolloverHandler.uninstallFrom(this.getComponent());
        this.getComponent().removeKeyListener(this.myKeyHandler);
    }

    @Override
    public View create(Element elem) {
        Document doc = elem.getDocument();
        Object i18nFlag = doc.getProperty("i18n");
        if (Boolean.TRUE.equals(i18nFlag)) {
            return super.create(elem);
        }
        return new NetFieldView(elem);
    }

    @Override
    protected Caret createCaret() {
        return new NetCaret.UIResource();
    }

    @Override
    protected void paintSafely(Graphics g) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        this.paintBackground(g);
        super.paintSafely(g);
        JTextComponent component = this.getComponent();
        NetUtils.paintLabelOrPrompt(g, component);
    }

    @Override
    protected void paintBackground(Graphics g) {
        NetUtils.paintTextComponentBackground(g, this.getComponent());
    }
}

