/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetButtonUI;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class NetHelpButtonUI
extends NetButtonUI {
    private static final NetHelpButtonUI theButtonUI = new NetHelpButtonUI();
    private static final HelpAction theHelpAction = new HelpAction();
    private static final String PREFIX = "HelpButton";
    private Icon myIcon;

    public static ComponentUI createUI(JComponent comp) {
        return theButtonUI;
    }

    @Override
    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        this.defaultTextShiftOffset = 0;
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.setFocusable(false);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
        button.setBorder(BorderFactory.createEmptyBorder());
        this.myIcon = UIManager.getIcon("HelpButton.icon");
        button.setIcon(this.myIcon);
        button.setRolloverIcon(this.myIcon);
        if (!Boolean.FALSE.equals(button.getClientProperty("helpListenerSet"))) {
            button.getActionMap().put("helpUI", theHelpAction);
            button.getInputMap(2).put(KeyStroke.getKeyStroke("F1"), "helpUI");
        }
    }

    @Override
    public void uninstallDefaults(AbstractButton button) {
        if (button.getIcon().equals(this.myIcon)) {
            button.setIcon(null);
            button.getActionMap().remove("helpUI");
            button.getInputMap(2).remove(KeyStroke.getKeyStroke("F1"));
        }
    }

    @Override
    protected boolean isReadOnlyEnabled(AbstractButton button) {
        return false;
    }

    private static class HelpAction
    extends AbstractAction {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractButton button = (AbstractButton)ae.getSource();
            button.doClick();
        }
    }
}

