/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetInternalFrameTitlePane;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.combobox.NetComboBoxButton;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.CompoundIcon;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;

public class NetIconFactory {
    private static Icon theRadioButtonIcon;
    private static Icon theCheckBoxIcon;
    private static Icon theComboBoxIcon;
    private static Icon theTableEditorComboBoxIcon;
    private static Icon theRadioButtonMenuItemIcon;
    private static Icon theMenuArrowIcon;
    private static Icon theCheckBoxMenuItemIcon;
    private static Icon theSliderIcon;
    private static Icon theVerticalSliderIcon;
    private static Icon theHelpIcon;
    private static Icon theEmptyIcon;
    private static Icon theSmallRadioButtonIcon;
    private static Icon theSmallCheckBoxIcon;
    private static Icon theDatePickerIcon;
    private static Icon theCircularIcon;
    private static Icon theSmallCircularIcon;
    private static Icon theSmallComboBoxIcon;

    private NetIconFactory() {
    }

    public static Icon getCircularIcon() {
        if (theCircularIcon == null) {
            theCircularIcon = new CircularIcon();
        }
        return theCircularIcon;
    }

    public static Icon getCircularSmallIcon() {
        if (theSmallCircularIcon == null) {
            theSmallCircularIcon = new CircularSmallIcon();
        }
        return theSmallCircularIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (theRadioButtonIcon == null) {
            theRadioButtonIcon = new RadioButtonIcon();
        }
        return theRadioButtonIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (theMenuArrowIcon == null) {
            theMenuArrowIcon = new MenuArrowIcon();
        }
        return theMenuArrowIcon;
    }

    public static Icon getTreeNodeIcon(boolean collapsed) {
        return new TreeNodeIcon(collapsed);
    }

    public static Icon getTreeLeafIcon() {
        return new TreeLeafIcon();
    }

    public static Icon getComboBoxIcon() {
        if (theComboBoxIcon == null) {
            theComboBoxIcon = new ComboBoxIcon(null, null);
        }
        return theComboBoxIcon;
    }

    public static Icon getSmallComboBoxIcon() {
        if (theSmallComboBoxIcon == null) {
            theSmallComboBoxIcon = new SmallComboBoxIcon();
        }
        return theSmallComboBoxIcon;
    }

    public static Icon getTableEditorComboBoxIcon() {
        if (theTableEditorComboBoxIcon == null) {
            theTableEditorComboBoxIcon = new TableEditorComboBoxIcon();
        }
        return theTableEditorComboBoxIcon;
    }

    public static Icon getDatePickerIcon() {
        if (theDatePickerIcon == null) {
            theDatePickerIcon = new DatePickerIcon();
        }
        return theDatePickerIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (theCheckBoxIcon == null) {
            theCheckBoxIcon = new CheckBoxIcon();
        }
        return theCheckBoxIcon;
    }

    public static Icon getSmallCheckBoxIcon() {
        if (theSmallCheckBoxIcon == null) {
            theSmallCheckBoxIcon = new SmallCheckBoxIcon();
        }
        return theSmallCheckBoxIcon;
    }

    public static Icon getSmallRadioButtonIcon() {
        if (theSmallRadioButtonIcon == null) {
            theSmallRadioButtonIcon = new SmallRadioButtonIcon();
        }
        return theSmallRadioButtonIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (theRadioButtonMenuItemIcon == null) {
            CompoundIcon.UIResource result = new CompoundIcon.UIResource(16, 16, new RadioButtonMenuItemIcon());
            result.setInnerIconHorizontalAlignment(0);
            result.setInnerIconVerticalAlignment(0);
            theRadioButtonMenuItemIcon = result;
        }
        return theRadioButtonMenuItemIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (theCheckBoxMenuItemIcon == null) {
            CompoundIcon.UIResource result = new CompoundIcon.UIResource(16, 16, new CheckBoxMenuItemIcon());
            result.setInnerIconHorizontalAlignment(0);
            result.setInnerIconVerticalAlignment(0);
            theCheckBoxMenuItemIcon = result;
        }
        return theCheckBoxMenuItemIcon;
    }

    public static Icon getVerticalSliderIcon() {
        if (theVerticalSliderIcon == null) {
            theVerticalSliderIcon = new SliderIcon();
        }
        return theVerticalSliderIcon;
    }

    public static Icon getSliderIcon() {
        if (theSliderIcon == null) {
            theSliderIcon = new SliderIcon();
        }
        return theSliderIcon;
    }

    public static Icon getHelpIcon() {
        if (theHelpIcon == null) {
            theHelpIcon = new HelpIcon();
        }
        return theHelpIcon;
    }

    public static Icon getEmptyIcon() {
        if (theEmptyIcon == null) {
            theEmptyIcon = new IconUIResource(new EmptyIcon());
        }
        return theEmptyIcon;
    }

    public static Icon getButtonIcon(String icon, String rolloverIcon, String disabledIcon) {
        return new IconUIResource(new ButtonIcon(icon, rolloverIcon, disabledIcon));
    }

    public static Icon getInternalFrameIcon(String icon, String rolloverIcon, String disabledIcon, String pressedIcon) {
        return new IconUIResource(new InternalFrameIcon(icon, rolloverIcon, disabledIcon, pressedIcon));
    }

    public static Icon getButtonIcon(String icon, String rolloverIcon, String disabledIcon, String pressedIcon) {
        return new IconUIResource(new ButtonIcon(icon, rolloverIcon, disabledIcon, pressedIcon));
    }

    private static class ButtonIcon
    extends RadioButtonIcon {
        public ButtonIcon(String icon, String rolloverIcon, String disabledIcon) {
            this.myBasicIcon = ButtonIcon.loadIcon(icon);
            this.myRolloverIcon = ButtonIcon.loadIcon(rolloverIcon);
            this.myDisabledIcon = ButtonIcon.loadIcon(disabledIcon);
        }

        public ButtonIcon(String icon, String rolloverIcon, String disabledIcon, String pressedIcon) {
            this(icon, rolloverIcon, disabledIcon);
            this.myPressedIcon = ButtonIcon.loadIcon(pressedIcon);
        }

        @Override
        protected void initIcons() {
        }

        @Override
        public int getIconHeight() {
            return this.myBasicIcon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.myBasicIcon.getIconWidth();
        }
    }

    private static class CheckBoxIcon
    extends RadioButtonIcon {
        CheckBoxIcon() {
            super(22);
        }

        @Override
        protected void initIcons() {
            this.myBasicIcon = CheckBoxIcon.loadIcon("action_std_unselected_normal.png");
            this.myRolloverIcon = CheckBoxIcon.loadIcon("action_std_unselected_hover.png");
            this.myPressedIcon = CheckBoxIcon.loadIcon("action_std_unselected_pressed.png");
            this.myDisabledIcon = CheckBoxIcon.loadIcon("action_std_unselected_disabled.png");
            this.myUnselectedFocusedIcon = CheckBoxIcon.loadIcon("action_std_unselected_infocus.png");
            this.myUnselectedFocusedPressedIcon = CheckBoxIcon.loadIcon("action_std_unselected_infocuspressed.png");
            this.myCheckIcon = CheckBoxIcon.loadIcon("action_std_selected_normal.png");
            this.mySelectedHoverIcon = CheckBoxIcon.loadIcon("action_std_selected_hover.png");
            this.mySelectedPressedIcon = CheckBoxIcon.loadIcon("action_std_selected_pressed.png");
            this.myDisabledCheck = CheckBoxIcon.loadIcon("action_std_selected_disabled.png");
            this.mySelectedFocusedIcon = CheckBoxIcon.loadIcon("action_std_selected_infocus.png");
            this.mySelectedFocusedPressedIcon = CheckBoxIcon.loadIcon("action_std_selected_infocuspressed.png");
        }
    }

    private static class CheckBoxMenuItemIcon
    extends RadioButtonMenuItemIcon {
        private CheckBoxMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            AbstractButton menuItem = (AbstractButton)comp;
            ButtonModel model = menuItem.getModel();
            if (!model.isSelected()) {
                return;
            }
            Object oldAa = NetUtils.antiAliasingOn(g);
            Color oldColor = g.getColor();
            g.setColor(this.getIconColor(menuItem));
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            ((Graphics2D)g).setStroke(new BasicStroke(1.5f));
            g.drawLine(x, y + this.getIconHeight() / 2, x + this.getIconWidth() / 3, y + this.getIconHeight() - 1);
            g.drawLine(x + this.getIconWidth() / 3, y + this.getIconHeight() - 1, x + this.getIconWidth() - 1, y + 1);
            g.setColor(oldColor);
            ((Graphics2D)g).setStroke(oldStroke);
            NetUtils.setAntialiasing(g, oldAa);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 6;
        }
    }

    private static class CircularIcon
    implements Icon {
        protected Icon myBasicIcon = NetUtils.loadIcon("s_ot2_progress-verification_spinner36.gif");

        @Override
        public int getIconHeight() {
            return 36;
        }

        @Override
        public int getIconWidth() {
            return 36;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myBasicIcon.paintIcon(c, g, x, y);
        }
    }

    private static class CircularSmallIcon
    implements Icon {
        protected Icon myBasicIcon = NetUtils.loadIcon("s_ot2_progress-verification_spinner16.gif");

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myBasicIcon.paintIcon(c, g, x, y);
        }
    }

    private static class ComboBoxIcon
    extends RadioButtonIcon {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 4;
        private Icon myFocusedIcon;

        private ComboBoxIcon() {
        }

        @Override
        protected void initIcons() {
            this.myBasicIcon = ComboBoxIcon.loadIcon("combobox_arrow.png");
            this.myDisabledIcon = ComboBoxIcon.loadIcon("combobox_arrow_disabled.png");
            this.myFocusedIcon = ComboBoxIcon.loadIcon("combobox_arrow_focused.png");
            this.myRolloverIcon = ComboBoxIcon.loadIcon("combobox_arrow_rollover.png");
        }

        @Override
        public int getIconHeight() {
            return 4;
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            NetComboBoxButton comboButton = (NetComboBoxButton)comp;
            JComboBox<Object> comboBox = comboButton.getComboBox();
            if (NetUtils.isFocused(comboBox)) {
                this.myFocusedIcon.paintIcon(comp, g, x, y);
            } else {
                super.paintIcon(comp, g, x, y);
            }
        }

        /* synthetic */ ComboBoxIcon(ComboBoxIcon comboBoxIcon, ComboBoxIcon comboBoxIcon2) {
            this();
        }
    }

    private static class DatePickerIcon
    extends ComboBoxIcon {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 4;

        private DatePickerIcon() {
        }

        @Override
        protected void initIcons() {
            this.myBasicIcon = DatePickerIcon.loadIcon("n_ot2_action-navi_calendar_normal16.png");
            this.myDisabledIcon = DatePickerIcon.loadIcon("n_ot2_action-navi_calendar_disabled16.png");
            this.myRolloverIcon = DatePickerIcon.loadIcon("n_ot2_action-navi_calendar_hover16.png");
            this.myPressedIcon = DatePickerIcon.loadIcon("n_ot2_action-navi_calendar_pressed16.png");
            this.mySelectedFocusedPressedIcon = DatePickerIcon.loadIcon("n_ot2_action-navi_calendar_focuspressed16.png");
        }

        @Override
        public int getIconHeight() {
            return 4;
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            NetComboBoxButton comp = (NetComboBoxButton)c;
            ButtonModel model = comp.getModel();
            if (!c.isEnabled()) {
                this.myDisabledIcon.paintIcon(c, g, x + 1, y - 5);
                return;
            }
            boolean isFocus = NetUtils.isFocused(comp.getComboBox());
            if (model.isPressed()) {
                if (isFocus) {
                    this.mySelectedFocusedPressedIcon.paintIcon(c, g, x - 2, y - 7);
                } else {
                    this.myPressedIcon.paintIcon(c, g, x - 2, y - 7);
                }
            } else if (model.isRollover()) {
                this.myRolloverIcon.paintIcon(c, g, x - 2, y - 7);
            } else {
                this.myBasicIcon.paintIcon(c, g, x - 2, y - 7);
            }
        }
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public int getIconHeight() {
            return 13;
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
        }
    }

    private static class HelpIcon
    extends RadioButtonIcon {
        private Icon myBasicToolIcon;

        public HelpIcon() {
            super(20);
        }

        @Override
        protected void initIcons() {
            this.myBasicToolIcon = this.myBasicIcon = CommonIcons.getHelpIcon();
            this.myPressedIcon = this.myBasicIcon;
            this.myDisabledIcon = this.myBasicIcon;
            this.myRolloverIcon = CommonIcons.getHelpHoverIcon();
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            AbstractButton cb = (AbstractButton)comp;
            ButtonModel model = cb.getModel();
            if (model.isEnabled() && !model.isPressed() && !model.isArmed() && !model.isRollover() && Boolean.TRUE.equals(cb.getClientProperty("toolButton"))) {
                this.myBasicToolIcon.paintIcon(comp, g, x, y);
            } else {
                super.paintIcon(comp, g, x, y);
            }
        }
    }

    private static class InternalFrameIcon
    extends ButtonIcon {
        public InternalFrameIcon(String icon, String rolloverIcon, String disabledIcon, String pressedIcon) {
            super(icon, rolloverIcon, disabledIcon, pressedIcon);
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            JButton btn = (JButton)comp;
            ButtonModel model = btn.getModel();
            if (comp.getParent() instanceof NetInternalFrameTitlePane) {
                NetInternalFrameTitlePane titlePane = (NetInternalFrameTitlePane)comp.getParent();
                JInternalFrame frame = titlePane.getFrame();
                if (!frame.isSelected() && !model.isRollover()) {
                    this.myDisabledIcon.paintIcon(comp, g, x, y);
                } else {
                    super.paintIcon(comp, g, x, y);
                }
            }
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource {
        private static Icon NORMAL_ARROW = new PArrowIcon(4, 4, UIManager.getColor("Menu.foreground"), 3);
        private static Icon HOVER_ARROW = new PArrowIcon(4, 4, (Color)NetTheme.getHoverColor(), 3);

        private MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenu menu = (JMenu)c;
            if (menu.isArmed() || menu.isSelected() || menu.getModel().isRollover()) {
                HOVER_ARROW.paintIcon(c, g, x, y + 3);
            } else {
                NORMAL_ARROW.paintIcon(c, g, x, y + 3);
            }
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private final int SIZE;
        protected Icon myBasicIcon;
        protected Icon myRolloverIcon;
        protected Icon myPressedIcon;
        protected Icon myDisabledIcon;
        protected Icon myUnselectedFocusedIcon;
        protected Icon myUnselectedFocusedPressedIcon;
        protected Icon myCheckIcon;
        protected Icon myDisabledCheck;
        protected Icon mySelectedHoverIcon;
        protected Icon mySelectedPressedIcon;
        protected Icon mySelectedFocusedIcon;
        protected Icon mySelectedFocusedPressedIcon;
        protected Icon mySelectedReadOnlyIcon = null;

        RadioButtonIcon(int iconSize) {
            this.SIZE = iconSize;
            this.initIcons();
        }

        RadioButtonIcon() {
            this(20);
        }

        protected void initIcons() {
            this.myBasicIcon = RadioButtonIcon.loadIcon("radiobutton_std_unselected_normal.png");
            this.myRolloverIcon = RadioButtonIcon.loadIcon("radiobutton_std_unselected_hover.png");
            this.myPressedIcon = RadioButtonIcon.loadIcon("radiobutton_std_unselected_pressed.png");
            this.myDisabledIcon = RadioButtonIcon.loadIcon("radiobutton_std_unselected_disabled.png");
            this.myUnselectedFocusedIcon = RadioButtonIcon.loadIcon("radiobutton_std_unselected_infocus.png");
            this.myUnselectedFocusedPressedIcon = RadioButtonIcon.loadIcon("radiobutton_std_unselected_infocuspressed.png");
            this.myCheckIcon = RadioButtonIcon.loadIcon("radiobutton_std_selected_normal.png");
            this.mySelectedHoverIcon = RadioButtonIcon.loadIcon("radiobutton_std_selected_hover.png");
            this.mySelectedPressedIcon = RadioButtonIcon.loadIcon("radiobutton_std_selected_pressed.png");
            this.myDisabledCheck = RadioButtonIcon.loadIcon("radiobutton_std_selected_disabled.png");
            this.mySelectedFocusedIcon = RadioButtonIcon.loadIcon("radiobutton_std_selected_infocus.png");
            this.mySelectedFocusedPressedIcon = RadioButtonIcon.loadIcon("radiobutton_std_selected_infocuspressed.png");
        }

        protected static Icon loadIcon(String fileName) {
            if (fileName == null) {
                return null;
            }
            return new ImageIcon(NetIconFactory.class.getResource("icons/" + fileName));
        }

        @Override
        public int getIconHeight() {
            return this.SIZE;
        }

        @Override
        public int getIconWidth() {
            return this.SIZE;
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            AbstractButton btn = (AbstractButton)comp;
            ButtonModel model = btn.getModel();
            if (model.isSelected()) {
                if (model.isEnabled() && !Boolean.FALSE.equals(btn.getClientProperty("Table.isEditable"))) {
                    if (btn.isFocusOwner()) {
                        if (model.isPressed()) {
                            this.mySelectedFocusedPressedIcon.paintIcon(comp, g, x, y);
                        } else {
                            this.mySelectedFocusedIcon.paintIcon(comp, g, x, y);
                            if (model.isRollover()) {
                                this.mySelectedHoverIcon.paintIcon(comp, g, x, y);
                            }
                        }
                    } else if (ComponentUtils.isReadOnly(btn)) {
                        this.myDisabledCheck.paintIcon(comp, g, x, y);
                    } else if (model.isPressed()) {
                        this.mySelectedPressedIcon.paintIcon(comp, g, x, y);
                    } else {
                        this.myCheckIcon.paintIcon(comp, g, x, y);
                        if (model.isRollover()) {
                            this.mySelectedHoverIcon.paintIcon(comp, g, x, y);
                        }
                    }
                } else if ((Boolean.FALSE.equals(btn.getClientProperty("Table.isEditable")) || ComponentUtils.isReadOnly(btn)) && this.mySelectedReadOnlyIcon != null) {
                    this.mySelectedReadOnlyIcon.paintIcon(comp, g, x, y);
                } else {
                    this.myDisabledCheck.paintIcon(comp, g, x, y);
                }
            } else if (model.isEnabled() && !Boolean.FALSE.equals(btn.getClientProperty("Table.isEditable"))) {
                if (btn.isFocusOwner()) {
                    if (model.isPressed()) {
                        this.myUnselectedFocusedPressedIcon.paintIcon(comp, g, x, y);
                    } else {
                        this.myRolloverIcon.paintIcon(comp, g, x, y);
                        if (!model.isRollover()) {
                            this.myUnselectedFocusedIcon.paintIcon(comp, g, x, y);
                        }
                    }
                } else if (ComponentUtils.isReadOnly(btn)) {
                    this.myDisabledIcon.paintIcon(comp, g, x, y);
                } else if (model.isPressed() && this.myPressedIcon != null) {
                    this.myPressedIcon.paintIcon(comp, g, x, y);
                } else {
                    this.myBasicIcon.paintIcon(comp, g, x, y);
                    if (model.isRollover() && this.myRolloverIcon != null) {
                        this.myRolloverIcon.paintIcon(comp, g, x, y);
                    }
                }
            } else {
                this.myDisabledIcon.paintIcon(comp, g, x, y);
            }
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource {
        RadioButtonMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            AbstractButton menuItem = (AbstractButton)comp;
            ButtonModel model = menuItem.getModel();
            if (!model.isSelected()) {
                return;
            }
            Object oldAa = NetUtils.antiAliasingOn(g);
            Color oldColor = g.getColor();
            g.setColor(this.getIconColor(menuItem));
            g.fillOval(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
            g.setColor(oldColor);
            NetUtils.setAntialiasing(g, oldAa);
        }

        protected Color getIconColor(AbstractButton menuItem) {
            if (menuItem.getModel().isArmed() || menuItem.getModel().isRollover()) {
                return NetTheme.getHoverColor();
            }
            if (ComponentUtils.isReadOnly(menuItem) || !menuItem.isEnabled()) {
                return NetLookAndFeel.getCurrentTheme().getInactiveControlTextColor();
            }
            return UIManager.getColor("MenuItem.checkColor");
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public int getIconHeight() {
            return 7;
        }
    }

    private static class SliderIcon
    extends RadioButtonIcon {
        private static final int WIDTH = 16;
        private static final int HEIGHT = 16;
        protected Icon myFocusIcon;

        private SliderIcon() {
        }

        @Override
        protected void initIcons() {
            this.myBasicIcon = SliderIcon.loadIcon("slider_normal.png");
            this.myRolloverIcon = SliderIcon.loadIcon(SystemUtils.isOrangeTouch() ? "slider_hover.png" : "nokia_slider_hover.png");
            this.myPressedIcon = SliderIcon.loadIcon("slider_pressed.png");
            this.myDisabledIcon = SliderIcon.loadIcon("slider_disabled.png");
            this.myFocusIcon = SliderIcon.loadIcon("slider_focused.png");
            this.mySelectedFocusedPressedIcon = SliderIcon.loadIcon("slider_focusedpressed.png");
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean mouseOver;
            int fixedX;
            if (!(c instanceof JSlider)) {
                this.myBasicIcon.paintIcon(c, g, x, y);
                return;
            }
            JSlider comp = (JSlider)c;
            boolean horizontal = comp.getOrientation() == 0;
            int n = fixedX = horizontal ? x : x + 1;
            if (!comp.isEnabled() || ComponentUtils.isReadOnly(comp)) {
                this.myDisabledIcon.paintIcon(c, g, fixedX, y);
                return;
            }
            boolean pressed = ClientPropertyUtil.booleanValue(comp, "componentPressed");
            Point mousePosition = (Point)comp.getClientProperty("BlueTouch.rolloveredCell");
            Rectangle iconRect = new Rectangle(x, y, this.getIconWidth(), this.getIconHeight());
            boolean bl = mouseOver = mousePosition != null && iconRect.contains(mousePosition);
            if (pressed && mouseOver) {
                if (comp.hasFocus()) {
                    this.mySelectedFocusedPressedIcon.paintIcon(c, g, fixedX, y);
                } else {
                    this.myPressedIcon.paintIcon(c, g, fixedX, y);
                }
            } else if (mouseOver) {
                this.myRolloverIcon.paintIcon(c, g, fixedX, y);
            } else if (comp.hasFocus()) {
                this.myFocusIcon.paintIcon(c, g, fixedX, y);
            } else {
                this.myBasicIcon.paintIcon(c, g, fixedX, y);
            }
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }
    }

    private static class SmallCheckBoxIcon
    extends RadioButtonIcon {
        SmallCheckBoxIcon() {
            super(14);
        }

        @Override
        public int getIconHeight() {
            return 17;
        }

        @Override
        protected void initIcons() {
            this.myBasicIcon = SmallCheckBoxIcon.loadIcon("action_small_unselected_normal.png");
            this.myRolloverIcon = SmallCheckBoxIcon.loadIcon(SystemUtils.isOrangeTouch() ? "action_small_unselected_hover.png" : "nokia_check_unselected_hover.png");
            this.myPressedIcon = SmallCheckBoxIcon.loadIcon("action_small_unselected_pressed.png");
            this.myDisabledIcon = SmallCheckBoxIcon.loadIcon("action_small_unselected_disabled.png");
            this.myUnselectedFocusedIcon = SmallCheckBoxIcon.loadIcon("action_small_unselected_infocus.png");
            this.myUnselectedFocusedPressedIcon = SmallCheckBoxIcon.loadIcon("action_small_unselected_infocuspressed.png");
            this.myCheckIcon = SmallCheckBoxIcon.loadIcon("action_small_selected_normal.png");
            this.mySelectedHoverIcon = SmallCheckBoxIcon.loadIcon(SystemUtils.isOrangeTouch() ? "action_small_selected_hover.png" : "nokia_check_selected_hover.png");
            this.mySelectedPressedIcon = SmallCheckBoxIcon.loadIcon("action_small_selected_pressed.png");
            this.myDisabledCheck = SmallCheckBoxIcon.loadIcon("action_small_selected_disabled.png");
            this.mySelectedFocusedIcon = SmallCheckBoxIcon.loadIcon("action_small_selected_infocus.png");
            this.mySelectedFocusedPressedIcon = SmallCheckBoxIcon.loadIcon("action_small_selected_infocuspressed.png");
            this.mySelectedReadOnlyIcon = SmallCheckBoxIcon.loadIcon("action_small_selected_readonly.png");
        }
    }

    private static class SmallComboBoxIcon
    extends RadioButtonIcon {
        private static final int WIDTH = 4;
        private static final int HEIGHT = 4;
        private Icon myFocusedIcon;

        private SmallComboBoxIcon() {
        }

        @Override
        protected void initIcons() {
            this.myBasicIcon = new PArrowIcon(4, 4, Color.decode("#6E6E6E"));
            this.myDisabledIcon = new PArrowIcon(4, 4, NetTheme.getDisabledComponentOutlineColor());
            this.myFocusedIcon = new PArrowIcon(4, 4, NetLookAndFeel.getWhite());
            this.myRolloverIcon = new PArrowIcon(4, 4, NetTheme.getHoverColor());
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            if (NetUtils.isFocused((JComboBox)comp.getParent()) && comp.getParent().isEnabled()) {
                this.myFocusedIcon.paintIcon(comp, g, x, y);
                return;
            }
            if (comp.isEnabled()) {
                this.myFocusedIcon.paintIcon(comp, g, x, y + 1);
            }
            super.paintIcon(comp, g, x, y);
        }

        @Override
        public int getIconHeight() {
            return 4;
        }

        @Override
        public int getIconWidth() {
            return 4;
        }
    }

    private static class SmallRadioButtonIcon
    extends RadioButtonIcon {
        SmallRadioButtonIcon() {
            super(13);
        }

        @Override
        protected void initIcons() {
            this.myBasicIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_unselected_normal.png");
            this.myRolloverIcon = SmallRadioButtonIcon.loadIcon(SystemUtils.isOrangeTouch() ? "radiobutton_small_unselected_hover.png" : "nokia_radio_unselected_hover.png");
            this.myPressedIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_unselected_pressed.png");
            this.myDisabledIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_unselected_disabled.png");
            this.myUnselectedFocusedIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_unselected_infocus.png");
            this.myUnselectedFocusedPressedIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_unselected_infocuspressed.png");
            this.myCheckIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_selected_normal.png");
            this.mySelectedHoverIcon = SmallRadioButtonIcon.loadIcon(SystemUtils.isOrangeTouch() ? "radiobutton_small_selected_hover.png" : "nokia_radio_selected_hover.png");
            this.mySelectedPressedIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_selected_pressed.png");
            this.myDisabledCheck = SmallRadioButtonIcon.loadIcon("radiobutton_small_selected_disabled.png");
            this.mySelectedFocusedIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_selected_infocus.png");
            this.mySelectedFocusedPressedIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_selected_infocuspressed.png");
            this.mySelectedReadOnlyIcon = SmallRadioButtonIcon.loadIcon("radiobutton_small_selected_readonly.png");
        }

        @Override
        public int getIconHeight() {
            return 15;
        }
    }

    private static class TableEditorComboBoxIcon
    extends RadioButtonIcon {
        private static final int WIDTH = 4;
        private static final int HEIGHT = 4;
        private Icon myFocusedIcon;

        private TableEditorComboBoxIcon() {
        }

        @Override
        protected void initIcons() {
            this.myBasicIcon = new PArrowIcon(4, 3, NetLookAndFeel.getFocusColor());
            this.myDisabledIcon = new PArrowIcon(4, 3, NetTheme.getDisabledComponentOutlineColor());
            this.myFocusedIcon = new PArrowIcon(4, 3, NetLookAndFeel.getWhite());
            this.myRolloverIcon = new PArrowIcon(4, 3, NetTheme.getHoverColor());
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            if (NetUtils.isFocused((JComboBox)comp.getParent()) && comp.getParent().isEnabled()) {
                this.myFocusedIcon.paintIcon(comp, g, x, y);
                return;
            }
            if (comp.isEnabled()) {
                this.myFocusedIcon.paintIcon(comp, g, x, y + 1);
            }
            super.paintIcon(comp, g, x, y);
        }

        @Override
        public int getIconHeight() {
            return 4;
        }

        @Override
        public int getIconWidth() {
            return 4;
        }
    }

    private static class TreeLeafIcon
    implements Icon {
        private Icon myNormalIcon = NetUtils.loadIcon("tree_leaf.png");
        private Icon mySelectedIcon = ImageUtils.createSolidColorIcon(null, this.myNormalIcon, UIManager.getColor("TextField.selectionForeground"));

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c instanceof JComponent && ClientPropertyUtil.booleanValue((JComponent)c, "OrangeTouch.isSelected")) {
                this.mySelectedIcon.paintIcon(c, g, x, y);
            } else {
                this.myNormalIcon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myNormalIcon.getIconWidth() + 3;
        }

        @Override
        public int getIconHeight() {
            return this.myNormalIcon.getIconHeight();
        }
    }

    private static class TreeNodeIcon
    implements Icon {
        private static final int ARROW_SIZE = 4;
        private static final int ICON_SIZE = 4;
        private static final Color ARROW_COLOR = NetUtils.decodeColor("#5B5B5B");
        private Icon myNormalIcon;
        private Icon mySelectedIcon;
        private Icon myDisabledIcon;

        public TreeNodeIcon(boolean collapsed) {
            ColorUIResource disabledArrowColor = NetLookAndFeel.getCurrentTheme().getControlDisabled();
            if (collapsed) {
                this.myNormalIcon = new PArrowIcon(4, 4, ARROW_COLOR, 3);
                this.mySelectedIcon = new PArrowIcon(4, 4, UIManager.getColor("Tree.selectionForeground"), 3);
                this.myDisabledIcon = new PArrowIcon(4, 4, (Color)disabledArrowColor, 3);
            } else {
                this.myNormalIcon = new PArrowIcon(4, 4, ARROW_COLOR);
                this.mySelectedIcon = new PArrowIcon(4, 4, UIManager.getColor("Tree.selectionForeground"));
                this.myDisabledIcon = new PArrowIcon(4, 4, disabledArrowColor);
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(c instanceof JTree)) {
                this.myNormalIcon.paintIcon(c, g, x + 3, y + 3);
                return;
            }
            JTree tree = (JTree)c;
            Point point = (Point)tree.getClientProperty("BlueTouch.rolloveredCell");
            int currentRow = tree.getClosestRowForLocation(0, y + this.getIconHeight() / 2);
            if (!tree.isEnabled()) {
                this.myDisabledIcon.paintIcon(c, g, x + 3, y + 3);
            } else if (tree.isRowSelected(currentRow)) {
                boolean hideSelection = Boolean.TRUE.equals(tree.getClientProperty("OrangeTouch.hideTreeNodeSelectionBorder"));
                if (hideSelection) {
                    this.myNormalIcon.paintIcon(c, g, x + 3, y + 3);
                } else {
                    this.mySelectedIcon.paintIcon(c, g, x + 3, y + 3);
                }
            } else if (point != null && point.getX() >= 0.0 && currentRow == (int)point.getX()) {
                this.myNormalIcon.paintIcon(c, g, x + 3, y + 3);
            } else {
                this.myNormalIcon.paintIcon(c, g, x + 3, y + 3);
            }
        }

        @Override
        public int getIconWidth() {
            return 11;
        }

        @Override
        public int getIconHeight() {
            return 11;
        }
    }
}

