/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.util.NetUtils;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public class NetInfoRowRenderer
extends JTextArea
implements TableCellRenderer,
UIResource {
    public NetInfoRowRenderer() {
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setFont(UIManager.getFont("Table.infoRowFont"));
        this.setBorder(new InfoRowBorder());
        this.setBackground(UIManager.getColor("TableHeader.infoRowBackground"));
        this.setForeground(UIManager.getColor("TableHeader.infoRowForeground"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        int width = table.getColumnModel().getColumn(column).getWidth();
        Class<?> columnClass = table.getColumnClass(column);
        if (Number.class.isAssignableFrom(columnClass)) {
            this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        this.setSize(width, 1000);
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return null;
    }

    private static class InfoRowBorder
    extends AbstractBorder {
        private InfoRowBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 4;
            insets.top = 4;
            insets.right = 4;
            insets.left = 4;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(NetUtils.getColor("TableHeader.infoRowBorderColor", 100));
            g.drawLine(x, y + 1, x + width - 1, y + 1);
            g.setColor(NetUtils.getColor("TableHeader.infoRowBorderColor", 200));
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
            g.setColor(UIManager.getColor("TableHeader.infoRowBorderColor"));
            g.drawLine(x, y, x, y + height - 1);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        }
    }
}

