/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetBorderFactory;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class NetInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    public NetInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
        this.setBorder(new TitlePaneBorder());
    }

    @Override
    protected LayoutManager createLayout() {
        return new TitlePaneLayout(super.createLayout());
    }

    @Override
    protected void paintTitleBackground(Graphics g) {
        String gradient = this.frame.isSelected() ? "InternalFrame.gradient" : "InternalFrame.inactiveGradient";
        GradientUtils.drawVerticalGradient((JComponent)this, g, gradient, 0, 1, this.getWidth(), this.getHeight() - 2);
    }

    public JInternalFrame getFrame() {
        return this.frame;
    }

    @Override
    public void paintComponent(Graphics g) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        this.paintTitleBackground(g);
        if (this.frame.getTitle() != null) {
            int titleX;
            boolean isSelected = this.frame.isSelected();
            Font f = g.getFont();
            g.setFont(this.getFont());
            if (isSelected) {
                g.setColor(this.selectedTextColor);
            } else {
                g.setColor(this.notSelectedTextColor);
            }
            FontMetrics fm = this.frame.getFontMetrics(f);
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            Rectangle r = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                r = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                r = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                r = this.closeButton.getBounds();
            }
            String title = this.frame.getTitle();
            if (ComponentUtils.isLeftToRight(this.frame)) {
                if (r.x == 0) {
                    r.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                titleX = this.menuBar.getX() + this.menuBar.getWidth() + 7;
                int titleW = r.x - titleX - 3;
                title = this.getTitle(this.frame.getTitle(), fm, titleW);
            } else {
                titleX = this.menuBar.getX() - 2 - fm.stringWidth(title);
            }
            g.drawString(title, titleX, baseline);
            g.setFont(f);
        }
    }

    @Override
    protected void setButtonIcons() {
        super.setButtonIcons();
        if (this.frame.isIcon()) {
            this.iconButton.setPressedIcon(UIManager.getIcon("InternalFrame.minimizeIcon"));
        } else {
            this.iconButton.setPressedIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
        }
        if (this.frame.isMaximum()) {
            this.maxButton.setPressedIcon(UIManager.getIcon("InternalFrame.minimizeIcon"));
        } else {
            this.maxButton.setPressedIcon(UIManager.getIcon("InternalFrame.maximizeIcon"));
        }
    }

    @Override
    protected void addSystemMenuItems(JMenu systemMenu) {
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        this.maxButton.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
        this.maxButton.setPressedIcon(UIManager.getIcon("InternalFrame.maximizeIcon"));
        this.maxButton.setContentAreaFilled(false);
        this.iconButton.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
        this.iconButton.setPressedIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
        this.iconButton.setContentAreaFilled(false);
        this.closeButton.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
        this.closeButton.setPressedIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.closeButton.setContentAreaFilled(false);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        this.closeButton.setBorder(emptyBorder);
        this.maxButton.setBorder(emptyBorder);
        this.iconButton.setBorder(emptyBorder);
    }

    private class TitlePaneBorder
    extends AbstractBorder
    implements UIResource {
        private TitlePaneBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.left = 1;
            insets.bottom = 1;
            insets.top = 1;
            if (NetInternalFrameTitlePane.this.frame.isIcon()) {
                insets.bottom = 2;
            }
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            ColorUIResource color = NetInternalFrameTitlePane.this.frame.isSelected() && NetInternalFrameTitlePane.this.frame.isEnabled() ? NetTheme.getComponentOutlineColor() : NetTheme.getDisabledComponentOutlineColor();
            g.translate(x, y);
            NetBorderFactory.getBasicNetBorder(color).paintBorder(c, g, 0, 0, width, height);
            Color oldColor = g.getColor();
            g.setColor(color);
            if (!NetInternalFrameTitlePane.this.frame.isIcon()) {
                g.drawLine(0, height - 1, 0, height - 1);
                g.drawLine(width - 1, height - 1, width - 1, height - 1);
                g.setColor(UIManager.getColor("InternalFrame.bottomBorder"));
                g.drawLine(1, height - 1, width - 2, height - 1);
            } else {
                g.setColor(UIManager.getColor("InternalFrame.bottomBorder"));
                g.drawLine(1, height - 2, width - 2, height - 2);
            }
            g.setColor(oldColor);
            g.translate(-x, -y);
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        LayoutManager myDelegate;

        public TitlePaneLayout(LayoutManager delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.myDelegate.addLayoutComponent(name, comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.myDelegate.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = this.myDelegate.minimumLayoutSize(parent);
            Icon icon = NetInternalFrameTitlePane.this.frame.getFrameIcon();
            FontMetrics fm = NetInternalFrameTitlePane.this.frame.getFontMetrics(NetInternalFrameTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 13);
            }
            dim.height = Math.max(fontHeight, iconHeight);
            if (NetInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = NetInternalFrameTitlePane.this.getBorder().getBorderInsets(parent);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean leftToRight = ComponentUtils.isLeftToRight(NetInternalFrameTitlePane.this.frame);
            int w = NetInternalFrameTitlePane.this.getWidth();
            int h = NetInternalFrameTitlePane.this.getHeight();
            int buttonHeight = NetInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int buttonWidth = NetInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            NetInternalFrameTitlePane.this.menuBar.setBounds(-1, -1, 0, 0);
            int x = leftToRight ? w - buttonWidth - 3 : 3;
            int buttonY = (h - buttonHeight) / 2 + 1;
            if (NetInternalFrameTitlePane.this.frame.isIcon()) {
                --buttonY;
            }
            if (NetInternalFrameTitlePane.this.frame.isClosable()) {
                NetInternalFrameTitlePane.this.closeButton.setBounds(x, buttonY, buttonWidth, buttonHeight);
                x += leftToRight ? -(buttonWidth + 2) : buttonWidth + 2;
            }
            if (NetInternalFrameTitlePane.this.frame.isMaximizable()) {
                NetInternalFrameTitlePane.this.maxButton.setBounds(x, buttonY, buttonWidth, buttonHeight);
                x += leftToRight ? -(buttonWidth + 2) : buttonWidth + 2;
            }
            if (NetInternalFrameTitlePane.this.frame.isIconifiable()) {
                NetInternalFrameTitlePane.this.iconButton.setBounds(x, buttonY, buttonWidth, buttonHeight);
            }
        }
    }
}

