/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLabelUIHelper;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.table.TableUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.labels.highlight.LabelHighlighter;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;
import javax.swing.text.View;

public class NetLabelUI
extends MetalLabelUI {
    private static String DEFAULT_ALIGNMENT_MODE = "individual";
    private static String DEFAULT_CLIPPED_MODE = "clipped";
    private static String DEFAULT_VERTICAL_WIDTH = "W";
    private static String DEFAULT_VERTICAL_SPACE = " ";
    private Rectangle myIconR = new Rectangle();
    private Rectangle myTextR = new Rectangle();
    private Rectangle myViewR = new Rectangle();
    private Insets myViewInsets = new Insets(0, 0, 0, 0);
    private Rectangle myPaintIconR = new Rectangle();
    private Rectangle myPaintTextR = new Rectangle();
    private Rectangle myPaintViewR = new Rectangle();
    private Insets myPaintViewInsets = new Insets(0, 0, 0, 0);
    private Rectangle myOPaintIconR = new Rectangle();
    private Rectangle myOPaintTextR = new Rectangle();
    protected static final NetLabelUI theNetLabelUI = new NetLabelUI();
    private NetLabelUIHelper myHelper;
    private Pattern myDefaultRangePattern;
    protected Matcher myMatcher;

    public static ComponentUI createUI(JComponent comp) {
        return theNetLabelUI;
    }

    protected NetLabelUI() {
    }

    @Override
    public void installDefaults(JLabel label) {
        super.installDefaults(label);
        if (this.myDefaultRangePattern == null) {
            this.myDefaultRangePattern = (Pattern)UIManager.get("Label.rangePattern");
            this.myMatcher = this.myDefaultRangePattern.matcher("");
        }
        if (this.myHelper == null) {
            this.myHelper = new NetLabelUIHelper();
        }
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        if (this.myHelper != null) {
            this.myHelper.propertyChanged(component);
        }
    }

    @Override
    public void uninstallDefaults(JLabel label) {
        super.uninstallDefaults(label);
        if (this.myHelper != null) {
            this.myHelper.uninstallDefaults();
        }
        this.myHelper = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("multiAlignmentMode") || propertyName.equals("clippedMode") || propertyName.equals("verticalSpace") || propertyName.equals("verticalWidth") || propertyName.equals("OrangeTouch.automaticTooltipEnabled")) {
            JLabel label = (JLabel)event.getSource();
            label.repaint();
        } else {
            super.propertyChange(event);
            if (event.getSource() instanceof JComponent) {
                JComponent comp = (JComponent)event.getSource();
                if (propertyName.equals("labelType") && this.myHelper != null) {
                    this.myHelper.propertyChanged(comp);
                }
                if (propertyName.equals("ToolTipText")) {
                    Object newValue = event.getNewValue();
                    if (!Boolean.TRUE.equals(comp.getClientProperty("OceanTouch.settingAutoTooltipText"))) {
                        comp.putClientProperty("OceanTouch.tooltipSetByClient", newValue != null && !newValue.toString().isEmpty());
                    }
                }
            }
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (ClientPropertyUtil.booleanValue(c, "Table.isHeaderRenderer", false)) {
                TableUtils.paintTableHeaderBackground(g, c);
                this.paint(g, c);
                return;
            }
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        NetUtils.paintTableCellBackground(g, c);
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        String[] lines;
        Icon icon;
        NetLookAndFeel.toggleTextAntialiasing(g);
        JLabel label = (JLabel)component;
        LabelHighlighter highlighter = (LabelHighlighter)label.getClientProperty("OrangeTouch.highlighter");
        FontMetrics fm = g.getFontMetrics();
        Rectangle textRect = null;
        if (highlighter != null) {
            textRect = new Rectangle();
            NetUtils.layoutCompoundLabel(label, fm, new Rectangle(), new Rectangle(), textRect, false);
            highlighter.paint(g, label, textRect);
        }
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        int fontHeight = fm.getHeight();
        int fontAscent = fm.getAscent();
        int numLines = 1;
        int maxline = 0;
        if (text != null) {
            int maxlength = 0;
            lines = NetUtils.breakupLines(text);
            numLines = lines.length;
            int i = 0;
            while (i < numLines) {
                int stringW = SwingUtilities.computeStringWidth(fm, lines[i]);
                if (stringW > maxlength) {
                    maxlength = stringW;
                    maxline = i;
                }
                ++i;
            }
        } else {
            lines = new String[]{null};
        }
        boolean clippedMode = this.isClippedMode(label);
        boolean vertical = this.isVerticalMode(label);
        boolean individualAlign = this.isIndividualAlign(label);
        this.myPaintViewInsets = component.getInsets(this.myPaintViewInsets);
        this.myPaintViewR.x = this.myPaintViewInsets.left;
        this.myPaintViewR.y = this.myPaintViewInsets.top;
        this.myPaintViewR.width = component.getWidth() - (this.myPaintViewInsets.left + this.myPaintViewInsets.right);
        this.myPaintViewR.height = component.getHeight() - (this.myPaintViewInsets.top + this.myPaintViewInsets.bottom);
        this.myPaintIconR.height = 0;
        this.myPaintIconR.width = 0;
        this.myPaintIconR.y = 0;
        this.myPaintIconR.x = 0;
        this.myPaintTextR.height = 0;
        this.myPaintTextR.width = 0;
        this.myPaintTextR.y = 0;
        this.myPaintTextR.x = 0;
        if (vertical) {
            String totalWidth = this.getTotalVerticalWidth(label, numLines);
            clippedMode = false;
            this.layoutCL(label, fm, totalWidth, icon, this.myPaintViewR, this.myPaintIconR, this.myPaintTextR, lines[maxline].length() * fontHeight, clippedMode);
        } else {
            this.layoutCL(label, fm, lines[maxline], icon, this.myPaintViewR, this.myPaintIconR, this.myPaintTextR, fontHeight * numLines, clippedMode);
        }
        if (icon != null && icon.getIconHeight() > 0 && icon.getIconWidth() > 0) {
            if (ClientPropertyUtil.booleanValue(label, "Label.isRollover")) {
                icon = ImageUtils.createRolloverIcon(label, icon);
            } else if (ClientPropertyUtil.booleanValue(label, "Label.isDark") && SystemUtils.isFocusedIconAutoCreated()) {
                icon = ImageUtils.createFocusedIcon(label, icon);
            }
            icon.paintIcon(component, g, this.myPaintIconR.x, this.myPaintIconR.y);
        }
        if (text != null) {
            int accChar = label.getDisplayedMnemonic();
            int accCharIndex = label.getDisplayedMnemonicIndex();
            int textX = this.myPaintTextR.x;
            int textY = this.myPaintTextR.y + fontAscent;
            int textWidth = this.myPaintTextR.width;
            View v = (View)component.getClientProperty("html");
            if (v != null) {
                v.paint(g, this.myPaintTextR);
            } else if (vertical) {
                String space = this.getVerticalSpace(label);
                String width = this.getVerticalWidth(label);
                int pixelSpace = fm.stringWidth(space);
                int pixelWidth = fm.stringWidth(width);
                int pixelColumnWidth = pixelSpace + pixelWidth;
                char[] oneChar = new char[1];
                int i = 0;
                while (i < numLines) {
                    String line = lines[i];
                    int strlen = line.length();
                    if (individualAlign) {
                        this.myOPaintIconR.height = 0;
                        this.myOPaintIconR.width = 0;
                        this.myOPaintIconR.y = 0;
                        this.myOPaintIconR.x = 0;
                        this.myOPaintTextR.height = 0;
                        this.myOPaintTextR.width = 0;
                        this.myOPaintTextR.y = 0;
                        this.myOPaintTextR.x = 0;
                        line = this.layoutCL(label, fm, space, icon, this.myPaintViewR, this.myOPaintIconR, this.myOPaintTextR, strlen * fontHeight, clippedMode);
                        textY = this.myOPaintTextR.y + fontAscent;
                    }
                    int j = 0;
                    int k = textY;
                    while (j < strlen) {
                        oneChar[0] = lines[i].charAt(j);
                        String oneCharStr = new String(oneChar);
                        int offset = (pixelWidth - fm.stringWidth(oneCharStr)) / 2;
                        if (label.isEnabled()) {
                            if (this.paintEnabledText(label, g, oneCharStr, textX + offset, k, accChar, accCharIndex)) {
                                accChar = 0;
                            }
                        } else if (this.paintDisabledText(label, g, oneCharStr, textX + offset, k, accChar, accCharIndex)) {
                            accChar = 0;
                        }
                        ++j;
                        k += fontHeight;
                    }
                    ++i;
                    textX += pixelColumnWidth;
                }
            } else {
                int textHeight = fontHeight * numLines;
                int i = 0;
                while (i < numLines) {
                    int w;
                    String clipped = lines[i];
                    if (individualAlign) {
                        this.myOPaintIconR.height = 0;
                        this.myOPaintIconR.width = 0;
                        this.myOPaintIconR.y = 0;
                        this.myOPaintIconR.x = 0;
                        this.myOPaintTextR.height = 0;
                        this.myOPaintTextR.width = 0;
                        this.myOPaintTextR.y = 0;
                        this.myOPaintTextR.x = 0;
                        clipped = this.layoutCL(label, fm, clipped, icon, this.myPaintViewR, this.myOPaintIconR, this.myOPaintTextR, textHeight, clippedMode);
                        textX = this.myOPaintTextR.x;
                    } else if (clippedMode && (w = SwingUtilities.computeStringWidth(fm, clipped)) > textWidth) {
                        int orientation = ClientPropertyUtil.integerValue(label, "OrangeTouch.textClipOrientation");
                        clipped = NetUtils.getClippedText(clipped, fm, textWidth, orientation);
                    }
                    if (label.isEnabled()) {
                        if (ClientProperties.LABEL_RANGE.equals(label.getClientProperty("labelType"))) {
                            int rangeStart = 0;
                            int rangeEnd = 0;
                            int[] indices = (int[])label.getClientProperty("Label.rangeTextIndex");
                            if (indices != null && indices.length > 0) {
                                rangeStart = Math.max(indices[0], 0);
                                rangeStart = Math.min(indices[0], clipped.length());
                                rangeEnd = indices.length == 1 ? clipped.length() : Math.min(indices[1], clipped.length());
                            } else {
                                this.myMatcher.reset(lines[i]);
                                if (this.myMatcher.find()) {
                                    rangeStart = this.myMatcher.start();
                                    rangeEnd = Math.min(this.myMatcher.end(), clipped.length());
                                }
                            }
                            if (this.paintEnabledTextWithRange(label, g, clipped, textX, textY, accChar, accCharIndex, rangeStart, rangeEnd)) {
                                accChar = 0;
                            }
                        } else if (this.paintEnabledText(label, g, clipped, textX, textY, accChar, accCharIndex)) {
                            accChar = 0;
                        }
                    } else if (this.paintDisabledText(label, g, clipped, textX, textY, accChar, accCharIndex)) {
                        accChar = 0;
                    }
                    if (highlighter != null) {
                        highlighter.paintForeground(g, label, textRect);
                    }
                    ++i;
                    textY += fontHeight;
                }
            }
        }
        if (ClientPropertyUtil.booleanValue(label, "OrangeTouch.automaticTooltipEnabled")) {
            NetUtils.updateAutomaticTooltipVisibility(g, component, text, icon, label.getHorizontalTextPosition(), this.myPaintViewR, this.myPaintIconR, label.getIconTextGap());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        JLabel label = (JLabel)component;
        String text = label.getText();
        Icon icon = label.getIcon();
        Insets insets = label.getInsets(this.myViewInsets);
        Font font = label.getFont();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (icon == null && (text == null || text != null && font == null)) {
            return new Dimension(dx, dy);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + dx, icon.getIconHeight() + dy);
        }
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int fontHeight = fm.getHeight();
        String[] lines = NetUtils.breakupLines(text);
        int numLines = lines.length;
        String maxline = "";
        int maxwidth = 0;
        boolean clippedMode = this.isClippedMode(label);
        boolean vertical = this.isVerticalMode(label);
        int i = 0;
        while (i < numLines) {
            int w = fm.stringWidth(lines[i]);
            if (w > maxwidth) {
                maxline = lines[i];
                maxwidth = w;
            }
            ++i;
        }
        this.myIconR.height = 0;
        this.myIconR.width = 0;
        this.myIconR.y = 0;
        this.myIconR.x = 0;
        this.myTextR.height = 0;
        this.myTextR.width = 0;
        this.myTextR.y = 0;
        this.myTextR.x = 0;
        this.myViewR.x = dx;
        this.myViewR.y = dy;
        this.myViewR.height = Short.MAX_VALUE;
        this.myViewR.width = Short.MAX_VALUE;
        if (vertical) {
            String totalWidth = this.getTotalVerticalWidth(label, numLines);
            clippedMode = false;
            this.layoutCL(label, fm, totalWidth, icon, this.myViewR, this.myIconR, this.myTextR, maxline.length() * fontHeight, clippedMode);
        } else {
            this.layoutCL(label, fm, maxline, icon, this.myViewR, this.myIconR, this.myTextR, numLines * fontHeight, clippedMode);
        }
        int x1 = Math.min(this.myIconR.x, this.myTextR.x);
        int x2 = Math.max(this.myIconR.x + this.myIconR.width, this.myTextR.x + this.myTextR.width);
        int y1 = Math.min(this.myIconR.y, this.myTextR.y);
        int y2 = Math.max(this.myIconR.y + this.myIconR.height, this.myTextR.y + this.myTextR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        rv.width += dx;
        rv.height += dy;
        return rv;
    }

    public static void setDefaultAlignmentMode(String mode) {
        DEFAULT_ALIGNMENT_MODE = mode;
    }

    public static void setDefaultClippedMode(String mode) {
        DEFAULT_CLIPPED_MODE = mode;
    }

    public static void setDefaultVerticalSpace(String space) {
        DEFAULT_VERTICAL_SPACE = space;
    }

    public static void setDefaultVerticalWidth(String width) {
        DEFAULT_VERTICAL_WIDTH = width;
    }

    protected boolean isIndividualAlign(JLabel label) {
        String val = (String)label.getClientProperty("multiAlignmentMode");
        return val != null ? val.equals("individual") : DEFAULT_ALIGNMENT_MODE.equals("individual");
    }

    protected boolean isClippedMode(JLabel label) {
        String val = (String)label.getClientProperty("clippedMode");
        return val != null ? val.equals("clipped") : DEFAULT_CLIPPED_MODE.equals("clipped");
    }

    protected boolean isVerticalMode(JLabel label) {
        String val = (String)label.getClientProperty("orientationMode");
        return val != null ? val.equals("vertical") : false;
    }

    protected String getVerticalSpace(JLabel label) {
        String val = (String)label.getClientProperty("verticalSpace");
        return val != null ? val : DEFAULT_VERTICAL_SPACE;
    }

    protected String getVerticalWidth(JLabel label) {
        String val = (String)label.getClientProperty("verticalWidth");
        return val != null ? val : DEFAULT_VERTICAL_WIDTH;
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, int textHeight, boolean clippedMode) {
        return NetUtils.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap(), textHeight, clippedMode);
    }

    protected boolean paintEnabledText(JLabel label, Graphics g, String s, int textX, int textY, int accChar, int accCharIndex) {
        return NetUtils.drawStringWithOffset(label, g, s, textX, textY, accChar, accCharIndex);
    }

    protected boolean paintEnabledTextWithRange(JLabel label, Graphics g, String s, int textX, int textY, int accChar, int accCharIndex, int rangeStartIndex, int rangeEndIndex) {
        g.setColor(label.getForeground());
        if (rangeStartIndex >= rangeEndIndex) {
            return this.paintEnabledText(label, g, s, textX, textY, accChar, accCharIndex);
        }
        return NetUtils.drawStringWithRange(g, s, textX, textY, accCharIndex, rangeStartIndex, rangeEndIndex);
    }

    protected boolean paintDisabledText(JLabel label, Graphics g, String s, int textX, int textY, int accChar, int accCharIndex) {
        g.setColor(UIManager.getColor("Label.disabledForeground"));
        return NetUtils.drawString(g, s, accChar, textX, textY, -1);
    }

    protected String getTotalVerticalWidth(JLabel label, int numLines) {
        String space = this.getVerticalSpace(label);
        char[] spaceArr = space.toCharArray();
        int spaceLen = spaceArr.length;
        String width = this.getVerticalWidth(label);
        char[] widthArr = width.toCharArray();
        int widthLen = widthArr.length;
        char[] totalWidth = new char[spaceLen * numLines + widthLen * (numLines - 1)];
        int i = 0;
        while (i < numLines) {
            System.arraycopy(widthArr, 0, totalWidth, i * (spaceLen + widthLen), widthLen);
            if (i != numLines - 1) {
                System.arraycopy(spaceArr, 0, totalWidth, i * (spaceLen + widthLen) + widthLen, spaceLen);
            }
            ++i;
        }
        return new String(totalWidth);
    }
}

