/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class NetLabelUIHelper {
    private static Color theDefaultColor;
    private static final Color TITLE_SHADOW;

    static {
        TITLE_SHADOW = new Color(250, 250, 250);
        theDefaultColor = UIManager.getColor("Label.foreground");
    }

    public void propertyChanged(JComponent label) {
        Font font;
        Integer labelType = ClientPropertyUtil.integerValue(label, "labelType");
        Color foreground = label.getForeground();
        if (foreground == null || foreground instanceof UIResource) {
            Color newForeground = this.getDefaultColor();
            Color offsetForeground = null;
            if (labelType.equals(ClientProperties.LABEL_VISUALIZATION_HEADER)) {
                newForeground = NetTheme.COLOR_BLACK_29;
            } else if (labelType.equals(ClientProperties.LABEL_PRODUCT_NAME)) {
                newForeground = NetLookAndFeel.getControlInfo();
            } else if (labelType.equals(ClientProperties.LABEL_HEADER)) {
                newForeground = NetLookAndFeel.getControlInfo();
                offsetForeground = TITLE_SHADOW;
            } else if (labelType.equals(ClientProperties.LABEL_VALUE_TEXT)) {
                newForeground = NetLookAndFeel.getControlInfo();
                offsetForeground = null;
            } else if (labelType.equals(ClientProperties.LABEL_RANGE)) {
                newForeground = NetTheme.COLOR_BLACK_29;
                label.putClientProperty("PLabel.range.secondForeground", NetTheme.COLOR_GRAY_3);
            } else if (labelType.equals(ClientProperties.LABEL_TITLE)) {
                offsetForeground = TITLE_SHADOW;
                newForeground = UIManager.getColor("Label.titleForeground");
            } else if (labelType.equals(ClientProperties.LABEL_SUB_HEADER)) {
                offsetForeground = TITLE_SHADOW;
                newForeground = UIManager.getColor("Label.titleForeground");
            } else if (labelType.equals(ClientProperties.LABEL_TIP_TEXT)) {
                newForeground = NetLookAndFeel.getWhite();
            } else if (labelType.equals(ClientProperties.LABEL_TIP_LABEL)) {
                newForeground = UIManager.getColor("Label.tipLabelForeground");
            } else if (labelType.equals(ClientProperties.LABEL_SYSTEM_TEXT)) {
                newForeground = NetTheme.COLOR_GRAY_3;
            }
            label.setForeground(newForeground);
            if (offsetForeground != null) {
                label.putClientProperty("OrangeTouch.labelOffsetColor", offsetForeground);
            }
        }
        if ((font = label.getFont()) == null || font instanceof UIResource) {
            Font newFont = UIManager.getFont("Label.textFont");
            if (labelType.equals(ClientProperties.LABEL_VISUALIZATION_HEADER)) {
                newFont = UIManager.getFont("Label.visualizationtHeaderFont");
            } else if (labelType.equals(ClientProperties.LABEL_PRODUCT_NAME)) {
                newFont = UIManager.getFont("Label.productNameFont");
            } else if (labelType.equals(ClientProperties.LABEL_HEADER)) {
                newFont = UIManager.getFont("Label.headersFont");
            } else if (labelType.equals(ClientProperties.LABEL_SUB_HEADER)) {
                newFont = UIManager.getFont("Label.subHeadersFont");
            } else if (labelType.equals(ClientProperties.LABEL_TITLE) || labelType.equals(ClientProperties.LABEL_TIP_TEXT) || labelType.equals(ClientProperties.LABEL_TIP_LABEL)) {
                newFont = UIManager.getFont("Label.titleFont");
            } else if (labelType.equals(ClientProperties.LABEL_TEXT)) {
                newFont = UIManager.getFont("Label.textFont");
            } else if (labelType.equals(ClientProperties.LABEL_CALENDAR_DAYS)) {
                newFont = UIManager.getFont("Label.calendarDaysFont");
            }
            label.setFont(newFont);
        }
    }

    public void uninstallDefaults() {
    }

    protected Color getDefaultColor() {
        return theDefaultColor;
    }
}

