/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.RolloverHandler;
import com.nokia.laf.combobox.NetComboBoxRenderer;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.list.FilteredListModel;
import com.nokia.widgets.list.StatusListCellRenderer;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.WidgetResources;
import com.nokia.widgets.validation.Validator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class NetListUI
extends BasicListUI {
    private RolloverHandler myRolloverHandler = new RolloverHandler();
    private FocusListener myFocusHandler = new SelectionHandler();

    public static ComponentUI createUI(JComponent list) {
        return new NetListUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        UIManager.get("List.cellRenderer");
        this.installRenderer();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.myRolloverHandler.installTo(this.list);
        this.list.addFocusListener(this.myFocusHandler);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.myRolloverHandler.uninstallFrom(this.list);
        this.list.removeFocusListener(this.myFocusHandler);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new NetPropertyChangeHandler();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int size;
        int n = size = this.list == null ? 0 : this.list.getModel().getSize();
        if (size <= 0) {
            NetUtils.paintEmptyText(g, this.list, this.getEmptyText());
        }
        g.setColor(UIManager.getColor("ScrollPane.topShadow"));
        g.drawLine(0, 0, 0, c.getHeight() - 1);
        super.paint(g, c);
    }

    protected String getEmptyText() {
        FilteredListModel listModel;
        Object emptyText = this.list.getClientProperty("OrangeTouch.emptyText");
        if (emptyText == null) {
            emptyText = UIManager.get("List.defaultEmptyText");
        }
        if (this.list.getModel() instanceof FilteredListModel && (listModel = (FilteredListModel)this.list.getModel()).getWrappedModel().getSize() > 0) {
            return WidgetResources.getString("ListFilter.noMatches");
        }
        return emptyText == null ? null : emptyText.toString();
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        boolean cellHasFocus;
        Object value = dataModel.getElementAt(row);
        boolean bl = cellHasFocus = this.list.hasFocus() && row == leadIndex;
        if (this.list.isFocusOwner() && leadIndex < 0) {
            cellHasFocus = row == 0;
        }
        boolean isSelected = selModel.isSelectedIndex(row);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        if (Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"))) {
            int w = Math.min(cw, rendererComponent.getPreferredSize().width + 4);
            if (!ComponentUtils.isLeftToRight(this.list)) {
                cx += cw - w;
            }
            cw = w;
        }
        if (Boolean.TRUE.equals(this.list.getClientProperty("OrangeTouch.alternate")) && NetUtils.lookAndFeelCanReplace(rendererComponent.getBackground()) && !isSelected) {
            rendererComponent.setBackground(row % 2 == 0 ? UIManager.getColor("List.evenRowBackground") : UIManager.getColor("List.oddRowBackground"));
        }
        this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
        this.paintRollover(g, rowBounds, isSelected, cx, cy, cw, ch, rendererComponent);
    }

    private void paintRollover(Graphics g, Rectangle rowBounds, boolean isSelected, int cx, int cy, int cw, int ch, Component rendererComponent) {
        boolean isRollovered;
        Point rolloverPosition = (Point)this.list.getClientProperty("BlueTouch.rolloveredCell");
        boolean hoverWholeRow = this.list.getLayoutOrientation() == 0 && ClientPropertyUtil.booleanValue(this.list, "OrangeTouch.wholeRowActiveInTree", true);
        boolean bl = isRollovered = rolloverPosition != null && rowBounds.contains(rolloverPosition);
        if (isRollovered && !hoverWholeRow) {
            Dimension rendererPrefSize = rendererComponent.getPreferredSize();
            isRollovered = new Rectangle(cx, cy, rendererPrefSize.width, rendererPrefSize.height).contains(rolloverPosition);
        }
        if (rolloverPosition != null && isRollovered && !isSelected && rendererComponent.isEnabled()) {
            int width = hoverWholeRow ? cw - 3 : rendererComponent.getPreferredSize().width - 1;
            NetUtils.paintHoverEffect(g, rendererComponent, cx + 1, cy, width, ch - 1, null);
        }
    }

    protected void installRenderer() {
        if (NetUtils.lookAndFeelCanReplace(this.list.getCellRenderer()) && !(this.list.getCellRenderer() instanceof NetComboBoxRenderer)) {
            if (this.list.getModel() instanceof Validator || ClientPropertyUtil.hasProperty(this.list, "OrangeTouch.validator")) {
                this.list.setCellRenderer(new StatusListCellRenderer.UIResource());
            } else {
                this.list.setCellRenderer((ListCellRenderer)UIManager.get("List.cellRenderer"));
            }
            if (this.list.getCellRenderer() instanceof JComponent) {
                ((JComponent)((Object)this.list.getCellRenderer())).putClientProperty("JComponent.sizeVariant", this.list.getClientProperty("JComponent.sizeVariant"));
            }
        }
    }

    public class NetPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public NetPropertyChangeHandler() {
            super(NetListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if ("model".equals(propertyName) || "OrangeTouch.validator".equals(propertyName)) {
                NetListUI.this.installRenderer();
            } else if (("JComponent.sizeVariant".equals(propertyName) || "cellRenderer".equals(propertyName)) && NetListUI.this.list.getCellRenderer() instanceof JComponent) {
                ((JComponent)((Object)NetListUI.this.list.getCellRenderer())).putClientProperty("JComponent.sizeVariant", e.getNewValue());
            }
            NetListUI.this.list.revalidate();
            NetListUI.this.list.repaint();
        }
    }

    private class SelectionHandler
    extends FocusAdapter {
        private SelectionHandler() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Rectangle listBounds;
            if (NetListUI.this.list == null) {
                return;
            }
            int leadSelection = NetListUI.this.list.getLeadSelectionIndex();
            if (leadSelection < 0 && (listBounds = NetListUI.this.list.getCellBounds(0, 0)) != null) {
                NetListUI.this.list.repaint(listBounds);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focusLost(e);
        }
    }
}

