/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetBorderFactory;
import com.nokia.laf.NetIconFactory;
import com.nokia.laf.NetListCellRenderer;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.NetCheckBoxBorder;
import com.nokia.laf.borders.NetComboBoxEditorBorder;
import com.nokia.laf.borders.NetComboBoxPopupBorder;
import com.nokia.laf.borders.NetDialogBorder;
import com.nokia.laf.borders.NetListCellBorder;
import com.nokia.laf.borders.NetScrollPaneBorder;
import com.nokia.laf.borders.NetSpinnerBorder;
import com.nokia.laf.borders.NetTableCellBorder;
import com.nokia.laf.borders.NetTableHeaderCellBorder;
import com.nokia.laf.borders.NetTooltipBorder;
import com.nokia.laf.borders.TablePanelBorder;
import com.nokia.laf.borders.TableShadowBorder;
import com.nokia.laf.painters.SelectionBackgroundPainter;
import com.nokia.laf.painters.TableSelectionBackgroundPainter;
import com.nokia.laf.scrollbar.NetScrollPaneViewportBorder;
import com.nokia.laf.table.NetTrailingCornerComponent;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.icons.CloseIcon;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.CompoundIcon;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.icons.PEmptyIcon;
import com.nokia.widgets.text.PTextComponent;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.NSNColors;
import com.nokia.widgets.util.SystemUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class NetLookAndFeel
extends MetalLookAndFeel
implements KeyEventPostProcessor,
PropertyChangeListener {
    public static final String FONT_SIZE_INCREMENT_PROPERTY = "fontSizeIncrement";
    public static final String ALLOW_EMPTY_VALUES_AS_INVALID = "OrangeTouch.TextComponent.allowEmptyValuesAsInvalid";
    public static final String WRAP_TAB_LAYOUT_ENABLED = "OrangeTouch.TabbedPane.setWrapTabLayoutEnabled";
    private static boolean theTextAntialiased = false;
    private static int theFontSizeIncrement = 0;
    private static RenderingHints theRenderingHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    private static PropertyChangeListener thePropertyChangeListener;
    private static SwingPropertyChangeSupport thePropertyChangeSupport;
    private static JFrame theDefaultMainFrame;

    public static void install() {
        try {
            UIManager.setLookAndFeel(NetLookAndFeel.class.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDefaultMainFrame(JFrame frame) {
        theDefaultMainFrame = frame;
    }

    public static JFrame getDefaultMainFrame() {
        return theDefaultMainFrame;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (SystemUtils.isOrangeTouch()) {
            this.initOrangeTouchIcons();
        }
        JDialog.setDefaultLookAndFeelDecorated(true);
        thePropertyChangeSupport = new SwingPropertyChangeSupport(this);
        NetLookAndFeel.setCurrentTheme(new NetTheme());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this);
        UIDefaults defaults = UIManager.getDefaults();
        if (defaults != null) {
            UIManager.getDefaults().addPropertyChangeListener(this.createPropertyChangeListener());
        }
        UIManager.addPropertyChangeListener(this);
        NetLookAndFeel.setDesktopHints();
        Toolkit.getDefaultToolkit().addPropertyChangeListener("awt.font.desktophints", this);
        ToolTipManager.sharedInstance().setDismissDelay(5000);
        ToolTipManager.sharedInstance().setInitialDelay(500);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalPolicy(new LAFFocusPolicy());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("defaultFocusTraversalPolicy", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof LayoutFocusTraversalPolicy && !(evt.getNewValue() instanceof LAFFocusPolicy)) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalPolicy(new LAFFocusPolicy());
                }
            }
        });
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        thePropertyChangeSupport = null;
        theFontSizeIncrement = 0;
        NetLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this);
        UIDefaults defaults = UIManager.getDefaults();
        if (defaults != null) {
            defaults.removePropertyChangeListener(thePropertyChangeListener);
        }
        UIManager.removePropertyChangeListener(this);
        Toolkit.getDefaultToolkit().removePropertyChangeListener("awt.font.desktophints", this);
    }

    @Override
    public String getName() {
        return "OrangeTouch";
    }

    @Override
    public String getID() {
        return "OrangeTouch";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Nokia UI Look And Feel";
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public static boolean isTextAntialiased() {
        return theTextAntialiased;
    }

    public static void setTextAntialiased(boolean textAntialised) {
        theTextAntialiased = textAntialised;
        if (!SystemUtils.isAfterJava15()) {
            theRenderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, textAntialised ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public static void increaseFontSize(int increment) {
        int current = theFontSizeIncrement;
        theFontSizeIncrement += increment;
        NetLookAndFeel.updateFontUIDefaults(increment);
        NetLookAndFeel.firePropertyChange(current);
    }

    public static void setFontSizeIncrement(int increment) {
        int current = theFontSizeIncrement;
        theFontSizeIncrement = increment;
        NetLookAndFeel.updateFontUIDefaults(increment - current);
        NetLookAndFeel.firePropertyChange(current);
    }

    public static int getFontSizeIncrement() {
        return theFontSizeIncrement;
    }

    public static void resetFontSizeIncrement() {
        NetLookAndFeel.setFontSizeIncrement(0);
    }

    public static int getFontSize() {
        return UIManager.getFont("Label.font").getSize();
    }

    private static void updateFontUIDefaults(int fontSizeChange) {
        if (fontSizeChange == 0) {
            return;
        }
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Set keys = defaults.keySet();
        for (Object nextKey : keys) {
            Object nextResource;
            if (!nextKey.toString().toLowerCase().endsWith("font") || !((nextResource = defaults.get(nextKey)) instanceof FontUIResource)) continue;
            Font font = (Font)nextResource;
            int fontSize = font.getSize();
            FontUIResource newFont = new FontUIResource(font.deriveFont((float)(fontSize += fontSizeChange)));
            defaults.put(nextKey, newFont);
        }
        NetLookAndFeel.updateUI();
    }

    public static void updateUI() {
        Frame[] frames = Frame.getFrames();
        int idx = 0;
        while (idx < frames.length) {
            NetLookAndFeel.updateUI(frames[idx]);
            ++idx;
        }
    }

    private static void updateUI(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        Window[] windows = window.getOwnedWindows();
        int idx = 0;
        while (idx < windows.length) {
            NetLookAndFeel.updateUI(windows[idx]);
            ++idx;
        }
    }

    public static void toggleTextAntialiasing(Graphics gr) {
        if (gr instanceof Graphics2D) {
            Graphics2D graphics2d = (Graphics2D)gr;
            graphics2d.addRenderingHints(theRenderingHints);
        }
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String NET_PREFIX = "com.nokia.laf.Net";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.nokia.laf.NetButtonUI", "ToggleButtonUI", "com.nokia.laf.NetToggleButtonUI", "HelpButtonUI", "com.nokia.laf.NetHelpButtonUI", "CheckBoxUI", "com.nokia.laf.NetCheckBoxUI", "RadioButtonUI", "com.nokia.laf.NetRadioButtonUI", "SplitPaneUI", "com.nokia.laf.NetSplitPaneUI", "ScrollBarUI", "com.nokia.laf.NetScrollBarUI", "SpinnerUI", "com.nokia.laf.NetSpinnerUI", "LabelUI", "com.nokia.laf.NetLabelUI", "PanelUI", "com.nokia.laf.NetPanelUI", "TabbedPaneUI", "com.nokia.laf.NetTabbedPaneUI", "TextFieldUI", "com.nokia.laf.NetTextFieldUI", "MenuBarUI", "com.nokia.laf.NetMenuBarUI", "MenuItemUI", "com.nokia.laf.NetMenuItemUI", "MenuUI", "com.nokia.laf.NetMenuUI", "ComboBoxUI", "com.nokia.laf.NetComboBoxUI", "ComboBox.ButtonUI", "com.nokia.laf.NetComboBoxButtonUI", "PopupMenuSeparatorUI", "com.nokia.laf.NetPopupMenuSeparatorUI", "RadioButtonMenuItemUI", "com.nokia.laf.NetRadioButtonMenuItemUI", "CheckBoxMenuItemUI", "com.nokia.laf.NetCheckBoxMenuItemUI", "PopupMenuUI", "com.nokia.laf.NetPopupMenuUI", "ProgressBarUI", "com.nokia.laf.NetProgressBarUI", "ToolBarUI", "com.nokia.laf.NetToolBarUI", "FormattedTextFieldUI", "com.nokia.laf.NetFormattedTextFieldUI", "ToolTipUI", "com.nokia.laf.NetToolTipUI", "OptionPaneUI", "com.nokia.laf.NetOptionPaneUI", "SliderUI", "com.nokia.laf.NetSliderUI", "TextAreaUI", "com.nokia.laf.NetTextAreaUI", "TableUI", "com.nokia.laf.NetTableUI", "TableHeaderUI", "com.nokia.laf.NetTableHeaderUI", "FileChooserUI", "com.nokia.laf.NetFileChooserUI", "ListUI", "com.nokia.laf.NetListUI", "PasswordFieldUI", "com.nokia.laf.NetPasswordFieldUI", "TextPaneUI", "com.nokia.laf.NetTextPaneUI", "EditorPaneUI", "com.nokia.laf.NetEditorPaneUI", "InternalFrameUI", "com.nokia.laf.NetInternalFrameUI", "TreeUI", "com.nokia.laf.NetTreeUI", "ScrollPaneUI", "com.nokia.laf.NetScrollPaneUI", "ToolBarSeparatorUI", "com.nokia.laf.NetToolBarSeparatorUI", "DesktopIconUI", "com.nokia.laf.NetDesktopIconUI", "RootPaneUI", "com.nokia.laf.NetRootPaneUI", "ViewportUI", "com.nokia.laf.NetViewportUI", "ColorChooserUI", "com.nokia.laf.NetColorChooserUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        Color[] disabledButtonGradient;
        super.initComponentDefaults(table);
        Icon radioButtonIcon = NetIconFactory.getRadioButtonIcon();
        InsetsUIResource checkBoxMargin = new InsetsUIResource(3, 0, 4, 2);
        InsetsUIResource checkBoxSmallMargin = new InsetsUIResource(0, 0, 0, 2);
        Border textFieldBorder = NetBorderFactory.getTextFieldBorder();
        Border textAreaBorder = NetBorderFactory.getTextAreaBorder();
        Border menuItemBorder = NetBorderFactory.getMenuItemBorder();
        Icon radioButtonMenuItemIcon = NetIconFactory.getRadioButtonMenuItemIcon();
        NetTableCellBorder tableCellBorder = new NetTableCellBorder();
        Border panelBorder = NetBorderFactory.getPanelBorder();
        PEmptyIcon emptyIcon = new PEmptyIcon(16, 16);
        UIDefaults.ActiveValue netListCellRenderer = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults defaultsTable) {
                return new NetListCellRenderer.UIResource();
            }
        };
        BorderUIResource tooltipBorder = new BorderUIResource(BorderFactory.createCompoundBorder(new NetTooltipBorder(), BorderFactory.createEmptyBorder(3, 5, 2, 5)));
        Color[] buttonGradient = new Color[]{NetUtils.decodeColor("#FAFAFA"), NetUtils.decodeColor("#EBEBEB")};
        Color[] pressedButtonGradient = new Color[]{NetUtils.decodeColor("#C9C9C9"), NetUtils.decodeColor("#E1E1E1")};
        Color[] pressedDefaultButtonGradient = new Color[]{NetUtils.decodeColor("#2B2B2B"), NetUtils.decodeColor("#575757")};
        Color[] defaultButtonGradient = new Color[]{NetUtils.decodeColor("#737373"), NetUtils.decodeColor("#2A2A2A")};
        Color[] disabledDefaultButtonGradient = disabledButtonGradient = new Color[]{new ColorUIResource(238, 238, 238), new ColorUIResource(232, 232, 232)};
        ColorUIResource white = new ColorUIResource(255, 255, 255);
        Color[] rolloverButtonGradient = new Color[]{NetUtils.decodeColor("#FDFDFD"), NetUtils.decodeColor("#E3E3E3")};
        Color[] comboboxGradient = buttonGradient;
        Color[] pressedComboBoxGradient = pressedButtonGradient;
        Color[] rolloverComboBoxGradient = rolloverButtonGradient;
        Color[] scrollBarGradient = new Color[]{new ColorUIResource(244, 244, 244), new ColorUIResource(234, 234, 234), new ColorUIResource(218, 218, 218), new ColorUIResource(213, 213, 213)};
        Color[] scrollBarRolloverGradient = new Color[]{white, white, new ColorUIResource(242, 242, 242), new ColorUIResource(237, 237, 237)};
        Color[] scrollBarPressedGradient = new Color[]{new ColorUIResource(204, 204, 204), new ColorUIResource(200, 200, 200), new ColorUIResource(180, 180, 180), new ColorUIResource(176, 176, 176)};
        Color[] scrollBarArrowButtonGradient = new Color[]{new ColorUIResource(249, 249, 249), new ColorUIResource(235, 235, 235), new ColorUIResource(218, 218, 218), new ColorUIResource(208, 208, 208)};
        Color[] scrollBarArrowButtonRolloverGradient = new Color[]{white, white, new ColorUIResource(242, 242, 242), new ColorUIResource(234, 234, 234)};
        Color[] scrollBarArrowButtonPressedGradient = new Color[]{new ColorUIResource(214, 214, 214), new ColorUIResource(200, 200, 200), new ColorUIResource(180, 180, 180), new ColorUIResource(174, 174, 174)};
        Color[] tabbedPaneGradient = new Color[]{new ColorUIResource(248, 248, 248), new ColorUIResource(235, 235, 235), new ColorUIResource(218, 218, 218), new ColorUIResource(211, 211, 211)};
        Color[] tabbedPaneRolloverGradient = new Color[]{white, white, new ColorUIResource(242, 242, 242), new ColorUIResource(235, 235, 235)};
        Color[] toggleButtonSelectedGradient = new Color[]{new ColorUIResource(190, 217, 253), new ColorUIResource(139, 172, 245)};
        Color[] toggleButtonLargeSelectedGradient = new Color[]{new ColorUIResource(210, 226, 248), new ColorUIResource(183, 202, 244)};
        Color[] stripeGradient = new Color[]{new ColorUIResource(255, 240, 0), new ColorUIResource(253, 213, 146)};
        Color[] internalFrameGradient = new Color[]{new ColorUIResource(167, 166, 191), new ColorUIResource(254, 254, 254)};
        Color[] selectionGradient = new Color[]{NetTheme.getSelectionColor(), NetTheme.getSelectionColor(), NetTheme.getSelectionColor(), NetTheme.getSelectionColor()};
        Color[] editableTableSelectionGradient = new Color[]{new Color(248, 248, 248, 222), new Color(205, 225, 250, 222), new Color(205, 225, 250, 222), new Color(205, 225, 250, 222)};
        Color[] internalFrameInactiveGradient = new Color[]{new ColorUIResource(211, 211, 223), white};
        ImageIcon asterisk = new ImageIcon(NetLookAndFeel.class.getResource("icons/asterisk.png"));
        InsetsUIResource menuItemMargin = new InsetsUIResource(4, 5, 3, 5);
        ColorUIResource labelForeground = null;
        try {
            Color labelColor = NetUtils.decodeColor(System.getProperty("BlueTouch.labelColor"));
            if (labelColor != null) {
                labelForeground = new ColorUIResource(labelColor);
            }
        }
        catch (Exception labelColor) {
            // empty catch block
        }
        Color[] balloonShadow = NetLookAndFeel.getGrayShadow(6, 9, 7);
        Color[] tableShadow = new Color[]{new Color(0, 0, 0, 4), new Color(0, 0, 0, 6), new Color(0, 0, 0, 12)};
        ColorUIResource scrollBarBorderColor = new ColorUIResource(NetUtils.decodeColor("#DFDFDF"));
        Color productBannerBottomColor = NetUtils.decodeColor("#DADADA");
        ColorUIResource disabledTextComponentBackground = new ColorUIResource(NetUtils.decodeColor("#EFEFEF"));
        Color[] popupShadow = new Color[]{NetUtils.getBlack(5), NetUtils.getBlack(15), NetUtils.getBlack(26), NetUtils.getBlack(37), NetUtils.getBlack(48), NetUtils.getBlack(60), NetUtils.getBlack(75), NetUtils.getBlack(92)};
        List<Color> list = Arrays.asList(NetLookAndFeel.getGrayShadow(7, 9, 8));
        Collections.reverse(list);
        Color[] popupInverseShadow = list.toArray(new Color[popupShadow.length]);
        Color[] popupMenuCornerShadow = list.subList(4, list.size()).toArray(new Color[4]);
        int alpha = 185;
        Color navigationPanelColor = new Color(255, 255, 255, 170);
        Color navPanelBottomBorderShadow1 = new Color(235, 236, 239, alpha);
        Color navPanelBottomBorderShadow2 = new Color(229, 230, 232, alpha);
        Color navPanelBottomBorderShadow3 = new Color(216, 217, 219, alpha);
        Color navPanelBottomBorderShadow4 = new Color(196, 196, 199, alpha);
        Color navPanelBottomBorderShadow5 = new Color(183, 183, 186, alpha);
        ColorUIResource menuItemBackground = new ColorUIResource(NetUtils.decodeColor("#EDEDED"));
        Color[] curvedSheetShadow = NetLookAndFeel.getGrayShadow(42, -4, 10);
        UIDefaults.ActiveValue tableCorner = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults defaultsTable) {
                return new NetTrailingCornerComponent();
            }
        };
        Color[] productBannerBackground = new Color[]{NetUtils.decodeColor("#D9DBE1"), NetUtils.decodeColor("#E4E4E4")};
        ColorUIResource tableGridColor = new ColorUIResource(NetUtils.decodeColor("#C3C5D0"));
        NetDialogBorder dialogBorder = new NetDialogBorder();
        ColorUIResource selectionForeground = SystemUtils.isOrangeTouch() ? NetLookAndFeel.getBlack() : NetLookAndFeel.getWhite();
        Object[] objectArray = new Object[1474];
        objectArray[0] = "Button.border";
        objectArray[1] = NetBorderFactory.getButtonBorder();
        objectArray[2] = "Button.gradientIncrement";
        objectArray[3] = 9;
        objectArray[4] = "Button.textShiftOffset";
        objectArray[5] = 0;
        objectArray[6] = "Button.toolBorder";
        objectArray[7] = NetBorderFactory.getToolButtonBorder();
        objectArray[8] = "Button.toolBorderHighlight";
        objectArray[9] = NetTheme.COLOR_WHITE_20;
        objectArray[10] = "Button.toolBorderShadow";
        objectArray[11] = NetTheme.COLOR_GRAY_13;
        objectArray[12] = "Button.toolBorderPressedHighLight";
        objectArray[13] = NetTheme.COLOR_GRAY_3;
        objectArray[14] = "Button.background";
        objectArray[15] = NetTheme.COLOR_GRAY_15;
        objectArray[16] = "Button.lineColor";
        objectArray[17] = NetTheme.getComponentOutlineColor();
        objectArray[18] = "Button.defaultButtonFollowsFocus";
        objectArray[19] = Boolean.TRUE;
        objectArray[20] = "Button.focus";
        objectArray[21] = NetLookAndFeel.getFocusColor();
        objectArray[22] = "Button.lightFocus";
        objectArray[23] = NetLookAndFeel.getFocusColor();
        objectArray[24] = "Button.iconTextGap";
        objectArray[25] = 7;
        objectArray[26] = "Button.rolloverColor";
        objectArray[27] = NetTheme.getHoverColor();
        objectArray[28] = "Button.rolloverColor2";
        objectArray[29] = NetTheme.COLOR_ORANGE_2;
        objectArray[30] = "Button.pressedOutline";
        objectArray[31] = new ColorUIResource(NetUtils.decodeColor("#6B6B6B"));
        objectArray[32] = "Button.defaultButtonOutline";
        objectArray[33] = new ColorUIResource(NetUtils.decodeColor("#333333"));
        objectArray[34] = "Button.defaultButtonHighlightOutline";
        objectArray[35] = new ColorUIResource(NetUtils.decodeColor("#777777"));
        objectArray[36] = "Button.defaultButtonPressedHighlight";
        objectArray[37] = new ColorUIResource(NetUtils.decodeColor("#323232"));
        objectArray[38] = "Button.pressedOutlineGradient";
        objectArray[39] = new Color[]{Color.decode("#6B6B6B"), Color.decode("#A7A7A7")};
        objectArray[40] = "Button.pressedHighlight1";
        objectArray[41] = new ColorUIResource(NetUtils.getColor(Color.decode("#5F5F5F"), 116));
        objectArray[42] = "Button.pressedHighlight2";
        objectArray[43] = new ColorUIResource(NetUtils.getColor(Color.decode("#888888"), 74));
        objectArray[44] = "Button.pressedBottomHighlight";
        objectArray[45] = new ColorUIResource(NetUtils.decodeColor("#EEEEEE"));
        objectArray[46] = "Button.nsnGradient";
        objectArray[47] = buttonGradient;
        objectArray[48] = "Button.nsnRolloverGradient";
        objectArray[49] = buttonGradient;
        objectArray[50] = "Button.nsnPressedGradient";
        objectArray[51] = pressedButtonGradient;
        objectArray[52] = "Button.nsnDefaultButtonGradient";
        objectArray[53] = defaultButtonGradient;
        objectArray[54] = "Button.nsnDefaultButtonRolloverGradient";
        objectArray[55] = new Color[]{NetUtils.decodeColor("#2794CC"), NetUtils.decodeColor("#092454")};
        objectArray[56] = "Button.nsnPressedDefaultButtonGradient";
        objectArray[57] = pressedDefaultButtonGradient;
        objectArray[58] = "Button.nsnDisabledButtonGradient";
        objectArray[59] = disabledButtonGradient;
        objectArray[60] = "Button.nsnDisabledDefaultButtonGradient";
        objectArray[61] = disabledDefaultButtonGradient;
        objectArray[62] = "Button.outlineGradient";
        objectArray[63] = new Color[]{NetUtils.decodeColor("#B2B2B2"), NetUtils.decodeColor("#B2B2B2")};
        objectArray[64] = "Button.outlineColor";
        objectArray[65] = new ColorUIResource(NetUtils.decodeColor("#B2B2B2"));
        objectArray[66] = "Button.margin";
        objectArray[67] = new InsetsUIResource(6, 18, 6, 18);
        objectArray[68] = "Button.largemargin";
        objectArray[69] = new InsetsUIResource(9, 22, 9, 22);
        objectArray[70] = "Button.smallmargin";
        objectArray[71] = new InsetsUIResource(4, 13, 4, 13);
        objectArray[72] = "Button.iconmargin";
        objectArray[73] = new InsetsUIResource(6, 8, 6, 18);
        objectArray[74] = "Button.iconlargemargin";
        objectArray[75] = new InsetsUIResource(9, 12, 9, 22);
        objectArray[76] = "Button.iconsmallmargin";
        objectArray[77] = new InsetsUIResource(4, 3, 4, 12);
        objectArray[78] = "Button.iconOnlyMargin";
        objectArray[79] = new InsetsUIResource(7, 7, 7, 7);
        objectArray[80] = "Button.smallIconOnlyMargin";
        objectArray[81] = new InsetsUIResource(3, 3, 3, 3);
        objectArray[82] = "Button.largefont";
        objectArray[83] = NetTheme.getLargeControlTextFont();
        objectArray[84] = "Button.hoverShadow";
        objectArray[85] = new Color[]{NetUtils.getColor(NetTheme.getHoverColor(), 16), NetUtils.getColor(NetTheme.getHoverColor(), 30), NetUtils.getColor(NetTheme.getHoverColor(), 68)};
        objectArray[86] = "Button.shadow";
        objectArray[87] = new Color[]{new Color(0, 0, 0, 8), new Color(0, 0, 0, 14), new Color(0, 0, 0, 37)};
        objectArray[88] = "Editor.shadow";
        objectArray[89] = new Color[]{new Color(0, 0, 0, 8), new Color(0, 0, 0, 28)};
        objectArray[90] = "Button.minimalisticShadow";
        objectArray[91] = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 20)};
        objectArray[92] = "Editor.hoverShadow";
        objectArray[93] = new Color[]{NetUtils.getColor(NetTheme.getHoverColor(), 16), NetUtils.getColor(NetTheme.getHoverColor(), 55)};
        objectArray[94] = "FloatingPane.shadow";
        objectArray[95] = new Color[]{new Color(0, 0, 0, 7), new Color(0, 0, 0, 14), new Color(0, 0, 0, 28)};
        objectArray[96] = "FloatingPane.dropShadow";
        objectArray[97] = new Color[]{new Color(0, 0, 0, 6), new Color(0, 0, 0, 16), new Color(0, 0, 0, 32)};
        objectArray[98] = "FloatingPane.shadowOutline";
        objectArray[99] = new Color[]{new Color(255, 255, 255, 255), NetUtils.decodeColor("FFFFFF")};
        objectArray[100] = "FloatingPane.bottomOutline";
        objectArray[101] = new Color[]{NetUtils.decodeColor("FEFEFE"), NetUtils.decodeColor("B7B7B7")};
        objectArray[102] = "FloatingPane.lightShadow";
        objectArray[103] = new ColorUIResource(NetUtils.decodeColor("#F4F4F4"));
        objectArray[104] = "FloatingPane.bottomHighlight";
        objectArray[105] = Color.decode("#FCFCFC");
        objectArray[106] = "FloatingPane.bottomShadow";
        objectArray[107] = Color.decode("#EFEFEF");
        objectArray[108] = "FloatingPane.topShadow";
        objectArray[109] = Color.decode("#FDFDFD");
        objectArray[110] = "FloatingPane.outlineGradient";
        objectArray[111] = new Color[]{NetLookAndFeel.getWhite(), Color.decode("#FCFCFC")};
        objectArray[112] = "Button.rolloverShadow";
        objectArray[113] = new Color[]{new Color(244, 117, 0, 60), new Color(244, 117, 0, 80), new Color(244, 117, 0, 100)};
        objectArray[114] = "Button.disabledHighlight";
        objectArray[115] = new ColorUIResource(244, 244, 244);
        objectArray[116] = "Button.defaultButtonTextColor";
        objectArray[117] = new ColorUIResource(NetUtils.decodeColor("#191919"));
        objectArray[118] = "Button.disabledDefaultButtonText";
        objectArray[119] = new ColorUIResource(NetUtils.decodeColor("#F3F3F3"));
        objectArray[120] = "NavigationButton.rolloverTopBorder";
        objectArray[121] = NetUtils.decodeColor("#CCCDD1");
        objectArray[122] = "NavigationButton.selectedTopBorder";
        objectArray[123] = NetTheme.getHoverColor();
        objectArray[124] = "NavigationButton.selectedTopBorderShadow";
        objectArray[125] = NetUtils.getColor(NetTheme.getHoverColor(), 100);
        objectArray[126] = "NavigationButton.bottomBorder";
        objectArray[127] = NetUtils.decodeColor("#ABABAB");
        objectArray[128] = "NavigationButton.bottomBorderShadow1";
        objectArray[129] = navPanelBottomBorderShadow1;
        objectArray[130] = "NavigationButton.bottomBorderShadow2";
        objectArray[131] = navPanelBottomBorderShadow2;
        objectArray[132] = "NavigationButton.bottomBorderShadow3";
        objectArray[133] = navPanelBottomBorderShadow3;
        objectArray[134] = "NavigationButton.bottomBorderShadow4";
        objectArray[135] = navPanelBottomBorderShadow4;
        objectArray[136] = "NavigationButton.bottomBorderShadow5";
        objectArray[137] = navPanelBottomBorderShadow5;
        objectArray[138] = "NavigationButton.leftrightWhiteBorder";
        objectArray[139] = NetUtils.decodeColor("#FBFBFC");
        objectArray[140] = "NavigationButton.whiteunderlay";
        objectArray[141] = new Color[]{NetUtils.decodeColor("#F4F5F6"), NetUtils.decodeColor("#ECEDEE"), NetUtils.decodeColor("#DEDEE0"), NetUtils.decodeColor("#CBCBCD"), NetUtils.decodeColor("#BEBEBF"), NetUtils.decodeColor("#B8B8B9")};
        objectArray[142] = "NavigationButton.gradient1";
        objectArray[143] = NetUtils.decodeColor("#F4F4F4");
        objectArray[144] = "NavigationButton.gradientShadow1";
        objectArray[145] = NetUtils.decodeColor("#F0F0F0");
        objectArray[146] = "NavigationButton.gradientShadow2";
        objectArray[147] = NetUtils.decodeColor("#F1F1F1");
        objectArray[148] = "NavigationButton.gradientShadow3";
        objectArray[149] = NetUtils.decodeColor("#F3F3F3");
        objectArray[150] = "NavigationButton.leftrightBorder";
        objectArray[151] = NetUtils.decodeColor("#CCCDD1");
        objectArray[152] = "NavigationButton.pressedGradient1";
        objectArray[153] = NetUtils.decodeColor("#E1E1E1");
        objectArray[154] = "NavigationButton.pressedGradient2";
        objectArray[155] = NetUtils.decodeColor("#F2F2F2");
        objectArray[156] = "NavigationButton.pressedGradient3";
        objectArray[157] = NetUtils.decodeColor("#EDEDED");
        objectArray[158] = "NavigationButton.pressedOutline";
        objectArray[159] = NetUtils.decodeColor("#CCCDD1");
        objectArray[160] = "NavigationPanel.color";
        objectArray[161] = navigationPanelColor;
        objectArray[162] = "ToggleButton.selectedGradient";
        objectArray[163] = toggleButtonSelectedGradient;
        objectArray[164] = "ToggleButton.largeSelectedGradient";
        objectArray[165] = toggleButtonLargeSelectedGradient;
        objectArray[166] = "ToggleButton.border";
        objectArray[167] = NetBorderFactory.getToggleButtonBorder();
        objectArray[168] = "ToggleButton.textShiftOffset";
        objectArray[169] = 0;
        objectArray[170] = "ToggleButton.toolBorder";
        objectArray[171] = NetBorderFactory.getToggleToolButtonBorder();
        objectArray[172] = "ToggleButton.focus";
        objectArray[173] = NetLookAndFeel.getFocusColor();
        objectArray[174] = "ToggleButton.lightFocus";
        objectArray[175] = NetLookAndFeel.getFocusColor();
        objectArray[176] = "ToggleButton.largeButtonGradient";
        objectArray[177] = new Color[]{Color.decode("#FDFDFD"), Color.decode("#EDEDED")};
        objectArray[178] = "ToggleButton.margin";
        objectArray[179] = new InsetsUIResource(6, 19, 6, 19);
        objectArray[180] = "ToggleButton.smallmargin";
        objectArray[181] = new InsetsUIResource(4, 13, 4, 13);
        objectArray[182] = "ToggleButton.tabbutton.margin";
        objectArray[183] = new InsetsUIResource(6, 10, 6, 5);
        objectArray[184] = "ToggleButton.tabbutton.smallmargin";
        objectArray[185] = new InsetsUIResource(3, 5, 3, 5);
        objectArray[186] = "ToggleButton.tabbutton.iconOnlyMargin";
        objectArray[187] = new InsetsUIResource(7, 7, 7, 7);
        objectArray[188] = "ToggleButton.tabbutton.smallIconOnlyMargin";
        objectArray[189] = new InsetsUIResource(3, 3, 3, 3);
        objectArray[190] = "ToggleButton.iconmargin";
        objectArray[191] = new InsetsUIResource(6, 19, 6, 19);
        objectArray[192] = "ToggleButton.iconsmallmargin";
        objectArray[193] = new InsetsUIResource(3, 13, 3, 13);
        objectArray[194] = "ToggleButton.iconOnlyMargin";
        objectArray[195] = new InsetsUIResource(8, 8, 8, 8);
        objectArray[196] = "ToggleButton.smallIconOnlyMargin";
        objectArray[197] = new InsetsUIResource(3, 3, 3, 3);
        objectArray[198] = "ToggleButton.gradient";
        objectArray[199] = new Color[]{NetUtils.decodeColor("#FCFCFC"), NetUtils.decodeColor("#EDEDED")};
        objectArray[200] = "ToggleButton.pressedGradient";
        objectArray[201] = pressedButtonGradient;
        objectArray[202] = "ToggleButton.alternate1PressedGradient";
        objectArray[203] = pressedDefaultButtonGradient;
        objectArray[204] = "ToggleButton.alternate2PressedGradient";
        objectArray[205] = new Color[]{NetUtils.decodeColor("#376400"), NetUtils.decodeColor("#339900")};
        objectArray[206] = "ToggleButton.focusButtonGradient";
        objectArray[207] = defaultButtonGradient;
        objectArray[208] = "ToggleButton.disabledButtonGradient";
        objectArray[209] = disabledButtonGradient;
        objectArray[210] = "ToggleButton.disabledAlternate1PressedGradient";
        objectArray[211] = new Color[]{NetUtils.decodeColor("#8F8F8F"), NetUtils.decodeColor("#AFAFAF")};
        objectArray[212] = "ToggleButton.disabledAlternate2PressedGradient";
        objectArray[213] = new Color[]{NetUtils.decodeColor("#A6BC9B"), NetUtils.decodeColor("#C2D6B7")};
        objectArray[214] = "ToggleButton.focusOutline";
        objectArray[215] = new ColorUIResource(NetUtils.decodeColor("#333333"));
        objectArray[216] = "ToggleButton.alternate1PressedOutline";
        objectArray[217] = pressedDefaultButtonGradient;
        objectArray[218] = "ToggleButton.alternate2PressedOutline";
        objectArray[219] = new ColorUIResource(NetUtils.decodeColor("#0D5B03"));
        objectArray[220] = "ToggleButton.disabledPressedHighlight1";
        objectArray[221] = new ColorUIResource(NetUtils.decodeColor("#B1B1B1"));
        objectArray[222] = "ToggleButton.iconTextGap";
        objectArray[223] = 7;
        objectArray[224] = "Toggle.border";
        objectArray[225] = NetBorderFactory.getToggleBorder();
        objectArray[226] = "Toggle.margin";
        objectArray[227] = new InsetsUIResource(6, 9, 6, 10);
        objectArray[228] = "Toggle.smallmargin";
        objectArray[229] = new InsetsUIResource(2, 5, 1, 6);
        objectArray[230] = "Toggle.textColor";
        objectArray[231] = new ColorUIResource(NetUtils.decodeColor("#FFFFFF"));
        objectArray[232] = "Toggle.disabledText";
        objectArray[233] = new ColorUIResource(NetUtils.decodeColor("#F3F3F3"));
        objectArray[234] = "Toggle.smallfont";
        objectArray[235] = NetTheme.getSmallControlTextFont();
        objectArray[236] = "Toggle.outline";
        objectArray[237] = new ColorUIResource(NetUtils.decodeColor("#333333"));
        objectArray[238] = "Toggle.disabledOutline";
        objectArray[239] = new ColorUIResource(NetUtils.decodeColor("#8F8F8F"));
        objectArray[240] = "Toggle.normalGradient";
        objectArray[241] = pressedDefaultButtonGradient;
        objectArray[242] = "Toggle.disabledNormalGradient";
        objectArray[243] = new Color[]{NetUtils.decodeColor("#8F8F8F"), NetUtils.decodeColor("#AFAFAF")};
        objectArray[244] = "Toggle.offOutline";
        objectArray[245] = new ColorUIResource(NetUtils.decodeColor("#670101"));
        objectArray[246] = "Toggle.onOutline";
        objectArray[247] = new ColorUIResource(NetUtils.decodeColor("#336600"));
        objectArray[248] = "Toggle.disabledOffOutline";
        objectArray[249] = new ColorUIResource(NetUtils.decodeColor("#C49D9E"));
        objectArray[250] = "Toggle.disabledOnOutline";
        objectArray[251] = new ColorUIResource(NetUtils.decodeColor("#A6BC9B"));
        objectArray[252] = "Toggle.offGradient";
        objectArray[253] = new Color[]{NetUtils.decodeColor("#670101"), NetUtils.decodeColor("#D20000")};
        objectArray[254] = "Toggle.onGradient";
        objectArray[255] = new Color[]{NetUtils.decodeColor("#336600"), NetUtils.decodeColor("#339B00")};
        objectArray[256] = "Toggle.disabledOffGradient";
        objectArray[257] = new Color[]{NetUtils.decodeColor("#C49D9E"), NetUtils.decodeColor("#E0BABA")};
        objectArray[258] = "Toggle.disabledOnGradient";
        objectArray[259] = new Color[]{NetUtils.decodeColor("#A6BC9B"), NetUtils.decodeColor("#C4D8B9")};
        objectArray[260] = "Toggle.knobOutline";
        objectArray[261] = NetTheme.COLOR_GRAY_6;
        objectArray[262] = "Toggle.disabledKnobOutline";
        objectArray[263] = NetTheme.COLOR_GRAY_11;
        objectArray[264] = "Toggle.knobFocusColor";
        objectArray[265] = new ColorUIResource(NetUtils.decodeColor("#333333"));
        objectArray[266] = "Toggle.knobGradient";
        objectArray[267] = new Color[]{NetUtils.decodeColor("#F9F9F9"), NetUtils.decodeColor("#EBEBEB")};
        objectArray[268] = "Toggle.knobPressedGradient";
        objectArray[269] = pressedButtonGradient;
        objectArray[270] = "HelpButton.dimension";
        objectArray[271] = new Dimension(24, 24);
        objectArray[272] = "HelpButton.icon";
        objectArray[273] = NetIconFactory.getHelpIcon();
        objectArray[274] = "Hyperlink.font";
        objectArray[275] = NetTheme.FONT_BOLD;
        objectArray[276] = "Hyperlink.foreground";
        objectArray[277] = Color.decode("#0B6DAF");
        objectArray[278] = "Hyperlink.lightForeground";
        objectArray[279] = Color.decode("#7fc8f7");
        objectArray[280] = "Hyperlink.background";
        objectArray[281] = Color.WHITE;
        objectArray[282] = "Hyperlink.border";
        objectArray[283] = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        objectArray[284] = "Hyperlink.visited";
        objectArray[285] = NetLookAndFeel.getBlack();
        objectArray[286] = "CheckBox.textIconGap";
        objectArray[287] = 8;
        objectArray[288] = "CheckBox.icon";
        objectArray[289] = NetIconFactory.getCheckBoxIcon();
        objectArray[290] = "CheckBox.smallIcon";
        objectArray[291] = NetIconFactory.getSmallCheckBoxIcon();
        objectArray[292] = "CheckBox.border";
        objectArray[293] = new BorderUIResource.CompoundBorderUIResource(new NetCheckBoxBorder(), new BasicBorders.MarginBorder());
        objectArray[294] = "CheckBox.margin";
        objectArray[295] = checkBoxMargin;
        objectArray[296] = "CheckBox.smallmargin";
        objectArray[297] = checkBoxSmallMargin;
        objectArray[298] = "CheckBox.background";
        objectArray[300] = "RadioButton.textIconGap";
        objectArray[301] = 10;
        objectArray[302] = "RadioButton.icon";
        objectArray[303] = radioButtonIcon;
        objectArray[304] = "RadioButton.smallIcon";
        objectArray[305] = NetIconFactory.getSmallRadioButtonIcon();
        objectArray[306] = "RadioButton.border";
        objectArray[307] = new BorderUIResource.CompoundBorderUIResource(new NetCheckBoxBorder(), new BasicBorders.MarginBorder());
        objectArray[308] = "RadioButton.margin";
        objectArray[309] = checkBoxMargin;
        objectArray[310] = "RadioButton.smallmargin";
        objectArray[311] = checkBoxSmallMargin;
        objectArray[312] = "TitledBorder.border";
        objectArray[313] = new EmptyBorder(4, 4, 2, 0){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                NetLookAndFeel.toggleTextAntialiasing(g);
            }
        };
        objectArray[314] = "TitledBorder.font";
        objectArray[315] = new FontUIResource(NetTheme.FONT_NORMAL.deriveFont(16.0f));
        objectArray[316] = "TitledBorder.titleColor";
        objectArray[317] = NetTheme.COLOR_GRAY_3;
        objectArray[318] = "HeaderBorder.font";
        objectArray[319] = new FontUIResource(NetTheme.FONT_NORMAL.deriveFont(20.0f));
        objectArray[320] = "HeaderBorder.titleColor";
        objectArray[321] = NetTheme.COLOR_BLACK_29;
        objectArray[322] = "HeaderBorder.gradient";
        objectArray[323] = new Color[]{NetLookAndFeel.getWhite(), new Color(255, 255, 255, 89)};
        objectArray[324] = "HeaderBorder.panelBackground";
        objectArray[325] = new Color[]{NetUtils.decodeColor("#F7F7F7"), new Color(255, 255, 255)};
        objectArray[326] = "HeaderBorder.headerBackground";
        objectArray[327] = new Color[]{NetLookAndFeel.getWhite(), Color.decode("#F4F4F4")};
        objectArray[328] = "SplitPane.border";
        objectArray[330] = "SplitPaneDivider.border";
        objectArray[332] = "SplitPane.supportsOneTouchButtons";
        objectArray[333] = false;
        objectArray[334] = "SplitPane.dividerSize";
        objectArray[335] = 4;
        objectArray[336] = "SplitPane.background";
        objectArray[337] = NetTheme.COLOR_GRAY_15;
        objectArray[338] = "SplitPane.highlight";
        objectArray[339] = NetTheme.COLOR_GRAY_16;
        objectArray[340] = "SplitPane.shadow";
        objectArray[341] = NetTheme.COLOR_GRAY_16;
        objectArray[342] = "SplitPane.darkShadow";
        objectArray[343] = NetTheme.COLOR_GRAY_13;
        objectArray[344] = "SplitPane.arrowColor";
        objectArray[345] = NetTheme.COLOR_TABLE_TEXT;
        objectArray[346] = "SplitPane.OrangeTouch.dividerLightShadow";
        objectArray[347] = NetTheme.COLOR_WHITE_20;
        objectArray[348] = "ColorChooser.border";
        objectArray[349] = new BorderUIResource.EmptyBorderUIResource(20, 20, 20, 20);
        objectArray[350] = "ScrollBar.width";
        objectArray[351] = 17;
        objectArray[352] = "ScrollBar.trackShape";
        objectArray[353] = new ColorUIResource(NetUtils.decodeColor("#DDDDDD"));
        objectArray[354] = "ScrollBar.trackHighlight";
        objectArray[355] = new ColorUIResource(NetUtils.decodeColor("#E6E6E6"));
        objectArray[356] = "ScrollBar.thumb";
        objectArray[357] = new Color[]{NetUtils.decodeColor("#999999"), NetUtils.decodeColor("#666666")};
        objectArray[358] = "ScrollBar.rolloverThumb";
        objectArray[359] = new Color[]{NetUtils.decodeColor("#2691C9"), NetUtils.decodeColor("#092454")};
        objectArray[360] = "ScrollBar.pressedThumb";
        objectArray[361] = new Color[]{NetUtils.decodeColor("#333333"), NetUtils.decodeColor("#000000")};
        objectArray[362] = "ScrollBar.darkShadow";
        objectArray[363] = NetTheme.getComponentOutlineColor();
        objectArray[364] = "ScrollBar.shadow";
        objectArray[365] = NetTheme.COLOR_GRAY_9;
        objectArray[366] = "ScrollBar.thumbHighlight";
        objectArray[367] = NetLookAndFeel.getWhite();
        objectArray[368] = "ScrollBar.thumbShadow";
        objectArray[369] = NetLookAndFeel.getControlShadow();
        objectArray[370] = "ScrollBar.thumbDarkShadow";
        objectArray[371] = NetTheme.getComponentOutlineColor();
        objectArray[372] = "ScrollBar.PressedArrowBackground";
        objectArray[373] = NetTheme.COLOR_GRAY_13;
        objectArray[374] = "ScrollBar.background";
        objectArray[375] = NetTheme.COLOR_WHITE_20;
        objectArray[376] = "ScrollBar.trackHighlight";
        objectArray[377] = NetUtils.decodeColor("#E6E6E6");
        objectArray[378] = "ScrollBar.thubmHighlight";
        objectArray[379] = NetUtils.decodeColor("#868686");
        objectArray[380] = "ScrollBar.darkTrackShadow";
        objectArray[381] = new ColorUIResource(NetUtils.decodeColor("CACACA"));
        objectArray[382] = "ScrollBar.lightTrackShadow";
        objectArray[383] = new ColorUIResource(NetUtils.decodeColor("D4D4D4"));
        objectArray[384] = "ScrollBar.minimumThumbSize";
        objectArray[385] = new DimensionUIResource(12, 12);
        objectArray[386] = "Scrollbar.NormalBorder";
        objectArray[387] = scrollBarBorderColor;
        objectArray[388] = "ScrollBar.pressedThumbBackground";
        objectArray[389] = NetLookAndFeel.getControl();
        objectArray[390] = "ScrollBar.normalShadow";
        objectArray[391] = NetTheme.COLOR_GRAY_10;
        objectArray[392] = "ScrollBar.lightShadow";
        objectArray[393] = NetTheme.COLOR_GRAY_13;
        objectArray[394] = "ScrollBar.PressedGrabSurface1";
        objectArray[395] = NetTheme.COLOR_WHITE_20;
        objectArray[396] = "ScrollBar.PressedGrabSurface2";
        objectArray[397] = NetLookAndFeel.getFocusColor();
        objectArray[398] = "ScrollBar.PressedGrabSurface3";
        objectArray[399] = NetTheme.getComponentOutlineColor();
        objectArray[400] = "ScrollBar.normalArrow";
        objectArray[401] = new ColorUIResource(NetUtils.decodeColor("#666666"));
        objectArray[402] = "ScrollBar.disabledArrow";
        objectArray[403] = NetTheme.getDisabledComponentOutlineColor();
        objectArray[404] = "ScrollBar.pressedBorder";
        objectArray[405] = NetTheme.COLOR_GRAY_14;
        objectArray[406] = "ScrollBar.disabledBorder";
        objectArray[407] = NetTheme.getDisabledComponentOutlineColor();
        objectArray[408] = "ScrollBar.arrowBorderColor";
        objectArray[409] = scrollBarBorderColor;
        objectArray[410] = "ScrollBar.arroButtonOutlineGradient";
        objectArray[411] = new Color[]{NetUtils.decodeColor("#BABABA"), NetUtils.decodeColor("#DADADA")};
        objectArray[412] = "ScrollBar.DisabledGrabSurface1";
        objectArray[413] = NetTheme.COLOR_GRAY_16;
        objectArray[414] = "ScrollBar.DisabledGrabSurface2";
        objectArray[415] = NetTheme.COLOR_GRAY_13;
        objectArray[416] = "ScrollBar.DisabledGrabSurface3";
        objectArray[417] = NetTheme.getDisabledComponentOutlineColor();
        objectArray[418] = "ScrollBar.thumbRolloverColor";
        objectArray[419] = NetTheme.COLOR_WHITE_20;
        objectArray[420] = "ScrollBar.nsnGradient";
        objectArray[421] = scrollBarGradient;
        objectArray[422] = "ScrollBar.nsnRolloverGradient";
        objectArray[423] = scrollBarRolloverGradient;
        objectArray[424] = "ScrollBar.nsnPressedGradient";
        objectArray[425] = scrollBarPressedGradient;
        objectArray[426] = "ScrollBar.nsnArrowButtonGradient";
        objectArray[427] = scrollBarArrowButtonGradient;
        objectArray[428] = "ScrollBar.nsnArrowButtonRolloverGradient";
        objectArray[429] = scrollBarArrowButtonRolloverGradient;
        objectArray[430] = "ScrollBar.nsnArrowButtonPressedGradient";
        objectArray[431] = scrollBarArrowButtonPressedGradient;
        objectArray[432] = "ScrollBar.trackGradient";
        objectArray[433] = new Color[]{NetUtils.decodeColor("#DDDDDD"), NetUtils.decodeColor("#ECECEC")};
        objectArray[434] = "ScrollBar.decrementButtonGap";
        objectArray[435] = 4;
        objectArray[436] = "ScrollBar.incrementButtonGap";
        objectArray[437] = 4;
        objectArray[438] = "Viewport.cleanupPanelBorder";
        objectArray[439] = Boolean.FALSE;
        objectArray[440] = "ScrollPane.borderHighlight";
        objectArray[441] = NetUtils.decodeColor("#F8F8F8");
        objectArray[442] = "ScrollPane.shadowOutline";
        objectArray[443] = new Color[]{new Color(255, 255, 255, 255), NetUtils.decodeColor("F0F0F0")};
        objectArray[444] = "ScrollPane.curvedSheetInUse";
        objectArray[445] = Boolean.TRUE;
        objectArray[446] = "ScrollPane.border";
        objectArray[447] = new NetScrollPaneBorder();
        objectArray[448] = "ScrollPane.viewportBorder";
        objectArray[449] = new NetScrollPaneViewportBorder();
        objectArray[450] = "ScrollPane.panelViewportBorder";
        objectArray[451] = new BorderUIResource(BorderFactory.createEmptyBorder());
        objectArray[452] = "ScrollPane.outline";
        objectArray[453] = new Color[]{NetUtils.decodeColor("#C7C7C7"), NetUtils.decodeColor("#D6D6D6")};
        objectArray[454] = "ScrollPane.background";
        objectArray[455] = NetUtils.decodeColor("#F2F2F2");
        objectArray[456] = "ScrollPane.topShadow";
        objectArray[457] = NetUtils.decodeColor("#EFEFEF");
        objectArray[458] = "ScrollPane.splitPaneShadow";
        objectArray[459] = NetLookAndFeel.getGrayShadow(10, 16, 4);
        objectArray[460] = "ScrollPane.arrowButtonGradient";
        objectArray[461] = new Color[]{NetUtils.decodeColor("#FFFFFF"), NetUtils.decodeColor("#F6F6F6")};
        objectArray[462] = "Table.scrollPaneCornerComponent";
        objectArray[463] = tableCorner;
        objectArray[464] = "PopupMenu.border";
        objectArray[465] = NetBorderFactory.getPopupMenuBorder();
        objectArray[466] = "PopupMenu.shadow";
        objectArray[467] = popupShadow;
        objectArray[468] = "PopupMenu.inverseShadow";
        objectArray[469] = popupInverseShadow;
        objectArray[470] = "PopupMenu.cornerShadow";
        objectArray[471] = popupMenuCornerShadow;
        objectArray[472] = "PopupMenu.background";
        objectArray[473] = menuItemBackground;
        objectArray[474] = "Separator.foreground";
        objectArray[475] = NetUtils.decodeColor("#D8D8D8");
        objectArray[476] = "Separator.background";
        objectArray[477] = NetLookAndFeel.getWhite();
        objectArray[478] = "MenuItem.background";
        objectArray[479] = menuItemBackground;
        objectArray[480] = "MenuItem.iconTextGap";
        objectArray[481] = 8;
        objectArray[482] = "MenuItem.border";
        objectArray[483] = menuItemBorder;
        objectArray[484] = "MenuItem.font";
        objectArray[485] = NetLookAndFeel.getControlTextFont();
        objectArray[486] = "MenuItem.margin";
        objectArray[487] = menuItemMargin;
        objectArray[488] = "MenuItem.acceleratorFont";
        objectArray[489] = NetTheme.FONT_NORMAL;
        objectArray[490] = "MenuItem.acceleratorForeground";
        objectArray[491] = new ColorUIResource(Color.decode("#4d4d4d"));
        objectArray[492] = "MenuItem.acceleratorSelectionForeground";
        objectArray[493] = new ColorUIResource(Color.decode("#4d4d4d"));
        objectArray[494] = "MenuItem.acceleratorDelimiter";
        objectArray[495] = "+";
        objectArray[496] = "MenuItem.selectionBackground";
        objectArray[497] = NetLookAndFeel.getWhite();
        objectArray[498] = "MenuItem.selectionBorderColor";
        objectArray[499] = new ColorUIResource(141, 174, 245);
        objectArray[500] = "MenuItem.selectedOutline";
        objectArray[501] = new ColorUIResource(NetUtils.decodeColor("#666666"));
        objectArray[502] = "MenuItem.toggleIconBackground";
        objectArray[503] = new ColorUIResource(123, 165, 225);
        objectArray[504] = "MenuItem.toggleIconShadow";
        objectArray[505] = new ColorUIResource(19, 43, 78);
        objectArray[506] = "MenuItem.toggleIconHighlight";
        objectArray[507] = new ColorUIResource(123, 165, 225);
        objectArray[508] = "MenuItem.checkColor";
        objectArray[509] = new ColorUIResource(NetUtils.decodeColor("#5D5D5D"));
        objectArray[510] = "MenuItem.checkIcon";
        objectArray[511] = emptyIcon;
        objectArray[512] = "RadioButtonMenuItem.background";
        objectArray[513] = menuItemBackground;
        objectArray[514] = "RadioButtonMenuItem.iconTextGap";
        objectArray[515] = 8;
        objectArray[516] = "RadioButtonMenuItem.selectionBackground";
        objectArray[517] = NetLookAndFeel.getWhite();
        objectArray[518] = "RadioButtonMenuItem.checkIcon";
        objectArray[519] = radioButtonMenuItemIcon;
        objectArray[520] = "RadioButtonMenuItem.border";
        objectArray[521] = menuItemBorder;
        objectArray[522] = "RadioButtonMenuItem.font";
        objectArray[523] = NetLookAndFeel.getControlTextFont();
        objectArray[524] = "RadioButtonMenuItem.margin";
        objectArray[525] = menuItemMargin;
        objectArray[526] = "RadioButtonMenuItem.acceleratorForeground";
        objectArray[527] = NetTheme.COLOR_GRAY_3;
        objectArray[528] = "RadioButtonMenuItem.acceleratorSelectionForeground";
        objectArray[529] = NetTheme.COLOR_GRAY_3;
        objectArray[530] = "CheckBoxMenuItem.background";
        objectArray[531] = menuItemBackground;
        objectArray[532] = "CheckBoxMenuItem.iconTextGap";
        objectArray[533] = 8;
        objectArray[534] = "CheckBoxMenuItem.selectionBackground";
        objectArray[535] = NetLookAndFeel.getWhite();
        objectArray[536] = "CheckBoxMenuItem.checkIcon";
        objectArray[537] = NetIconFactory.getCheckBoxMenuItemIcon();
        objectArray[538] = "CheckBoxMenuItem.border";
        objectArray[539] = menuItemBorder;
        objectArray[540] = "CheckBoxMenuItem.font";
        objectArray[541] = NetLookAndFeel.getControlTextFont();
        objectArray[542] = "CheckBoxMenuItem.margin";
        objectArray[543] = menuItemMargin;
        objectArray[544] = "CheckBoxMenuItem.acceleratorForeground";
        objectArray[545] = NetTheme.COLOR_GRAY_3;
        objectArray[546] = "CheckBoxMenuItem.acceleratorSelectionForeground";
        objectArray[547] = NetTheme.COLOR_GRAY_3;
        objectArray[548] = "Menu.background";
        objectArray[549] = menuItemBackground;
        objectArray[550] = "Menu.border";
        objectArray[551] = NetBorderFactory.getMenuBorder();
        objectArray[552] = "Menu.margin";
        objectArray[553] = new InsetsUIResource(4, 3, 3, 3);
        objectArray[554] = "Menu.menuPopupOffsetY";
        objectArray[555] = -1;
        objectArray[556] = "Menu.menuPopupOffsetX";
        objectArray[557] = 0;
        objectArray[558] = "Menu.submenuPopupOffsetX";
        objectArray[559] = -5;
        objectArray[560] = "Menu.useMenuBarBackgroundForTopLevel";
        objectArray[561] = Boolean.TRUE;
        objectArray[562] = "Menu.font";
        objectArray[563] = NetLookAndFeel.getControlTextFont();
        objectArray[564] = "Menu.checkIcon";
        objectArray[565] = emptyIcon;
        objectArray[566] = "Menu.arrowIcon";
        objectArray[567] = NetIconFactory.getMenuArrowIcon();
        objectArray[568] = "Menu.rolloverForeground";
        objectArray[569] = NetTheme.getHoverColor();
        objectArray[570] = "Menu.rolloverBackground";
        objectArray[571] = NetLookAndFeel.getWhite();
        objectArray[572] = "Menu.selectionBackground";
        objectArray[573] = NetLookAndFeel.getWhite();
        objectArray[574] = "MenuBar.border";
        objectArray[575] = NetBorderFactory.getMenuBarBorder();
        objectArray[576] = "MenuBar.borderHighlight";
        objectArray[577] = NetTheme.getComponentOutlineColor();
        objectArray[578] = "MenuBar.borderNormal";
        objectArray[579] = NetTheme.COLOR_GRAY_8;
        objectArray[580] = "MenuBar.borderShadow";
        objectArray[581] = NetUtils.decodeColor("#BBBBBB");
        objectArray[582] = "MenuBar.borderLightShadow";
        objectArray[583] = NetLookAndFeel.getWhite();
        objectArray[584] = "ToolBar.background";
        objectArray[585] = new ColorUIResource(productBannerBackground[0]);
        objectArray[586] = "ToolBar.border";
        objectArray[587] = NetBorderFactory.getToolBarBorder();
        objectArray[588] = "ToolBar.separatorSize";
        objectArray[589] = new DimensionUIResource(19, 6);
        objectArray[590] = "TextComponent.defaultPopupMenuInUse";
        objectArray[591] = Boolean.TRUE;
        objectArray[592] = "TextField.mandatoryBackground";
        objectArray[593] = new ColorUIResource(245, 240, 171);
        objectArray[594] = "TextField.disabledBackground";
        objectArray[595] = disabledTextComponentBackground;
        objectArray[596] = "TextField.clearButtonColor";
        objectArray[597] = new ColorUIResource(NetUtils.decodeColor("#999999"));
        objectArray[598] = "TextField.border";
        objectArray[599] = textFieldBorder;
        objectArray[600] = "TextField.margin";
        objectArray[601] = new InsetsUIResource(4, 6, 4, 8);
        objectArray[602] = "TextField.tableMargin";
        objectArray[603] = new InsetsUIResource(1, 3, 1, 3);
        objectArray[604] = "TextField.smallmargin";
        objectArray[605] = new InsetsUIResource(0, 3, 1, 6);
        objectArray[606] = "TextField.caretForeground";
        objectArray[607] = new ColorUIResource(NetUtils.decodeColor("#323232"));
        objectArray[608] = "TextField.mandatoryAsterisk";
        objectArray[609] = new ColorUIResource(NetUtils.decodeColor("#BE0006"));
        objectArray[610] = "TextField.invalidBackground";
        objectArray[611] = NetTheme.COLOR_WHITE_20;
        objectArray[612] = "TextField.invalidForeground";
        objectArray[613] = new ColorUIResource(NetUtils.decodeColor("#BE0006"));
        objectArray[614] = "TextField.invalidFont";
        objectArray[615] = NetTheme.FONT_BOLD;
        objectArray[616] = "TextField.ItemCountBackground";
        objectArray[617] = new ColorUIResource(NetUtils.decodeColor("#666666"));
        objectArray[618] = "TextField.ItemCountForeground";
        objectArray[619] = new ColorUIResource(NetUtils.decodeColor("#FFFFFF"));
        objectArray[620] = "TextField.invalidStripe";
        objectArray[621] = new Color[]{NetUtils.decodeColor("#CA0000"), NetUtils.decodeColor("#9B0000")};
        objectArray[622] = "TextField.invalidStripeDisabled";
        objectArray[623] = new ColorUIResource(NetUtils.decodeColor("#B4B4B4"));
        objectArray[624] = "TextField.validateOnFocusLost";
        objectArray[625] = Boolean.FALSE;
        objectArray[626] = "TextField.asterisk";
        objectArray[627] = new IconUIResource(asterisk);
        objectArray[628] = "TextField.stripeGradient";
        objectArray[629] = stripeGradient;
        objectArray[630] = "TextField.focus";
        objectArray[631] = NetLookAndFeel.getFocusColor();
        objectArray[632] = "TextField.labelColor";
        objectArray[633] = new ColorUIResource(NetUtils.decodeColor("#666666"));
        objectArray[634] = "TextField.promptColor";
        objectArray[635] = new ColorUIResource(NetUtils.decodeColor("#595959"));
        objectArray[636] = "TextField.readOnlyFocusInputMap";
        objectArray[637] = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "COPY", "copy-to-clipboard", "control INSERT", "copy-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "LEFT", "caret-backward", "RIGHT", "caret-forward", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"});
        objectArray[638] = "TextField.topOutline";
        objectArray[639] = new Color[]{NetUtils.decodeColor("#B2B2B2")};
        objectArray[640] = "TextField.bottomOutline";
        objectArray[641] = new Color[]{NetUtils.decodeColor("#CFCFCF")};
        objectArray[642] = "TextField.bottomHighlight";
        objectArray[643] = new ColorUIResource(NetUtils.decodeColor("#FFFFFF"));
        objectArray[644] = "TextField.topHighlight";
        objectArray[645] = new ColorUIResource(NetUtils.decodeColor("#efefef"));
        objectArray[646] = "TextArea.margin";
        objectArray[647] = new InsetsUIResource(3, 6, 4, 6);
        objectArray[648] = "TextArea.inactiveBackground";
        objectArray[649] = new ColorUIResource(NetUtils.decodeColor("#F6F6F6"));
        objectArray[650] = "TextArea.border";
        objectArray[651] = textAreaBorder;
        objectArray[652] = "FormattedTextField.margin";
        objectArray[653] = new InsetsUIResource(3, 6, 4, 6);
        objectArray[654] = "FormattedTextField.smallmargin";
        objectArray[655] = new InsetsUIResource(0, 3, 1, 6);
        objectArray[656] = "FormattedTextField.border";
        objectArray[657] = textFieldBorder;
        objectArray[658] = "FormattedTextField.invalidBackground";
        objectArray[659] = NetTheme.COLOR_RED_19;
        objectArray[660] = "FormattedTextField.invalidForeground";
        objectArray[661] = NetTheme.COLOR_WHITE_20;
        objectArray[662] = "FormattedTextField.focus";
        objectArray[663] = NetLookAndFeel.getFocusColor();
        objectArray[664] = "FormattedTextField.disabledBackground";
        objectArray[665] = disabledTextComponentBackground;
        objectArray[666] = "Spinner.border";
        objectArray[667] = new NetSpinnerBorder();
        objectArray[668] = "Spinner.editorBorderPainted";
        objectArray[669] = Boolean.TRUE;
        objectArray[670] = "Spinner.enabledArrowColor";
        objectArray[671] = NetLookAndFeel.getFocusColor();
        objectArray[672] = "Spinner.disabledArrowColor";
        objectArray[673] = new ColorUIResource(NetUtils.decodeColor("#D0D0D0"));
        objectArray[674] = "Spinner.arrowButtonInsets";
        objectArray[675] = new InsetsUIResource(1, 0, 3, 2);
        objectArray[676] = "Spinner.buttonBorderColor";
        objectArray[677] = NetTheme.COLOR_GRAY_13;
        objectArray[678] = "Spinner.disableOnBoundaryValues";
        objectArray[679] = true;
        objectArray[680] = "Spinner.table.arrowColor";
        objectArray[681] = new ColorUIResource(Color.decode("#5F5F5F"));
        objectArray[682] = "Spinner.table.fillColor";
        objectArray[683] = new ColorUIResource(Color.decode("#F8F8F8"));
        objectArray[684] = "Spinner.table.lineColor";
        objectArray[685] = new ColorUIResource(Color.decode("#D7D7D7"));
        objectArray[686] = "Datepicker.DaysLabel.font";
        objectArray[687] = NetTheme.FONT_DATEPICKER_DAYS;
        objectArray[688] = "Datepicker.MonthLabel.font";
        objectArray[689] = NetTheme.FONT_DATEPICKER_MONTH;
        objectArray[690] = "Datepicker.MonthLabel.ForeColor";
        objectArray[691] = NetUtils.decodeColor("#474747");
        objectArray[692] = "Datepicker.CurrentMonth.Background";
        objectArray[693] = NetUtils.decodeColor("#FFFFFF");
        objectArray[694] = "Datepicker.OtherMonth.Background";
        objectArray[695] = NetUtils.decodeColor("#E0E0E0");
        objectArray[696] = "Datepicker.SelectedDate.ForeColor";
        objectArray[697] = selectionForeground;
        objectArray[698] = "Datepicker.Editor.Border";
        objectArray[699] = new CompoundBorder(new NetComboBoxEditorBorder(), new BasicBorders.MarginBorder());
        objectArray[700] = "Datepicker.Popoup.Border";
        objectArray[701] = new CompoundBorder(new NetComboBoxPopupBorder(8, 8, 8, 8), null);
        objectArray[702] = "ComboBox.border";
        objectArray[703] = NetBorderFactory.getComboBoxBorder();
        objectArray[704] = "ComboBox.margin";
        objectArray[705] = new Insets(0, 1, 0, 4);
        objectArray[706] = "ComboBox.nsnGradient";
        objectArray[707] = comboboxGradient;
        objectArray[708] = "ComboBox.nsnPressedGradient";
        objectArray[709] = pressedComboBoxGradient;
        objectArray[710] = "ComboBox.nsnRolloverGradient";
        objectArray[711] = rolloverComboBoxGradient;
        objectArray[712] = "Popup.border";
        objectArray[713] = new Color[]{new Color(0, 0, 0, 8), new Color(0, 0, 0, 23), new Color(0, 0, 0, 40)};
        objectArray[714] = "ComboBox.renderer.border";
        objectArray[715] = BorderFactory.createEmptyBorder(5, 3, 5, 11);
        objectArray[716] = "ComboBox.renderer.border.rightalign";
        objectArray[717] = BorderFactory.createEmptyBorder(5, 3, 5, 26);
        objectArray[718] = "ComboBox.renderer.border.smallrightalign";
        objectArray[719] = BorderFactory.createEmptyBorder(1, 4, 2, 19);
        objectArray[720] = "ComboBox.table.renderer.border.rightalign";
        objectArray[721] = BorderFactory.createEmptyBorder(5, 3, 5, 0);
        objectArray[722] = "ComboBox.renderer.smallborder";
        objectArray[723] = BorderFactory.createEmptyBorder(1, 5, 2, 4);
        objectArray[724] = "ComboBox.table.renderer.border";
        objectArray[725] = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        objectArray[726] = "ComboBox.editable.renderer.border";
        objectArray[727] = BorderFactory.createEmptyBorder(1, 5, 1, 24);
        objectArray[728] = "ComboBox.list.border";
        objectArray[729] = BorderFactory.createEmptyBorder(5, 10, 5, 4);
        objectArray[730] = "ComboBox.list.smallborder";
        objectArray[731] = BorderFactory.createEmptyBorder(3, 5, 3, 4);
        objectArray[732] = "ComboBox.list.tableborder";
        objectArray[733] = BorderFactory.createEmptyBorder(3, 2, 3, 3);
        objectArray[734] = "ComboBox.list.tableborder.rightalign";
        objectArray[735] = BorderFactory.createEmptyBorder(3, 1, 3, 16);
        objectArray[736] = "ComboBox.list.tableborder.rightalign.scroll";
        objectArray[737] = BorderFactory.createEmptyBorder(3, 5, 3, 5);
        objectArray[738] = "ComboBox.list.border.rightalign";
        objectArray[739] = BorderFactory.createEmptyBorder(5, 3, 5, 16);
        objectArray[740] = "ComboBox.list.smallborder.rightalign";
        objectArray[741] = BorderFactory.createEmptyBorder(0, 3, 0, 16);
        objectArray[742] = "ComboBox.background";
        objectArray[743] = new ColorUIResource(NetUtils.decodeColor("#FAFAFA"));
        objectArray[744] = "ComboBox.buttonBackground";
        objectArray[745] = NetTheme.COLOR_GRAY_17;
        objectArray[746] = "ComboBox.buttonDarkShadow";
        objectArray[747] = NetTheme.COLOR_GRAY_13;
        objectArray[748] = "ComboBox.buttonHighlight";
        objectArray[749] = NetTheme.COLOR_WHITE_20;
        objectArray[750] = "ComboBox.buttonShadow";
        objectArray[751] = NetTheme.COLOR_GRAY_13;
        objectArray[752] = "ComboBox.disabledBackground";
        objectArray[753] = NetTheme.COLOR_GRAY_15;
        objectArray[754] = "ComboBox.selectionBackground";
        objectArray[755] = new SelectionBackgroundPainter(selectionGradient);
        objectArray[756] = "ComboBox.Editor.border";
        objectArray[757] = new CompoundBorder(new NetComboBoxEditorBorder(), new BasicBorders.MarginBorder());
        objectArray[758] = "ComboBox.Button.icon";
        objectArray[759] = NetIconFactory.getComboBoxIcon();
        objectArray[760] = "ComboBox.Button.Table.icon";
        objectArray[761] = NetIconFactory.getTableEditorComboBoxIcon();
        objectArray[762] = "ComboBox.Button.Small.icon";
        objectArray[763] = NetIconFactory.getSmallComboBoxIcon();
        objectArray[764] = "ComboBox.Button.textIconGap";
        objectArray[765] = 3;
        objectArray[766] = "ComboBox.Button.textShiftOffset";
        objectArray[767] = 0;
        objectArray[768] = "ComboBox.Table.EditableBorder";
        objectArray[769] = new ColorUIResource(NetUtils.decodeColor("#D7D7D7"));
        objectArray[770] = "ComboBox.Button.margin";
        objectArray[771] = new Insets(0, 0, 0, 12);
        objectArray[772] = "ComboBox.Button.Table.margin";
        objectArray[773] = new Insets(1, 0, 0, 1);
        objectArray[774] = "ComboBox.Button.border";
        objectArray[775] = NetBorderFactory.getComboBoxButtonBorder();
        objectArray[776] = "DropdownList.Button.border";
        objectArray[777] = BorderFactory.createEmptyBorder();
        objectArray[778] = "ComboBox.Popup.border";
        objectArray[779] = new NetComboBoxPopupBorder();
        objectArray[780] = "ComboBox.OrangeTouch.comboBoxBottomBorder";
        objectArray[781] = new ColorUIResource(172, 172, 172);
        objectArray[782] = "ComboBox.separatorColor";
        objectArray[783] = new ColorUIResource(NetUtils.decodeColor("#B2B2B2"));
        objectArray[784] = "ComboBox.separatorColor2";
        objectArray[785] = new ColorUIResource(NetUtils.decodeColor("#686868"));
        objectArray[786] = "ComboBox.selectionForeground";
        objectArray[787] = selectionForeground;
        objectArray[788] = "Panel.background";
        objectArray[789] = NetTheme.COLOR_GRAY_15;
        objectArray[790] = "Panel.userforeground";
        objectArray[791] = NetTheme.COLOR_WHITE_20;
        objectArray[792] = "Panel.buttonAreaBackground";
        objectArray[793] = NetTheme.COLOR_GRAY_14;
        objectArray[794] = "Panel.border";
        objectArray[795] = panelBorder;
        objectArray[796] = "Panel.borderHighlight";
        objectArray[797] = NetTheme.getComponentOutlineColor();
        objectArray[798] = "Panel.borderShadow";
        objectArray[799] = new ColorUIResource(new Color(255, 255, 255));
        objectArray[800] = "Panel.borderLightShadow";
        objectArray[801] = new ColorUIResource(new Color(245, 245, 245));
        objectArray[802] = "Panel.borderFullShadow";
        objectArray[803] = new ColorUIResource(NetUtils.decodeColor("#D8D8D8"));
        objectArray[804] = "Panel.borderDarkShadow";
        objectArray[805] = new ColorUIResource(128, 128, 128);
        objectArray[806] = "Panel.font";
        objectArray[807] = NetLookAndFeel.getCurrentTheme().getControlTextFont();
        objectArray[808] = "Panel.headerGradient";
        objectArray[809] = new Color[]{NetUtils.decodeColor("#e9e9e9"), NetUtils.decodeColor("#ECECEC")};
        objectArray[810] = "Panel.headerTopColor";
        objectArray[811] = Color.decode("#FDFDFD");
        objectArray[812] = "Panel.headerPanelOutline";
        objectArray[813] = new ColorUIResource(NetUtils.decodeColor("#E5E5E5"));
        objectArray[814] = "Panel.curvedShadow";
        objectArray[815] = curvedSheetShadow;
        objectArray[816] = "Panel.lightCurvedShadow";
        objectArray[817] = NetLookAndFeel.getGrayShadow(32, -3, 10);
        objectArray[818] = "Label.font";
        objectArray[819] = NetTheme.FONT_INFO;
        objectArray[820] = "Label.toolTipFont";
        objectArray[821] = NetTheme.FONT_TOOLTIP;
        objectArray[822] = "Label.titleFont";
        objectArray[823] = new FontUIResource(NetTheme.FONT_NORMAL.deriveFont(1));
        objectArray[824] = "Label.titleForeground";
        objectArray[825] = Color.decode("#333333");
        objectArray[826] = "Label.foreground";
        objectArray[827] = NetTheme.COLOR_GRAY_3;
        objectArray[828] = "Label.systemForeground";
        objectArray[829] = labelForeground != null ? labelForeground : NetLookAndFeel.getSystemTextColor();
        objectArray[830] = "Label.valueTextForeground";
        objectArray[831] = NetTheme.COLOR_BLACK_1;
        objectArray[832] = "Label.tipLabelForeground";
        objectArray[833] = new ColorUIResource(NetUtils.decodeColor("#EBEBEB"));
        objectArray[834] = "Label.visualizationtHeaderFont";
        objectArray[835] = new FontUIResource(NetTheme.FONT_NORMAL.deriveFont(40.0f));
        objectArray[836] = "Label.productNameFont";
        objectArray[837] = new FontUIResource(NetTheme.FONT_NORMAL_700.deriveFont(21.0f));
        objectArray[838] = "Label.headersFont";
        objectArray[839] = new FontUIResource(NetTheme.FONT_NORMAL.deriveFont(18.0f));
        objectArray[840] = "Label.subHeadersFont";
        objectArray[841] = new FontUIResource(NetTheme.FONT_NORMAL.deriveFont(14.0f));
        objectArray[842] = "Label.textFont";
        objectArray[843] = new FontUIResource(NetTheme.FONT_NORMAL);
        objectArray[844] = "Label.calendarDaysFont";
        objectArray[845] = new FontUIResource(NetTheme.FONT_NORMAL_700.deriveFont(12.0f));
        objectArray[846] = "Label.tipFont";
        objectArray[847] = new FontUIResource(NetTheme.FONT_NORMAL.deriveFont(12.0f).deriveFont(1));
        objectArray[848] = "Label.unitForeground";
        objectArray[849] = NetTheme.COLOR_GRAY_3;
        objectArray[850] = "Label.rangePattern";
        objectArray[851] = Pattern.compile("[\\(\\[]\\s*[-+]?\\d*\\.?\\d+.*[-+]?\\d*\\.?\\d+\\s*[\\)\\]]");
        objectArray[852] = "ProgressBar.foreground";
        objectArray[853] = NetTheme.getComponentOutlineColor();
        objectArray[854] = "ProgressBar.background";
        objectArray[855] = new ColorUIResource(NetUtils.decodeColor("#D5D5D5"));
        objectArray[856] = "ProgressBar.selectionBackground";
        objectArray[857] = NetLookAndFeel.getBlack();
        objectArray[858] = "ProgressBar.selectionForeground";
        objectArray[859] = NetLookAndFeel.getWhite();
        objectArray[860] = "ProgressBar.foreground";
        objectArray[861] = NetLookAndFeel.getBlack();
        objectArray[862] = "ProgressBar.border";
        objectArray[863] = NetBorderFactory.getProgressBarBorder();
        objectArray[864] = "ProgressBar.circularIcon";
        objectArray[865] = NetIconFactory.getCircularIcon();
        objectArray[866] = "ProgressBar.circularSmallIcon";
        objectArray[867] = NetIconFactory.getCircularSmallIcon();
        objectArray[868] = "ProgressBar.trackShadow";
        objectArray[869] = new ColorUIResource(121, 121, 121);
        objectArray[870] = "ProgressBar.outlineGradient";
        objectArray[871] = new Color[]{NetUtils.decodeColor("#797979"), NetUtils.decodeColor("#D0D0D0")};
        objectArray[872] = "ProgressBar.trackColor";
        objectArray[873] = new ColorUIResource(NetUtils.decodeColor("#D5D5D5"));
        objectArray[874] = "ProgressBar.darkTrackShadow";
        objectArray[875] = new ColorUIResource(NetUtils.decodeColor("#A7A7A7"));
        objectArray[876] = "ProgressBar.midTrackShadow";
        objectArray[877] = new ColorUIResource(NetUtils.decodeColor("#C7C7C7"));
        objectArray[878] = "Footer.gradient";
        objectArray[879] = new Color[]{Color.WHITE, Color.decode("#EAEAEA")};
        objectArray[880] = "Footer.topOutline";
        objectArray[881] = Color.decode("#DFDFDF");
        objectArray[882] = "OrangeTouch.stringPaintedOnTrack";
        objectArray[883] = Boolean.TRUE;
        objectArray[884] = "OrangeTouch.percentPainted";
        objectArray[885] = Boolean.FALSE;
        objectArray[886] = "ProgressBar.font";
        objectArray[887] = NetLookAndFeel.getCurrentTheme().getControlTextFont();
        objectArray[888] = "ProgressBar.trackFont";
        objectArray[889] = NetTheme.FONT_NORMAL;
        objectArray[890] = "ProgressBar.statusBorder";
        objectArray[891] = NetBorderFactory.getBasicNetBorder();
        objectArray[892] = "ProgressBar.statusFont";
        objectArray[893] = NetTheme.FONT_TOOLTIP;
        objectArray[894] = "ProgressBar.nsnGradient";
        objectArray[895] = new Color[]{NetUtils.decodeColor("#2794CC"), NetUtils.decodeColor("#092454")};
        objectArray[896] = "ProgressBar.topBorder";
        objectArray[897] = new ColorUIResource(new Color(0, 0, 0, 90));
        objectArray[898] = "ProgressBar.topBorder2";
        objectArray[899] = new ColorUIResource(new Color(0, 0, 0, 30));
        objectArray[900] = "ProgressBar.bottomBorder";
        objectArray[901] = new ColorUIResource(46, 186, 24);
        objectArray[902] = "ProgressBar.OrangeTouch.ProgressBorderGlow";
        objectArray[903] = new Color(255, 255, 255, 190);
        objectArray[904] = "ProgressBar.repaintInterval";
        objectArray[905] = 30;
        objectArray[906] = "ProgressBar.cycleTime";
        objectArray[907] = 8010;
        objectArray[908] = "Table.ComboBox.Button.border";
        objectArray[909] = NetBorderFactory.getComboBoxEditableTableBorder();
        objectArray[910] = "Table.ComboBox.Editor.border";
        objectArray[911] = BorderFactory.createEmptyBorder();
        objectArray[912] = "Table.selectedEditorOutline";
        objectArray[913] = new Color[]{NetTheme.getSelectionColor().darker(), SystemUtils.isOrangeTouch() ? NetTheme.getSelectionColor().brighter() : Color.decode("#3D8DbF")};
        objectArray[914] = "ToolTip.background";
        objectArray[915] = new ColorUIResource(NetUtils.decodeColor("#FCFCC7"));
        objectArray[916] = "ToolTip.dropShadow";
        objectArray[917] = new Color[]{new Color(0, 0, 0, 6), new Color(0, 0, 0, 13), new Color(0, 0, 0, 27), new Color(0, 0, 0, 52)};
        objectArray[918] = "ToolTip.foreground";
        objectArray[919] = NetTheme.COLOR_BLACK_1;
        objectArray[920] = "ToolTip.backgroundInactive";
        objectArray[921] = new ColorUIResource(NetUtils.decodeColor("#FCFCC7"));
        objectArray[922] = "ToolTip.foregroundInactive";
        objectArray[923] = NetTheme.COLOR_BLACK_1;
        objectArray[924] = "ToolTip.accessForeground";
        objectArray[925] = NetTheme.COLOR_GRAY_3;
        objectArray[926] = "ToolTip.font";
        objectArray[927] = NetTheme.FONT_TOOLTIP;
        objectArray[928] = "ToolTip.border";
        objectArray[929] = tooltipBorder;
        objectArray[930] = "ToolTip.borderColor";
        objectArray[931] = new ColorUIResource(NetUtils.decodeColor("#F9CF00"));
        objectArray[932] = "ToolTip.borderInactive";
        objectArray[933] = tooltipBorder;
        objectArray[934] = "OptionPane.buttonAreaBackground";
        objectArray[935] = NetTheme.COLOR_GRAY_14;
        objectArray[936] = "OptionPane.buttonAreaBorder";
        objectArray[937] = new BorderUIResource(PBorderFactory.getButtonBarBorder());
        objectArray[938] = "OptionPane.border";
        objectArray[939] = panelBorder;
        objectArray[940] = "OptionPane.titleFont";
        objectArray[941] = new FontUIResource(NetTheme.FONT_NORMAL.deriveFont(14.0f));
        objectArray[942] = "OptionPane.headlineForeground";
        objectArray[943] = NetLookAndFeel.getSystemTextColor();
        objectArray[944] = "OptionPane.errorIcon";
        objectArray[945] = new IconUIResource(CommonIcons.getErrorIcon());
        objectArray[946] = "OptionPane.warningIcon";
        objectArray[947] = new IconUIResource(CommonIcons.getWarningIcon());
        objectArray[948] = "OptionPane.informationIcon";
        objectArray[949] = new IconUIResource(CommonIcons.getInfoIcon());
        objectArray[950] = "OptionPane.warningDialog.titlePane.foreground";
        objectArray[951] = NetLookAndFeel.getControlInfo();
        objectArray[952] = "OptionPane.errorDialog.titlePane.foreground";
        objectArray[953] = NetLookAndFeel.getControlInfo();
        objectArray[954] = "OptionPane.questionDialog.titlePane.foreground";
        objectArray[955] = NetLookAndFeel.getControlInfo();
        objectArray[956] = "OptionPane.questionIcon";
        objectArray[958] = "Slider.foreground";
        objectArray[959] = NetLookAndFeel.getBlack();
        objectArray[960] = "Slider.border";
        objectArray[961] = new BorderUIResource(BorderFactory.createEmptyBorder(3, 3, 2, 3));
        objectArray[962] = "Slider.trackWidth";
        objectArray[963] = 6;
        objectArray[964] = "Slider.majorTickLength";
        objectArray[965] = 7;
        objectArray[966] = "Slider.tickColor";
        objectArray[967] = NetLookAndFeel.getCurrentTheme().getControlInfo();
        objectArray[968] = "Slider.highlight";
        objectArray[969] = NetLookAndFeel.getWhite();
        objectArray[970] = "Slider.shadowColor";
        objectArray[971] = new ColorUIResource(146, 145, 140);
        objectArray[972] = "Slider.disabledColor";
        objectArray[973] = NetTheme.getDisabledComponentOutlineColor();
        objectArray[974] = "Slider.enabledColor";
        objectArray[975] = NetTheme.getComponentOutlineColor();
        objectArray[976] = "Slider.verticalThumbIcon";
        objectArray[977] = NetIconFactory.getVerticalSliderIcon();
        objectArray[978] = "Slider.horizontalThumbIcon";
        objectArray[979] = NetIconFactory.getSliderIcon();
        objectArray[980] = "Slider.horizontalSize";
        objectArray[981] = new Dimension(200, 21);
        objectArray[982] = "Slider.verticalSize";
        objectArray[983] = new Dimension(21, 200);
        objectArray[984] = "Slider.filledHighlight";
        objectArray[985] = new ColorUIResource(166, 202, 240);
        objectArray[986] = "Slider.lightTrackHighlight";
        objectArray[987] = new ColorUIResource(68, 144, 223);
        objectArray[988] = "Slider.darkTrackHighlight";
        objectArray[989] = new ColorUIResource(56, 128, 224);
        objectArray[990] = "Slider.filledColor";
        objectArray[991] = NetTheme.getSelectionColor();
        objectArray[992] = "Slider.midTrack";
        objectArray[993] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_mid.png"));
        objectArray[994] = "Slider.leftEdge";
        objectArray[995] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_left_edge.png"));
        objectArray[996] = "Slider.rightEdge";
        objectArray[997] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_right_edge.png"));
        objectArray[998] = "Slider.disabledMidTrack";
        objectArray[999] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_mid_disabled.png"));
        objectArray[1000] = "Slider.disabledLeftEdge";
        objectArray[1001] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_left_edge_disabled.png"));
        objectArray[1002] = "Slider.disabledRightEdge";
        objectArray[1003] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_right_edge_disabled.png"));
        objectArray[1004] = "Slider.verticalMidTrack";
        objectArray[1005] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_vertical_mid.png"));
        objectArray[1006] = "Slider.topEdge";
        objectArray[1007] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_top_edge.png"));
        objectArray[1008] = "Slider.bottomEdge";
        objectArray[1009] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_bottom_edge.png"));
        objectArray[1010] = "Slider.disabledVerticalMidTrack";
        objectArray[1011] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_vertical_mid_disabled.png"));
        objectArray[1012] = "Slider.disabledTopEdge";
        objectArray[1013] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_top_edge_disabled.png"));
        objectArray[1014] = "Slider.disabledBottomEdge";
        objectArray[1015] = new ImageIcon(NetIconFactory.class.getResource("icons/slider_bottom_edge_disabled.png"));
        objectArray[1016] = "TabbedPane.borderOutline";
        objectArray[1017] = Color.decode("#C6C6C6");
        objectArray[1018] = "TabbedPane.topColor";
        objectArray[1019] = Color.decode("#FEFEFE");
        objectArray[1020] = "TabbedPane.selectedTabEmphasis1";
        objectArray[1021] = NetTheme.getEmphasisColor();
        objectArray[1022] = "TabbedPane.selectedTabEmphasis2";
        objectArray[1023] = NetUtils.getColor(NetTheme.getEmphasisColor(), 160);
        objectArray[1024] = "TabbedPane.onlyTopBorderOutline";
        objectArray[1025] = Color.decode("#e5e5e5");
        objectArray[1026] = "TabbedPane.background";
        objectArray[1027] = NetTheme.COLOR_GRAY_15;
        objectArray[1028] = "TabbedPane.dialogBackground";
        objectArray[1029] = new Color[]{Color.decode("#F5F5F5"), Color.decode("#EDEDED")};
        objectArray[1030] = "TabbedPane.dialogHeader";
        objectArray[1031] = new Color[]{Color.decode("#FEFEFE"), Color.decode("#F5F5F5")};
        objectArray[1032] = "TabbedPane.disabledGradient";
        objectArray[1033] = new Color[]{NetUtils.decodeColor("#FEFEFE"), NetUtils.decodeColor("#FAFAFA")};
        objectArray[1034] = "TabbedPane.selectedTabGradient";
        objectArray[1035] = new Color[]{NetUtils.decodeColor("#FFFFFF"), NetUtils.decodeColor("#FEFEFE")};
        objectArray[1036] = "TabbedPane.selected";
        objectArray[1037] = NetTheme.COLOR_GRAY_16;
        objectArray[1038] = "TabbedPane.selectHighlight";
        objectArray[1039] = NetTheme.COLOR_WHITE_20;
        objectArray[1040] = "TabbedPane.shadow";
        objectArray[1041] = NetTheme.COLOR_GRAY_10;
        objectArray[1042] = "TabbedPane.borderShadow";
        objectArray[1043] = new Color[]{new Color(0, 0, 0, 6), new Color(0, 0, 0, 17), new Color(0, 0, 0, 28)};
        objectArray[1044] = "TabbedPane.darkShadow";
        objectArray[1045] = Color.decode("#B5B5B5");
        objectArray[1046] = "TabbedPane.bottomShadow";
        objectArray[1047] = NetUtils.decodeColor("#e8e8e8");
        objectArray[1048] = "TabbedPane.selectedFont";
        objectArray[1049] = NetTheme.FONT_NORMAL;
        objectArray[1050] = "TabbedPane.tabsOverlapBorder";
        objectArray[1051] = Boolean.TRUE;
        objectArray[1052] = "TabbedPane.selectedTabPadInsets";
        objectArray[1053] = new InsetsUIResource(0, 0, 0, 0);
        objectArray[1054] = "TabbedPane.focus";
        objectArray[1055] = NetLookAndFeel.getFocusColor();
        objectArray[1056] = "TabbedPane.tabInsets";
        objectArray[1057] = new InsetsUIResource(4, 10, 0, 10);
        objectArray[1058] = "TabbedPane.unselectedTabForeground";
        objectArray[1059] = new ColorUIResource(NetUtils.decodeColor("#222222"));
        objectArray[1060] = "TabbedPane.tabInsetsLeftRight";
        objectArray[1061] = new InsetsUIResource(1, 10, 1, 9);
        objectArray[1062] = "TabbedPane.tabAreaInsets";
        objectArray[1063] = new InsetsUIResource(1, 1, 0, 1);
        objectArray[1064] = "TabbedPane.tabAreaInsetsLeft";
        objectArray[1065] = new InsetsUIResource(3, 0, 3, 0);
        objectArray[1066] = "TabbedPane.tabAreaInsetsRight";
        objectArray[1067] = new InsetsUIResource(3, 0, 0, 4);
        objectArray[1068] = "TabbedPane.contentBackground";
        objectArray[1069] = NetTheme.COLOR_GRAY_15;
        objectArray[1070] = "TabbedPane.contentBorderInsets";
        objectArray[1071] = new InsetsUIResource(3, 3, 5, 4);
        objectArray[1072] = "TabbedPane.selectedTabBottomBorder";
        objectArray[1073] = new ColorUIResource(233, 233, 233);
        objectArray[1074] = "TabbedPane.nsnGradient";
        objectArray[1075] = tabbedPaneGradient;
        objectArray[1076] = "TabbedPane.nsnRolloverGradient";
        objectArray[1077] = tabbedPaneRolloverGradient;
        objectArray[1078] = "TabbePane.scrollButtonBorder";
        objectArray[1079] = NetBorderFactory.getTabbedPaneScrollButtonBorder();
        objectArray[1080] = "TabbedPane.focusInputMap";
        objectArray[1081] = new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hideOverflowPopup", "ENTER", "selectTabFromOverflow", "SPACE", "selectTabFromOverflow", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"});
        objectArray[1082] = "TabbedPane.unselectedTabGradient";
        objectArray[1083] = new Color[]{NetUtils.decodeColor("#FBFBFB"), NetUtils.decodeColor("#EFEFEF")};
        objectArray[1084] = "TabbedPane.disabledTabGradient";
        objectArray[1085] = new Color[]{NetUtils.decodeColor("#FDFDFD"), NetUtils.decodeColor("#EFEFEF")};
        objectArray[1086] = "TabbedPane.tabBorderShadow";
        objectArray[1087] = new Color(0, 0, 0, 5);
        objectArray[1088] = "TabbedPane.contentBorderOutline";
        objectArray[1089] = new ColorUIResource(NetUtils.decodeColor("#D9D9D9"));
        objectArray[1090] = "TabbedPane.selectedForeground";
        objectArray[1091] = new ColorUIResource(NetUtils.decodeColor("#1B1B1B"));
        objectArray[1092] = "Table.editableForeground";
        objectArray[1093] = NetLookAndFeel.getControlInfo();
        objectArray[1094] = "Table.GridVertical";
        objectArray[1095] = tableGridColor;
        objectArray[1096] = "Table.GridVertical";
        objectArray[1097] = Color.decode("#CFCFCF");
        objectArray[1098] = "Table.EditableGridHorizontal";
        objectArray[1099] = tableGridColor;
        objectArray[1100] = "Table.EditableRowBackground1";
        objectArray[1101] = NetTheme.COLOR_GRAY_17;
        objectArray[1102] = "Table.EditableRowBackground2";
        objectArray[1103] = NetTheme.COLOR_WHITE_20;
        objectArray[1104] = "Table.UnEditableRowBackground1";
        objectArray[1105] = new ColorUIResource(NetUtils.decodeColor("#FFFFFF"));
        objectArray[1106] = "Table.UnEditableRowBackground2";
        objectArray[1107] = new ColorUIResource(NetUtils.decodeColor("#EFEFEF"));
        objectArray[1108] = "Table.UnEditableGridHorizontal1";
        objectArray[1109] = tableGridColor;
        objectArray[1110] = "Table.UnEditableGridHorizontal2";
        objectArray[1111] = tableGridColor;
        objectArray[1112] = "Table.editableArrowColor";
        objectArray[1113] = NetUtils.decodeColor("#6F6F6F");
        objectArray[1114] = "Table.bottomRule";
        objectArray[1115] = new ColorUIResource(NetUtils.getColor(Color.decode("#D2d2d2"), 180));
        objectArray[1116] = "Table.headerGroupRule";
        objectArray[1117] = Color.decode("#e2e2e2");
        objectArray[1118] = "Table.disabledGridColor";
        objectArray[1119] = new ColorUIResource(230, 230, 230);
        objectArray[1120] = "Table.disabledDialogBackground";
        objectArray[1121] = new ColorUIResource(Color.decode("#F4f4f4"));
        objectArray[1122] = "Table.UnEditableGridVertical";
        objectArray[1123] = tableGridColor;
        objectArray[1124] = "Table.UneditableForeground";
        objectArray[1125] = NetLookAndFeel.getCurrentTheme().getControlInfo();
        objectArray[1126] = "Table.editorTopHighlight";
        objectArray[1127] = new Color(0, 0, 0, 13);
        objectArray[1128] = "Table.cellNoFocusBorder";
        objectArray[1129] = tableCellBorder;
        objectArray[1130] = "Table.noFocusCellBorder";
        objectArray[1131] = tableCellBorder;
        objectArray[1132] = "Table.foreground";
        objectArray[1133] = NetLookAndFeel.getCurrentTheme().getControlInfo();
        objectArray[1134] = "Table.noneditableGrid";
        objectArray[1135] = NetTheme.COLOR_GRAY_13;
        objectArray[1136] = "Table.defaultGrid";
        objectArray[1137] = NetTheme.COLOR_GRAY_15;
        objectArray[1138] = "Table.selectionForeground";
        objectArray[1139] = selectionForeground;
        objectArray[1140] = "Table.selectionBackground1";
        objectArray[1141] = NetTheme.getSelectionColor();
        objectArray[1142] = "Table.selectionBackground2";
        objectArray[1143] = NetTheme.getSelectionColor();
        objectArray[1144] = "Table.background1";
        objectArray[1145] = new ColorUIResource(238, 238, 238);
        objectArray[1146] = "Table.background2";
        objectArray[1147] = new ColorUIResource(230, 230, 230);
        objectArray[1148] = "Table.filterAreaBackground";
        objectArray[1149] = new ColorUIResource(NetUtils.decodeColor("#E6E6E6"));
        objectArray[1150] = "Table.emptyBackground";
        objectArray[1151] = new ColorUIResource(NetUtils.decodeColor("#F2F2F2"));
        objectArray[1152] = "Table.emptyText";
        objectArray[1153] = Color.decode("#505050");
        objectArray[1154] = "Table.evenHoverBackground";
        objectArray[1155] = new ColorUIResource(NetUtils.decodeColor("#CCF4FF"));
        objectArray[1156] = "Table.oddHoverBackground";
        objectArray[1157] = new ColorUIResource(NetUtils.decodeColor("#B2E3F0"));
        objectArray[1158] = "Table.missingEntry";
        objectArray[1159] = NetTheme.COLOR_YELLOW_22;
        objectArray[1160] = "Table.iconRendererBorder";
        objectArray[1161] = new BorderUIResource(new EmptyBorder(0, 0, 0, 13));
        objectArray[1162] = "Table.editorBorder";
        objectArray[1163] = new ColorUIResource(NetUtils.decodeColor("#D2D2D2"));
        objectArray[1164] = "Table.InfoRowGridVertical";
        objectArray[1165] = NetTheme.COLOR_GRAY_9;
        objectArray[1166] = "Table.InfoRowBackground";
        objectArray[1167] = NetTheme.COLOR_GRAY_13;
        objectArray[1168] = "Table.selectionBackground";
        objectArray[1169] = new SelectionBackgroundPainter.UIResource(selectionGradient);
        objectArray[1170] = "TableHeader.cellBorder";
        objectArray[1171] = new BorderUIResource.CompoundBorderUIResource(new NetTableHeaderCellBorder(), new BasicBorders.MarginBorder());
        objectArray[1172] = "TableHeader.bottomColor";
        objectArray[1173] = Color.decode("#E9E9E9");
        objectArray[1174] = "TableHeader.outlineColor";
        objectArray[1175] = new ColorUIResource(NetUtils.decodeColor("#D2D2D2"));
        objectArray[1176] = "Table.dialogOutlineColor";
        objectArray[1177] = new ColorUIResource(Color.decode("#dedede"));
        objectArray[1178] = "TableHeader.headerRendererBottomColor";
        objectArray[1179] = Color.decode("#F6F6F6");
        objectArray[1180] = "Table.panelOutlineColor";
        objectArray[1181] = new ColorUIResource(Color.decode("#DBDBDB"));
        objectArray[1182] = "TableHeader.dialogOutlineColor";
        objectArray[1183] = new ColorUIResource(Color.decode("#E0E0E0"));
        objectArray[1184] = "TableHeader.sortableCellBorder";
        objectArray[1185] = NetBorderFactory.getSortableTableHeaderBorder();
        objectArray[1186] = "TableHeader.foreground";
        objectArray[1187] = NetTheme.COLOR_GRAY_3;
        objectArray[1188] = "TableHeader.background";
        objectArray[1189] = NetTheme.COLOR_GRAY_15;
        objectArray[1190] = "TableHeader.backgroundGradient";
        objectArray[1191] = new Color[]{NetUtils.decodeColor("#FFFFFF"), NetUtils.decodeColor("#EAEAEA")};
        objectArray[1192] = "TableHeader.sortableBackground";
        objectArray[1193] = NetTheme.COLOR_GRAY_17;
        objectArray[1194] = "TableHeader.infoRowBackground";
        objectArray[1195] = NetTheme.COLOR_GRAY_13;
        objectArray[1196] = "TableHeader.infoRowForeground";
        objectArray[1197] = NetLookAndFeel.getBlack();
        objectArray[1198] = "TableHeader.infoRowBorderColor";
        objectArray[1199] = NetTheme.COLOR_GRAY_9;
        objectArray[1200] = "Table.border";
        objectArray[1201] = new TablePanelBorder();
        objectArray[1202] = "Table.focusCellHighlightBorder";
        objectArray[1203] = tableCellBorder;
        objectArray[1204] = "Table.ActiveSortableHeaderBackground";
        objectArray[1205] = NetTheme.COLOR_GRAY_13;
        objectArray[1206] = "Table.infoRowFont";
        objectArray[1207] = NetTheme.FONT_TOOLTIP;
        objectArray[1208] = "Table.infoRowBackground";
        objectArray[1209] = NetTheme.COLOR_GRAY_13;
        objectArray[1210] = "Table.scrollPaneBorder";
        objectArray[1211] = new TableShadowBorder();
        objectArray[1212] = "Table.ActiveSortableHeaderBorder";
        objectArray[1213] = NetBorderFactory.getSortedColumnBorder();
        objectArray[1214] = "Table.SelectedFocusedBackground";
        objectArray[1215] = new TableSelectionBackgroundPainter.UIResource(selectionGradient);
        objectArray[1216] = "Table.selectedHighlight";
        objectArray[1217] = NetLookAndFeel.getFocusColor();
        objectArray[1218] = "Table.emptyRowBackground";
        objectArray[1219] = NetTheme.COLOR_GRAY_15;
        objectArray[1220] = "Table.defaultEmptyText";
        objectArray[1221] = WidgetResources.getString("DefaultEmptyText");
        objectArray[1222] = "Table.selectionBackground";
        objectArray[1223] = new TableSelectionBackgroundPainter.UIResource(selectionGradient);
        objectArray[1224] = "Table.focusCellBackground";
        objectArray[1225] = new TableSelectionBackgroundPainter.UIResource(selectionGradient);
        objectArray[1226] = "Table.editableCellSelectionBackground";
        objectArray[1227] = editableTableSelectionGradient;
        objectArray[1228] = "Table.shadow";
        objectArray[1229] = tableShadow;
        objectArray[1230] = "Table.dialogShadow";
        objectArray[1231] = new Color[]{new Color(0, 0, 0, 5), new Color(0, 0, 0, 9), new Color(0, 0, 0, 18)};
        objectArray[1232] = "Table.bottomRuleColor";
        objectArray[1233] = new ColorUIResource(NetUtils.decodeColor("#DFE1E7"));
        objectArray[1234] = "Table.bottomOutline";
        objectArray[1235] = Color.decode("#d9d9d9");
        objectArray[1236] = "Table.dialogBottomOutline";
        objectArray[1237] = Color.decode("#dedede");
        objectArray[1238] = "Table.topRuleColor";
        objectArray[1239] = new ColorUIResource(NetUtils.decodeColor("#EFEFEF"));
        objectArray[1240] = "Tree.rightChildIndent";
        objectArray[1241] = 7;
        objectArray[1242] = "Tree.paintLines";
        objectArray[1243] = false;
        objectArray[1244] = "Tree.dividerColor";
        objectArray[1245] = tableGridColor;
        objectArray[1246] = "Tree.leftChildIndent";
        objectArray[1247] = 4;
        objectArray[1248] = "Tree.rowHeight";
        objectArray[1249] = 25;
        objectArray[1250] = "Tree.smallRowHeight";
        objectArray[1251] = 19;
        objectArray[1252] = "Tree.editorBorder";
        objectArray[1253] = new BorderUIResource.LineBorderUIResource(new Color(141, 174, 245));
        objectArray[1254] = "Tree.collapsedIcon";
        objectArray[1255] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults defaultsTable) {
                return NetIconFactory.getTreeNodeIcon(true);
            }
        };
        objectArray[1256] = "Tree.expandedIcon";
        objectArray[1257] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults defaultsTable) {
                return NetIconFactory.getTreeNodeIcon(false);
            }
        };
        objectArray[1258] = "Tree.leafIcon";
        objectArray[1259] = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults defaultsTable) {
                return NetIconFactory.getTreeLeafIcon();
            }
        };
        objectArray[1260] = "Tree.openIcon";
        objectArray[1261] = new IconUIResource(new PEmptyIcon(0, 0));
        objectArray[1262] = "Tree.closedIcon";
        objectArray[1263] = new IconUIResource(new PEmptyIcon(0, 0));
        objectArray[1264] = "Tree.rolloverForeground";
        objectArray[1265] = NetLookAndFeel.getBlack();
        objectArray[1266] = "Tree.drawDashedFocusIndicator";
        objectArray[1267] = false;
        objectArray[1268] = "Tree.line";
        objectArray[1269] = new ColorUIResource(198, 216, 252);
        objectArray[1270] = "Tree.hash";
        objectArray[1271] = new ColorUIResource(198, 216, 252);
        objectArray[1272] = "Tree.rendererMargins";
        objectArray[1273] = new InsetsUIResource(0, 2, 0, 0);
        objectArray[1274] = "Tree.selectedNonFocusBackground";
        objectArray[1275] = new Color(NetTheme.getSelectionColor().getRGB());
        objectArray[1276] = "Tree.selectionBackground";
        objectArray[1277] = new Color(NetTheme.getSelectionColor().getRGB());
        objectArray[1278] = "Tree.selectionForeground";
        objectArray[1279] = selectionForeground;
        objectArray[1280] = "Tree.selectionBorderColor";
        objectArray[1281] = NetTheme.getSelectionColor();
        objectArray[1282] = "Tree.border";
        objectArray[1283] = new BorderUIResource(BorderFactory.createEmptyBorder(1, 6, 0, 4));
        objectArray[1284] = "Tree.evenRowBackground";
        objectArray[1285] = NetUtils.decodeColor("#FFFFFF");
        objectArray[1286] = "Tree.oddRowBackground";
        objectArray[1287] = NetUtils.decodeColor("#EFEFEF");
        objectArray[1288] = "List.focusCellHighlightBorder";
        objectArray[1289] = NetBorderFactory.getListCellBorder();
        objectArray[1290] = "List.noFocusCellBorder";
        objectArray[1291] = new NetListCellBorder();
        objectArray[1292] = "List.cellNoFocusBorder";
        objectArray[1293] = new NetListCellBorder();
        objectArray[1294] = "List.cellRenderer";
        objectArray[1295] = netListCellRenderer;
        objectArray[1296] = "List.selectionBackground";
        objectArray[1297] = new SelectionBackgroundPainter.UIResource(selectionGradient);
        objectArray[1298] = "List.selectionForeground";
        objectArray[1299] = selectionForeground;
        objectArray[1300] = "List.border";
        objectArray[1301] = new BorderUIResource(BorderFactory.createEmptyBorder());
        objectArray[1302] = "List.evenRowBackground";
        objectArray[1303] = new ColorUIResource(NetUtils.decodeColor("#FFFFFF"));
        objectArray[1304] = "List.oddRowBackground";
        objectArray[1305] = new ColorUIResource(NetUtils.decodeColor("#EFEFEF"));
        objectArray[1306] = "List.borderShadow";
        objectArray[1307] = NetUtils.decodeColor("#E7E7E7");
        objectArray[1308] = "FileChooser.saveButtonMnemonic";
        objectArray[1309] = 83;
        objectArray[1310] = "FileChooser.ancestorInputMap";
        objectArray[1311] = new UIDefaults.LazyInputMap(new Object[]{"F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up", "ctrl ENTER", "approveSelection"});
        objectArray[1312] = "FileChooser.openButtonMnemonic";
        objectArray[1313] = 79;
        objectArray[1314] = "FileChooser.newFolderIcon";
        objectArray[1315] = new CompoundIcon(18, 18, NetUtils.loadIcon("t_ new folder_16_normal.png"), 0);
        objectArray[1316] = "FileChooser.upFolderIcon";
        objectArray[1317] = new CompoundIcon(18, 18, NetUtils.loadIcon("l_folder_up_16_14_2_normal.png"), 0);
        objectArray[1318] = "FileChooser.homeFolderIcon";
        objectArray[1319] = new CompoundIcon(18, 18, CommonIcons.getHomeIcon(), 0);
        objectArray[1320] = "FileChooser.detailsViewIcon";
        objectArray[1321] = new CompoundIcon(18, 18, NetUtils.loadIcon("l_file_chooser_details_16_14_normal.png"), 0);
        objectArray[1322] = "FileChooser.listViewIcon";
        objectArray[1323] = new CompoundIcon(18, 18, NetUtils.loadIcon("l_file_chooser_list_16_14_normal.png"), 0);
        objectArray[1324] = "FileView.directoryIcon";
        objectArray[1325] = new IconUIResource(CommonIcons.getFolderClosedIcon());
        objectArray[1326] = "FileView.fileIcon";
        objectArray[1327] = NetLookAndFeel.makeIcon(this.getClass(), "icons/l_file_16_14_normal.png");
        objectArray[1328] = "FileView.computerIcon";
        objectArray[1329] = NetLookAndFeel.makeIcon(this.getClass(), "icons/t_pc_16_normal.png");
        objectArray[1330] = "FileView.hardDriveIcon";
        objectArray[1331] = new CompoundIcon(16, 16, NetUtils.loadIcon("l_hard_drive_16_14_normal.png"), 0);
        objectArray[1332] = "FileView.floppyDriveIcon";
        objectArray[1333] = NetLookAndFeel.makeIcon(this.getClass(), "icons/l_ floppy_driver_16_14_normal.png");
        objectArray[1334] = "TextComponent.disabledFill";
        objectArray[1335] = new Color(0, 0, 0, 3);
        objectArray[1336] = "PasswordField.border";
        objectArray[1337] = textFieldBorder;
        objectArray[1338] = "PasswordField.margin";
        objectArray[1339] = new InsetsUIResource(6, 6, 5, 6);
        objectArray[1340] = "PasswordField.smallmargin";
        objectArray[1341] = new InsetsUIResource(1, 6, 2, 6);
        objectArray[1342] = "PasswordField.invalidBackground";
        objectArray[1343] = NetTheme.COLOR_RED_19;
        objectArray[1344] = "PasswordField.invalidForeground";
        objectArray[1345] = NetTheme.COLOR_WHITE_20;
        objectArray[1346] = "PasswordField.disabledBackground";
        objectArray[1347] = disabledTextComponentBackground;
        objectArray[1348] = "InternalFrame.maximizeIcon";
        objectArray[1349] = NetIconFactory.getInternalFrameIcon("maximize_normal_13.png", "maximize_rollover_13.png", "maximize_disabled_13.png", "maximize_pressed_13.png");
        objectArray[1350] = "InternalFrame.closeIcon";
        objectArray[1351] = NetIconFactory.getInternalFrameIcon("dialog_close.png", "dialog_close.png", "dialog_close.png", "dialog_close.png");
        objectArray[1352] = "InternalFrame.minimizeIcon";
        objectArray[1353] = NetIconFactory.getInternalFrameIcon("restore_normal_13.png", "restore_rollover_13.png", "restore_disabled_13.png", "restore_pressed_13.png");
        objectArray[1354] = "InternalFrame.iconifyIcon";
        objectArray[1355] = NetIconFactory.getInternalFrameIcon("minimize_normal_13.png", "minimize_rollover_13.png", "minimize_disabled_13.png", "minimize_pressed_13.png");
        objectArray[1356] = "InternalFrame.bottomBorder";
        objectArray[1357] = new ColorUIResource(213, 213, 218);
        objectArray[1358] = "InternalFrame.inactiveTitleForeground";
        objectArray[1359] = NetTheme.getDisabledComponentOutlineColor();
        objectArray[1360] = "InternalFrame.layoutTitlePaneAtOrigin";
        objectArray[1361] = Boolean.FALSE;
        objectArray[1362] = "DesktopIcon.width";
        objectArray[1363] = 160;
        objectArray[1364] = "InternalFrame.gradient";
        objectArray[1365] = internalFrameGradient;
        objectArray[1366] = "InternalFrame.inactiveGradient";
        objectArray[1367] = internalFrameInactiveGradient;
        objectArray[1368] = "InternalFrame.border";
        objectArray[1369] = NetBorderFactory.getInternalFrameBorder();
        objectArray[1370] = "InternalFrame.titleFont";
        objectArray[1371] = NetTheme.FONT_BOLD;
        objectArray[1372] = "InternalFrameTitlePane.closeButtonOpacity";
        objectArray[1373] = Boolean.FALSE;
        objectArray[1374] = "InternalFrameTitlePane.maximizeButtonOpacity";
        objectArray[1375] = Boolean.FALSE;
        objectArray[1376] = "InternalFrameTitlePane.minimizeButtonOpacity";
        objectArray[1377] = Boolean.FALSE;
        objectArray[1378] = "InternalFrameTitlePane.iconifyButtonOpacity";
        objectArray[1379] = Boolean.FALSE;
        objectArray[1380] = "BalloonInternalFrame.closeIcon";
        objectArray[1381] = new CloseIcon();
        objectArray[1382] = "BalloonInternalFrame.infoIcon";
        objectArray[1383] = NetLookAndFeel.makeIcon(this.getClass(), "icons/m_info16.png");
        objectArray[1384] = "BalloonInternalFrame.warnIcon";
        objectArray[1385] = NetLookAndFeel.makeIcon(this.getClass(), "icons/m_warning16.png");
        objectArray[1386] = "BalloonInternalFrame.errorIcon";
        objectArray[1387] = NetLookAndFeel.makeIcon(this.getClass(), "icons/m_error16.png");
        objectArray[1388] = "BalloonInternalFrame.titleFont";
        objectArray[1389] = NetTheme.FONT_BOLD;
        objectArray[1390] = "BalloonInternalFrame.font";
        objectArray[1391] = NetTheme.FONT_BOLD;
        objectArray[1392] = "Balloon.backgroundGradient";
        objectArray[1393] = new Color[]{NetUtils.decodeColor("#676767"), NetUtils.decodeColor("#000000")};
        objectArray[1394] = "Balloon.dropShadow";
        objectArray[1395] = balloonShadow;
        objectArray[1396] = "Desktop.background";
        objectArray[1397] = NetTheme.COLOR_GRAY_15;
        objectArray[1398] = "RootPane.capGradient";
        objectArray[1399] = new Color[]{NetUtils.decodeColor("#FEFEFE"), NetUtils.decodeColor("#E3E3E3")};
        objectArray[1400] = "RootPane.warningCapGradient";
        objectArray[1401] = new Color[]{NetUtils.decodeColor("#F89B00"), NetUtils.decodeColor("#FBAE00")};
        objectArray[1402] = "RootPane.errorCapGradient";
        objectArray[1403] = new Color[]{NetUtils.decodeColor("#B50E00"), NetUtils.decodeColor("#EE2B00")};
        objectArray[1404] = "RootPane.bottomShadow";
        objectArray[1405] = Color.decode("#bbbbbb");
        objectArray[1406] = "RootPane.topEmphasis";
        objectArray[1407] = new Color[]{NetTheme.getSelectionColor(), NetTheme.getSelectionColor().brighter(), Color.decode("#DBDBDB")};
        objectArray[1408] = "RootPane.font";
        objectArray[1409] = NetLookAndFeel.getCurrentTheme().getControlTextFont().deriveFont(14.0f);
        objectArray[1410] = "RootPane.productBannerContentPaneBorder";
        objectArray[1411] = new BorderUIResource.MatteBorderUIResource(16, 16, 0, 16, productBannerBottomColor);
        objectArray[1412] = "RootPane.plainDialogBorder";
        objectArray[1413] = dialogBorder;
        objectArray[1414] = "RootPane.informationDialogBorder";
        objectArray[1415] = dialogBorder;
        objectArray[1416] = "RootPane.errorDialogBorder";
        objectArray[1417] = dialogBorder;
        objectArray[1418] = "RootPane.colorChooserDialogBorder";
        objectArray[1419] = dialogBorder;
        objectArray[1420] = "RootPane.fileChooserDialogBorder";
        objectArray[1421] = dialogBorder;
        objectArray[1422] = "RootPane.questionDialogBorder";
        objectArray[1423] = dialogBorder;
        objectArray[1424] = "RootPane.warningDialogBorder";
        objectArray[1425] = dialogBorder;
        objectArray[1426] = "RootPane.productBannerContentPaneBorder";
        objectArray[1427] = new BorderUIResource.MatteBorderUIResource(16, 16, 0, 16, productBannerBottomColor);
        objectArray[1428] = "Dialog.shadow";
        objectArray[1429] = new Color[]{new Color(0, 0, 0, 3), new Color(0, 0, 0, 8), new Color(0, 0, 0, 15), new Color(0, 0, 0, 24), new Color(0, 0, 0, 34), new Color(0, 0, 0, 42), new Color(0, 0, 0, 52), new Color(0, 0, 0, 62), new Color(0, 0, 0, 74), new Color(0, 0, 0, 86)};
        objectArray[1430] = "RootPane.bottomHighlight";
        objectArray[1431] = new Color[]{NetUtils.decodeColor("#E4E4E4"), NetUtils.decodeColor("#CFCFCF")};
        objectArray[1432] = "RootPane.curvyOutline";
        objectArray[1433] = new Color[]{NetUtils.decodeColor("#DFDFDF"), NetUtils.decodeColor("#D0D0D0")};
        objectArray[1434] = "RootPane.warningCurvyOutline";
        objectArray[1435] = new Color[]{NetUtils.decodeColor("#FFE000"), NetUtils.decodeColor("#FFE000")};
        objectArray[1436] = "RootPane.errorCurvyOutline";
        objectArray[1437] = new Color[]{new Color(216, 140, 125), new Color(216, 140, 125)};
        objectArray[1438] = "Dialog.background";
        objectArray[1439] = new Color[]{NetUtils.decodeColor("#FAFAFA"), NetUtils.decodeColor("#ECECEC")};
        objectArray[1440] = "OptionPane.backgroundGradient";
        objectArray[1441] = new Color[]{NetUtils.decodeColor("#FEFEFE"), NetUtils.decodeColor("#EFEFEF")};
        objectArray[1442] = "Frame.background";
        objectArray[1443] = new ColorUIResource(NetUtils.decodeColor("#EBEBEB"));
        objectArray[1444] = "Dialog.productBannerBackground";
        objectArray[1445] = productBannerBackground;
        objectArray[1446] = "OrangeTouch.resizeCornerVisible";
        objectArray[1447] = Boolean.TRUE;
        objectArray[1448] = "OrangeTouch.closeWindowOnEscape";
        objectArray[1449] = Boolean.TRUE;
        objectArray[1450] = "ProductBanner.innerOutline";
        objectArray[1451] = Color.decode("#DCDCDC");
        objectArray[1452] = "ProductBanner.outerOutline";
        objectArray[1453] = Color.decode("#D7D7D7");
        objectArray[1454] = "ProductBanner.lightGradient";
        objectArray[1455] = new Color[]{Color.decode("#D7D7D7"), Color.decode("#A4A4A4")};
        objectArray[1456] = "ProductBanner.darkGradient";
        objectArray[1457] = new Color[]{Color.decode("#1750A9"), Color.decode("#0B2C6A")};
        objectArray[1458] = "ProductBanner.topOffset";
        objectArray[1459] = 22;
        objectArray[1460] = "ProductBanner.trailingOffset";
        objectArray[1461] = 5;
        objectArray[1462] = "AboutBox.brandText";
        objectArray[1464] = "Drilldown.background";
        objectArray[1465] = Color.decode("#DCDCDC");
        objectArray[1466] = "Drilldown.topHighlight";
        objectArray[1467] = Color.decode("#818181");
        objectArray[1468] = "Drilldown.footerGradient";
        objectArray[1469] = new Color[]{NetUtils.decodeColor("#DBDBDB"), NetUtils.decodeColor("#D2D2D2"), Color.decode("#888888")};
        objectArray[1470] = "Drilldown.headerGradient";
        objectArray[1471] = new Color[]{NetUtils.decodeColor("#8C8C8C"), NetUtils.decodeColor("#C8C8C8"), Color.decode("#DCDCDC")};
        objectArray[1472] = "Drilldown.focusInputMap";
        objectArray[1473] = new UIDefaults.LazyInputMap(new Object[]{"UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRowChangeLead", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRowChangeLead", "ctrl A", "selectAll", "ctrl BACK_SLASH", "clearSelection", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo", "SPACE", "toggleDrill", "ENTER", "openDrill", "ESCAPE", "closeDrill"});
        Object[] defaults = objectArray;
        table.putDefaults(defaults);
        if (SystemUtils.isOrangeTouch()) {
            this.setOrangeTouchDefaults(table);
        }
    }

    private void setOrangeTouchDefaults(UIDefaults table) {
        Object[] defaults = new Object[]{"ProductBanner.innerOutline", new Color(255, 164, 39), "ProductBanner.outerOutline", new Color(242, 145, 48), "ProductBanner.lightGradient", new Color[]{NetUtils.decodeColor("#FF9500"), NetUtils.decodeColor("#FF5F00")}, "ProductBanner.darkGradient", new Color[]{new Color(110, 110, 110), NSNColors.getDarkGray()}, "ProductBanner.topOffset", 17, "ProductBanner.trailingOffset", 8, "AboutBox.brandText", "for a world in motion", "Button.hoverShadow", new Color[]{new Color(244, 117, 0, 15), new Color(244, 117, 0, 40), new Color(244, 117, 0, 80)}, "NavigationButton.selectedTopBorder", NetUtils.decodeColor("#FF9900"), "NavigationButton.selectedTopBorderShadow", NetUtils.decodeColor("#FFC875"), "Hyperlink.font", NetTheme.FONT_NORMAL, "Hyperlink.foreground", NetLookAndFeel.getBlack(), "ScrollBar.rolloverThumb", new Color[]{NetUtils.decodeColor("#F7AB37"), NetUtils.decodeColor("#F47500")}, "ProgressBar.topBorder", new ColorUIResource(NetUtils.decodeColor("#4B214B")), "ProgressBar.topBorder2", NetUtils.getColor(NetUtils.decodeColor("#793777"), 41), "Table.selectedEditorOutline", new Color[]{Color.decode("#C88600"), Color.decode("#e29700")}, "Slider.filledColor", new ColorUIResource(255, 130, 0), "Table.evenHoverBackground", new ColorUIResource(NetUtils.decodeColor("#FEEABC")), "Table.oddHoverBackground", new ColorUIResource(NetUtils.decodeColor("#F3DEB0")), "RootPane.topEmphasis", new Color[]{NSNColors.getYellow(), NSNColors.getOrange(), NSNColors.getPurple()}, "ProgressBar.nsnGradient", new Color[]{NetUtils.decodeColor("#8F428D"), NetUtils.decodeColor("#5C225C")}, "Button.nsnDefaultButtonRolloverGradient", new Color[]{NetUtils.decodeColor("#737373"), NetUtils.decodeColor("#2A2A2A")}, "TabbedPane.selectedTabEmphasis2", NetUtils.getColor(NetTheme.getSelectionColor(), 170), "Editor.hoverShadow", new Color[]{NetUtils.getColor(NetTheme.getHoverColor(), 16), NetUtils.getColor(NetTheme.getHoverColor(), 30), NetUtils.getColor(NetTheme.getHoverColor(), 68)}, "Hyperlink.lightForeground", NetLookAndFeel.getWhite()};
        table.putDefaults(defaults);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("menu", new ColorUIResource(NetUtils.decodeColor("#EDEDED")));
        table.put("menuText", NetLookAndFeel.getCurrentTheme().getControlInfo());
        table.put("userBackground", NetTheme.COLOR_GRAY_15);
        table.put("userForeground", NetLookAndFeel.getWhite());
        table.put("staticLabel", NetLookAndFeel.getControlInfo());
        table.put("activeCaptionText", new ColorUIResource(Color.decode("#1B1B1B")));
        table.put("activeWindowBorder", NetTheme.COLOR_BLUE_7);
        table.put("selection", NetTheme.getHoverColor());
        table.put("largeColouredArea", NetTheme.COLOR_BLUE_12);
        table.put("border3d", NetTheme.COLOR_GRAY_3);
        table.put("secondaryShadow", NetTheme.getDisabledComponentOutlineColor());
        table.put("userWorkingArea", NetLookAndFeel.getWhite());
        table.put("linkUnvisited", NetTheme.COLOR_BLUE_26);
        table.put("linkVisited", NetTheme.getComponentOutlineColor());
        table.put("fieldMandatory", NetTheme.COLOR_YELLOW_22);
        table.put("fieldError", NetTheme.COLOR_RED_19);
        table.put("textHighlight", NetTheme.getSelectionColor());
        table.put("textHighlightText", SystemUtils.isOrangeTouch() ? NetLookAndFeel.getBlack() : NetLookAndFeel.getWhite());
        table.put("textText", NetLookAndFeel.getCurrentTheme().getControlInfo());
        table.put("inactiveCaptionText", new ColorUIResource(NetUtils.decodeColor("#9A9A9A")));
    }

    protected void installNLAFHelpIcons() {
        Object[] table = new Object[]{"BackAction.icon", new PArrowIcon(16, 6, (Color)NetLookAndFeel.getFocusColor(), 7), "ForwardAction.icon", new PArrowIcon(16, 6, (Color)NetLookAndFeel.getFocusColor(), 3), "PrintAction.icon", CommonIcons.getPrintIcon(), "HomeAction.icon", NetIconFactory.getButtonIcon("home_enabled20.gif", "help_home_rollover20.gif", "home_disabled20.gif"), "PrintSetupAction.icon", NetUtils.loadIcon("t_print_setup_20_normal.png"), "TOCNav.icon", NetLookAndFeel.makeIcon(this.getClass(), "icons/table_of_contents_normal20.gif"), "IndexNav.icon", NetLookAndFeel.makeIcon(this.getClass(), "icons/index_normal20.gif"), "SearchNav.icon", CommonIcons.getSearchIcon()};
        UIDefaults defaults = UIManager.getDefaults();
        if (defaults != null) {
            defaults.putDefaults(table);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        if (thePropertyChangeListener == null) {
            thePropertyChangeListener = new HelpIconUpdater();
        }
        return thePropertyChangeListener;
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        if (thePropertyChangeSupport != null) {
            thePropertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        if (thePropertyChangeSupport != null) {
            thePropertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public static Color[] getGrayShadow(int startAlpha, int step, int size) {
        Color[] result = new Color[size];
        int idx = 0;
        while (idx < result.length) {
            result[idx] = new Color(0, 0, 0, startAlpha + idx * step);
            ++idx;
        }
        return result;
    }

    @Override
    public Icon getDisabledSelectedIcon(JComponent component, Icon icon) {
        return this.getDisabledIcon(component, icon);
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon.getIconHeight() <= 0 || icon.getIconWidth() <= 0) {
            return icon;
        }
        Image image = null;
        image = icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : ImageUtils.createImage(component, icon);
        int min = 180;
        int max = 245;
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), new DisabledButtonImageFilter(min, max));
        return new IconUIResource(new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod)));
    }

    @Override
    public void provideErrorFeedback(Component component) {
        if (component instanceof PTextComponent) {
            ((PTextComponent)((Object)component)).flashField();
            Toolkit.getDefaultToolkit().beep();
        } else if (component instanceof JSpinner) {
            JSpinner.DefaultEditor editor;
            JSpinner spinner = (JSpinner)component;
            if (spinner.getEditor() instanceof JSpinner.DefaultEditor && (editor = (JSpinner.DefaultEditor)spinner.getEditor()).getTextField() instanceof PTextComponent) {
                ((PTextComponent)((Object)editor.getTextField())).flashField();
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            super.provideErrorFeedback(component);
        }
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent e) {
        if (e.isConsumed() || !(e.getSource() instanceof JTable)) {
            return false;
        }
        JTable table = (JTable)e.getSource();
        if (table.isVisible() && table.isEditing() && table.isFocusOwner() && !Boolean.FALSE.equals(table.getClientProperty("JTable.autoStartsEdit"))) {
            JComponent comp = (JComponent)table.getEditorComponent();
            if (comp instanceof JComboBox) {
                Component editorComponent;
                JComboBox combo = (JComboBox)comp;
                if (combo.isEditable() && (editorComponent = combo.getEditor().getEditorComponent()) != null) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(editorComponent, e);
                }
            } else if (comp instanceof JSpinner) {
                JSpinner spinner = (JSpinner)comp;
                JComponent editor = spinner.getEditor();
                if (editor instanceof JSpinner.DefaultEditor) {
                    JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(defaultEditor.getTextField(), e);
                } else if (editor instanceof JTextField) {
                    JTextField defaultEditor = (JTextField)editor;
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(defaultEditor, e);
                }
            }
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("lookAndFeel".equals(evt.getPropertyName()) && evt.getNewValue() == this) {
            try {
                String property = System.getProperty("bluetouch.fontSizeIncrement");
                if (property != null) {
                    NetLookAndFeel.setFontSizeIncrement(Integer.valueOf(property));
                }
            }
            catch (Exception exception) {}
        } else if ("awt.font.desktophints".equals(evt.getPropertyName())) {
            NetLookAndFeel.setDesktopHints();
        }
    }

    private static void setDesktopHints() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Object desktopHints = toolkit.getDesktopProperty("awt.font.desktophints");
        if (desktopHints instanceof Map && SystemUtils.isAfterJava15()) {
            theRenderingHints.clear();
            theRenderingHints.putAll((Map<?, ?>)((Map)desktopHints));
        }
    }

    private static void firePropertyChange(int current) {
        if (thePropertyChangeSupport != null) {
            thePropertyChangeSupport.firePropertyChange(FONT_SIZE_INCREMENT_PROPERTY, current, theFontSizeIncrement);
        }
    }

    private void initOrangeTouchIcons() {
        try {
            InputStream iconStream = WidgetResources.class.getResourceAsStream("/com/nokia/widgets/OrangeTouchWidgetIconBundle.properties");
            Properties icons = new Properties();
            icons.load(iconStream);
            iconStream.close();
            WidgetResources.setAdditionalIconBundle(icons);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class DisabledButtonImageFilter
    extends RGBImageFilter {
        private float myMin;
        private float myFactor;

        DisabledButtonImageFilter(int min, int max) {
            this.canFilterIndexColorModel = true;
            this.myMin = min;
            this.myFactor = (float)(max - min) / 255.0f;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = Math.min(255, (int)((0.2125f * (float)(rgb >> 16 & 0xFF) + 0.7154f * (float)(rgb >> 8 & 0xFF) + 0.0721f * (float)(rgb & 0xFF) + 0.5f) * this.myFactor + this.myMin));
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }

    protected class HelpIconUpdater
    implements PropertyChangeListener {
        protected HelpIconUpdater() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (UIManager.get("HomeAction.icon") instanceof UIResource) {
                return;
            }
            NetLookAndFeel.this.installNLAFHelpIcons();
        }
    }

    private static class LAFFocusPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean myInGetDefaultComponent = false;

        private LAFFocusPolicy() {
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            this.myInGetDefaultComponent = true;
            Component result = super.getDefaultComponent(aContainer);
            this.myInGetDefaultComponent = false;
            return result;
        }

        @Override
        protected boolean accept(Component component) {
            if (component instanceof JComponent) {
                JComponent comp = (JComponent)component;
                if (Boolean.FALSE.equals(comp.getClientProperty("OrangeTouch.isKeyboardFocusTraversable")) || ComponentUtils.isReadOnly(comp)) {
                    return false;
                }
                if (this.myInGetDefaultComponent && Boolean.TRUE.equals(comp.getClientProperty("toolButton"))) {
                    return false;
                }
            }
            return super.accept(component);
        }
    }
}

