/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.PMenuBar;
import com.nokia.widgets.ProductBannerDescription;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class NetMenuBarUI
extends BasicMenuBarUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent comp) {
        return new NetMenuBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        ProductBannerDescription desc = (ProductBannerDescription)this.menuBar.getClientProperty("OceanTouch.productBannerDescription");
        if (desc != null) {
            this.configureMenuBar(desc);
        }
    }

    @Override
    protected void installListeners() {
        this.menuBar.addPropertyChangeListener("OceanTouch.productBannerDescription", this);
    }

    @Override
    protected void uninstallListeners() {
        this.menuBar.removePropertyChangeListener("OceanTouch.productBannerDescription", this);
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        super.paint(g, comp);
        ProductBannerDescription description = (ProductBannerDescription)comp.getClientProperty("OceanTouch.productBannerDescription");
        if (description != null) {
            PMenuBar.paintBannerElements(g, comp, description.getToolBar(), description.getLogoLabel(), description.getApplicationName());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ProductBannerDescription description = (ProductBannerDescription)evt.getNewValue();
        if ("OceanTouch.productBannerDescription".equals(evt.getPropertyName()) && description != null) {
            this.configureMenuBar(description);
        }
    }

    protected void configureMenuBar(ProductBannerDescription description) {
        description.getToolBar().setOpaque(false);
        this.menuBar.setBackground(NetLookAndFeel.getWhite());
        description.getLogoLabel().setIcon(WidgetResources.getImageIcon("CompanyLogoProductBanner_Icon"));
        this.menuBar.setLayout(new PMenuBar.ProductBannerLayout());
    }
}

