/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.icons.ScaledIcon;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.text.View;

public class NetMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener {
    private String myAcceleratorDelimiter;
    private static final String MAX_ACC_WIDTH = "maxAccWidth";
    private static Rectangle theZeroRect = new Rectangle(0, 0, 0, 0);
    private static Rectangle theIconRect = new Rectangle();
    private static Rectangle theTextRect = new Rectangle();
    private static Rectangle theAcceleratorRect = new Rectangle();
    private static Rectangle theCheckIconRect = new Rectangle();
    private static Rectangle theViewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    protected MouseListener myReadOnlyMouseListener = null;

    protected NetMenuItemUI() {
    }

    public static ComponentUI createUI(JComponent menuItem) {
        return new NetMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultTextIconGap = 5;
        NetUtils.setCursor(this.menuItem);
        this.setScaledIcon();
        this.myAcceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.myAcceleratorDelimiter == null) {
            this.myAcceleratorDelimiter = "+";
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (ComponentUtils.isReadOnly(this.menuItem)) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
            if (this.myReadOnlyMouseListener == null) {
                this.myReadOnlyMouseListener = new ReadOnlyMouseHandler();
            }
            this.menuItem.addMouseListener(this.myReadOnlyMouseListener);
        }
        this.menuItem.addPropertyChangeListener(this);
        ReadOnlyHandler.getInstance().installTo(this.menuItem);
        NetUtils.setCursor(this.menuItem);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
        if (this.myReadOnlyMouseListener != null) {
            this.menuItem.removeMouseListener(this.myReadOnlyMouseListener);
        }
        ReadOnlyHandler.getInstance().uninstallFrom(this.menuItem);
    }

    private void resetRects() {
        theIconRect.setBounds(theZeroRect);
        theTextRect.setBounds(theZeroRect);
        theAcceleratorRect.setBounds(theZeroRect);
        theCheckIconRect.setBounds(theZeroRect);
        theViewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        this.paintMenuItem(g, comp, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon menuCheckIcon, Icon menuArrowIcon, int defaultMenuTextIconGap) {
        Dimension dim = super.getPreferredMenuItemSize(c, menuCheckIcon, menuArrowIcon, defaultMenuTextIconGap);
        --dim.height;
        if (!SystemUtils.isAfterJava15() && menuCheckIcon != null) {
            int checkIconHeight = menuCheckIcon.getIconHeight();
            Insets insets = this.menuItem.getInsets();
            if (insets != null) {
                checkIconHeight += insets.top + insets.bottom;
            }
            dim.height = Math.max(dim.height, checkIconHeight);
        }
        if (NetLookAndFeel.getFontSizeIncrement() > 0 && NetLookAndFeel.getFontSizeIncrement() < 6) {
            dim.height += NetLookAndFeel.getFontSizeIncrement();
        }
        return dim;
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent comp, Icon menuCheckIcon, Icon menuArrowIcon, Color background, Color foreground, int defaultMenuTextIconGap) {
        boolean selectedCheckIcon;
        JMenuItem item = (JMenuItem)comp;
        ButtonModel model = item.getModel();
        int menuWidth = item.getWidth();
        int menuHeight = item.getHeight();
        Insets insets = comp.getInsets();
        this.resetRects();
        theViewRect.setBounds(0, 0, menuWidth, menuHeight);
        NetMenuItemUI.theViewRect.x += insets.left;
        NetMenuItemUI.theViewRect.y += insets.top;
        NetMenuItemUI.theViewRect.width -= insets.right + NetMenuItemUI.theViewRect.x;
        NetMenuItemUI.theViewRect.height -= insets.bottom + NetMenuItemUI.theViewRect.y;
        FontMetrics fm = g.getFontMetrics(comp.getFont());
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        String acceleratorText = this.getAcceleratorText(item);
        String text = this.layoutMenuItem(fm, item.getText(), fmAccel, acceleratorText, item.getIcon(), menuCheckIcon, item.getVerticalAlignment(), item.getHorizontalAlignment(), item.getVerticalTextPosition(), item.getHorizontalTextPosition(), theViewRect, theIconRect, theTextRect, theAcceleratorRect, theCheckIconRect, defaultMenuTextIconGap);
        this.paintBackground(g, item, background);
        boolean bl = selectedCheckIcon = this.useNormalIconAsCheckIcon() && model.isSelected();
        if (selectedCheckIcon) {
            GradientUtils.drawVerticalGradient((JComponent)this.menuItem, g, "ToggleButton.pressedGradient", (Shape)NetUtils.getRoundedRect(comp, NetMenuItemUI.theIconRect.x - 2, NetMenuItemUI.theIconRect.y - 1, NetMenuItemUI.theIconRect.width + 4, NetMenuItemUI.theIconRect.height + 3, 7));
        }
        this.paintCheckIcon(g, menuCheckIcon, item);
        this.paintIcon(g, item);
        this.paintText(g, item, text);
        this.paintAccelerator(g, item, fmAccel, acceleratorText);
        if (this.menuItem.getModel().isArmed()) {
            int offset = selectedCheckIcon ? 3 : 1;
            NetUtils.paintHoverEffect(g, this.menuItem, offset, 1, this.menuItem.getWidth() - 3 - offset, this.menuItem.getHeight() - 3, theTextRect);
        }
        if (selectedCheckIcon) {
            Color oldColor = g.getColor();
            g.setColor(UIManager.getColor("Button.pressedHighlight1"));
            g.drawLine(NetMenuItemUI.theIconRect.x + 1, NetMenuItemUI.theIconRect.y - 1, NetMenuItemUI.theIconRect.x + NetMenuItemUI.theIconRect.width - 2, NetMenuItemUI.theIconRect.y - 1);
            g.setColor(UIManager.getColor("Button.pressedHighlight2"));
            g.drawLine(NetMenuItemUI.theIconRect.x, NetMenuItemUI.theIconRect.y, NetMenuItemUI.theIconRect.x + NetMenuItemUI.theIconRect.width, NetMenuItemUI.theIconRect.y);
            g.setColor(oldColor);
            Color color = UIManager.getColor("MenuItem.selectedOutline");
            NetUtils.drawRoundedRect(g, color, NetMenuItemUI.theIconRect.x - 2, NetMenuItemUI.theIconRect.y - 2, NetMenuItemUI.theIconRect.width + 3, NetMenuItemUI.theIconRect.height + 3, 7);
        }
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon menuCheckIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, int menuItemGap) {
        String tempAcceleratorText = acceleratorText;
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, 0);
        if (tempAcceleratorText == null || "".equals(tempAcceleratorText)) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            tempAcceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, tempAcceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (icon == null && menuCheckIcon != null) {
            checkIconRect.width = menuCheckIcon.getIconWidth();
            checkIconRect.height = menuCheckIcon.getIconHeight();
        } else if (menuCheckIcon != null) {
            checkIconRect.width = 0;
            checkIconRect.height = menuCheckIcon.getIconHeight();
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (ComponentUtils.isLeftToRight(this.menuItem)) {
            acceleratorRect.x = viewRect.x + viewRect.width - menuItemGap - acceleratorRect.width - 2;
            checkIconRect.x = viewRect.x;
            textRect.x += menuItemGap;
            if (!this.useNormalIconAsCheckIcon()) {
                textRect.x += checkIconRect.width;
            }
            if (checkIconRect.width > 0) {
                iconRect.x += menuItemGap + checkIconRect.width;
            }
            if (horizontalTextPosition == 2 || horizontalTextPosition == 10) {
                iconRect.x += 2 * menuItemGap;
                if (menuCheckIcon != null) {
                    iconRect.x += menuCheckIcon.getIconWidth();
                    textRect.x += menuCheckIcon.getIconWidth();
                }
            }
        } else {
            textRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + menuItemGap;
            checkIconRect.x = viewRect.x + viewRect.width - checkIconRect.width;
            textRect.x -= menuItemGap;
            if (!this.useNormalIconAsCheckIcon()) {
                textRect.x -= checkIconRect.width;
            }
            if (checkIconRect.width > 0) {
                iconRect.x -= menuItemGap + checkIconRect.width;
            }
        }
        acceleratorRect.y = labelRect.y + (labelRect.height - acceleratorRect.height) / 2;
        checkIconRect.y = labelRect.y + (labelRect.height - checkIconRect.height) / 2;
        if (this.useNormalIconAsCheckIcon()) {
            checkIconRect.y = labelRect.y + (labelRect.height - iconRect.height) / 2;
        }
        return text;
    }

    protected boolean useNormalIconAsCheckIcon() {
        return !(this.menuItem.getIcon() == null && this.menuItem.getSelectedIcon() == null || !(this.menuItem instanceof JRadioButtonMenuItem) && !(this.menuItem instanceof JCheckBoxMenuItem));
    }

    private String getAcceleratorText(JMenuItem item) {
        KeyStroke accelerator = item.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + this.myAcceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        return acceleratorText;
    }

    private void paintCheckIcon(Graphics g, Icon menuCheckIcon, JMenuItem item) {
        if (menuCheckIcon != null) {
            if (this.useNormalIconAsCheckIcon()) {
                Icon rolloverIcon;
                ButtonModel model;
                Icon tmpIcon = null;
                if (this.menuItem.isSelected()) {
                    tmpIcon = this.menuItem.isEnabled() ? item.getSelectedIcon() : item.getDisabledSelectedIcon();
                } else if (!this.menuItem.isEnabled()) {
                    tmpIcon = item.getDisabledIcon();
                }
                if (tmpIcon == null) {
                    tmpIcon = item.getIcon();
                }
                if ((model = this.menuItem.getModel()).isArmed() && (rolloverIcon = item.getRolloverIcon()) != null) {
                    tmpIcon = rolloverIcon;
                }
                if (tmpIcon != null) {
                    tmpIcon.paintIcon(item, g, NetMenuItemUI.theCheckIconRect.x, NetMenuItemUI.theCheckIconRect.y);
                }
            } else {
                menuCheckIcon.paintIcon(item, g, NetMenuItemUI.theCheckIconRect.x, NetMenuItemUI.theCheckIconRect.y);
            }
        }
    }

    protected void paintText(Graphics g, JMenuItem item, String text) {
        if (text != null) {
            View v = (View)item.getClientProperty("html");
            if (v != null) {
                v.paint(g, theTextRect);
            } else {
                this.paintText(g, item, theTextRect, text);
            }
        }
    }

    protected void paintIcon(Graphics g, JMenuItem item) {
        ButtonModel model = item.getModel();
        if (item.getIcon() != null && !this.useNormalIconAsCheckIcon()) {
            Icon rolloverIcon;
            Icon icon;
            if (!model.isEnabled()) {
                icon = item.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = item.getPressedIcon();
                if (icon == null) {
                    icon = item.getIcon();
                }
            } else {
                icon = item.getIcon();
            }
            if (model.isArmed() && (rolloverIcon = item.getRolloverIcon()) != null) {
                icon = rolloverIcon;
            }
            if (icon != null) {
                icon.paintIcon(item, g, NetMenuItemUI.theIconRect.x, NetMenuItemUI.theIconRect.y);
            }
        }
    }

    protected void paintAccelerator(Graphics g, JMenuItem item, FontMetrics fmAccel, String acceleratorText) {
        if (acceleratorText != null && !"".equals(acceleratorText)) {
            Object oldAa = NetUtils.antiAliasingOff(g);
            NetLookAndFeel.toggleTextAntialiasing(g);
            ButtonModel model = item.getModel();
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : NetMenuItemUI.theAcceleratorRect.width;
                accOffset = maxValue - NetMenuItemUI.theAcceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, NetMenuItemUI.theAcceleratorRect.x - accOffset, NetMenuItemUI.theAcceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(item.getBackground().brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, NetMenuItemUI.theAcceleratorRect.x - accOffset, NetMenuItemUI.theAcceleratorRect.y + fmAccel.getAscent());
                    g.setColor(item.getBackground().darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, NetMenuItemUI.theAcceleratorRect.x - accOffset - 1, NetMenuItemUI.theAcceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, NetMenuItemUI.theAcceleratorRect.x - accOffset, NetMenuItemUI.theAcceleratorRect.y + fmAccel.getAscent());
            }
            NetUtils.setAntialiasing(g, oldAa);
        }
    }

    @Override
    protected void paintText(Graphics g, JMenuItem jMenuItem, Rectangle textRect, String text) {
        ButtonModel model = jMenuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = jMenuItem.isEnabled() ? jMenuItem.getDisplayedMnemonicIndex() : -1;
        g.setColor(jMenuItem.getForeground());
        if (!model.isEnabled() || ComponentUtils.isReadOnly(jMenuItem)) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g.setColor(jMenuItem.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(jMenuItem.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        } else {
            ColorUIResource offsetColor = NetTheme.getTextShadowColor();
            if (model.isArmed()) {
                g.setColor(this.selectionForeground);
                offsetColor = null;
            }
            NetUtils.paintText(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent(), g.getColor(), offsetColor, 1);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("icon".equals(evt.getPropertyName())) {
            this.menuItem.removePropertyChangeListener(this);
            this.setScaledIcon();
            this.menuItem.addPropertyChangeListener(this);
        } else if ("enabled".equals(evt.getPropertyName())) {
            NetUtils.setCursor(this.menuItem);
        }
    }

    private void setScaledIcon() {
        Icon icon = this.menuItem.getIcon();
        if (icon != null) {
            if (icon.getIconWidth() > 16) {
                this.menuItem.setIcon(ScaledIcon.create(icon));
            } else if (icon.getIconWidth() < 16) {
                BufferedImage image = ImageUtils.createEmptyImage(16, 16);
                int x = (16 - icon.getIconWidth()) / 2;
                int y = (16 - icon.getIconHeight()) / 2;
                icon.paintIcon(this.menuItem, image.getGraphics(), x, y);
                this.menuItem.setIcon(new ImageIcon(image));
            }
        }
    }

    private class ReadOnlyMouseHandler
    extends MouseAdapter {
        private ReadOnlyMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ComponentUtils.isReadOnly(NetMenuItemUI.this.menuItem)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }
}

