/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PMenuBar;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuUI;

public class NetMenuUI
extends BasicMenuUI
implements PropertyChangeListener {
    protected static final int STRIPE_WIDTH = 22;
    protected static int theMenuOffset = 2;

    static {
        if (SystemUtils.isAfterJava15()) {
            theMenuOffset += 30;
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        return new NetMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        NetUtils.setCursor(this.menuItem);
        this.menuItem.setRolloverEnabled(true);
        if (this.isInPMenuBar(this.menuItem)) {
            this.menuItem.setOpaque(false);
        }
        if (this.menuItem.getIcon() != null && !(this.menuItem.getIcon() instanceof AlignedIcon)) {
            this.menuItem.setIcon(new AlignedIcon(this.menuItem.getIcon()));
        }
        if (this.menuItem.getIcon() != null && !(this.menuItem.getDisabledIcon() instanceof AlignedIcon)) {
            this.menuItem.setDisabledIcon(new AlignedIcon(this.menuItem.getDisabledIcon()));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        super.paint(g, comp);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon menuCheckIcon, Icon menuArrowIcon, int defaultMenuTextIconGap) {
        JMenu menu;
        Dimension dim = super.getPreferredMenuItemSize(c, menuCheckIcon, menuArrowIcon, defaultMenuTextIconGap);
        if (!SystemUtils.isAfterJava15() && !(menu = (JMenu)this.menuItem).isTopLevelMenu() && menuCheckIcon != null) {
            int checkIconHeight = menuCheckIcon.getIconHeight();
            Insets insets = menu.getInsets();
            if (insets != null) {
                checkIconHeight += insets.top + insets.bottom;
            }
            dim.height = Math.max(dim.height, checkIconHeight);
        }
        int fontSizeIncrement = NetLookAndFeel.getFontSizeIncrement();
        if (this.useCheckAndArrow() && fontSizeIncrement > 0 && fontSizeIncrement < 6) {
            dim.height += fontSizeIncrement;
        }
        return dim;
    }

    private boolean useCheckAndArrow() {
        return !(this.menuItem instanceof JMenu) || !((JMenu)this.menuItem).isTopLevelMenu();
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem jMenuItem, Color bgColor) {
        boolean selected;
        ButtonModel model = jMenuItem.getModel();
        int rounding = NetTheme.getComponentOutlineRounding(jMenuItem);
        boolean bl = selected = model.isArmed() || jMenuItem instanceof JMenu && model.isSelected();
        if (((JMenu)jMenuItem).isTopLevelMenu()) {
            Object oldAa = NetUtils.antiAliasingOn(g);
            Color oldColor = g.getColor();
            Container parent = jMenuItem.getParent();
            if (jMenuItem.isOpaque()) {
                g.setColor(parent.getBackground());
                g.fillRect(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
            }
            if (selected) {
                g.setColor(jMenuItem.getBackground());
                Shape fillShape = NetUtils.getRoundedRect(jMenuItem, 4, 1, jMenuItem.getWidth() - rounding, jMenuItem.getHeight(), rounding, 5);
                ((Graphics2D)g).fill(fillShape);
            }
            g.setColor(oldColor);
            NetUtils.setAntialiasing(g, oldAa);
            return;
        }
        super.paintBackground(g, jMenuItem, bgColor);
    }

    private boolean isInPMenuBar(Component comp) {
        return comp.getParent() instanceof PMenuBar || comp.getParent() instanceof JComponent && ((JComponent)comp.getParent()).getClientProperty("OceanTouch.productBannerDescription") != null;
    }

    @Override
    protected void paintText(Graphics g, JMenuItem jMenuItem, Rectangle textRect, String text) {
        int mnemIndex;
        if (ComponentUtils.isLeftToRight(jMenuItem)) {
            if (!((JMenu)jMenuItem).isTopLevelMenu()) {
                textRect.x = 27;
            }
        } else if (!((JMenu)jMenuItem).isTopLevelMenu()) {
            textRect.x += theMenuOffset;
        }
        ButtonModel model = jMenuItem.getModel();
        FontMetrics fm = g.getFontMetrics(jMenuItem.getFont());
        int n = mnemIndex = jMenuItem.isEnabled() ? jMenuItem.getDisplayedMnemonicIndex() : -1;
        if (!model.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g.setColor(jMenuItem.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(jMenuItem.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        } else {
            if (model.isRollover() || !((JMenu)jMenuItem).isTopLevelMenu() && (model.isArmed() || model.isSelected())) {
                g.setColor(this.selectionForeground);
            } else {
                Color oldColor = g.getColor();
                g.setColor(NetTheme.getTextShadowColor());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() + 1);
                g.setColor(oldColor);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
        if (!((JMenu)jMenuItem).isTopLevelMenu() && jMenuItem.isSelected()) {
            NetUtils.paintHoverEffect(g, jMenuItem, 1, 1, jMenuItem.getWidth() - 3, jMenuItem.getHeight() - 3, textRect);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("icon".equals(evt.getPropertyName())) {
            this.menuItem.removePropertyChangeListener(this);
            if (this.menuItem.getIcon() != null && !(this.menuItem.getIcon() instanceof AlignedIcon)) {
                this.menuItem.setIcon(new AlignedIcon(this.menuItem.getIcon()));
            }
            this.menuItem.addPropertyChangeListener(this);
        } else if ("disabledIcon".equals(evt.getPropertyName())) {
            this.menuItem.removePropertyChangeListener(this);
            if (this.menuItem.getIcon() != null && !(this.menuItem.getDisabledIcon() instanceof AlignedIcon)) {
                this.menuItem.setDisabledIcon(new AlignedIcon(this.menuItem.getDisabledIcon()));
            }
            this.menuItem.addPropertyChangeListener(this);
        } else if ("ancestor".equals(evt.getPropertyName()) && this.isInPMenuBar(this.menuItem)) {
            this.menuItem.setOpaque(false);
        }
    }

    public static class AlignedIcon
    implements Icon,
    UIResource {
        Icon myIcon;

        public AlignedIcon(Icon icon) {
            this.myIcon = icon;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Insets insets = ((JComponent)c).getInsets();
            if (ComponentUtils.isLeftToRight(c)) {
                this.myIcon.paintIcon(c, g, insets.left, y);
            } else {
                this.myIcon.paintIcon(c, g, c.getWidth() - insets.right - this.getIconWidth(), y);
            }
        }
    }
}

