/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetTextFieldUI;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.infotip.InfoButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.plaf.ComponentUI;

public class NetMultiLanguageTextFieldUI
extends NetTextFieldUI {
    private static final ImageIcon lANGUAGE_ICON = CommonIcons.getMultiLanguageIcon();
    public static final int LANGUAGE_ICON_WIDTH = 22;
    public static final int LANGUAGE_ICON_HEIGHT = 22;
    public static final int LANGUAGE_ICON_WIDTH_SPACE = 12;
    public static final int LANGUAGE_ICON_WIDTH_OFFSET = -34;
    private MultiLanguageLayoutManager myMultiLanguageLayoutManager = new MultiLanguageLayoutManager();
    private InfoButton myLanguageInfoButton;
    private final LayoutFocusTraversalPolicy myFocusPolicy = new LayoutFocusTraversalPolicy(){

        @Override
        protected boolean accept(Component aComponent) {
            if (aComponent.isFocusOwner()) {
                return false;
            }
            return super.accept(aComponent);
        }
    };

    public static ComponentUI createUI(JComponent b) {
        return new NetMultiLanguageTextFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("Multi-language", true);
        this.installLanguageButton();
        this.getComponent().setLayout(this.myMultiLanguageLayoutManager);
        this.addFocusTraversalPolicy();
    }

    private void installLanguageButton() {
        this.myLanguageInfoButton = new InfoButton();
        this.myLanguageInfoButton.setIcon(lANGUAGE_ICON);
        this.myLanguageInfoButton.setPreferredSize(new Dimension(22, 22));
        this.myLanguageInfoButton.setFocusable(true);
        this.myLanguageInfoButton.setName("LanguageIcon");
        this.myLanguageInfoButton.getInfoTip().setTipContent("Local language supported");
        this.getComponent().add(this.myLanguageInfoButton);
    }

    public InfoButton getLanguageButton() {
        return this.myLanguageInfoButton;
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle alloc = super.getVisibleEditorRect();
        if (alloc != null) {
            alloc.width += -34;
            return alloc;
        }
        return null;
    }

    private void addFocusTraversalPolicy() {
        this.getComponent().setFocusTraversalPolicy(this.myFocusPolicy);
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this.myFocusPolicy;
    }

    class MultiLanguageLayoutManager
    implements LayoutManager {
        MultiLanguageLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension languageIconSize = NetMultiLanguageTextFieldUI.this.myLanguageInfoButton.getPreferredSize();
            Rectangle rectangle = NetMultiLanguageTextFieldUI.this.getComponent().getBounds();
            NetMultiLanguageTextFieldUI.this.myLanguageInfoButton.setBounds((int)(rectangle.getWidth() - languageIconSize.getWidth()), 0, (int)languageIconSize.getWidth(), (int)languageIconSize.getHeight());
        }
    }
}

