/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.widgets.layout.RowAlignLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class NetOptionPaneUI
extends BasicOptionPaneUI {
    private Color myButtonAreaBackground;
    private Color myMessageAreaBackground;
    protected static final Dimension ZERO_DIMENSION = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent component) {
        return new NetOptionPaneUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.myMessageAreaBackground = UIManager.getColor("OptionPane.background");
        this.myButtonAreaBackground = UIManager.getColor("OptionPane.buttonAreaBackground");
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.myMessageAreaBackground = null;
        this.myButtonAreaBackground = null;
    }

    @Override
    protected Container createMessageArea() {
        Object[] msgObjects;
        JPanel top = new JPanel();
        top.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        top.setLayout(new BorderLayout());
        JPanel body = new JPanel();
        JPanel realBody = new JPanel();
        realBody.setLayout(new BorderLayout());
        realBody.add((Component)body, "Center");
        body.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 21;
        cons.insets = new Insets(0, 4, 0, 0);
        Object[] message = this.getMessage();
        if (message instanceof Object[] && (msgObjects = (Object[])message).length > 1 && msgObjects[0] instanceof String) {
            Object[] newObjects = new Object[msgObjects.length - 1];
            System.arraycopy(msgObjects, 1, newObjects, 0, newObjects.length);
            message = newObjects;
        }
        this.addMessageComponents(body, cons, message, this.getMaxCharactersPerLineCount(), false);
        top.add((Component)realBody, "Center");
        top.setBackground(this.myMessageAreaBackground);
        top.setBorder(BorderFactory.createEmptyBorder(18, 14, 24, 20));
        return top;
    }

    @Override
    protected Container createButtonArea() {
        Object[] buttons = this.getButtons();
        JPanel bottom = new JPanel();
        bottom.setBorder(UIManager.getBorder("OptionPane.buttonAreaBorder"));
        if (buttons == null || buttons.length == 0) {
            bottom.setPreferredSize(new Dimension(0, 0));
        } else {
            RowAlignLayout layout = new RowAlignLayout(new Dimension(24, 24), null, true);
            layout.setAlgnment(0);
            bottom.setLayout(layout);
            this.addButtonComponents(bottom, buttons, this.getInitialValueIndex());
            bottom.setBackground(this.myButtonAreaBackground);
        }
        return bottom;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] buttonObjects, int initialIndex) {
        int counter = 0;
        while (counter < buttonObjects.length) {
            JComponent newComponent;
            Object button = buttonObjects[counter];
            if (button instanceof JComponent) {
                newComponent = (JComponent)button;
                this.hasCustomComponents = true;
            } else {
                JButton aButton;
                if (button instanceof ButtonFactory) {
                    aButton = ((ButtonFactory)button).createButton();
                } else if (button instanceof Icon) {
                    aButton = new JButton((Icon)button);
                } else if (button instanceof Action) {
                    Action action = (Action)button;
                    aButton = new JButton(action);
                    aButton.putClientProperty("OrangeTouch.functionButton", action.getValue("OrangeTouch.functionButton"));
                } else {
                    aButton = new JButton(button.toString());
                }
                aButton.setName(aButton.getText());
                aButton.setMultiClickThreshhold(UIManager.getInt("OptionPane.buttonClickThreshhold"));
                ActionListener buttonListener = this.createButtonActionListener(counter);
                if (buttonListener != null) {
                    aButton.addActionListener(buttonListener);
                }
                newComponent = aButton;
            }
            this.addButton(container, newComponent);
            if (counter == initialIndex) {
                this.initialFocusComponent = newComponent;
                if (this.initialFocusComponent instanceof JButton) {
                    JButton defaultB = (JButton)this.initialFocusComponent;
                    defaultB.addAncestorListener(new AncestorListener(){

                        @Override
                        public void ancestorAdded(AncestorEvent e) {
                            JButton defaultButton = (JButton)e.getComponent();
                            JRootPane root = SwingUtilities.getRootPane(defaultButton);
                            if (root != null) {
                                root.setDefaultButton(defaultButton);
                            }
                        }

                        @Override
                        public void ancestorRemoved(AncestorEvent event) {
                        }

                        @Override
                        public void ancestorMoved(AncestorEvent event) {
                        }
                    });
                }
            }
            ++counter;
        }
    }

    protected void addButton(Container parent, JComponent comp) {
        if (Boolean.TRUE.equals(comp.getClientProperty("help")) || Boolean.TRUE.equals(comp.getClientProperty("OrangeTouch.functionButton"))) {
            parent.add((Component)comp, "West");
        } else {
            parent.add((Component)comp, "East");
        }
    }

    @Override
    protected void addIcon(Container top) {
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            JLabel iconLabel = new JLabel(sideIcon);
            iconLabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 14));
            iconLabel.setVerticalAlignment(1);
            top.add((Component)iconLabel, "Before");
        }
    }

    @Override
    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                int type = this.optionPane.getOptionType();
                Locale l = this.optionPane.getLocale();
                Object[] defaultOptions = type == 0 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), UIManager.getIcon("OptionPane.yesIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), UIManager.getIcon("OptionPane.noIcon"))} : (type == 1 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), UIManager.getIcon("OptionPane.yesIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), UIManager.getIcon("OptionPane.noIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), UIManager.getIcon("OptionPane.cancelIcon"))} : (type == 2 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), UIManager.getIcon("OptionPane.okIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), UIManager.getIcon("OptionPane.cancelIcon"))} : new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), UIManager.getIcon("OptionPane.okIcon"))}));
                return defaultOptions;
            }
            return suppliedOptions;
        }
        return null;
    }

    private int getMnemonic(String key, Locale l) {
        String value = (String)UIManager.get(key, l);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static class ButtonFactory {
        private Icon icon;
        private String text;
        private int mnemonic;

        ButtonFactory(String text, int mnemonic, Icon icon) {
            this.text = text;
            this.mnemonic = mnemonic;
            this.icon = icon;
        }

        JButton createButton() {
            JButton button = new JButton(this.text);
            if (this.icon != null) {
                button.setIcon(this.icon);
            }
            if (this.mnemonic != 0) {
                button.setMnemonic(this.mnemonic);
            }
            return button;
        }
    }
}

