/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class NetPanelBorder
extends AbstractBorder {
    private Color myFullShadowColor;
    private Color myShadowColor;
    private static final int LINE_OFFSET = 18;

    @Override
    public Insets getBorderInsets(Component comp) {
        return this.handleInsets(comp, null);
    }

    @Override
    public Insets getBorderInsets(Component comp, Insets insets) {
        return this.handleInsets(comp, insets);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        if (this.myFullShadowColor == null) {
            this.myFullShadowColor = UIManager.getColor("Panel.borderFullShadow");
            this.myShadowColor = UIManager.getColor("Panel.borderShadow");
        }
        boolean visibleUpperEdge = false;
        boolean visibleLowerEdge = false;
        boolean visibleLeadingEdge = false;
        boolean visibleTrailingEdge = false;
        boolean curvedSheet = false;
        boolean paintSheetOutline = true;
        if (comp instanceof JPanel) {
            JPanel panel = (JPanel)comp;
            visibleUpperEdge = ClientPropertyUtil.booleanValue(panel, "visibleUpperEdge");
            visibleLowerEdge = ClientPropertyUtil.booleanValue(panel, "visibleLowerEdge");
            visibleLeadingEdge = ClientPropertyUtil.booleanValue(panel, "visibleLeadingEdge");
            visibleTrailingEdge = ClientPropertyUtil.booleanValue(panel, "visibleTrailingEdge");
            curvedSheet = ClientPropertyUtil.booleanValue(panel, "OrangeTouch.curvedSheet");
            paintSheetOutline = ClientPropertyUtil.booleanValue(panel, "OrangeTouch.paintSheetOutline", true);
        }
        Color oldColor = g.getColor();
        int xmax = width - 1;
        int ymax = height - 1;
        g.translate(x, y);
        boolean shadeLeft = false;
        boolean shadeRight = false;
        ComponentOrientation panelOrientation = comp.getComponentOrientation();
        if (visibleLeadingEdge) {
            if (panelOrientation.isLeftToRight()) {
                shadeLeft = true;
            } else {
                shadeRight = true;
            }
        }
        if (visibleTrailingEdge) {
            if (panelOrientation.isLeftToRight()) {
                shadeRight = true;
            } else {
                shadeLeft = true;
            }
        }
        if (visibleUpperEdge) {
            g.setColor(this.myFullShadowColor);
            g.drawLine(18, 0, xmax - 18, 0);
            g.setColor(this.myShadowColor);
            g.drawLine(18, 1, xmax - 18, 1);
        }
        if (visibleLowerEdge) {
            g.setColor(this.myShadowColor);
            g.drawLine(18, ymax, xmax - 18, ymax);
            g.setColor(this.myFullShadowColor);
            g.drawLine(18, ymax - 1, xmax - 18, ymax - 1);
        }
        if (shadeLeft) {
            g.setColor(this.myFullShadowColor);
            g.drawLine(0, 0, 0, ymax);
            g.setColor(this.myShadowColor);
            g.drawLine(1, visibleUpperEdge ? 1 : 0, 1, visibleLowerEdge ? ymax - 1 : ymax);
        }
        if (shadeRight) {
            g.setColor(this.myFullShadowColor);
            g.drawLine(xmax, 0, xmax, ymax);
            g.setColor(this.myShadowColor);
            g.drawLine(xmax - 1, visibleUpperEdge ? 1 : 0, xmax - 1, visibleUpperEdge ? ymax - 1 : ymax);
        }
        if (curvedSheet) {
            if (paintSheetOutline) {
                PBorderFactory.getBlueBorder().paintBorder(comp, g, x, y, width, height - 9);
            }
            NetUtils.drawCurvedDropShadow((Graphics2D)g, x + 4, height - 9, width - 9);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    private Insets handleInsets(Component comp, Insets insets) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        boolean visibleUpperEdge = false;
        boolean visibleLowerEdge = false;
        boolean visibleLeadingEdge = false;
        boolean visibleTrailingEdge = false;
        boolean curvedSheet = false;
        boolean paintSheetOutline = true;
        if (comp instanceof JPanel) {
            JPanel panel = (JPanel)comp;
            visibleUpperEdge = ClientPropertyUtil.booleanValue(panel, "visibleUpperEdge");
            visibleLowerEdge = ClientPropertyUtil.booleanValue(panel, "visibleLowerEdge");
            visibleLeadingEdge = ClientPropertyUtil.booleanValue(panel, "visibleLeadingEdge");
            visibleTrailingEdge = ClientPropertyUtil.booleanValue(panel, "visibleTrailingEdge");
            curvedSheet = ClientPropertyUtil.booleanValue(panel, "OrangeTouch.curvedSheet");
            paintSheetOutline = ClientPropertyUtil.booleanValue(panel, "OrangeTouch.paintSheetOutline", true);
        }
        if (visibleUpperEdge) {
            top = 2;
        }
        if (visibleLowerEdge) {
            bottom = 2;
        }
        ComponentOrientation panelOrientation = comp.getComponentOrientation();
        if (visibleLeadingEdge) {
            if (panelOrientation.isLeftToRight()) {
                left = 2;
            } else {
                right = 2;
            }
        }
        if (visibleTrailingEdge) {
            if (panelOrientation.isLeftToRight()) {
                right = 2;
            } else {
                left = 2;
            }
        }
        if (curvedSheet) {
            if (paintSheetOutline) {
                top = 3;
                left = 3;
                bottom = 3;
                bottom = 12;
            } else {
                bottom = 9;
            }
        }
        if (insets == null) {
            return new Insets(top, left, bottom, right);
        }
        insets.top = top;
        insets.bottom = bottom;
        insets.left = left;
        insets.right = right;
        return insets;
    }
}

