/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.borders.FloatingPaneBorder;
import com.nokia.laf.borders.HeaderBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.tree.TreeCellRenderer;

public class NetPanelUI
extends BasicPanelUI
implements PropertyChangeListener {
    private static NetPanelUI theNetPanelUI = new NetPanelUI();
    private Color myUserForeGround;
    private Color myUserBackground;
    private Color myButtonAreaBackground;

    protected NetPanelUI() {
    }

    public static ComponentUI createUI(JComponent component) {
        return theNetPanelUI;
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        component.addPropertyChangeListener(this);
        this.propertyChanged(component);
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        component.removePropertyChangeListener(this);
    }

    @Override
    public void installDefaults(JPanel panel) {
        super.installDefaults(panel);
        this.myUserForeGround = UIManager.getColor("Panel.userforeground");
        this.myUserBackground = UIManager.getColor("Panel.background");
        this.myButtonAreaBackground = UIManager.getColor("Panel.buttonAreaBackground");
        if (panel instanceof TreeCellRenderer) {
            panel.setOpaque(true);
        }
        if (panel.getBorder() instanceof HeaderBorder) {
            panel.setOpaque(false);
        }
    }

    @Override
    public void uninstallDefaults(JPanel panel) {
        super.uninstallDefaults(panel);
        this.myUserForeGround = null;
        this.myUserBackground = null;
        this.myButtonAreaBackground = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        if (eventName.equals("panelType") || eventName.equals("foregroundArea")) {
            this.propertyChanged((JComponent)event.getSource());
        }
        if ("border".equals(event.getPropertyName()) && event.getNewValue() != null) {
            JComponent comp = (JComponent)event.getSource();
            if (comp.getBorder() instanceof HeaderBorder) {
                comp.setOpaque(false);
            }
        } else if ("OrangeTouch.floatingPane".equals(event.getPropertyName())) {
            JComponent comp = (JComponent)event.getSource();
            comp.setBorder(new FloatingPaneBorder());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            int panelType = ClientPropertyUtil.integerValue(c, "panelType");
            if (ClientPropertyUtil.booleanValue(c, "OrangeTouch.floatingPane")) {
                GradientUtils.drawVerticalBackgroundGradient((Container)c, g, 1);
                RectangularShape fill = NetUtils.getOutline(c, 2, 1, c.getWidth() - 4, c.getHeight() - 4);
                GradientUtils.drawVerticalBackgroundGradient((Container)c, g, fill);
            } else if (c.getBackground() instanceof UIResource && !(c.getParent() instanceof CellRendererPane) && panelType != ClientProperties.PANEL_USER_FOREGROUND) {
                GradientUtils.drawVerticalBackgroundGradient(c, g);
            } else {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
        if (c.getBorder() instanceof HeaderBorder) {
            ((HeaderBorder)c.getBorder()).paintBackground(g, c);
        }
        NetUtils.paintTableCellBackground(g, c);
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        super.paint(g, comp);
    }

    private void propertyChanged(JComponent panel) {
        Integer panelType = ClientPropertyUtil.integerValue(panel, "panelType");
        Color color = panel.getBackground();
        if (color == null || color instanceof UIResource) {
            if (panelType.equals(ClientProperties.PANEL_BUTTONAREA_BACKGROUND)) {
                color = this.myButtonAreaBackground;
            } else if (panelType.equals(ClientProperties.PANEL_USER_BACKGROUND)) {
                color = this.myUserBackground;
            } else if (panelType.equals(ClientProperties.PANEL_USER_FOREGROUND)) {
                color = this.myUserForeGround;
            } else if (panelType.equals(ClientProperties.UNKNOWN_VALUE)) {
                Object value = panel.getClientProperty("foregroundArea");
                color = value != null && value instanceof Boolean ? ((Boolean)value != false ? this.myUserBackground : this.myButtonAreaBackground) : this.myUserBackground;
            }
            panel.setBackground(color);
        }
    }
}

