/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.RolloverHandler;
import com.nokia.laf.text.NetCaret;
import com.nokia.laf.text.NetTextComponentHandler;
import com.nokia.laf.text.ReadOnlyKeymap;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class NetPasswordFieldUI
extends BasicPasswordFieldUI {
    protected RolloverHandler myRolloverHandler;
    protected NetTextComponentHandler myHandler = null;

    public static ComponentUI createUI(JComponent c) {
        return new NetPasswordFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.getComponent().getClientProperty("TextField.validateOnFocusLost") == null) {
            this.getComponent().putClientProperty("TextField.validateOnFocusLost", UIManager.get("TextField.validateOnFocusLost"));
        }
        this.getComponent().setOpaque(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.myHandler = new NetTextComponentHandler(this.getPropertyPrefix(), this.getComponent());
        ReadOnlyHandler.getInstance().installTo(this.getComponent());
        this.myRolloverHandler = new RolloverHandler();
        this.myRolloverHandler.installTo(this.getComponent());
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        NetUtils.installReadOnlyFocusInputMap(this.getComponent());
    }

    @Override
    protected Keymap createKeymap() {
        Keymap keyMap = super.createKeymap();
        if (ComponentUtils.isReadOnly(this.getComponent())) {
            keyMap = new ReadOnlyKeymap(keyMap);
        }
        return keyMap;
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.myHandler.uninstallFrom(this.getComponent());
        this.myRolloverHandler.uninstallFrom(this.getComponent());
        ReadOnlyHandler.getInstance().uninstallFrom(this.getComponent());
    }

    @Override
    protected Caret createCaret() {
        return new NetCaret.UIResource();
    }

    @Override
    protected void paintSafely(Graphics g) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        this.paintBackground(g);
        super.paintSafely(g);
        JTextComponent component = this.getComponent();
        NetUtils.paintLabelOrPrompt(g, component);
    }

    @Override
    protected void paintBackground(Graphics g) {
        NetUtils.paintTextComponentBackground(g, this.getComponent());
    }
}

