/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class NetPopupMenuUI
extends BasicPopupMenuUI
implements PopupMenuListener {
    protected static final int STRIPE_WIDTH = 23;

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupMenu.addPopupMenuListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePopupMenuListener(this);
    }

    public static ComponentUI createUI(JComponent comp) {
        return new NetPopupMenuUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.popupMenu.setOpaque(false);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (ClientPropertyUtil.booleanValue(c, "OrangeTouch.isHeavyweight")) {
            BufferedImage screenCapture = (BufferedImage)c.getClientProperty("OrangeTouch.screenCapture");
            Rectangle windowBounds = SwingUtilities.getWindowAncestor(c).getBounds();
            if (screenCapture == null || (double)screenCapture.getWidth() != windowBounds.getWidth() || (double)screenCapture.getHeight() != windowBounds.getHeight()) {
                screenCapture = NetUtils.getRobot().createScreenCapture(windowBounds);
                c.putClientProperty("OrangeTouch.screenCapture", screenCapture);
            }
            g.drawImage(screenCapture, 0, 0, null);
        }
        g.setColor(c.getBackground());
        g.fillRect(4, 4, c.getWidth() - 8, c.getHeight() - 14);
        super.update(g, c);
    }

    @Override
    public Popup getPopup(JPopupMenu jPopupMenu, int x, int y) {
        int tempX = x;
        int tempY = y;
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        Component invoker = jPopupMenu.getInvoker();
        if (invoker instanceof JMenu && invoker.getParent() instanceof JPanel) {
            tempX += invoker.getWidth() - 12;
            tempY -= invoker.getHeight() + 2;
        }
        boolean isPulldown = Boolean.TRUE.equals(jPopupMenu.getClientProperty("OrangeTouch.isPulldown"));
        Point locationInInvokerCoords = new Point(tempX, tempY);
        if (invoker != null) {
            try {
                SwingUtilities.convertPointFromScreen(locationInInvokerCoords, invoker);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean isPopupAboveCombo = locationInInvokerCoords.y < 0 && isPulldown;
        jPopupMenu.putClientProperty("OrangeTouch.popupAboveCombo", isPopupAboveCombo);
        if (isPopupAboveCombo && invoker != null && invoker.isShowing()) {
            tempY = invoker.getLocationOnScreen().y - jPopupMenu.getPreferredSize().height + 1;
        }
        if (invoker instanceof JComponent && isPulldown) {
            JComponent jComp = (JComponent)invoker;
            jComp.putClientProperty("OrangeTouch.popupAboveCombo", isPopupAboveCombo);
            jComp.putClientProperty("OrangeTouch.isStraightBottomEdge", !isPopupAboveCombo);
            jComp.putClientProperty("OrangeTouch.isStraightTopEdge", isPopupAboveCombo);
            if (isPopupAboveCombo) {
                ++tempY;
            }
        }
        Popup popup = popupFactory.getPopup(invoker, jPopupMenu, tempX, tempY);
        Container popupComponent = jPopupMenu.getParent();
        if (popupComponent instanceof JComponent) {
            ((JComponent)popupComponent).setOpaque(false);
        }
        jPopupMenu.putClientProperty("OrangeTouch.isHeavyweight", false);
        jPopupMenu.putClientProperty("OrangeTouch.screenCapture", null);
        Window window = SwingUtilities.getWindowAncestor(jPopupMenu);
        if (window != null && window.getClass().getName().contains("Popup$HeavyWeightWindow")) {
            jPopupMenu.putClientProperty("OrangeTouch.isHeavyweight", true);
            if (ClientPropertyUtil.booleanValue(jPopupMenu, "OrangeTouch.isFocusablePopup")) {
                window.setFocusableWindowState(true);
            }
        }
        return popup;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetPopupMenuUI.this.popupMenu.repaint();
            }
        });
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

