/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.UIResource;

public class NetProgressBarUI
extends ProgressBarUI {
    private int myLength = 0;
    private static final Dimension PREFERRED_STANDRAD_INNER_HORIZONTAL = new Dimension(146, 15);
    private static final Dimension PREFERRED_STANDRAD_INNER_VERTICAL = new Dimension(15, 146);
    private static final Dimension PREFERRED_SMALL_INNER_HORIZONTAL = new Dimension(146, 10);
    private static final Dimension PREFERRED_SMALL_INNER_VERTICAL = new Dimension(10, 146);
    private int myCachedPercent;
    private int myCellLength;
    private int myCellSpacing;
    private Color mySelectionForeground;
    private Color mySelectionBackground;
    private boolean myIsIndeterminate = false;
    private Animator myAnimator;
    private PropertyChangeListener myPropertyListener;
    protected JProgressBar myProgressBar;
    protected ChangeListener myChangeListener;
    protected HierarchyChangeHandler myHierarchyListener;
    private int myAnimationIndex = 0;
    private int myNumFrames;
    private int myRepaintInterval;
    private int myCycleTime;
    private static boolean ADJUSTTIMER = true;
    private Rectangle myBoxRect;
    private Rectangle myNextPaintRect;
    private Rectangle myComponentInnards;
    private Rectangle myOldComponentInnards;
    private double myDelta = 0.0;
    private int myMaxPosition = 0;
    private boolean myIsCircularDeterminate = false;
    private String mySizeVariant = "normal";
    private static Icon myCircularIcon = UIManager.getIcon("ProgressBar.circularIcon");
    private static Icon myCircularSmallIcon = CommonIcons.getProgressOngoingIcon();

    public static ComponentUI createUI(JComponent c) {
        return new NetProgressBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.myProgressBar = (JProgressBar)c;
        this.installDefaults();
        this.installListeners();
        this.myIsIndeterminate = this.myProgressBar.isIndeterminate();
        if (this.myIsIndeterminate) {
            this.initIndeterminateValues();
            Boolean isCircular = (Boolean)this.myProgressBar.getClientProperty("OrangeTouch.circularIndeterminate");
            if (isCircular != null && isCircular.booleanValue()) {
                this.setCircular();
            }
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.myIsIndeterminate) {
            this.cleanUpIndeterminateValues();
        }
        this.uninstallDefaults();
        this.uninstallListeners();
        this.myAnimator = null;
        this.myProgressBar = null;
    }

    protected void installDefaults() {
        this.myProgressBar.setOpaque(true);
        LookAndFeel.installBorder(this.myProgressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.myProgressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.myCellLength = UIManager.getInt("ProgressBar.cellLength");
        this.myCellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
        this.mySelectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
        this.mySelectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
        ClientPropertyUtil.installProperty(this.myProgressBar, "OrangeTouch.stringPaintedOnTrack");
        ClientPropertyUtil.installProperty(this.myProgressBar, "OrangeTouch.percentPainted");
        this.stringPaintedOnTrackChanged();
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.myProgressBar);
        this.mySelectionForeground = null;
        this.mySelectionBackground = null;
    }

    protected void installListeners() {
        this.myChangeListener = new ChangeHandler();
        this.myProgressBar.addChangeListener(this.myChangeListener);
        this.myPropertyListener = new PropertyChangeHandler();
        this.myProgressBar.addPropertyChangeListener(this.myPropertyListener);
        this.myHierarchyListener = new HierarchyChangeHandler();
    }

    protected void uninstallListeners() {
        this.myProgressBar.removePropertyChangeListener(this.myPropertyListener);
        this.myPropertyListener = null;
        this.myProgressBar.removeChangeListener(this.myChangeListener);
        this.myChangeListener = null;
        this.myProgressBar.removeHierarchyListener(this.myHierarchyListener);
        this.myHierarchyListener = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.myIsIndeterminate) {
            if (this.myIsCircularDeterminate) {
                this.paintCircularIndeterminate(g, c);
            } else {
                this.paintIndeterminate(g, c);
            }
        } else {
            this.paintDeterminate(g, c);
        }
    }

    private void paintCircularIndeterminate(Graphics g, JComponent c) {
        if (ComponentUtils.isSmall(this.myProgressBar)) {
            myCircularSmallIcon.paintIcon(c, g, 0, 0);
        } else {
            myCircularIcon.paintIcon(c, g, 0, 0);
        }
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        int radius;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.myProgressBar.getInsets();
        int barRectWidth = this.myProgressBar.getWidth() - (b.left + b.right);
        int barRectHeight = this.myProgressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Rectangle box = null;
        box = this.getBox(box);
        boolean leftToRight = ComponentUtils.isLeftToRight(c);
        int n = radius = ComponentUtils.isSmall(c) ? NetTheme.getSmallRounding() : NetTheme.getNormalRounding();
        if (this.isHorizontal()) {
            g.setColor(UIManager.getColor("ProgressBar.trackColor"));
            ((Graphics2D)g).fillRoundRect(0, b.top, c.getWidth() - 1, c.getHeight() - 1 - b.top, radius, radius);
            g.setColor(UIManager.getColor("ProgressBar.darkTrackShadow"));
            g.drawLine(2, b.top + 1, c.getWidth() - 3, b.top + 1);
            g.setColor(UIManager.getColor("ProgressBar.midTrackShadow"));
            g.drawLine(2, b.top + 2, c.getWidth() - 3, b.top + 2);
            if (this.myProgressBar.isEnabled()) {
                GradientUtils.drawVerticalGradientOutline(c, g, "ProgressBar.outlineGradient", (Shape)new RoundRectangle2D.Double(0.0, b.top, c.getWidth() - 1, c.getHeight() - 1 - b.top, radius, radius));
            } else {
                ((Graphics2D)g).drawRoundRect(0, 0, c.getWidth() - 1, c.getHeight() - 1, radius, radius);
            }
            Area rect = new Area(new Rectangle(box.x, b.top, box.width, barRectHeight + 1));
            Area area = new Area(new RoundRectangle2D.Double(0.0, b.top, c.getWidth(), c.getHeight() - b.top, radius, radius));
            area.intersect(rect);
            GradientUtils.drawVerticalGradient((JComponent)this.myProgressBar, g, "ProgressBar.nsnGradient", (Shape)area);
            this.paintTopHighlight(g, box.x, 0, box.width, area);
        } else {
            GradientUtils.drawProgressBarGradient(this.myProgressBar, g, "ProgressBar.nsnGradient", true, leftToRight, false, b.left, box.y, barRectWidth, box.height);
        }
        this.paintString(g, b, barRectWidth, barRectHeight, amountFull);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size;
        Insets border = this.myProgressBar.getInsets();
        int fontSize = this.myProgressBar.getFont().getSize();
        FontMetrics fontSizer = this.myProgressBar.getFontMetrics(this.myProgressBar.getFont());
        if (this.myIsCircularDeterminate) {
            size = new Dimension(37, 37);
        } else if (this.isHorizontal()) {
            size = new Dimension(this.getPreferredInnerHorizontal());
            boolean stringPaintedOnTrack = ClientPropertyUtil.booleanValue(this.myProgressBar, "OrangeTouch.stringPaintedOnTrack");
            if (this.myProgressBar.isStringPainted()) {
                String progString = this.myProgressBar.getString();
                int stringWidth = fontSizer.stringWidth(progString);
                if (stringWidth > size.width) {
                    size.width = stringWidth;
                }
                if (stringPaintedOnTrack && fontSize > size.height - 3) {
                    size.height = fontSize + 4;
                }
            }
        } else {
            size = new Dimension(this.getPreferredInnerVertical());
            if (this.myProgressBar.isStringPainted()) {
                int stringWidth;
                String progString = this.myProgressBar.getString();
                if (fontSize > size.width) {
                    size.width = fontSize;
                }
                if ((stringWidth = fontSizer.stringWidth(progString)) > size.height) {
                    size.height = stringWidth;
                }
            }
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension pref = this.getPreferredSize(this.myProgressBar);
        if (this.myProgressBar.getOrientation() == 0) {
            pref.width = 10;
        } else {
            pref.height = 10;
        }
        return pref;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension pref = this.getPreferredSize(this.myProgressBar);
        if (this.myProgressBar.getOrientation() == 0) {
            pref.width = Short.MAX_VALUE;
        } else {
            pref.height = Short.MAX_VALUE;
        }
        return pref;
    }

    protected void startAnimationTimer() {
        if (this.myAnimator == null) {
            this.myAnimator = new Animator();
        }
        this.myAnimator.start(this.getRepaintInterval());
    }

    protected void stopAnimationTimer() {
        if (this.myAnimator != null) {
            this.myAnimator.stop();
        }
    }

    protected Dimension getPreferredInnerHorizontal() {
        if (this.mySizeVariant.equals("normal")) {
            return PREFERRED_STANDRAD_INNER_HORIZONTAL;
        }
        return PREFERRED_SMALL_INNER_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        if (this.mySizeVariant.equals("normal")) {
            return PREFERRED_STANDRAD_INNER_VERTICAL;
        }
        return PREFERRED_SMALL_INNER_VERTICAL;
    }

    protected Color getSelectionForeground() {
        return this.mySelectionForeground;
    }

    protected Color getSelectionBackground() {
        return this.mySelectionBackground;
    }

    protected int getCellLength() {
        if (this.myProgressBar.isStringPainted()) {
            return 1;
        }
        return this.myCellLength;
    }

    protected void setCellLength(int cellLen) {
        this.myCellLength = cellLen;
    }

    protected int getCellSpacing() {
        if (this.myProgressBar.isStringPainted()) {
            return 0;
        }
        return this.myCellSpacing;
    }

    protected void setCellSpacing(int cellSpace) {
        this.myCellSpacing = cellSpace;
    }

    protected int getAmountFull(Insets b, int width, int height) {
        int amountFull = 0;
        BoundedRangeModel model = this.myProgressBar.getModel();
        if (model.getMaximum() - model.getMinimum() != 0) {
            amountFull = this.isHorizontal() ? (int)Math.round((double)width * this.myProgressBar.getPercentComplete()) : (int)Math.round((double)height * this.myProgressBar.getPercentComplete());
        }
        return amountFull;
    }

    protected Rectangle getBox(Rectangle r) {
        Rectangle tempR = r;
        int currentFrame = this.getAnimationIndex();
        int middleFrame = this.myNumFrames / 2;
        if (this.sizeChanged() || SystemUtils.isEqual(this.myDelta, 0.0) || SystemUtils.isEqual(this.myMaxPosition, 0.0)) {
            this.updateSizes();
        }
        if ((tempR = this.getGenericBox(tempR)) == null || middleFrame <= 0) {
            return null;
        }
        int leadingBoxEdge = (int)Math.round(this.myDelta * (double)currentFrame);
        if (this.isHorizontal()) {
            tempR.x = this.myComponentInnards.x + leadingBoxEdge - this.myLength;
        } else {
            tempR.y = this.myComponentInnards.y + (this.myComponentInnards.height - leadingBoxEdge);
        }
        return tempR;
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        int radius;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.myProgressBar.getInsets();
        int barRectWidth = this.myProgressBar.getWidth() - (b.left + b.right);
        int barRectHeight = this.myProgressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Shape oldClip = g.getClip();
        int n = radius = ComponentUtils.isSmall(c) ? 8 : 10;
        if (this.myProgressBar.isEnabled()) {
            g.setColor(UIManager.getColor("ProgressBar.trackColor"));
            ((Graphics2D)g).fillRoundRect(0, b.top, c.getWidth() - 1, c.getHeight() - 1 - b.top, radius, radius);
            g.setColor(UIManager.getColor("ProgressBar.darkTrackShadow"));
            g.drawLine(2, b.top + 1, c.getWidth() - 3, b.top + 1);
            g.setColor(UIManager.getColor("ProgressBar.midTrackShadow"));
            g.drawLine(2, b.top + 2, c.getWidth() - 3, b.top + 2);
        }
        this.paintDeterminateOutline(g, c, radius);
        if (this.isHorizontal()) {
            Area rect = new Area(new Rectangle(b.left, b.top, amountFull + b.left, barRectHeight));
            Area area = new Area(new RoundRectangle2D.Double(0.0, b.top, c.getWidth(), c.getHeight() - b.top, radius, radius));
            area.intersect(rect);
            GradientUtils.drawVerticalGradient((JComponent)this.myProgressBar, g, "ProgressBar.nsnGradient", (Shape)area);
            this.paintTopHighlight(g, b.left, b.top, amountFull, area);
        } else {
            g.setClip(new RoundRectangle2D.Double(0.0, 0.0, c.getWidth(), c.getHeight(), radius, radius));
            GradientUtils.drawProgressBarGradient(this.myProgressBar, g, "ProgressBar.nsnGradient", true, false, true, b.left, b.top + (barRectHeight - amountFull) - 0, barRectWidth, barRectHeight + 0);
        }
        g.setClip(oldClip);
        this.paintString(g, b, barRectWidth, barRectHeight, amountFull);
    }

    private void paintTopHighlight(Graphics g, int boxLeft, int boxTop, int boxWidth, Shape progressTrack) {
        Shape oldClip = g.getClip();
        g.setClip(progressTrack);
        g.setColor(UIManager.getColor("ProgressBar.topBorder"));
        g.drawLine(boxLeft - 1, boxTop, boxLeft + boxWidth + 2, boxTop);
        g.setColor(UIManager.getColor("ProgressBar.topBorder2"));
        g.drawLine(boxLeft - 1, boxTop + 1, boxLeft + boxWidth + 2, boxTop + 1);
        g.setClip(oldClip);
    }

    private void paintDeterminateOutline(Graphics g, JComponent c, int radius) {
        Insets insets = c.getInsets();
        if (this.myProgressBar.isEnabled()) {
            GradientUtils.drawVerticalGradientOutline(c, g, "ProgressBar.outlineGradient", (Shape)new RoundRectangle2D.Double(0.0, insets.top, c.getWidth() - 1, c.getHeight() - 1 - insets.top, radius, radius));
        } else {
            Object oldAa = NetUtils.antiAliasingOn(g);
            Color oldColor = g.getColor();
            g.setColor(NetTheme.getDisabledComponentOutlineColor());
            ((Graphics2D)g).drawRoundRect(0, insets.top, c.getWidth() - 1, c.getHeight() - 1 - insets.top, radius, radius);
            g.setColor(oldColor);
            NetUtils.setAntialiasing(g, oldAa);
        }
    }

    private void paintString(Graphics g, Insets b, int barRectWidth, int barRectHeight, int amountFull) {
        boolean percentsPainted;
        Color oldColor = g.getColor();
        g.setColor(this.myProgressBar.isEnabled() ? this.getSelectionBackground() : UIManager.getColor("Label.disabledForeground"));
        if (this.myProgressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
        if (this.myProgressBar.getOrientation() == 0 && (percentsPainted = ClientPropertyUtil.booleanValue(this.myProgressBar, "OrangeTouch.percentPainted"))) {
            this.paintPercents(g, b.left, b.top, barRectHeight);
        }
        g.setColor(oldColor);
    }

    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        if (this.isHorizontal()) {
            if (ComponentUtils.isLeftToRight(this.myProgressBar)) {
                if (this.myProgressBar.isIndeterminate()) {
                    this.myBoxRect = this.getBox(this.myBoxRect);
                    this.paintString(g, x, y, width, height, this.myBoxRect.x, this.myBoxRect.width);
                } else {
                    this.paintString(g, x, y, width, height, x, amountFull);
                }
            } else {
                this.paintString(g, x, y, width, height, x + width - amountFull, amountFull);
            }
        } else if (this.myProgressBar.isIndeterminate()) {
            this.myBoxRect = this.getBox(this.myBoxRect);
            this.paintString(g, x, y, width, height, this.myBoxRect.y, this.myBoxRect.height);
        } else {
            this.paintString(g, x, y, width, height, y + height - amountFull, amountFull);
        }
    }

    protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
        FontMetrics fontSizer = this.myProgressBar.getFontMetrics(this.myProgressBar.getFont());
        int stringWidth = fontSizer.stringWidth(progressString);
        boolean stringPaintedOnTrack = ClientPropertyUtil.booleanValue(this.myProgressBar, "OrangeTouch.stringPaintedOnTrack");
        if (this.isHorizontal()) {
            if (stringPaintedOnTrack) {
                return new Point(x + Math.round((float)width / 2.0f - (float)stringWidth / 2.0f), y + (height + fontSizer.getAscent() - fontSizer.getLeading() - fontSizer.getDescent()) / 2);
            }
            return new Point(x, y + (height + fontSizer.getAscent() - fontSizer.getLeading() - fontSizer.getDescent()) / 2);
        }
        return new Point(x + (width - fontSizer.getAscent() + fontSizer.getLeading() + fontSizer.getDescent()) / 2 + 1, y + Math.round((float)height / 2.0f - (float)stringWidth / 2.0f));
    }

    protected int getAnimationIndex() {
        return this.myAnimationIndex;
    }

    protected void setAnimationIndex(int newValue) {
        if (this.myAnimationIndex != newValue) {
            if (this.sizeChanged()) {
                this.myAnimationIndex = newValue;
                this.myMaxPosition = 0;
                this.myDelta = 0.0;
                this.myProgressBar.repaint();
                return;
            }
            this.myNextPaintRect = this.getBox(this.myNextPaintRect);
            this.myAnimationIndex = newValue;
            if (this.myNextPaintRect != null) {
                this.myBoxRect = this.getBox(this.myBoxRect);
                if (this.myBoxRect != null) {
                    this.myNextPaintRect.add(this.myBoxRect);
                }
            }
        } else {
            return;
        }
        if (this.myNextPaintRect != null) {
            this.myProgressBar.repaint(this.myNextPaintRect);
        } else {
            this.myProgressBar.repaint();
        }
    }

    protected void incrementAnimationIndex() {
        int newValue = this.getAnimationIndex() + 1;
        this.setAnimationIndex(newValue < this.myNumFrames / 2 ? newValue : 0);
    }

    private int getCachedPercent() {
        return this.myCachedPercent;
    }

    private void setCachedPercent(int cachedPercent) {
        this.myCachedPercent = cachedPercent;
    }

    private void updateSizes() {
        if (this.isHorizontal()) {
            this.myLength = this.getBoxLength(this.myComponentInnards.width);
            this.myMaxPosition = this.myComponentInnards.x + this.myComponentInnards.width + this.myLength;
        } else {
            this.myLength = this.getBoxLength(this.myComponentInnards.height);
            this.myMaxPosition = this.myComponentInnards.y + this.myComponentInnards.height + this.myLength;
        }
        this.myDelta = 2.0 * (double)this.myMaxPosition / (double)this.myNumFrames;
    }

    private Rectangle getGenericBox(Rectangle rect) {
        Rectangle tempRect = rect;
        if (tempRect == null) {
            tempRect = new Rectangle();
        }
        if (this.isHorizontal()) {
            tempRect.width = this.getBoxLength(this.myComponentInnards.width);
            if (tempRect.width < 0) {
                tempRect = null;
            } else {
                tempRect.height = this.myComponentInnards.height;
                tempRect.y = this.myComponentInnards.y;
            }
        } else {
            tempRect.height = this.getBoxLength(this.myComponentInnards.height);
            if (tempRect.height < 0) {
                tempRect = null;
            } else {
                tempRect.width = this.myComponentInnards.width;
                tempRect.x = this.myComponentInnards.x;
            }
        }
        return tempRect;
    }

    private int getBoxLength(int availableLength) {
        return (int)Math.round((double)availableLength / 1.5);
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        NetLookAndFeel.toggleTextAntialiasing(g);
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.myProgressBar.getString();
        Font font = this.myProgressBar.getFont();
        if (font instanceof UIResource && (!this.isHorizontal() || ClientPropertyUtil.booleanValue(this.myProgressBar, "OrangeTouch.stringPaintedOnTrack"))) {
            font = UIManager.getFont("ProgressBar.trackFont");
        }
        g2.setFont(font);
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        g2.setColor(this.myProgressBar.isEnabled() ? UIManager.getColor("ProgressBar.topBorder") : UIManager.getColor("Label.disabledForeground"));
        if (this.isHorizontal()) {
            if (ClientPropertyUtil.booleanValue(this.myProgressBar, "OrangeTouch.stringPaintedOnTrack")) {
                g2.drawString(progressString, renderLocation.x, renderLocation.y);
                Shape oldClip = g.getClip();
                g.clipRect(fillStart, y, amountFull, height);
                g.setColor(NetLookAndFeel.getWhite());
                g2.drawString(progressString, renderLocation.x, renderLocation.y);
                g.setClip(oldClip);
            } else {
                int fontHeight = g2.getFontMetrics().getHeight();
                Color oldColor = g2.getColor();
                g2.setColor(UIManager.getColor("Label.foreground"));
                g2.translate(0, -fontHeight - 2);
                g2.drawString(progressString, renderLocation.x, renderLocation.y);
                g2.translate(0, fontHeight + 2);
                g2.setColor(oldColor);
            }
        } else {
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(font.deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        }
    }

    private void paintPercents(Graphics g, int x, int y, int height) {
        FontMetrics fontSizer = this.myProgressBar.getFontMetrics(this.myProgressBar.getFont());
        g.setFont(this.myProgressBar.getFont());
        int fontHeight = fontSizer.getHeight();
        String percents = String.valueOf(this.getCachedPercent()) + "%";
        boolean stringPaintedOnTrack = ClientPropertyUtil.booleanValue(this.myProgressBar, "OrangeTouch.stringPaintedOnTrack");
        if (stringPaintedOnTrack) {
            g.drawString(percents, this.myProgressBar.getWidth() - fontSizer.stringWidth("100%"), y + (height - fontHeight) / 2 + fontSizer.getAscent());
        } else {
            g.drawString(percents, x, y + height + fontSizer.getHeight());
        }
    }

    private boolean sizeChanged() {
        if (this.myOldComponentInnards == null || this.myComponentInnards == null) {
            return true;
        }
        this.myOldComponentInnards.setRect(this.myComponentInnards);
        this.myComponentInnards = SwingUtilities.calculateInnerArea(this.myProgressBar, this.myComponentInnards);
        return !this.myOldComponentInnards.equals(this.myComponentInnards);
    }

    private int getRepaintInterval() {
        return this.myRepaintInterval;
    }

    private int initRepaintInterval() {
        this.myRepaintInterval = UIManager.getInt("ProgressBar.repaintInterval");
        return this.myRepaintInterval;
    }

    private int initCycleTime() {
        this.myCycleTime = UIManager.getInt("ProgressBar.cycleTime");
        return this.myCycleTime;
    }

    private void initIndeterminateDefaults() {
        this.initRepaintInterval();
        this.initCycleTime();
        if (this.myRepaintInterval <= 0) {
            this.myRepaintInterval = 100;
        }
        if (this.myRepaintInterval > this.myCycleTime) {
            this.myCycleTime = this.myRepaintInterval * 20;
        } else {
            int factor = (int)Math.ceil((double)this.myCycleTime / ((double)this.myRepaintInterval * 2.0));
            this.myCycleTime = this.myRepaintInterval * factor * 2;
        }
    }

    private void initIndeterminateValues() {
        this.initIndeterminateDefaults();
        this.myNumFrames = this.myCycleTime / this.myRepaintInterval;
        this.initAnimationIndex();
        this.myBoxRect = new Rectangle();
        this.myNextPaintRect = new Rectangle();
        this.myComponentInnards = new Rectangle();
        this.myOldComponentInnards = new Rectangle();
        this.myProgressBar.addHierarchyListener(this.myHierarchyListener);
        if (this.myProgressBar.isDisplayable()) {
            this.startAnimationTimer();
        }
    }

    private void cleanUpIndeterminateValues() {
        if (this.myProgressBar.isDisplayable()) {
            this.stopAnimationTimer();
        }
        this.myRepaintInterval = 0;
        this.myCycleTime = 0;
        this.myAnimationIndex = 0;
        this.myNumFrames = 0;
        this.myMaxPosition = 0;
        this.myDelta = 0.0;
        this.myNextPaintRect = null;
        this.myBoxRect = null;
        this.myOldComponentInnards = null;
        this.myComponentInnards = null;
        this.myProgressBar.removeHierarchyListener(this.myHierarchyListener);
    }

    private boolean isHorizontal() {
        return this.myProgressBar.getOrientation() == 0;
    }

    private void initAnimationIndex() {
        if (this.isHorizontal()) {
            this.setAnimationIndex(0);
        } else {
            this.setAnimationIndex(this.myNumFrames);
        }
    }

    private void stringPaintedOnTrackChanged() {
        this.myProgressBar.revalidate();
        this.myProgressBar.repaint();
    }

    private void setCircular() {
        this.myProgressBar.setOpaque(false);
        LookAndFeel.uninstallBorder(this.myProgressBar);
        this.myIsCircularDeterminate = true;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque() && c.getBackground() instanceof UIResource) {
            GradientUtils.drawVerticalBackgroundGradient(c, g);
            this.paint(g, c);
            return;
        }
        super.update(g, c);
    }

    private class Animator
    implements ActionListener {
        private Timer myTimer;
        private long myPreviousDelay;
        private long myLastCall;
        private int myMinDelay = 5;

        private Animator() {
        }

        private void start(int interval) {
            this.myPreviousDelay = interval;
            this.myLastCall = 0L;
            if (this.myTimer == null) {
                this.myTimer = new Timer(interval, this);
            } else {
                this.myTimer.setDelay(interval);
            }
            if (ADJUSTTIMER) {
                this.myTimer.setRepeats(false);
                this.myTimer.setCoalesce(false);
            }
            this.myTimer.start();
        }

        private void stop() {
            this.myTimer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ADJUSTTIMER) {
                long time = System.currentTimeMillis();
                if (this.myLastCall > 0L) {
                    int nextDelay = (int)(this.myPreviousDelay - time + this.myLastCall + (long)NetProgressBarUI.this.getRepaintInterval());
                    if (nextDelay < this.myMinDelay) {
                        nextDelay = this.myMinDelay;
                    }
                    this.myTimer.setInitialDelay(nextDelay);
                    this.myPreviousDelay = nextDelay;
                }
                this.myTimer.start();
                this.myLastCall = time;
            }
            NetProgressBarUI.this.incrementAnimationIndex();
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            int oldPercent;
            BoundedRangeModel model = NetProgressBarUI.this.myProgressBar.getModel();
            int newRange = model.getMaximum() - model.getMinimum();
            int newPercent = newRange > 0 ? (int)(100L * (long)model.getValue() / (long)newRange) : 0;
            if (newPercent != (oldPercent = NetProgressBarUI.this.getCachedPercent())) {
                NetProgressBarUI.this.setCachedPercent(newPercent);
                NetProgressBarUI.this.myProgressBar.repaint();
            }
        }
    }

    private class HierarchyChangeHandler
    implements HierarchyListener {
        private HierarchyChangeHandler() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 2L) != 0L && NetProgressBarUI.this.myProgressBar.isIndeterminate()) {
                if (NetProgressBarUI.this.myProgressBar.isDisplayable()) {
                    NetProgressBarUI.this.startAnimationTimer();
                } else {
                    NetProgressBarUI.this.stopAnimationTimer();
                }
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("indeterminate".equals(prop)) {
                NetProgressBarUI.this.myIsIndeterminate = NetProgressBarUI.this.myProgressBar.isIndeterminate();
                if (NetProgressBarUI.this.myIsIndeterminate) {
                    NetProgressBarUI.this.initIndeterminateValues();
                } else {
                    NetProgressBarUI.this.cleanUpIndeterminateValues();
                }
                NetProgressBarUI.this.myProgressBar.repaint();
            } else if ("OrangeTouch.stringPaintedOnTrack".equals(prop)) {
                NetProgressBarUI.this.stringPaintedOnTrackChanged();
            } else if ("OrangeTouch.percentPainted".equals(prop)) {
                NetProgressBarUI.this.stringPaintedOnTrackChanged();
            } else if ("OrangeTouch.circularIndeterminate".equals(prop) && ((Boolean)NetProgressBarUI.this.myProgressBar.getClientProperty("OrangeTouch.circularIndeterminate")).booleanValue()) {
                NetProgressBarUI.this.setCircular();
            } else if ("JComponent.sizeVariant".equals(prop)) {
                NetProgressBarUI.this.mySizeVariant = (String)NetProgressBarUI.this.myProgressBar.getClientProperty("JComponent.sizeVariant");
                NetProgressBarUI.this.stringPaintedOnTrackChanged();
            }
        }
    }
}

