/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.painters.BackgroundPainter;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.text.status.ModifiedStatusHandler;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;

public class NetRadioButtonUI
extends MetalRadioButtonUI {
    private static final NetRadioButtonUI theRadioButtonUI = new NetRadioButtonUI();

    public static ComponentUI createUI(JComponent comp) {
        return theRadioButtonUI;
    }

    @Override
    public void installDefaults(AbstractButton btn) {
        super.installDefaults(btn);
        btn.setRolloverEnabled(true);
        NetUtils.setCursor(btn);
        btn.setIconTextGap(UIManager.getInt(String.valueOf(this.getPropertyPrefix()) + "textIconGap"));
        NetUtils.setMarginAndFont(btn, this.getPropertyPrefix());
        btn.putClientProperty("OrangeTouch.modifiedValueHandler", ModifiedStatusHandler.create(btn));
    }

    @Override
    protected void uninstallDefaults(AbstractButton btn) {
        super.uninstallDefaults(btn);
        ModifiedStatusHandler handler = (ModifiedStatusHandler)btn.getClientProperty("OrangeTouch.modifiedValueHandler");
        if (handler != null) {
            handler.uninstallFrom(btn);
        }
        btn.putClientProperty("OrangeTouch.modifiedValueHandler", null);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        if (c.getComponentCount() > 0 || text != null && text.length() > 0) {
            return super.getPreferredSize(c);
        }
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + (ComponentUtils.isSmall(b) ? "smallIcon" : "icon"));
        }
        if (buttonIcon == null) {
            return super.getPreferredSize(c);
        }
        int width = buttonIcon.getIconWidth();
        int height = buttonIcon.getIconHeight();
        Insets prefInsets = b.getInsets();
        return new Dimension(width += prefInsets.left + prefInsets.right, height += prefInsets.top + prefInsets.bottom);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (c.getParent() instanceof CellRendererPane) {
                super.update(g, c);
                return;
            }
            if (c.getBackground() instanceof UIResource) {
                GradientUtils.drawVerticalBackgroundGradient(c, g);
            } else if (c.getBackground() instanceof BackgroundPainter) {
                BackgroundPainter gc = (BackgroundPainter)((Object)c.getBackground());
                gc.paintBackground(g, c);
                gc.paintBorderContour(g, c, c.getWidth(), c.getHeight());
            } else {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
        this.paint(g, c);
    }

    @Override
    protected void installListeners(AbstractButton button) {
        BasicButtonListener listener = this.createButtonListener(button);
        if (listener != null) {
            if (!ComponentUtils.isReadOnly(button)) {
                button.addMouseListener(listener);
                button.addMouseMotionListener(listener);
                button.addFocusListener(listener);
            }
            button.addPropertyChangeListener(listener);
            button.addChangeListener(listener);
        }
        ReadOnlyHandler.getInstance().installTo(button);
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        super.uninstallListeners(button);
        ReadOnlyHandler.getInstance().uninstallFrom(button);
    }

    @Override
    public synchronized void paint(Graphics g, JComponent comp) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        AbstractButton btn = (AbstractButton)comp;
        btn.setFocusPainted(false);
        Dimension size = comp.getSize();
        Font font = comp.getFont();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets insets = comp.getInsets();
        viewRect.x += insets.left;
        viewRect.y += insets.top;
        viewRect.width -= insets.right + viewRect.x;
        viewRect.height -= insets.bottom + viewRect.y;
        Icon altIcon = btn.getIcon();
        Icon defaultIcon = ComponentUtils.isSmall(btn) ? UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "smallIcon") : UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "icon");
        String text = SwingUtilities.layoutCompoundLabel(comp, fm, btn.getText(), altIcon != null ? altIcon : defaultIcon, btn.getVerticalAlignment(), btn.getHorizontalAlignment(), btn.getVerticalTextPosition(), btn.getHorizontalTextPosition(), viewRect, iconRect, textRect, btn.getIconTextGap());
        this.paintIcon(g, btn, iconRect);
        this.paintText(g, btn, text, textRect, fm, iconRect);
    }

    @Override
    protected void paintIcon(Graphics g, AbstractButton btn, Rectangle iconRect) {
        ButtonModel model = btn.getModel();
        Icon altIcon = btn.getIcon();
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? btn.getDisabledSelectedIcon() : btn.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = btn.getPressedIcon();
                if (altIcon == null) {
                    altIcon = btn.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (btn.isRolloverEnabled() && model.isRollover()) {
                    altIcon = btn.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = btn.getSelectedIcon();
                    }
                } else {
                    altIcon = btn.getSelectedIcon();
                }
            } else if (btn.isRolloverEnabled() && model.isRollover()) {
                altIcon = btn.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = btn.getIcon();
            }
            altIcon.paintIcon(btn, g, iconRect.x, iconRect.y);
        } else if (ComponentUtils.isSmall(btn)) {
            UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "smallIcon").paintIcon(btn, g, iconRect.x, iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(btn, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintText(Graphics g, AbstractButton btn, String text, Rectangle textRect, FontMetrics fm, Rectangle iconRect) {
        if (text != null) {
            View view = (View)btn.getClientProperty("html");
            if (view != null) {
                view.paint(g, textRect);
            } else {
                int mnemIndex;
                int n = mnemIndex = btn.isEnabled() ? btn.getDisplayedMnemonicIndex() : -1;
                if (btn.getModel().isEnabled()) {
                    g.setColor(btn.getForeground());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                } else {
                    g.setColor(this.getDisabledTextColor());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                }
                if (btn.hasFocus() && btn.isFocusPainted()) {
                    this.paintFocus(g, btn, textRect, iconRect);
                }
            }
        }
    }

    private void paintFocus(Graphics g, AbstractButton btn, Rectangle textRect, Rectangle iconRect) {
        if (textRect.width > 0 && textRect.height > 0) {
            Rectangle focusRect = new Rectangle(textRect.x - 3, textRect.y, textRect.width + 5, textRect.height + 1);
            Rectangle bounds = btn.getBounds();
            bounds.y = 0;
            bounds.x = 0;
            focusRect = focusRect.intersection(bounds);
            NetUtils.drawDash(g, focusRect.x, focusRect.y, focusRect.width, focusRect.height);
        } else {
            NetUtils.drawDash(g, iconRect.x - 1, iconRect.y - 1, iconRect.width + 2, iconRect.height + 2);
        }
    }
}

