/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.rootpane.DimmingGlassPane;
import com.nokia.laf.rootpane.NetRootPaneLayout;
import com.nokia.laf.rootpane.NetTitlePane;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ResizeCorner;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class NetRootPaneUI
extends BasicRootPaneUI {
    protected LayoutManager layoutManager;
    protected ResizeCorner myResizeCorner;
    protected Window myWindow;
    protected JRootPane myRootPane;
    private LayoutManager mySavedOldLayout;
    private JComponent myTitlePane;
    private MouseInputListener myMouseInputListener;
    private ComponentListener myComponentListener;
    private static final String CLOSE_WINDOW_ACTION_KEY = "closeWindowAction";
    private Cursor myLastCursor = Cursor.getPredefinedCursor(0);
    private boolean myIsMouseOnWindow = false;
    private static final int[] CURSOR_MAP;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final String[] borderKeys;

    static {
        int[] nArray = new int[25];
        nArray[0] = 6;
        nArray[1] = 6;
        nArray[2] = 8;
        nArray[3] = 7;
        nArray[4] = 7;
        nArray[5] = 6;
        nArray[9] = 7;
        nArray[10] = 10;
        nArray[14] = 11;
        nArray[15] = 4;
        nArray[19] = 5;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 9;
        nArray[23] = 5;
        nArray[24] = 5;
        CURSOR_MAP = nArray;
        String[] stringArray = new String[9];
        stringArray[1] = "RootPane.frameBorder";
        stringArray[2] = "RootPane.plainDialogBorder";
        stringArray[3] = "RootPane.informationDialogBorder";
        stringArray[4] = "RootPane.errorDialogBorder";
        stringArray[5] = "RootPane.colorChooserDialogBorder";
        stringArray[6] = "RootPane.fileChooserDialogBorder";
        stringArray[7] = "RootPane.questionDialogBorder";
        stringArray[8] = "RootPane.warningDialogBorder";
        borderKeys = stringArray;
    }

    public static ComponentUI createUI(JComponent c) {
        return new NetRootPaneUI();
    }

    private JComponent createTitlePane(JRootPane root) {
        return new NetTitlePane(root, this);
    }

    @Override
    public void installUI(JComponent c) {
        int style;
        this.myRootPane = (JRootPane)c;
        this.myWindow = SwingUtilities.getWindowAncestor(c);
        this.installComponentListenerToWindow();
        super.installUI(c);
        this.installLayout((JRootPane)c);
        if (NetUtils.lookAndFeelCanReplace(this.myRootPane.getFont())) {
            this.myRootPane.setFont(UIManager.getFont("RootPane.font"));
        }
        if ((style = this.myRootPane.getWindowDecorationStyle()) != 0) {
            this.installClientDecorations(this.myRootPane);
        }
    }

    protected void installComponentListenerToWindow() {
        if (this.myWindow != null) {
            this.myComponentListener = new DimmingHandler();
            this.myWindow.addComponentListener(this.myComponentListener);
        }
    }

    protected void uninstallComponentListenerFromWindow() {
        if (this.myWindow != null && this.myComponentListener != null) {
            this.myWindow.removeComponentListener(this.myComponentListener);
            this.myComponentListener = null;
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.myRootPane != null) {
            int style = this.myRootPane.getWindowDecorationStyle();
            if (style != 0) {
                this.uninstallClientDecorations(this.myRootPane);
            }
            this.uninstallComponentListenerFromWindow();
        }
        this.myRootPane = null;
        this.myWindow = null;
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.myWindow != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
        this.uninstallWindowListeners();
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.myWindow != null) {
            this.myWindow.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.myWindow = null;
    }

    void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, borderKeys[style]);
        }
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.myWindow = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(root);
        if (this.myWindow != null) {
            if (this.myMouseInputListener == null) {
                this.myMouseInputListener = this.createWindowMouseInputListener();
            }
            this.myWindow.addMouseListener(this.myMouseInputListener);
            this.myWindow.addMouseMotionListener(this.myMouseInputListener);
        }
    }

    private void uninstallWindowListeners() {
        if (this.myWindow != null) {
            this.myWindow.removeMouseListener(this.myMouseInputListener);
            this.myWindow.removeMouseMotionListener(this.myMouseInputListener);
        }
    }

    private MouseInputListener createWindowMouseInputListener() {
        return new MouseInputHandler();
    }

    public JComponent getTitlePane() {
        return this.myTitlePane;
    }

    public JRootPane getRootPane() {
        return this.myRootPane;
    }

    private JFrame getOwnerFrameToDim() {
        if (!(this.myWindow instanceof JDialog)) {
            return null;
        }
        JDialog dialog = (JDialog)this.myWindow;
        if (dialog.getModalityType() == Dialog.ModalityType.MODELESS) {
            return null;
        }
        Window owner = dialog.getOwner();
        if (owner instanceof JFrame) {
            return (JFrame)owner;
        }
        return NetLookAndFeel.getDefaultMainFrame();
    }

    private void undimOwnerFrame() {
        DimmingGlassPane dimminPane;
        JFrame frame = this.getOwnerFrameToDim();
        if (frame == null) {
            return;
        }
        if (frame.getGlassPane() instanceof DimmingGlassPane && (dimminPane = (DimmingGlassPane)frame.getGlassPane()).getRequestor() == this.myWindow) {
            dimminPane.undim();
        }
    }

    public ResizeCorner getResizeCorner() {
        return this.myResizeCorner;
    }

    public Window getWindow() {
        return this.myWindow;
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.myTitlePane = titlePane;
    }

    @Override
    protected void installKeyboardActions(JRootPane root) {
        super.installKeyboardActions(root);
        if (root.getLayeredPane() == null) {
            return;
        }
        InputMap inputMap = root.getLayeredPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), CLOSE_WINDOW_ACTION_KEY);
        ActionMap actionMap = root.getLayeredPane().getActionMap();
        actionMap.put(CLOSE_WINDOW_ACTION_KEY, new CloseWindowAction());
    }

    @Override
    protected void uninstallKeyboardActions(JRootPane root) {
        super.uninstallKeyboardActions(root);
        if (root.getLayeredPane() == null) {
            return;
        }
        InputMap inputMap = root.getLayeredPane().getInputMap(2);
        inputMap.remove(KeyStroke.getKeyStroke(27, 0));
        ActionMap actionMap = root.getLayeredPane().getActionMap();
        actionMap.remove(CLOSE_WINDOW_ACTION_KEY);
    }

    @Override
    protected void installComponents(JRootPane root) {
        super.installComponents(root);
        this.myResizeCorner = new ResizeCorner(this.myWindow);
        root.getLayeredPane().add((Component)this.myResizeCorner, (Object)(JLayeredPane.FRAME_CONTENT_LAYER + 1));
    }

    @Override
    protected void uninstallComponents(JRootPane root) {
        super.uninstallComponents(root);
        root.getLayeredPane().remove(this.myResizeCorner);
        this.myResizeCorner = null;
    }

    protected void installLayout(JRootPane root) {
        this.mySavedOldLayout = root.getLayout();
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        root.setLayout(this.layoutManager);
    }

    protected void uninstallLayout(JRootPane root) {
        if (this.mySavedOldLayout != null) {
            root.setLayout(this.mySavedOldLayout);
            this.mySavedOldLayout = null;
        }
    }

    protected LayoutManager createLayoutManager() {
        return new NetRootPaneLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        JRootPane root = (JRootPane)e.getSource();
        if ("ancestor".equals(propertyName)) {
            if (e.getNewValue() != null) {
                this.myWindow = SwingUtilities.getWindowAncestor((Component)e.getSource());
                this.installComponentListenerToWindow();
                this.myResizeCorner.setParent(this.myWindow);
            } else {
                if (!(e.getOldValue() instanceof JInternalFrame || e.getOldValue() != null && e.getOldValue().getClass().getName().startsWith("javax.swing.PopupFactory$"))) {
                    this.undimOwnerFrame();
                }
                this.uninstallComponentListenerFromWindow();
                this.myWindow = null;
                this.myResizeCorner.setParent(null);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (NetRootPaneUI.this.myWindow != null) {
                        NetRootPaneUI.this.myWindow.repaint();
                    }
                }
            });
        } else if ("windowDecorationStyle".equals(propertyName)) {
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(this.myRootPane);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        } else if ("ancestor".equals(propertyName)) {
            this.uninstallWindowListeners();
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.myRootPane, this.myRootPane.getParent());
            }
        }
    }

    protected class CloseWindowAction
    extends AbstractAction {
        protected CloseWindowAction() {
        }

        @Override
        public boolean isEnabled() {
            boolean isPopupMenuVisible;
            MenuSelectionManager menuManager = MenuSelectionManager.defaultManager();
            boolean bl = isPopupMenuVisible = menuManager.getSelectedPath() != null && menuManager.getSelectedPath().length != 0;
            if (isPopupMenuVisible) {
                return false;
            }
            if (!UIManager.getBoolean("OrangeTouch.closeWindowOnEscape") || !ClientPropertyUtil.booleanValue(NetRootPaneUI.this.myRootPane, "OrangeTouch.closeWindowOnEscape", true)) {
                return false;
            }
            if (NetRootPaneUI.this.myWindow instanceof JFrame && NetRootPaneUI.this.myWindow == NetRootPaneUI.this.myRootPane.getParent() && !Boolean.TRUE.equals(NetRootPaneUI.this.myRootPane.getClientProperty("OrangeTouch.closeWindowOnEscape"))) {
                return false;
            }
            return NetRootPaneUI.this.myRootPane.getParent() instanceof Window;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NetRootPaneUI.this.myWindow != null) {
                NetRootPaneUI.this.myWindow.dispatchEvent(new WindowEvent(NetRootPaneUI.this.myWindow, 201));
            }
        }
    }

    private final class DimmingHandler
    extends ComponentAdapter {
        private DimmingHandler() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            super.componentHidden(e);
            NetRootPaneUI.this.undimOwnerFrame();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (!SystemUtils.isDimmingSupported()) {
                return;
            }
            JFrame frame = NetRootPaneUI.this.getOwnerFrameToDim();
            if (frame == null) {
                return;
            }
            if (frame.getGlassPane() instanceof DimmingGlassPane) {
                DimmingGlassPane dimming = (DimmingGlassPane)frame.getGlassPane();
                if (!dimming.isDimming()) {
                    dimming.setRequestor(NetRootPaneUI.this.myWindow);
                    dimming.dim();
                }
                return;
            }
            DimmingGlassPane dimmer = new DimmingGlassPane(NetRootPaneUI.this.myWindow, frame.getGlassPane());
            frame.setGlassPane(dimmer);
            dimmer.dim();
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean myMovingWindow;
        private int myDragCursor;
        private int myDragOffsetX;
        private int myDragOffsetY;
        private int myDragWidth;
        private int myDragHeight;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = NetRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            if (w != null) {
                w.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, NetRootPaneUI.this.getTitlePane());
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (NetRootPaneUI.this.getTitlePane() != null && NetRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                if ((f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                    this.myMovingWindow = true;
                    this.myDragOffsetX = dragWindowOffset.x;
                    this.myDragOffsetY = dragWindowOffset.y;
                }
            } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.myDragOffsetX = dragWindowOffset.x;
                this.myDragOffsetY = dragWindowOffset.y;
                this.myDragWidth = w.getWidth();
                this.myDragHeight = w.getHeight();
                this.myDragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (this.myDragCursor != 0 && NetRootPaneUI.this.myWindow != null && !NetRootPaneUI.this.myWindow.isValid()) {
                NetRootPaneUI.this.myWindow.validate();
                NetRootPaneUI.this.getRootPane().repaint();
            }
            this.myMovingWindow = false;
            this.myDragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            JRootPane root = NetRootPaneUI.this.getRootPane();
            NetRootPaneUI.this.myIsMouseOnWindow = true;
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = (Window)ev.getSource();
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int cursor = this.getCursor(this.calculateCorner(window, ev.getX(), ev.getY()));
            if (cursor != 0 && (frame != null && frame.isResizable() && (frame.getExtendedState() & 6) == 0 || dialog != null && dialog.isResizable())) {
                window.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                window.setCursor(NetRootPaneUI.this.myLastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Window window = (Window)event.getSource();
            Point point = event.getPoint();
            if (this.myMovingWindow) {
                if (window.isShowing()) {
                    Point locationOnScreen = window.getLocationOnScreen();
                    Point eventLocationOnScreen = new Point(locationOnScreen.x + event.getX(), locationOnScreen.y + event.getY());
                    window.setLocation(eventLocationOnScreen.x - this.myDragOffsetX, eventLocationOnScreen.y - this.myDragOffsetY);
                }
            } else if (this.myDragCursor != 0) {
                Rectangle boudns = window.getBounds();
                Rectangle startBounds = new Rectangle(boudns);
                Dimension minimumSize = window.getMinimumSize();
                switch (this.myDragCursor) {
                    case 11: {
                        this.adjust(boudns, minimumSize, 0, 0, point.x + (this.myDragWidth - this.myDragOffsetX) - boudns.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(boudns, minimumSize, 0, 0, 0, point.y + (this.myDragHeight - this.myDragOffsetY) - boudns.height);
                        break;
                    }
                    case 8: {
                        this.adjust(boudns, minimumSize, 0, point.y - this.myDragOffsetY, 0, -(point.y - this.myDragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(boudns, minimumSize, point.x - this.myDragOffsetX, 0, -(point.x - this.myDragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(boudns, minimumSize, 0, point.y - this.myDragOffsetY, point.x + (this.myDragWidth - this.myDragOffsetX) - boudns.width, -(point.y - this.myDragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(boudns, minimumSize, 0, 0, point.x + (this.myDragWidth - this.myDragOffsetX) - boudns.width, point.y + (this.myDragHeight - this.myDragOffsetY) - boudns.height);
                        break;
                    }
                    case 6: {
                        this.adjust(boudns, minimumSize, point.x - this.myDragOffsetX, point.y - this.myDragOffsetY, -(point.x - this.myDragOffsetX), -(point.y - this.myDragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(boudns, minimumSize, point.x - this.myDragOffsetX, 0, -(point.x - this.myDragOffsetX), point.y + (this.myDragHeight - this.myDragOffsetY) - boudns.height);
                        break;
                    }
                }
                if (!boudns.equals(startBounds)) {
                    window.setBounds(boudns);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        window.validate();
                        NetRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            if (NetRootPaneUI.this.myIsMouseOnWindow) {
                return;
            }
            NetRootPaneUI.this.myIsMouseOnWindow = true;
            Window w = (Window)ev.getSource();
            NetRootPaneUI.this.myLastCursor = w.getCursor();
            this.mouseMoved(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            w.setCursor(NetRootPaneUI.this.myLastCursor);
            NetRootPaneUI.this.myIsMouseOnWindow = false;
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Frame frame = null;
            if (!(w instanceof Frame)) {
                return;
            }
            frame = (Frame)w;
            Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), NetRootPaneUI.this.getTitlePane());
            int state = frame.getExtendedState();
            if (NetRootPaneUI.this.getTitlePane() != null && NetRootPaneUI.this.getTitlePane().contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                if ((state & 6) != 0) {
                    frame.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    frame.setExtendedState(state | 6);
                }
                return;
            }
        }

        private int calculateCorner(Window w, int x, int y) {
            Insets insets = w.getInsets();
            int xPosition = this.calculatePosition(x - insets.left, w.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(y - insets.top, w.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return CURSOR_MAP[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }
}

