/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.combobox.NetComboPopup;
import com.nokia.laf.scrollbar.NetArrowButton;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class NetScrollBarUI
extends BasicScrollBarUI
implements PropertyChangeListener {
    private static Color theScrollBorderColor;
    private int myScrollBarWidth;
    private JButton myDecreaseButton;
    private JButton myIncreaseButton;
    protected boolean myIsRollover = false;
    protected boolean myWasRollover = false;
    protected boolean myThumbPressed = false;
    protected static final int TRACK_MARGIN = 5;
    protected static final int TRACK_ROUNDING;

    static {
        TRACK_ROUNDING = NetTheme.getSmallRounding();
    }

    public static ComponentUI createUI(JComponent component) {
        return new NetScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        int unitIncrement;
        this.myScrollBarWidth = UIManager.getInt("ScrollBar.width");
        if (this.myScrollBarWidth <= 0) {
            this.myScrollBarWidth = 17;
        }
        super.installDefaults();
        if (!Boolean.TRUE.equals(this.scrollbar.getClientProperty("OrangeTouch.scrollBarUnitIncrementChangedByClient")) && (unitIncrement = UIManager.getInt("ScrollBar.unitIncrement")) > 0) {
            this.scrollbar.removePropertyChangeListener(this);
            this.scrollbar.setUnitIncrement(unitIncrement);
            this.scrollbar.addPropertyChangeListener(this);
        }
        this.scrollbar.putClientProperty("clearOppositeBorder", Boolean.TRUE);
        this.scrollbar.setOpaque(false);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.scrollbar != null) {
            this.scrollbar.removePropertyChangeListener(this);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (this.scrollbar.isOpaque() && !ClientPropertyUtil.booleanValue(c, "ScrollBar.comboBoxPopup")) {
            GradientUtils.drawVerticalBackgroundGradient(c, g);
        }
        Color oldColor = g.getColor();
        g.setColor(c.getBackground());
        if (this.isVertical()) {
            GradientUtils.drawHorizontalGradient(c, g, "ScrollPane.arrowButtonGradient", 1, this.myScrollBarWidth - 1, c.getWidth() - 1, c.getHeight() - 2 * this.myScrollBarWidth + 1);
        } else {
            GradientUtils.drawVerticalGradient(c, g, "ScrollPane.arrowButtonGradient", this.myScrollBarWidth - 1, 1, c.getWidth() - 2 * this.myScrollBarWidth + 1, c.getHeight() - 2);
        }
        g.setColor(oldColor);
        this.paint(g, c);
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        if (theScrollBorderColor == null) {
            theScrollBorderColor = UIManager.getColor("Scrollbar.NormalBorder");
        }
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.myDecreaseButton = new NetArrowButton(orientation, this.myScrollBarWidth);
        return this.myDecreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.myIncreaseButton = new NetArrowButton(orientation, this.myScrollBarWidth);
        return this.myIncreaseButton;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g, c);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent comp, Rectangle trackBounds) {
        g.translate(trackBounds.x, trackBounds.y);
        Color borderColor = this.getBorderColor(comp);
        Color outerBorderColor = this.getOuterBorderColor(comp);
        if (this.isVertical()) {
            this.paintVerticalTrack(g, comp, trackBounds, borderColor, outerBorderColor);
        } else {
            this.paintHorizontalTrack(g, comp, trackBounds, borderColor, outerBorderColor);
        }
        g.translate(-trackBounds.x, -trackBounds.y);
    }

    private Color getBorderColor(JComponent comp) {
        return comp.isEnabled() ? theScrollBorderColor : theScrollBorderColor;
    }

    private Color getOuterBorderColor(JComponent comp) {
        NetComboPopup popup;
        JComboBox combo;
        JScrollPane parent;
        if (comp.getParent() instanceof JScrollPane && (parent = (JScrollPane)comp.getParent()).getViewport().getView() instanceof JTable) {
            return NetUtils.getTableOutlineColor(parent);
        }
        if (ClientPropertyUtil.booleanValue(comp, "ScrollBar.comboBoxPopup") && comp.getParent() != null && comp.getParent().getParent() instanceof NetComboPopup && NetUtils.isFocused(combo = (popup = (NetComboPopup)comp.getParent().getParent()).getComboBox())) {
            return NetLookAndFeel.getCurrentTheme().getFocusColor();
        }
        return this.getBorderColor(comp);
    }

    private void paintHorizontalTrack(Graphics g, JComponent comp, Rectangle trackBounds, Color borderColor, Color outerBorderColor) {
        g.setColor(borderColor);
        int trackShapeSize = this.getTrackSize(trackBounds);
        g.drawLine(0, 0, trackBounds.width, 0);
        g.setColor(outerBorderColor);
        g.drawLine(0, trackBounds.height - 1, trackBounds.width, trackBounds.height - 1);
        g.setColor(UIManager.getColor("ScrollBar.trackShape"));
        RoundRectangle2D.Double trackShape = new RoundRectangle2D.Double(0.0, 5.0, trackBounds.width, trackShapeSize, TRACK_ROUNDING, TRACK_ROUNDING);
        GradientUtils.drawVerticalGradient(comp, g, "ScrollBar.trackGradient", (Shape)trackShape);
    }

    private void paintVerticalTrack(Graphics g, JComponent comp, Rectangle trackBounds, Color borderColor, Color outerBorderColor) {
        g.setColor(borderColor);
        int trackShapeSize = this.getTrackSize(trackBounds);
        g.drawLine(0, 0, 0, trackBounds.height);
        g.setColor(outerBorderColor);
        g.drawLine(trackBounds.width - 1, 0, trackBounds.width - 1, trackBounds.height);
        g.setColor(UIManager.getColor("ScrollBar.trackShape"));
        RoundRectangle2D.Double trackShape = new RoundRectangle2D.Double(5.0, 0.0, trackShapeSize, trackBounds.height, TRACK_ROUNDING, TRACK_ROUNDING);
        GradientUtils.drawHorizontalGradient(comp, g, "ScrollBar.trackGradient", (Shape)trackShape);
    }

    private int getTrackSize(Rectangle trackBounds) {
        return this.isVertical() ? trackBounds.width - 10 : trackBounds.height - 10;
    }

    @Override
    protected void paintThumb(Graphics g, JComponent comp, Rectangle thumbBounds) {
        Color[] thumbGradient;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(thumbBounds.x, thumbBounds.y);
        Color[] colorArray = thumbGradient = this.myIsRollover ? (Color[])UIManager.get("ScrollBar.rolloverThumb") : (Color[])UIManager.get("ScrollBar.thumb");
        if (this.myThumbPressed) {
            thumbGradient = (Color[])UIManager.get("ScrollBar.pressedThumb");
        }
        int trackShapeSize = this.getTrackSize(thumbBounds);
        if (this.isVertical()) {
            RoundRectangle2D.Double trackShape = new RoundRectangle2D.Double(5.0, 0.0, trackShapeSize, thumbBounds.height, TRACK_ROUNDING, TRACK_ROUNDING);
            GradientUtils.drawHorizontalGradient(comp, g, thumbGradient, (Shape)trackShape);
            if (!this.myIsRollover) {
                g.setColor(UIManager.getColor("ScrollBar.thubmHighlight"));
                g.drawLine(5, 3, 5, thumbBounds.height - 4);
            }
        } else {
            RoundRectangle2D.Double trackShape = new RoundRectangle2D.Double(0.0, 5.0, thumbBounds.width, trackShapeSize, TRACK_ROUNDING, TRACK_ROUNDING);
            GradientUtils.drawVerticalGradient(comp, g, thumbGradient, (Shape)trackShape);
            if (!this.myIsRollover) {
                g.setColor(UIManager.getColor("ScrollBar.thubmHighlight"));
                g.drawLine(3, 5, thumbBounds.width - 4, 5);
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    private boolean isVertical() {
        return this.scrollbar.getOrientation() == 1;
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new NetTrackListener();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("unitIncrement".equals(evt.getPropertyName()) && this.scrollbar != null) {
            this.scrollbar.putClientProperty("OrangeTouch.scrollBarUnitIncrementChangedByClient", Boolean.TRUE);
        }
    }

    @Override
    protected void scrollByUnit(int direction) {
        super.scrollByUnit(direction);
        this.scrollbar.repaint();
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int decrButtonH = this.decrButton.getPreferredSize().height;
        int decrButtonY = sbInsets.top;
        int incrButtonH = this.incrButton.getPreferredSize().height;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = incrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY - 1) {
                thumbY = incrButtonY - 1 - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH + 1) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        super.layoutHScrollbar(sb);
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int leftButtonW = (ltr ? this.decrButton : this.incrButton).getPreferredSize().width;
        int rightButtonW = (ltr ? this.incrButton : this.decrButton).getPreferredSize().width;
        int leftButtonX = sbInsets.left;
        int rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = leftButtonW + rightButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? rightButtonX - thumbW : leftButtonX + leftButtonW;
        if ((float)sb.getValue() < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = ltr ? (int)(0.5f + thumbRange * ((value - min) / (range - extent))) : (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
            thumbX += leftButtonX + leftButtonW;
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            rightButtonW = leftButtonW = sbAvailButtonW / 2;
            rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
        }
        (ltr ? this.decrButton : this.incrButton).setBounds(leftButtonX, itemY, leftButtonW, itemH);
        (ltr ? this.incrButton : this.decrButton).setBounds(rightButtonX, itemY, rightButtonW, itemH);
        int itrackX = leftButtonX + leftButtonW;
        int itrackW = rightButtonX - itrackX;
        this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbX + thumbW > rightButtonX - 1) {
                thumbX = rightButtonX - 1 - thumbW;
            }
            if (thumbX < leftButtonX + leftButtonW + 1) {
                thumbX = leftButtonX + leftButtonW + 1;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected class NetTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected NetTrackListener() {
            super(NetScrollBarUI.this);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            super.mousePressed(evt);
            if (!NetScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            NetScrollBarUI.this.myThumbPressed = NetScrollBarUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY);
            NetScrollBarUI.this.scrollbar.repaint(NetScrollBarUI.this.thumbRect);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            super.mouseReleased(evt);
            NetScrollBarUI.this.myThumbPressed = false;
            NetScrollBarUI.this.scrollbar.repaint(NetScrollBarUI.this.thumbRect);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            NetScrollBarUI.this.myIsRollover = false;
            NetScrollBarUI.this.myWasRollover = false;
            if (NetScrollBarUI.this.getThumbBounds().contains(evt.getX(), evt.getY())) {
                NetScrollBarUI.this.myIsRollover = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            NetScrollBarUI.this.myIsRollover = false;
            if (NetScrollBarUI.this.myIsRollover != NetScrollBarUI.this.myWasRollover) {
                NetScrollBarUI.this.scrollbar.repaint(NetScrollBarUI.this.thumbRect);
                NetScrollBarUI.this.myWasRollover = NetScrollBarUI.this.myIsRollover;
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (NetScrollBarUI.this.getThumbBounds().contains(evt.getX(), evt.getY())) {
                NetScrollBarUI.this.myIsRollover = true;
            }
            super.mouseDragged(evt);
            if (NetScrollBarUI.this.scrollbar.getOrientation() == 0) {
                NetScrollBarUI.this.scrollbar.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            if (NetScrollBarUI.this.getThumbBounds().contains(evt.getX(), evt.getY())) {
                NetScrollBarUI.this.myIsRollover = true;
                if (NetScrollBarUI.this.myIsRollover != NetScrollBarUI.this.myWasRollover) {
                    NetScrollBarUI.this.scrollbar.repaint(NetScrollBarUI.this.thumbRect);
                    NetScrollBarUI.this.myWasRollover = NetScrollBarUI.this.myIsRollover;
                }
            } else {
                NetScrollBarUI.this.myIsRollover = false;
                if (NetScrollBarUI.this.myIsRollover != NetScrollBarUI.this.myWasRollover) {
                    NetScrollBarUI.this.scrollbar.repaint(NetScrollBarUI.this.thumbRect);
                    NetScrollBarUI.this.myWasRollover = NetScrollBarUI.this.myIsRollover;
                }
            }
        }
    }
}

