/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.scrollbar.NetScrollPaneLayout;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.Footer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalScrollPaneUI;

public class NetScrollPaneUI
extends MetalScrollPaneUI {
    protected PropertyChangeListener myBorderHandler;

    public static ComponentUI createUI(JComponent component) {
        return new NetScrollPaneUI();
    }

    @Override
    protected void installDefaults(JScrollPane jScrollpane) {
        super.installDefaults(jScrollpane);
        jScrollpane.putClientProperty("JComponent.sizeVariant", "small");
        if (jScrollpane.getParent() instanceof JTabbedPane) {
            jScrollpane.putClientProperty("contentBorderPainted", Boolean.FALSE);
        }
        if (jScrollpane.getLayout() == null || jScrollpane.getLayout() instanceof UIResource) {
            jScrollpane.setLayout(new NetScrollPaneLayout());
        }
        this.removeViewportBorderWhenInTabbedPane(jScrollpane);
    }

    private void removeViewportBorderWhenInTabbedPane(JScrollPane jScrollpane) {
        Container parent = jScrollpane.getParent();
        if (parent instanceof JTabbedPane && NetUtils.lookAndFeelCanReplace(jScrollpane.getViewportBorder())) {
            jScrollpane.setViewportBorder(new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0));
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane scrollPane) {
        super.uninstallDefaults(scrollPane);
        if (scrollPane.getLayout() instanceof NetScrollPaneLayout) {
            ((NetScrollPaneLayout)scrollPane.getLayout()).uninstallDefaults();
        }
        this.scrollpane.putClientProperty("contentBorderPainted", null);
    }

    @Override
    public void installListeners(JScrollPane scrollPane) {
        super.installListeners(scrollPane);
        scrollPane.addPropertyChangeListener(this.getBorderHandler(scrollPane));
    }

    @Override
    public void uninstallListeners(JScrollPane scrollPane) {
        super.uninstallListeners(scrollPane);
        scrollPane.removePropertyChangeListener(this.myBorderHandler);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            GradientUtils.drawVerticalBackgroundGradient((Container)c, g, 1);
            Component view = this.scrollpane.getViewport().getView();
            Insets insets = c.getInsets();
            if (view instanceof JPanel || view instanceof AbstractButton) {
                RectangularShape fill = NetUtils.getOutline(c, 2, 1, c.getWidth() - 4, c.getHeight() - insets.bottom + 1);
                GradientUtils.drawVerticalBackgroundGradient((Container)this.scrollpane, g, fill);
            }
        }
        this.paint(g, c);
    }

    protected PropertyChangeListener getBorderHandler(JScrollPane scrollPane) {
        if (this.myBorderHandler == null) {
            this.myBorderHandler = this.createBorderHandler();
        }
        return this.myBorderHandler;
    }

    protected PropertyChangeListener createBorderHandler() {
        return new BorderHandler();
    }

    private void setFloatingPaneContainer(Component source) {
        Container previousParent = null;
        Container c = source.getParent();
        while (c != null) {
            if (c instanceof JSplitPane) {
                if (previousParent instanceof JPanel) {
                    ((JPanel)previousParent).putClientProperty("OrangeTouch.floatingPane", true);
                    return;
                }
                return;
            }
            if (c instanceof JTabbedPane || c instanceof JScrollPane) {
                return;
            }
            previousParent = c;
            c = c.getParent();
        }
    }

    protected class BorderHandler
    implements PropertyChangeListener {
        protected BorderHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("viewportBorder".equals(evt.getPropertyName()) && NetScrollPaneUI.this.scrollpane != null) {
                if (NetScrollPaneUI.this.scrollpane.getVerticalScrollBar() != null) {
                    NetScrollPaneUI.this.scrollpane.getVerticalScrollBar().repaint();
                    NetScrollPaneUI.this.scrollpane.getVerticalScrollBar().revalidate();
                }
                if (NetScrollPaneUI.this.scrollpane.getHorizontalScrollBar() != null) {
                    NetScrollPaneUI.this.scrollpane.getHorizontalScrollBar().repaint();
                    NetScrollPaneUI.this.scrollpane.getHorizontalScrollBar().revalidate();
                }
            }
            if ("OceanTouch.footerComponent".equals(evt.getPropertyName())) {
                Footer footer = (Footer)evt.getNewValue();
                Footer oldFooter = (Footer)evt.getOldValue();
                if (oldFooter != null) {
                    NetScrollPaneUI.this.scrollpane.remove(oldFooter);
                }
                if (footer != null) {
                    NetScrollPaneUI.this.scrollpane.add(footer);
                }
                NetScrollPaneUI.this.scrollpane.revalidate();
                NetScrollPaneUI.this.scrollpane.repaint();
            }
            if (NetScrollPaneUI.this.scrollpane == null || !"ancestor".equals(evt.getPropertyName()) || evt.getNewValue() != NetScrollPaneUI.this.scrollpane.getParent()) {
                return;
            }
            if ("ancestor".equals(evt.getPropertyName())) {
                NetScrollPaneUI.this.setFloatingPaneContainer(NetScrollPaneUI.this.scrollpane);
            }
            NetScrollPaneUI.this.removeViewportBorderWhenInTabbedPane(NetScrollPaneUI.this.scrollpane);
        }
    }
}

