/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.RolloverHandler;
import com.nokia.laf.painters.BackgroundPainter;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalSliderUI;

public class NetSliderUI
extends MetalSliderUI {
    protected static Color theFilledColor;
    protected static Color theDisabledColor;
    protected static Color theTickColor;
    public static Color theLightTrackHighlight;
    public static Color theDarkTrackHighlight;
    public static Color theShadowColor;
    public static int theTickBuffer;
    protected MouseInputListener myMouseHandler = new MouseHandler();
    RolloverHandler myRolloverHandler = new RolloverHandler();

    public static ComponentUI createUI(JComponent c) {
        return new NetSliderUI();
    }

    protected NetSliderUI() {
    }

    @Override
    protected void installKeyboardActions(JSlider jSlider) {
        if (ComponentUtils.isReadOnly(jSlider)) {
            return;
        }
        super.installKeyboardActions(jSlider);
    }

    @Override
    public void installUI(JComponent c) {
        if (theFilledColor == null) {
            theFilledColor = UIManager.getColor("Slider.filledColor");
            theDisabledColor = UIManager.getColor("Slider.disabledColor");
            theTickColor = UIManager.getColor("Slider.tickColor");
            theLightTrackHighlight = UIManager.getColor("Slider.lightTrackHighlight");
            theDarkTrackHighlight = UIManager.getColor("Slider.darkTrackHighlight");
            theShadowColor = UIManager.getColor("Slider.shadowColor");
            theTickBuffer = 2;
        }
        super.installUI(c);
    }

    @Override
    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        boolean readOnly = ComponentUtils.isReadOnly(jSlider);
        if (readOnly) {
            jSlider.removeMouseListener(this.trackListener);
            jSlider.removeMouseMotionListener(this.trackListener);
        } else {
            this.myRolloverHandler.installTo(jSlider);
            jSlider.addMouseListener(this.myMouseHandler);
        }
        ReadOnlyHandler.getInstance().installTo(jSlider);
        jSlider.setFocusTraversalKeysEnabled(!readOnly);
    }

    @Override
    public int getTickLength() {
        return this.slider.getOrientation() == 0 ? tickLength + 4 - 2 : tickLength + 4 + 3;
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        super.uninstallListeners(jSlider);
        this.myRolloverHandler.uninstallFrom(jSlider);
        jSlider.removeMouseListener(this.myMouseHandler);
        ReadOnlyHandler.getInstance().uninstallFrom(jSlider);
    }

    @Override
    protected int getTrackWidth() {
        return super.getTrackWidth() - 1;
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        size.width = 16;
        size.height = 16;
        return size;
    }

    @Override
    protected int getThumbOverhang() {
        if (this.slider.getOrientation() == 0) {
            return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
        }
        return (int)(this.getThumbSize().getWidth() - (double)this.getTrackWidth()) / 2;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (c.getBackground() instanceof BackgroundPainter) {
                BackgroundPainter gc = (BackgroundPainter)((Object)c.getBackground());
                gc.paintBackground(g, c);
                gc.paintBorderContour(g, c, c.getWidth(), c.getHeight());
            } else {
                GradientUtils.drawVerticalBackgroundGradient(c, g);
            }
        }
        this.paint(g, c);
    }

    @Override
    protected void paintHorizontalLabel(Graphics g, int value, Component labelComponent) {
        if (labelComponent != null) {
            if (labelComponent.getForeground() instanceof UIResource) {
                labelComponent.setForeground(NetLookAndFeel.getCurrentTheme().getControlInfo());
            }
            super.paintHorizontalLabel(g, value, labelComponent);
        }
    }

    @Override
    protected void paintVerticalLabel(Graphics g, int value, Component labelComponent) {
        if (labelComponent != null) {
            if (labelComponent.getForeground() instanceof UIResource) {
                labelComponent.setForeground(NetLookAndFeel.getCurrentTheme().getControlInfo());
            }
            super.paintVerticalLabel(g, value, labelComponent);
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        boolean leftToRight = ComponentUtils.isLeftToRight(this.slider);
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        if (this.slider.getOrientation() == 0) {
            ImageIcon rightEdge;
            ImageIcon leftEdge;
            ImageIcon midTrack;
            if (this.slider.isEnabled() && !ComponentUtils.isReadOnly(this.slider)) {
                midTrack = (ImageIcon)UIManager.get("Slider.midTrack");
                leftEdge = (ImageIcon)UIManager.get("Slider.leftEdge");
                rightEdge = (ImageIcon)UIManager.get("Slider.rightEdge");
            } else {
                midTrack = (ImageIcon)UIManager.get("Slider.disabledMidTrack");
                leftEdge = (ImageIcon)UIManager.get("Slider.disabledLeftEdge");
                rightEdge = (ImageIcon)UIManager.get("Slider.disabledRightEdge");
            }
            g.drawImage(midTrack.getImage(), trackLeft, trackTop - 2, trackRight - trackLeft - 1, midTrack.getIconHeight(), null);
            g.drawImage(leftEdge.getImage(), trackLeft, trackTop - 2, leftEdge.getIconWidth(), leftEdge.getIconHeight(), null);
            g.drawImage(rightEdge.getImage(), trackRight - 1, trackTop - 2, rightEdge.getIconWidth(), rightEdge.getIconHeight(), null);
        } else {
            ImageIcon bottomEdge;
            ImageIcon topEdge;
            ImageIcon midTrack;
            if (this.slider.isEnabled() && !ComponentUtils.isReadOnly(this.slider)) {
                midTrack = (ImageIcon)UIManager.get("Slider.verticalMidTrack");
                topEdge = (ImageIcon)UIManager.get("Slider.topEdge");
                bottomEdge = (ImageIcon)UIManager.get("Slider.bottomEdge");
            } else {
                midTrack = (ImageIcon)UIManager.get("Slider.disabledVerticalMidTrack");
                topEdge = (ImageIcon)UIManager.get("Slider.disabledTopEdge");
                bottomEdge = (ImageIcon)UIManager.get("Slider.disabledBottomEdge");
            }
            g.drawImage(midTrack.getImage(), trackLeft, trackTop, midTrack.getIconWidth(), trackBottom - trackTop - 1, null);
            g.drawImage(topEdge.getImage(), trackLeft, trackTop - 1, topEdge.getIconWidth(), topEdge.getIconHeight(), null);
            g.drawImage(bottomEdge.getImage(), trackLeft, trackBottom - 5, bottomEdge.getIconWidth(), bottomEdge.getIconHeight(), null);
        }
        if (this.filledSlider) {
            int middleOfThumb = 0;
            int fillTop = 0;
            int fillLeft = 0;
            int fillBottom = 0;
            int fillRight = 0;
            if (this.slider.getOrientation() == 0) {
                middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
                middleOfThumb -= this.trackRect.x;
                fillTop = !this.slider.isEnabled() ? trackTop : trackTop - 1;
                int n = fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom - 1;
                if (!this.drawInverted()) {
                    fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft + 1;
                    fillRight = middleOfThumb;
                } else {
                    fillLeft = middleOfThumb;
                    fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight - 2;
                }
            } else {
                middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
                middleOfThumb -= this.trackRect.y;
                fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft;
                int n = fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight + 1;
                if (!this.drawInverted()) {
                    fillTop = middleOfThumb;
                    fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom;
                } else {
                    fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                    fillBottom = middleOfThumb;
                }
            }
            if (this.slider.isEnabled()) {
                g.setColor(theFilledColor);
                if (this.slider.getOrientation() == 0) {
                    g.fillRect(fillLeft, fillTop, fillRight - fillLeft, fillBottom - fillTop + 1);
                    g.fillOval(trackLeft, trackTop, trackBottom - trackTop, trackBottom - trackTop);
                    g.setColor(UIManager.getColor("Slider.theFilledColor"));
                } else {
                    g.fillRect(fillLeft + 1, fillTop + 1, fillRight - fillLeft, fillBottom - fillTop - 3);
                    g.fillOval(trackLeft + 2, trackBottom - 7, trackRight - trackLeft, trackRight - trackLeft);
                    g.setColor(UIManager.getColor("Slider.theFilledColor"));
                }
            }
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    @Override
    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        if (this.slider.getOrientation() == 1) {
            this.slider.repaint();
        }
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? theTickColor : theDisabledColor);
        g.drawLine(x, theTickBuffer, x, theTickBuffer + tickLength / 2 - 1);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? theTickColor : theDisabledColor);
        g.drawLine(x, theTickBuffer, x, theTickBuffer + (tickLength - 1));
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? theTickColor : theDisabledColor);
        if (ComponentUtils.isLeftToRight(this.slider)) {
            g.drawLine(theTickBuffer, y, theTickBuffer + tickLength / 2 - 1, y);
        } else {
            g.drawLine(0, y, tickLength / 2, y);
        }
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? theTickColor : theDisabledColor);
        if (ComponentUtils.isLeftToRight(this.slider)) {
            g.drawLine(theTickBuffer, y, theTickBuffer + tickLength - 1, y);
        } else {
            g.drawLine(0, y, tickLength, y);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        if (this.slider.getOrientation() == 0) {
            UIManager.getIcon("Slider.horizontalThumbIcon").paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
        } else {
            UIManager.getIcon("Slider.verticalThumbIcon").paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
        }
    }

    public class MouseHandler
    extends MouseInputAdapter {
        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            NetSliderUI.this.slider.putClientProperty("componentPressed", true);
            NetSliderUI.this.slider.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            NetSliderUI.this.slider.putClientProperty("componentPressed", false);
        }
    }
}

