/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetButtonUI;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetSpinnerUI;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicBorders;

public class NetSpinnerButton
extends JButton {
    private int myDirection;
    private Color myEnabledArrowColor;
    private Color myDisabledArrowColor;
    protected final Border theButtonBorder = new SpinnerButtonBorder();

    public NetSpinnerButton(int direction) {
        this.myDirection = direction;
        this.setBorder(new CompoundBorder(new SpinnerButtonBorder(), new BasicBorders.MarginBorder()));
        this.setFocusable(false);
        this.myEnabledArrowColor = UIManager.getColor("Spinner.enabledArrowColor");
        this.myDisabledArrowColor = UIManager.getColor("Spinner.disabledArrowColor");
        this.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
        this.setUI(new SpinnerButtonUI());
    }

    @Override
    public void updateUI() {
        this.setUI(new SpinnerButtonUI());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        JSpinner spinner = (JSpinner)this.getParent();
        size = Math.max(size, ComponentUtils.isSmall(spinner) ? 3 : 4);
        int y = (h - size) / 2 + 1;
        if (h < 10) {
            int n = y = this.myDirection == 1 ? (h - size) / 2 : (h - size) / 2 + 2;
        }
        if (spinner.getParent() instanceof JTable && this.myDirection == 5) {
            --y;
        }
        if (this.isEnabled()) {
            Color oldColor = g.getColor();
            this.paintTriangle(g, (w - size) / 2 + 1, y + 1, size, this.myDirection, this.isEnabled(), NetLookAndFeel.getWhite());
            g.setColor(oldColor);
        }
        this.paintTriangle(g, (w - size) / 2 + 1, y, size, this.myDirection, this.isEnabled());
        if (spinner.isEnabled() && !this.getModel().isPressed() && !ComponentUtils.isReadOnly(spinner)) {
            int rounding = NetTheme.getComponentOutlineRounding(spinner);
            if (this.myDirection == 1) {
                g.setColor(NetLookAndFeel.getWhite());
                g.drawLine(0, 1, this.getWidth() - rounding / 2 - 1, 1);
            } else {
                Color oldColor = g.getColor();
                g.setColor(UIManager.getColor("TextComponent.disabledFill"));
                g.drawLine(0, this.getHeight() - 2, this.getWidth() - rounding / 2 - 1, this.getHeight() - 2);
                g.setColor(oldColor);
            }
        }
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        this.paintTriangle(g, x, y, size, direction, isEnabled, null);
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled, Color arrowColor) {
        Color oldColor = g.getColor();
        int j = 0;
        int mid = size / 2 - 1;
        g.translate(x, y);
        if (arrowColor == null) {
            g.setColor(isEnabled && !ComponentUtils.isReadOnly((JComponent)this.getParent()) ? this.myEnabledArrowColor : this.myDisabledArrowColor);
            if (this.model.isRollover() && !this.model.isPressed()) {
                g.setColor(NetTheme.getHoverColor());
            }
        } else {
            g.setColor(arrowColor);
        }
        switch (direction) {
            case 1: {
                int i = 0;
                while (i < size) {
                    g.drawLine(mid - i, i, mid + i, i);
                    ++i;
                }
                break;
            }
            case 5: {
                j = -1;
                int i = size - 1;
                while (i >= 0) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                    --i;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    private class SpinnerButtonBorder
    extends AbstractBorder {
        private SpinnerButtonBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            boolean paintAsDisabled;
            int rounding = NetTheme.getComponentOutlineRounding((JComponent)c);
            Object oldAa = NetUtils.antiAliasingOn(g);
            NetSpinnerButton btn = (NetSpinnerButton)c;
            JSpinner spinner = (JSpinner)btn.getParent();
            ButtonModel buttonModel = btn.getModel();
            boolean isEnabled = btn.isEnabled();
            g.setColor(buttonModel.isRollover() && !buttonModel.isPressed() ? NetTheme.getHoverColor() : NetTheme.getComponentOutlineColor());
            Shape roundRect = this.getOutlineShape(c, x, y, width, height, rounding);
            Color oldColor = g.getColor();
            boolean bl = paintAsDisabled = !isEnabled || ComponentUtils.isReadOnly(spinner);
            if (paintAsDisabled) {
                g.setColor(NetTheme.getDisabledComponentOutlineColor());
            }
            ((Graphics2D)g).draw(roundRect);
            if (!paintAsDisabled) {
                if (this.paintAsHovered(spinner, buttonModel)) {
                    g.setColor(NetTheme.getHoverColor());
                } else if (this.paintAsFocused(spinner)) {
                    g.setColor(NetLookAndFeel.getFocusColor());
                }
            }
            g.drawLine(0, y, 0, y + height);
            if (NetSpinnerButton.this.myDirection == 1) {
                g.setColor(paintAsDisabled ? NetTheme.getDisabledComponentOutlineColor() : NetTheme.getComponentOutlineColor());
                g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
            }
            g.setColor(oldColor);
            NetUtils.setAntialiasing(g, oldAa);
        }

        private boolean paintAsFocused(JSpinner spinner) {
            return spinner.getUI() instanceof NetSpinnerUI && ((NetSpinnerUI)spinner.getUI()).getEditorTextComponent().isFocusOwner();
        }

        private boolean paintAsHovered(JSpinner spinner, ButtonModel buttonModel) {
            return NetSpinnerButton.this.isEnabled() && !buttonModel.isPressed() && (buttonModel.isRollover() || ClientPropertyUtil.booleanValue(spinner, "OrangeTouch.editorHovered")) && !(spinner.getParent() instanceof JTable);
        }

        private Shape getOutlineShape(Component c, int x, int y, int width, int height, int rounding) {
            if (NetSpinnerButton.this.myDirection == 1) {
                return NetUtils.getRoundedRect((JComponent)c, x - 100, y, width + 100, height + 100, rounding);
            }
            return NetUtils.getRoundedRect((JComponent)c, x - 100, y - 100, width + 100, height + 100, rounding);
        }
    }

    private class SpinnerButtonUI
    extends NetButtonUI {
        private SpinnerButtonUI() {
        }

        @Override
        protected Shape getOutlineForFill(JComponent comp) {
            int width = comp.getWidth();
            int height = comp.getHeight();
            JSpinner spinner = (JSpinner)NetSpinnerButton.this.getParent();
            int rounding = NetTheme.getComponentOutlineRounding(comp);
            if (spinner != null && spinner.getParent() instanceof JTable) {
                rounding -= 3;
            }
            if (NetSpinnerButton.this.myDirection == 1) {
                return NetUtils.getRoundedRect(comp, 0, 1, width, height, rounding, 5, 7);
            }
            return NetUtils.getRoundedRect(comp, 0, 0, width, height, rounding, 1, 7);
        }
    }
}

