/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetSpinnerButton;
import com.nokia.laf.borders.NetTextFieldBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.text.status.ModifiedStatusHandler;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ReadOnlySetter;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;

public class NetSpinnerUI
extends BasicSpinnerUI
implements PropertyChangeListener,
FocusListener {
    private MouseHandler myMouseHandler = new MouseHandler();
    private ModifiedStatusHandler myModifiedValueHandler = null;
    private static final ArrowButtonHandler theNextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler thePreviousButtonHandler = new ArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent comp) {
        return new NetSpinnerUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.myModifiedValueHandler = ModifiedStatusHandler.create(this.spinner);
        JComponent editor = this.spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)editor).getTextField().setOpaque(false);
            ((JSpinner.DefaultEditor)editor).getTextField().setHorizontalAlignment(2);
            if (editor.getBorder() instanceof UIResource) {
                editor.setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.myModifiedValueHandler.uninstallFrom(this.spinner);
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        JTextComponent field;
        super.installListeners();
        this.spinner.addPropertyChangeListener(this);
        this.spinner.addFocusListener(this);
        JComponent editor = this.spinner.getEditor();
        if (editor instanceof JTextField) {
            editor.addFocusListener(theNextButtonHandler);
            editor.addFocusListener(thePreviousButtonHandler);
        }
        if ((field = this.getEditorTextComponent()) != null) {
            field.addFocusListener(this);
            field.addMouseListener(this.myMouseHandler);
        }
        ReadOnlyHandler.getInstance().installTo(this.spinner);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent field;
        super.uninstallListeners();
        this.spinner.removePropertyChangeListener(this);
        this.spinner.removeFocusListener(this);
        JComponent editor = this.spinner.getEditor();
        if (editor instanceof JTextField) {
            editor.removeFocusListener(theNextButtonHandler);
            editor.removeFocusListener(thePreviousButtonHandler);
        }
        if ((field = this.getEditorTextComponent()) != null) {
            field.removeFocusListener(this);
            field.removeMouseListener(this.myMouseHandler);
        }
        ReadOnlyHandler.getInstance().uninstallFrom(this.spinner);
    }

    @Override
    public void update(Graphics g, JComponent comp) {
        if (comp.isOpaque()) {
            if (comp.getParent() instanceof CellRendererPane) {
                super.update(g, comp);
                return;
            }
            if (comp.getParent() instanceof JTable) {
                JTable table = (JTable)comp.getParent();
                g.setColor(table.getSelectionBackground());
                g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
            } else if (comp.getBackground() instanceof UIResource) {
                GradientUtils.drawVerticalBackgroundGradient(comp, g);
                NetUtils.paintTableCellBackground(g, comp);
            } else {
                super.update(g, comp);
                return;
            }
        }
        this.paint(g, comp);
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        super.paint(g, comp);
    }

    @Override
    protected Component createNextButton() {
        NetSpinnerButton btn = new NetSpinnerButton(1);
        if (ClientPropertyUtil.booleanValue(this.spinner, "OrangeTouch.readOnly")) {
            btn.putClientProperty("OrangeTouch.readOnly", Boolean.TRUE);
        }
        btn.addActionListener(theNextButtonHandler);
        btn.addMouseListener(theNextButtonHandler);
        return btn;
    }

    @Override
    protected Component createPreviousButton() {
        NetSpinnerButton btn = new NetSpinnerButton(5);
        if (ClientPropertyUtil.booleanValue(this.spinner, "OrangeTouch.readOnly")) {
            btn.putClientProperty("OrangeTouch.readOnly", Boolean.TRUE);
        }
        btn.addActionListener(thePreviousButtonHandler);
        btn.addMouseListener(thePreviousButtonHandler);
        return btn;
    }

    @Override
    protected LayoutManager createLayout() {
        return new NetSpinnerLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        JTextComponent field = this.getEditorTextComponent();
        if (this.spinner != null) {
            this.spinner.getEditor().setOpaque(false);
        }
        field.setOpaque(false);
        field.putClientProperty("OrangeTouch.openRightEdge", true);
        if ("editor".equals(evt.getPropertyName())) {
            JTextComponent newEditor;
            JTextComponent oldEditor = this.getEditorTextComponent((Component)evt.getOldValue());
            if (oldEditor != null) {
                oldEditor.removeFocusListener(this);
                oldEditor.removeMouseListener(this.myMouseHandler);
            }
            if ((newEditor = this.getEditorTextComponent((Component)evt.getNewValue())) != null) {
                newEditor.addFocusListener(this);
                newEditor.addMouseListener(this.myMouseHandler);
            }
        } else if ("ancestor".endsWith(propertyName)) {
            if (field.getBorder() == null || field.getBorder() instanceof UIResource) {
                if (evt.getNewValue() instanceof JTable) {
                    this.spinner.putClientProperty("JComponent.sizeVariant", "small");
                    if (this.spinner.isEnabled()) {
                        this.spinner.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                        this.getEditorTextComponent().setBorder(new NetTextFieldBorder(1, 3, 1, 4));
                    }
                } else {
                    field.setBorder(UIManager.getBorder("TextField.border"));
                }
            }
            if (evt.getNewValue() == null && this.spinner != null) {
                this.spinner.putClientProperty("OrangeTouch.editorHovered", false);
            }
        } else if ("OrangeTouch.readOnly".equals(propertyName)) {
            new ReadOnlySetter(this.spinner).setReadOnly(ClientPropertyUtil.booleanValue(this.spinner, "OrangeTouch.readOnly"));
        } else if ("JComponent.sizeVariant".equals(propertyName)) {
            this.getEditorTextComponent().putClientProperty("JComponent.sizeVariant", evt.getNewValue());
            Component[] componentArray = this.spinner.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                ((JComponent)child).putClientProperty("JComponent.sizeVariant", evt.getNewValue());
                ++n2;
            }
        }
    }

    JTextComponent getEditorTextComponent(Component editor) {
        if (editor instanceof JTextComponent) {
            return (JTextComponent)editor;
        }
        if (this.spinner.getEditor() instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.spinner.getEditor();
            return defaultEditor.getTextField();
        }
        return null;
    }

    JTextComponent getEditorTextComponent() {
        return this.getEditorTextComponent(this.spinner.getEditor());
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        JTextField tf;
        super.replaceEditor(oldEditor, newEditor);
        if (oldEditor instanceof JTextField) {
            tf = (JTextField)oldEditor;
            tf.removeFocusListener(theNextButtonHandler);
            tf.removeFocusListener(thePreviousButtonHandler);
        }
        if (newEditor instanceof JTextField) {
            tf = (JTextField)newEditor;
            if (tf.getFont() instanceof UIResource) {
                tf.setFont(this.spinner.getFont());
            }
            tf.addFocusListener(theNextButtonHandler);
            tf.addFocusListener(thePreviousButtonHandler);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JComponent editor = this.spinner.getEditor();
        if (focusEvent.getSource() == this.getEditorTextComponent()) {
            this.spinner.repaint();
        }
        if (this.spinner.getParent() instanceof JTable && editor instanceof JTextComponent && editor.isEnabled() && ((JTextComponent)editor).isEditable()) {
            editor.requestFocusInWindow();
        }
        this.spinner.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.getEditorTextComponent()) {
            this.spinner.repaint();
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener,
    UIResource,
    FocusListener {
        private final Timer autoRepeatTimer;
        private final boolean isNext;
        private JSpinner spinner = null;
        private JButton arrowButton = null;

        ArrowButtonHandler(String name, boolean isNext) {
            super(name);
            this.isNext = isNext;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent e) {
            Object src = e.getSource();
            while (src instanceof Component && !(src instanceof JSpinner)) {
                src = ((Component)src).getParent();
            }
            return src instanceof JSpinner ? (JSpinner)src : null;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JSpinner jSpinner = this.spinner;
            if (!(evt.getSource() instanceof Timer)) {
                jSpinner = this.eventToSpinner(evt);
                if (evt.getSource() instanceof JButton) {
                    this.arrowButton = (JButton)evt.getSource();
                }
            } else if (this.arrowButton != null && !this.arrowButton.getModel().isPressed() && this.autoRepeatTimer.isRunning()) {
                this.autoRepeatTimer.stop();
                jSpinner = null;
                this.arrowButton = null;
            }
            if (jSpinner != null) {
                try {
                    Object value;
                    int calendarField = this.getCalendarField(jSpinner);
                    jSpinner.commitEdit();
                    if (calendarField != -1) {
                        ((SpinnerDateModel)jSpinner.getModel()).setCalendarField(calendarField);
                    }
                    Object object = value = this.isNext ? jSpinner.getNextValue() : jSpinner.getPreviousValue();
                    if (value != null) {
                        jSpinner.setValue(value);
                        this.select(jSpinner);
                    }
                }
                catch (IllegalArgumentException iae) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
                catch (ParseException pe) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
            }
        }

        private void select(JSpinner jSpinner) {
            JComponent editor = jSpinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                SpinnerDateModel model;
                DateFormat.Field field;
                Object value;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                SimpleDateFormat format = dateEditor.getFormat();
                if (format != null && (value = jSpinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((model = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator iterator = ((Format)format).formatToCharacterIterator(value);
                        if (!this.select(ftf, iterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(ftf, iterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean select(JFormattedTextField ftf, AttributedCharacterIterator iterator, DateFormat.Field field) {
            int max = ftf.getDocument().getLength();
            iterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> attrs;
                if ((attrs = iterator.getAttributes()) == null || !attrs.containsKey(field)) continue;
                int start = iterator.getRunStart(field);
                int end = iterator.getRunLimit(field);
                if (start != -1 && end != -1 && start <= max && end <= max) {
                    ftf.select(start, end);
                }
                return true;
            } while (iterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner jSpinner) {
            JComponent editor = jSpinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                int start = ftf.getSelectionStart();
                JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
                if (formatter instanceof InternationalFormatter) {
                    Format.Field[] fields = ((InternationalFormatter)formatter).getFields(start);
                    int counter = 0;
                    while (counter < fields.length) {
                        int calendarField;
                        if (fields[counter] instanceof DateFormat.Field && (calendarField = fields[counter] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fields[counter]).getCalendarField()) != -1) {
                            return calendarField;
                        }
                        ++counter;
                    }
                }
            }
            return -1;
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (SwingUtilities.isLeftMouseButton(evt) && evt.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(evt);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
                this.spinner.revalidate();
                this.spinner.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
            this.arrowButton = null;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.spinner == this.eventToSpinner(e)) {
                if (this.autoRepeatTimer.isRunning()) {
                    this.autoRepeatTimer.stop();
                }
                this.spinner = null;
                if (this.arrowButton != null) {
                    ButtonModel model = this.arrowButton.getModel();
                    model.setPressed(false);
                    model.setArmed(false);
                    this.arrowButton = null;
                }
            }
        }

        private void focusSpinnerIfNecessary() {
            if (ComponentUtils.isReadOnly(this.spinner)) {
                return;
            }
            Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (fo == null || !SwingUtilities.isDescendingFrom(fo, this.spinner))) {
                FocusTraversalPolicy ftp;
                Component child;
                Container root = this.spinner;
                if (!root.isFocusCycleRoot()) {
                    root = root.getFocusCycleRootAncestor();
                }
                if (root != null && (child = (ftp = root.getFocusTraversalPolicy()).getComponentAfter(root, this.spinner)) != null && SwingUtilities.isDescendingFrom(child, this.spinner)) {
                    child.requestFocus();
                }
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            NetSpinnerUI.this.spinner.putClientProperty("OrangeTouch.editorHovered", true);
            NetSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            NetSpinnerUI.this.spinner.putClientProperty("OrangeTouch.editorHovered", true);
            NetSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NetSpinnerUI.this.spinner.putClientProperty("OrangeTouch.editorHovered", false);
            NetSpinnerUI.this.spinner.repaint();
        }
    }

    private static class NetSpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;
        private static Dimension theZeroSize = new Dimension(0, 0);

        private NetSpinnerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            if ("Next".equals(name)) {
                this.nextButton = c;
            } else if ("Previous".equals(name)) {
                this.previousButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            }
        }

        @Override
        public void removeLayoutComponent(Component c) {
            Component tempC = c;
            if (tempC == this.nextButton) {
                tempC = null;
            } else if (tempC == this.previousButton) {
                this.previousButton = null;
            } else if (tempC == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? theZeroSize : c.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            Dimension editorD = this.preferredSize(this.editor);
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            int buttonsWidth = height - (insets.top + insets.bottom) - 2;
            boolean small = ComponentUtils.isSmall(parent);
            int editorHeight = height - (insets.top + insets.bottom);
            buttonsWidth = !(parent.getParent() instanceof JTable) ? Math.max(small ? 20 : 32, buttonsWidth) : (buttonsWidth += 3);
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth - insets.right;
                buttonsX = width - buttonsWidth - insets.right;
            } else {
                buttonsX = insets.left;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - insets.left - buttonsWidth - insets.right;
            }
            int nextY = insets.top;
            int nextHeight = height / 2 + height % 2 - nextY;
            int previousY = insets.top + nextHeight;
            int previousHeight = height - previousY - insets.bottom - 1;
            if (parent.getParent() instanceof JTable) {
                ++previousHeight;
                ++nextHeight;
            }
            this.setBounds(this.editor, editorX, insets.top, editorWidth, editorHeight);
            this.setBounds(this.nextButton, buttonsX, nextY, buttonsWidth, nextHeight);
            this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }
}

