/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class NetSplitPaneDivider
extends BasicSplitPaneDivider {
    protected static Color theDividerLightShaodow;
    protected static Color theBackground;
    protected static Color theShadowColor;
    protected static Color theDarkShadowColor;
    protected static Icon theUpArrowIcon;
    protected static Icon theDownArrowIcon;
    protected static Icon theLeftArrowIcon;
    protected static Icon theRightArrowIcon;
    protected static Icon theGribAreaHorizontalIcon;
    protected static Icon theGribAreaVerticalIcon;
    protected static final int ARROW_HEIGHT = 4;
    protected static final int ARROW_WIDTH = 7;
    protected static final int BUMP_HEIGHT = 14;

    public NetSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new NetDividerLayout());
        if (theShadowColor == null) {
            theShadowColor = UIManager.getColor("SplitPane.shadow");
            theDarkShadowColor = UIManager.getColor("SplitPane.darkShadow");
            theDividerLightShaodow = UIManager.getColor("SplitPane.OrangeTouch.dividerLightShadow");
            theUpArrowIcon = NetUtils.loadIcon("splitpane_arrow_up.gif");
            theDownArrowIcon = NetUtils.loadIcon("splitpane_arrow_down.gif");
            theLeftArrowIcon = NetUtils.loadIcon("splitpane_arrow_left.gif");
            theRightArrowIcon = NetUtils.loadIcon("splitpane_arrow_right.gif");
            theGribAreaHorizontalIcon = NetUtils.loadIcon("splitpane_grib_horizontal.png");
            theGribAreaVerticalIcon = NetUtils.loadIcon("splitpane_grib_vertical.png");
            theBackground = NetLookAndFeel.getWhite();
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(theBackground);
        Rectangle clip = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Insets insets = this.getInsets();
        GradientUtils.drawVerticalBackgroundGradient((Container)this, g, clip);
        Dimension size = this.getSize();
        Icon gribIcon = null;
        int drawX = 0;
        int drawY = 0;
        if (insets != null) {
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            if (this.orientation == 1) {
                drawX = (this.getDividerSize() - 4) / 2 + 1;
                drawY += insets.top;
                drawY += (size.height - 14) / 2;
                gribIcon = theGribAreaVerticalIcon;
            } else {
                drawX += insets.left;
                drawX += (size.width - 14) / 2;
                drawY = (this.getDividerSize() - 4) / 2;
                gribIcon = theGribAreaHorizontalIcon;
            }
        }
        if (gribIcon != null) {
            gribIcon.paintIcon(this, g, drawX, drawY);
        }
        super.paint(g);
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        return new LeftOneTouchButton();
    }

    @Override
    protected JButton createRightOneTouchButton() {
        return new RightOneTouchButton();
    }

    protected class LeftOneTouchButton
    extends OneTouchButton {
        protected LeftOneTouchButton() {
        }

        @Override
        public void paint(Graphics g) {
            if (NetSplitPaneDivider.this.splitPane != null) {
                if (NetSplitPaneDivider.this.orientation == 1) {
                    int iconWidth = theLeftArrowIcon.getIconWidth();
                    theLeftArrowIcon.paintIcon(this, g, this.getWidth() - iconWidth, 0);
                } else {
                    int iconHeight = theUpArrowIcon.getIconHeight();
                    theUpArrowIcon.paintIcon(this, g, 0, this.getHeight() - iconHeight);
                }
            }
        }
    }

    protected class NetDividerLayout
    implements LayoutManager {
        protected NetDividerLayout() {
        }

        @Override
        public void layoutContainer(Container comp) {
            Insets insets = NetSplitPaneDivider.this.getInsets();
            if (NetSplitPaneDivider.this.leftButton != null && NetSplitPaneDivider.this.rightButton != null && comp == NetSplitPaneDivider.this) {
                if (NetSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    if (NetSplitPaneDivider.this.orientation == 0) {
                        int oneTouchOffset = NetSplitPaneDivider.this.getWidth() / 2 + 14;
                        int blockSize = NetSplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                        }
                        blockSize = Math.min(blockSize, 6);
                        int arrowY = (NetSplitPaneDivider.this.getDividerSize() - 4) / 2 - 1;
                        NetSplitPaneDivider.this.rightButton.setBounds(oneTouchOffset, arrowY, 9, 4);
                        NetSplitPaneDivider.this.leftButton.setBounds(oneTouchOffset + NetSplitPaneDivider.this.rightButton.getWidth(), arrowY, 7, 4);
                    } else {
                        int oneTouchOffset = NetSplitPaneDivider.this.getHeight() / 2 + 14;
                        int blockSize = NetSplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                        }
                        blockSize = Math.min(blockSize, 6);
                        int arrowX = (NetSplitPaneDivider.this.getDividerSize() - 4) / 2 - 1;
                        NetSplitPaneDivider.this.leftButton.setBounds(arrowX, oneTouchOffset, 4, 9);
                        NetSplitPaneDivider.this.rightButton.setBounds(arrowX, oneTouchOffset + NetSplitPaneDivider.this.leftButton.getHeight(), 4, 7);
                    }
                } else {
                    NetSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    NetSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }
    }

    protected class OneTouchButton
    extends JButton {
        public OneTouchButton() {
            int buttonWidth;
            int buttonHeight;
            if (NetSplitPaneDivider.this.orientation == 1) {
                buttonHeight = 6;
                buttonWidth = 4;
            } else {
                buttonHeight = 4;
                buttonWidth = 6;
            }
            this.setOpaque(false);
            this.setMinimumSize(new Dimension(buttonWidth, buttonHeight));
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }

    protected class RightOneTouchButton
    extends OneTouchButton {
        protected RightOneTouchButton() {
        }

        @Override
        public void paint(Graphics g) {
            if (NetSplitPaneDivider.this.splitPane != null) {
                if (NetSplitPaneDivider.this.orientation == 1) {
                    theRightArrowIcon.paintIcon(this, g, 1, 0);
                } else {
                    theDownArrowIcon.paintIcon(this, g, 0, 1);
                }
            }
        }
    }
}

