/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.widgets.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

class NetTabScrollButton
extends JButton
implements UIResource {
    public static final BufferedImage SCROLL_ARROW = ImageUtils.readImage("tabbedpane_scrollarrow.png");
    public static final BufferedImage DISABLED_SCROLL_ARROW = ImageUtils.readImage("tabbedpane_scrollarrow_disabled.png");

    public NetTabScrollButton(int direction) {
        BufferedImage image = ImageUtils.createRotatedImage(SCROLL_ARROW, direction);
        BufferedImage disabledImage = ImageUtils.createRotatedImage(DISABLED_SCROLL_ARROW, direction);
        this.setIcon(new ImageIcon(image));
        this.setDisabledIcon(new ImageIcon(disabledImage));
        this.putClientProperty("BlueTouch.rolloverHighlightDisabled", Boolean.TRUE);
        this.setRequestFocusEnabled(false);
        this.setBorder(UIManager.getBorder("TabbePane.scrollButtonBorder"));
        this.setPreferredSize(new Dimension(15, 14));
        this.setMinimumSize(this.getPreferredSize());
        if (direction == 3 || direction == 7) {
            this.setMargin(new Insets(0, direction == 3 ? 2 : 0, 0, 0));
            this.setVerticalAlignment(1);
        } else {
            this.setMargin(new Insets(1, 0, 0, 0));
            this.setVerticalAlignment(0);
        }
    }
}

