/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTabScrollButton;
import com.nokia.laf.NetTheme;
import com.nokia.laf.tabbedpane.TabCloseListenerSupport;
import com.nokia.laf.tabbedpane.TabbedPaneOverflowSupport;
import com.nokia.laf.tabbedpane.TabbedPaneUtils;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.icons.CloseIcon;
import com.nokia.widgets.icons.OverflowIcon;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;

public class NetTabbedPaneUI
extends MetalTabbedPaneUI
implements PropertyChangeListener,
FocusListener {
    private static final int ROUNDING = NetTheme.getNormalRounding();
    protected MouseMotionListener myMouseMotionHandler = new TabPaneMouseMotionHandler();
    private int myRolloverTabIndex = -1;
    private boolean myIsMouseOnCloseIcon = false;
    protected boolean myContentBorderPainted = true;
    private static Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private TabbedPaneOverflowSupport myOverflowSupport;
    private TabCloseListenerSupport myCloseListenerSupport;
    int myPreviousSelectedTab = -1;
    private boolean myIsMouseDownOnCloseIcon = false;
    private boolean myIsMouseDown = false;
    private CloseIcon myCloseIcon = new CloseIcon();
    protected static Font theSelectedFont;
    private static final String CTRL_F4 = "CTRL+F4";

    public static ComponentUI createUI(JComponent comp) {
        return new NetTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        if (!UIManager.getBoolean("OrangeTouch.TabbedPane.setWrapTabLayoutEnabled")) {
            ((JTabbedPane)c).setTabLayoutPolicy(1);
        }
        this.myOverflowSupport = new TabbedPaneOverflowSupport((JTabbedPane)c);
        super.installUI(c);
        this.myCloseListenerSupport = new TabCloseListenerSupport(this.tabPane);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.myCloseIcon.setStrokeWidth(2);
        Object paintBorder = this.tabPane.getClientProperty("contentBorderPainted");
        if (theSelectedFont == null) {
            theSelectedFont = UIManager.getFont("TabbedPane.selectedFont");
        }
        if (paintBorder != null) {
            this.myContentBorderPainted = Boolean.TRUE.equals(paintBorder);
            this.contentBorderInsets = this.myContentBorderPainted ? UIManager.getInsets("TabbedPane.contentBorderInsets") : ZERO_INSETS;
        }
        this.tabPane.putClientProperty("OrangeTouch.isStandalone", !NetUtils.isInDialog(this.tabPane) || !this.isOnlyTopSegmentPainted());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (!(this.tabAreaBackground instanceof UIResource)) {
                g.setColor(this.tabAreaBackground);
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            } else {
                GradientUtils.drawVerticalBackgroundGradient(c.getParent(), g);
            }
        }
        if (this.isStandalone()) {
            GradientUtils.drawVerticalBackgroundGradient((Container)c, g, 1);
        }
        this.paint(g, c);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.myOverflowSupport.installKeyboardActions();
        InputMap inputMap = this.tabPane.getInputMap(1);
        KeyStroke controlF4 = KeyStroke.getKeyStroke(115, 2);
        inputMap.put(controlF4, CTRL_F4);
        this.tabPane.getActionMap().put(CTRL_F4, new CloseAction());
    }

    @Override
    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.myOverflowSupport.uninstallKeyboardActions();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseMotionListener(this.myMouseMotionHandler);
        this.tabPane.addPropertyChangeListener(this);
        this.tabPane.addFocusListener(this);
        this.myOverflowSupport.installListeners();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseMotionListener(this.myMouseMotionHandler);
        this.tabPane.removePropertyChangeListener(this);
        this.tabPane.removeFocusListener(this);
        this.myOverflowSupport.uninstallListeners();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new NetTabbedPaneScrollLayout();
        }
        return super.createLayoutManager();
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new NetTabSelectionHandler();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isStandalone()) {
            int tabPlacement = this.tabPane.getTabPlacement();
            Insets insets = c.getInsets();
            Dimension size = c.getSize();
            Shape contentShape = null;
            int totalTabHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
            switch (tabPlacement) {
                case 3: {
                    contentShape = NetUtils.getRoundedRectWithSharpCorner(c, insets.left, insets.top, size.width - (insets.right + insets.left), (int)(size.getHeight() - (double)totalTabHeight), ROUNDING, 6);
                    break;
                }
                default: {
                    contentShape = NetUtils.getRoundedRectWithSharpCorner(c, insets.left + 2, insets.top + totalTabHeight + 1, size.width - insets.right - insets.left - 3, (int)(size.getHeight() - (double)(insets.top + insets.bottom) - (double)totalTabHeight - 3.0), ROUNDING, 8);
                }
            }
            GradientUtils.drawVerticalBackgroundGradient((Container)c, g, contentShape);
        }
        super.paint(g, c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("contentBorderPainted".equals(propName)) {
            this.myContentBorderPainted = Boolean.TRUE.equals(evt.getNewValue());
            this.contentBorderInsets = this.myContentBorderPainted ? UIManager.getInsets("TabbedPane.contentBorderInsets") : ZERO_INSETS;
            this.tabPane.revalidate();
            this.tabPane.repaint();
        }
        if ("contentBorderPainted".equals(propName) || "OrangeTouch.paintedContentBorderSegments".equals(propName) || "ancestor".equals(propName)) {
            this.tabPane.putClientProperty("OrangeTouch.isStandalone", !NetUtils.isInDialog(this.tabPane) || !this.isOnlyTopSegmentPainted());
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        Component selectedComponent = this.tabPane.getSelectedComponent();
        if (selectedComponent instanceof JComponent) {
            JComponent comp = (JComponent)selectedComponent;
            Object contentBorderPainted = comp.getClientProperty("contentBorderPainted");
            if (Boolean.TRUE.equals(contentBorderPainted) || contentBorderPainted == null) {
                Insets insets = UIManager.getInsets("TabbedPane.contentBorderInsets");
                insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
                int[] paintedSegments = (int[])this.tabPane.getClientProperty("OrangeTouch.paintedContentBorderSegments");
                if (paintedSegments != null) {
                    boolean paintTop = NetTabbedPaneUI.contains(paintedSegments, 1);
                    boolean paintBottom = NetTabbedPaneUI.contains(paintedSegments, 3);
                    boolean paintLeft = NetTabbedPaneUI.contains(paintedSegments, 2);
                    boolean paintRight = NetTabbedPaneUI.contains(paintedSegments, 4);
                    if (!paintTop) {
                        insets.top = 0;
                    }
                    if (!paintLeft) {
                        insets.left = 0;
                    }
                    if (!paintBottom) {
                        insets.bottom = 0;
                    }
                    if (!paintRight) {
                        insets.right = 0;
                    }
                }
                return insets;
            }
            return ZERO_INSETS;
        }
        return super.getContentBorderInsets(tabPlacement);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rectangles, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        Rectangle tabRect = rectangles[tabIndex];
        if (tabIndex > 0 && this.myOverflowSupport.isInOverflow(tabIndex)) {
            return;
        }
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        Rectangle contentRect = new Rectangle(tabRect);
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        contentRect.width -= insets.left + insets.right;
        String clipped = title;
        if (ClientPropertyUtil.booleanValue(this.tabPane, "OrangeTouch.maxTabWidth") || this.isClosable(this.tabPane)) {
            clipped = this.layoutAndClipLabel(tabPlacement, metrics, tabIndex, title, icon, contentRect, iconRect, textRect, isSelected);
        } else {
            this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        }
        this.paintText(g, tabPlacement, font, metrics, tabIndex, clipped, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        this.paintCloseIcon(g, tabIndex, tabRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rectangles, tabIndex, iconRect, textRect, isSelected);
        this.paintSelectedTabShadow(g, tabIndex, tabRect);
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Integer horizontalTextPosition;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        if ((horizontalTextPosition = ClientPropertyUtil.integerValue(this.tabPane, "OceanTouch.horizontalTextPosition")) == ClientProperties.UNKNOWN_VALUE) {
            horizontalTextPosition = 11;
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, horizontalTextPosition, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    private void paintSelectedTabShadow(Graphics g, int tabIndex, Rectangle tabRect) {
        if (!this.tabPane.isEnabled()) {
            return;
        }
        g.setColor(NetUtils.decodeColor("#D5D5D5"));
        if (this.tabPane.getSelectedIndex() == tabIndex - 1) {
            g.drawLine(tabRect.x + 1, tabRect.y + 4, tabRect.x + 1, tabRect.y + tabRect.height - 1);
        }
        if (this.tabPane.getSelectedIndex() == tabIndex + 1) {
            g.drawLine(tabRect.x + tabRect.width - 1, tabRect.y + 4, tabRect.x + tabRect.width - 1, tabRect.y + tabRect.height - 1);
        }
    }

    private boolean isMouseOnCloseIcon(MouseEvent e) {
        int tab = this.tabForCoordinate(this.tabPane, e.getX(), e.getY());
        if (tab < 0) {
            return false;
        }
        Rectangle tabRect = this.getTabBounds(tab, new Rectangle());
        int closeIconSize = this.myCloseIcon.getIconHeight();
        Point closePosition = this.getCloseIconLocation(tabRect, closeIconSize, tab == this.tabPane.getSelectedIndex());
        return new Rectangle(closePosition.x, closePosition.y, closeIconSize, closeIconSize).contains(e.getPoint());
    }

    private void paintCloseIcon(Graphics g, int tabIndex, Rectangle tabRect, boolean isSelected) {
        if (this.isClosable(this.tabPane)) {
            int closeIconSize = this.myCloseIcon.getIconHeight();
            Point position = this.getCloseIconLocation(tabRect, closeIconSize, isSelected);
            if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(NetTheme.getDisabledComponentOutlineColor());
            } else if (this.myIsMouseOnCloseIcon && this.myRolloverTabIndex >= 0 && tabIndex == this.myRolloverTabIndex) {
                g.setColor(NetTheme.getHoverColor());
            } else if (this.tabPane.isFocusOwner() && tabIndex == this.tabPane.getSelectedIndex()) {
                g.setColor(NetLookAndFeel.getWhite());
            } else {
                g.setColor(NetLookAndFeel.getCurrentTheme().getControlInfo());
            }
            this.myCloseIcon.paintIcon(this.tabPane, g, position.x, position.y);
        }
    }

    protected Point getCloseIconLocation(Rectangle tabRect, int closeIconSize, boolean isSelected) {
        int x = tabRect.x + tabRect.width - closeIconSize - 1;
        int y = tabRect.y + tabRect.height / 2 - closeIconSize / 2 + 1;
        return new Point(x, y);
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        int tabCount = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        int i = this.runCount - 1;
        while (i >= 0) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            int j = start;
            while (j <= end) {
                if (this.rects[j].intersects(clipRect)) {
                    this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
                }
                ++j;
            }
            --i;
        }
        this.paintOverflowTab(g, tabPlacement);
        if (this.myRolloverTabIndex >= 0 && this.myRolloverTabIndex < this.tabPane.getTabCount() && this.getRunForTab(tabCount, selectedIndex) == 0 && this.rects[this.myRolloverTabIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, this.myRolloverTabIndex, iconRect, textRect);
        }
        if (selectedIndex >= 0 && this.getRunForTab(tabCount, selectedIndex) == 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
    }

    public boolean isOverflowShown() {
        return this.myOverflowSupport.hasOverflow();
    }

    protected void paintOverflowTab(Graphics g, int tabPlacement) {
        if (!(this.tabPane.getLayout() instanceof NetTabbedPaneScrollLayout)) {
            return;
        }
        if (!this.isOverflowShown()) {
            return;
        }
        int lastVisibleTab = this.myOverflowSupport.getLastVisibleTab();
        if (lastVisibleTab < 0 || lastVisibleTab >= this.rects.length) {
            return;
        }
        Rectangle lastVisibleTabRect = this.rects[lastVisibleTab];
        int overflowY = lastVisibleTabRect.y;
        if (!this.isHorizontalRun(tabPlacement)) {
            this.myOverflowSupport.setOverflowButtonBounds(this.tabPane.getInsets().left, 100, this.maxTabWidth, 35);
            return;
        }
        this.myOverflowSupport.setOverflowButtonBounds(lastVisibleTabRect.x + lastVisibleTabRect.width, overflowY, 34, this.maxTabHeight);
        Rectangle overflowRect = this.myOverflowSupport.getOverflowRectangle();
        this.paintOverflowTabBackground(g, tabPlacement, overflowRect.x, overflowRect.y, overflowRect.width - 1, overflowRect.height, false);
        this.paintTabBorder(g, tabPlacement, -1, overflowRect.x, overflowRect.y, overflowRect.width - 1, overflowRect.height, false);
        if (this.myOverflowSupport.isOverflowRollovered() && !this.myOverflowSupport.isOverflowVisible() && this.tabPane.isEnabled()) {
            Shape oldClip = g.getClip();
            g.clipRect(overflowRect.x, overflowRect.y, overflowRect.width, overflowRect.height);
            this.drawTabHighlight(g, TabbedPaneUtils.getTabShape(this.tabPane.getTabPlacement(), overflowRect.x, overflowRect.y, overflowRect.width, overflowRect.height));
            g.setClip(oldClip);
        }
        if (!this.myOverflowSupport.isOverflowVisible() && tabPlacement == 1 && this.tabPane.isEnabled()) {
            g.setColor(UIManager.getColor("TabbedPane.bottomShadow"));
            g.drawLine(overflowRect.x + 1, overflowRect.y + overflowRect.height - 1, overflowRect.x + overflowRect.width - 2, overflowRect.y + overflowRect.height - 1);
        }
        this.paintOverflowIcon(g, overflowRect);
    }

    private void paintOverflowIcon(Graphics g, Rectangle overflowRect) {
        Color color;
        OverflowIcon chevron = new OverflowIcon();
        Color color2 = color = this.tabPane.isEnabled() ? NetUtils.decodeColor("#5F5F5F") : UIManager.getColor("Label.disabledForeground");
        if (this.myOverflowSupport.isOverflowRollovered() && !this.myOverflowSupport.isOverflowVisible() && this.tabPane.isEnabled()) {
            color = NetTheme.getHoverColor();
        }
        Rectangle iconPosition = NetUtils.calculateMidPosition(overflowRect, chevron.getIconWidth(), chevron.getIconHeight(), null);
        g.setColor(color);
        chevron.paintIcon(this.tabPane, g, iconPosition.x + 1, iconPosition.y + 2);
    }

    protected JComponent getTabScrollPanel() {
        return this.tabPane;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Font tempFont = font;
        FontMetrics tempMetrics = metrics;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        NetLookAndFeel.toggleTextAntialiasing(g);
        if (isSelected && this.tabPane.isEnabledAt(tabIndex) && this.tabPane.isFocusOwner() && tempFont instanceof UIResource) {
            tempFont = theSelectedFont;
            tempMetrics = g.getFontMetrics(tempFont);
        }
        if (this.tabPane.getTabPlacement() == 2 || this.tabPane.getTabPlacement() == 4) {
            Rectangle tabBounds = new Rectangle();
            this.getTabBounds(tabIndex, tabBounds);
            if (this.tabPane.getIconAt(tabIndex) == null) {
                textRect.x = tabBounds.x + 8;
            }
        }
        String clipped = title;
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            this.paintEnabledText(g, tabPlacement, tempFont, tempMetrics, tabIndex, clipped, textRect, isSelected);
        } else {
            View v = this.getTextViewForTab(tabIndex);
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(UIManager.getColor("Label.disabledForeground"));
                g.setFont(tempFont);
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, clipped, -1, textRect.x, textRect.y + tempMetrics.getAscent());
            }
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void paintEnabledText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            Color foreground = this.tabPane.getForegroundAt(tabIndex);
            Color offsetColor = NetTheme.getTextShadowColor();
            int offset = 1;
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected && foreground instanceof UIResource && this.tabPane.isFocusOwner()) {
                    Color selectedForeground = UIManager.getColor("TabbedPane.selectedForeground");
                    if (selectedForeground != null) {
                        foreground = NetLookAndFeel.getWhite();
                        offsetColor = UIManager.getColor("Button.defaultButtonTextColor");
                        offset = -1;
                    }
                } else if (this.isTabRollovered(tabIndex) && !this.myIsMouseDown) {
                    foreground = NetTheme.getTextHoverColor();
                } else if (!isSelected) {
                    foreground = UIManager.getColor("TabbedPane.unselectedTabForeground");
                }
                NetUtils.paintText(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent(), foreground, offsetColor, offset);
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    private boolean isTabRollovered(int tabIndex) {
        boolean result;
        boolean bl = result = this.myRolloverTabIndex >= 0 && tabIndex == this.myRolloverTabIndex;
        if (this.isClosable(this.tabPane)) {
            return result && !this.myIsMouseOnCloseIcon;
        }
        return result;
    }

    protected String layoutAndClipLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        FontMetrics tempMetrics = metrics;
        iconRect.y = 0;
        textRect.y = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (isSelected && this.tabPane.getFont() instanceof UIResource) {
            tempMetrics = this.tabPane.getFontMetrics(theSelectedFont);
        }
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        String clipped = SwingUtilities.layoutCompoundLabel(this.tabPane, tempMetrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
        iconRect.x = tabRect.x + 5;
        ++iconRect.y;
        textRect.x = tabRect.x + iconRect.width + 6;
        boolean closableTabs = this.isClosable(this.tabPane);
        if (closableTabs) {
            ++textRect.x;
        }
        return clipped;
    }

    @Override
    protected JButton createScrollButton(int direction) {
        if (direction != 5 && direction != 1 && direction != 3 && direction != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new NetTabScrollButton(direction);
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return UIManager.getInsets("TabbedPane.tabInsetsLeftRight");
        }
        return super.getTabInsets(tabPlacement, tabIndex);
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        if (tabPlacement == 2) {
            return UIManager.getInsets("TabbedPane.tabAreaInsetsLeft");
        }
        if (tabPlacement == 4) {
            return UIManager.getInsets("TabbedPane.tabAreaInsetsRight");
        }
        return super.getTabAreaInsets(tabPlacement);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        if (!this.myContentBorderPainted || this.tabPane.getTabCount() == 0) {
            return;
        }
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        boolean paintTop = true;
        boolean paintBottom = true;
        boolean paintLeft = true;
        boolean paintRight = true;
        int topOffset = 0;
        int bottomOffset = 0;
        int[] paintedSegments = (int[])this.tabPane.getClientProperty("OrangeTouch.paintedContentBorderSegments");
        if (paintedSegments != null) {
            paintTop = NetTabbedPaneUI.contains(paintedSegments, 1);
            if (paintTop) {
                topOffset = 1;
            }
            if (paintBottom = NetTabbedPaneUI.contains(paintedSegments, 3)) {
                bottomOffset = 1;
            }
            paintLeft = NetTabbedPaneUI.contains(paintedSegments, 2);
            paintRight = NetTabbedPaneUI.contains(paintedSegments, 4);
        }
        if (paintTop) {
            this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x - topOffset, y, w + 2 * topOffset, h);
        }
        if (paintLeft) {
            this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
        if (paintBottom) {
            this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x - bottomOffset, y, w + 2 * bottomOffset, h);
        }
        if (paintRight) {
            this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    private static boolean contains(int[] array, int value) {
        int idx = 0;
        while (idx < array.length) {
            if (value == array[idx]) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    @Override
    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        this.paintTabBorder(g, tabIndex, x, y, w, h, isSelected);
    }

    @Override
    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        this.paintTabBorder(g, tabIndex, x, y, w, h, isSelected);
    }

    @Override
    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        this.paintTabBorder(g, tabIndex, x, y, w, h, isSelected);
    }

    @Override
    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        Shape oldClip = g.getClip();
        if (isSelected) {
            g.clipRect(x, y, w, h);
        } else {
            g.clipRect(x, y - 1, w + 1, h + 1);
        }
        this.paintTabBorder(g, tabIndex, x, y, w, h + 10, isSelected);
        g.setClip(oldClip);
    }

    private void paintTabBorder(Graphics g, int tabIndex, int x, int y, int width, int height, boolean isSelected) {
        boolean paintAsDisabled;
        Shape tabShape = TabbedPaneUtils.getTabShape(this.tabPane.getTabPlacement(), x, y, width, height);
        if ((!isSelected || !this.tabPane.isFocusOwner()) && tabIndex >= 0 && tabIndex < this.tabPane.getTabCount() && this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            g.setColor(NetLookAndFeel.getWhite());
            this.paintBottomShadowForTab(g, tabIndex, x, y, width, height, isSelected);
        }
        boolean paintAsHovered = this.isTabRollovered(tabIndex) && this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex);
        ColorUIResource hoveroutline = SystemUtils.isOrangeTouch() ? NetTheme.getSelectionColor() : NetTheme.getHoverColor();
        g.setColor(paintAsHovered ? hoveroutline : UIManager.getColor("TabbedPane.darkShadow"));
        boolean bl = paintAsDisabled = tabIndex >= 0 && tabIndex < this.tabPane.getTabCount() && (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex));
        if (paintAsDisabled) {
            g.setColor(NetUtils.isInDialog(this.tabPane) ? NetTheme.getDisabledComponentOutlineColor() : Color.decode("#BFBFBF"));
        }
        Shape oldClip = g.getClip();
        Graphics2D g2 = (Graphics2D)g;
        if (isSelected && this.tabPane.isFocusOwner()) {
            if (!this.tabPane.isEnabledAt(tabIndex) || this.isTabRollovered(tabIndex)) {
                g2.draw(tabShape);
            }
        } else if (isSelected && this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            TabbedPaneUtils.paintEmphasis(this.tabPane, this.tabPane.getTabPlacement(), g2, x, y, width, height, paintAsHovered, hoveroutline);
        } else {
            if (this.tabPane.isEnabled() && tabIndex >= 0 && tabIndex < this.tabPane.getTabCount() && this.tabPane.isEnabledAt(tabIndex)) {
                Color oldColor = g.getColor();
                g.translate(1, -1);
                g.setColor(UIManager.getColor("TabbedPane.tabBorderShadow"));
                g2.draw(tabShape);
                g.translate(-1, 1);
                g.setColor(oldColor);
            }
            g2.draw(tabShape);
        }
        g.setClip(oldClip);
    }

    protected void paintBottomShadowForTab(Graphics g, int tabIndex, int x, int y, int width, int height, boolean isSelected) {
        switch (this.tabPane.getTabPlacement()) {
            case 1: {
                g.drawLine(x + ROUNDING / 2 + 1, y + 1, x + width - ROUNDING / 2 - 3, y + 1);
                g.setColor(UIManager.getColor("TabbedPane.bottomShadow"));
                if (!(isSelected || tabIndex < 0 && this.isOverflowShown())) {
                    g.drawLine(x + 1, y + height - 11, x + width - 2, y + height - 11);
                }
                if (tabIndex == this.tabPane.getSelectedIndex() - 1) {
                    g.drawLine(x + width - 2, y + ROUNDING / 2, x + width - 2, y + height - ROUNDING + 2);
                }
                if (tabIndex != this.tabPane.getSelectedIndex() + 1) break;
                g.drawLine(x + 1, y + ROUNDING / 2, x + 1, y + height - ROUNDING + 2);
                break;
            }
            case 3: {
                g.drawLine(x + ROUNDING / 2 + 1, y + height - 2, x + width - ROUNDING / 2 - 3, y + height - 2);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int tempW = w;
        String gradient = this.getBackgroundGradientKey(tabIndex, isSelected);
        int sizeOffset = 1;
        int yOffset = 0;
        int xOffset = 0;
        if (this.tabPane.isFocusOwner() && (this.myIsMouseDown && this.isTabRollovered(tabIndex) || isSelected)) {
            sizeOffset = 2;
            if (tabPlacement == 3) {
                yOffset = -1;
                sizeOffset = 2;
            } else if (tabPlacement == 4) {
                xOffset = -1;
                ++tempW;
            }
        }
        int backgroundWidth = tempW + sizeOffset;
        int backgroundHeight = h + sizeOffset;
        if (this.isTabRollovered(tabIndex) && this.tabPane.isFocusOwner() && isSelected) {
            ++xOffset;
            ++yOffset;
            --backgroundHeight;
            --backgroundWidth;
        }
        if (!this.tabPane.isFocusOwner() && isSelected) {
            ++xOffset;
            ++yOffset;
            --backgroundHeight;
            --backgroundWidth;
        }
        Shape tabShape = TabbedPaneUtils.getTabShape(this.tabPane.getTabPlacement(), x + xOffset, y + yOffset, backgroundWidth, backgroundHeight);
        Shape oldClip = g.getClip();
        if (gradient != null) {
            GradientUtils.drawVerticalGradient((JComponent)this.tabPane, g, gradient, tabShape);
            if (isSelected && !this.tabPane.isEnabled() && NetUtils.isInDialog(this.tabPane)) {
                g.setColor(UIManager.getColor("TextComponent.disabledFill"));
                ((Graphics2D)g).fill(tabShape);
            }
        } else {
            ((Graphics2D)g).clip(tabShape);
            GradientUtils.drawVerticalBackgroundGradient((Container)this.tabPane, g, tabShape);
        }
        g.setClip(oldClip);
    }

    private String getBackgroundGradientKey(int tabIndex, boolean isSelected) {
        if (!this.tabPane.isEnabledAt(tabIndex)) {
            return null;
        }
        if (!this.tabPane.isEnabled()) {
            return isSelected ? "TabbedPane.selectedTabGradient" : "TabbedPane.disabledTabGradient";
        }
        if (this.myIsMouseDown && this.isTabRollovered(tabIndex)) {
            if (this.tabPane.isFocusOwner()) {
                return "Button.nsnPressedDefaultButtonGradient";
            }
            return "TabbedPane.selectedTabGradient";
        }
        if (isSelected) {
            if (this.tabPane.isFocusOwner()) {
                return this.isTabRollovered(tabIndex) ? "Button.nsnDefaultButtonRolloverGradient" : "Button.nsnDefaultButtonGradient";
            }
            return "TabbedPane.selectedTabGradient";
        }
        return "TabbedPane.unselectedTabGradient";
    }

    protected void paintOverflowTabBackground(Graphics g, int tabPlacement, int x, int y, int w, int h, boolean isSelected) {
        String gradient = null;
        int sizeOffset = 1;
        int backgroundWidth = w + sizeOffset;
        int backgroundHeight = h + sizeOffset;
        Shape tabShape = TabbedPaneUtils.getTabShape(this.tabPane.getTabPlacement(), x, y, backgroundWidth, backgroundHeight);
        if (!this.tabPane.isEnabled()) {
            gradient = "TabbedPane.disabledTabGradient";
        } else if (this.myIsMouseDown && this.myOverflowSupport.isOverflowRollovered()) {
            gradient = "Button.nsnPressedGradient";
        } else if (!this.myOverflowSupport.isOverflowVisible()) {
            gradient = "Button.nsnGradient";
        }
        if (gradient != null) {
            GradientUtils.drawVerticalGradient((JComponent)this.tabPane, g, gradient, tabShape);
        } else {
            g.setColor(UIManager.getColor("ComboBox.background"));
            ((Graphics2D)g).fill(tabShape);
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int tempW = w;
        int tempH = h;
        if (tabPlacement == 1 || tabPlacement == 3) {
            ++tempW;
        } else {
            ++tempH;
        }
        super.paintTabBorder(g, tabPlacement, tabIndex, x, y, tempW, tempH, isSelected);
    }

    @Override
    public Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        super.getTabBounds(tabIndex, dest);
        int tabPlacement = this.tabPane.getTabPlacement();
        if (tabPlacement == 1) {
            ++dest.width;
            ++dest.height;
        } else if (tabPlacement == 3) {
            ++dest.width;
            --dest.y;
            ++dest.height;
        } else if (tabPlacement == 2) {
            ++dest.height;
            ++dest.width;
        } else if (tabPlacement == 4) {
            ++dest.height;
            --dest.x;
            ++dest.width;
        }
        return dest;
    }

    protected void drawTabHighlight(Graphics g, Shape tabShape) {
        g.setColor(NetTheme.getHoverColor());
        ((Graphics2D)g).draw(tabShape);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        int offset;
        int tempX = x;
        Object oldAa = NetUtils.antiAliasingOn(g);
        int x2 = tempX + w - 1;
        int right = x2 - 20;
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(UIManager.getColor("TabbedPane.contentBorderOutline"));
        boolean onlyTopSegmentPainted = this.isOnlyTopSegmentPainted() || h < ROUNDING;
        int xOffset = onlyTopSegmentPainted ? 0 : 2;
        int n = offset = ComponentUtils.isLeftToRight(this.tabPane) ? 1 : 0;
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < tempX || selRect.x > tempX + w) {
            Shape oldClip = g.getClip();
            RectangularShape borderShape = null;
            Insets insets = this.tabPane.getInsets();
            if (tabPlacement == 3) {
                g.clipRect(tempX, y, w + 2, ROUNDING / 2 + 1);
                borderShape = NetUtils.getRoundedRect(this.tabPane, tempX + 2, y + insets.top, w - 4, h - 3, ROUNDING);
            } else if (tabPlacement == 2) {
                g.clipRect(tempX, y, w, ROUNDING);
                borderShape = NetUtils.getRoundedRect(this.tabPane, tempX - ROUNDING, y + insets.top + 3, w - 2 + ROUNDING, h - 3, ROUNDING);
            } else if (tabPlacement == 4) {
                g.clipRect(tempX, y, w, ROUNDING);
                borderShape = NetUtils.getRoundedRect(this.tabPane, tempX, y + insets.top + 3, w - 2 + ROUNDING, h - 3, ROUNDING);
            }
            if (borderShape != null) {
                ((Graphics2D)g).draw(borderShape);
            }
            g.setClip(oldClip);
        } else {
            g.drawLine(tempX + xOffset, y, selRect.x, y);
            if (selRect.x + selRect.width < right - 1) {
                if (this.myIsMouseDown && this.myRolloverTabIndex >= 0) {
                    g.drawLine(selRect.x + 1, y, selRect.x + selRect.width - 1, y);
                }
                Shape oldClip = g.getClip();
                g.clipRect(selRect.x + selRect.width - offset, y, w, ROUNDING);
                if (onlyTopSegmentPainted) {
                    g.drawLine(selRect.x + selRect.width - offset, y, selRect.x + selRect.width - offset, y);
                    g.drawLine(selRect.x + selRect.width - offset + 1, y, this.getLastTabTrailingEdge(), y);
                    g.setColor(UIManager.getColor("TabbedPane.onlyTopBorderOutline"));
                    g.drawLine(this.getLastTabTrailingEdge() + 1, y, w, y);
                } else {
                    Shape topRect = NetUtils.getRoundedPath(this.tabPane, tempX, y, w - 2, ROUNDING + 1, ROUNDING, 5, true);
                    GradientUtils.drawVerticalGradientOutline((JComponent)this.tabPane, g, new Color[]{g.getColor(), UIManager.getColor("TabbedPane.borderOutline")}, topRect);
                }
                g.setClip(oldClip);
            }
        }
        if (tabPlacement == 1) {
            if (!onlyTopSegmentPainted) {
                x2 -= 7;
                ++tempX;
            }
            this.paintShadowAboveContentBorder(g, y, w, selRect, onlyTopSegmentPainted);
            this.paintHighlightBelowTabs(g, tempX, y, w, x2, right, selRect);
        }
        NetUtils.setAntialiasing(g, oldAa);
    }

    private void paintShadowAboveContentBorder(Graphics g, int y, int w, Rectangle selRect, boolean onlyTopSegmentPainted) {
        g.setColor(new Color(0, 0, 0, NetUtils.isInDialog(this.tabPane) ? 10 : 5));
        if (onlyTopSegmentPainted) {
            g.drawLine(selRect.x + selRect.width, y - 1, w - 4, y - 1);
        }
    }

    private void paintHighlightBelowTabs(Graphics g, int x, int y, int w, int x2, int right, Rectangle selRect) {
        boolean isInDialog = NetUtils.isInDialog(this.tabPane);
        if (isInDialog || this.isStandalone()) {
            g.setColor(this.isStandalone() ? UIManager.getColor("TabbedPane.topColor") : UIManager.getColor("FloatingPane.bottomHighlight"));
            g.drawLine(selRect.x + 1, y, selRect.x + selRect.width - 2, y);
            g.drawLine(x + 1, y + 1, x2 - 1, y + 1);
            g.drawLine(x + 1, y + 2, x2 + 1, y + 2);
        } else {
            g.setColor(NetUtils.getColor(NetLookAndFeel.getWhite(), 200));
            g.drawLine(selRect.x + 1, y, selRect.x + selRect.width - 2, y);
            g.drawLine(x + 1, y + 1, x2 - 2, y + 1);
            g.setColor(NetUtils.getColor(NetLookAndFeel.getWhite(), 30));
        }
        if (selRect.x + selRect.width < right - 1) {
            Shape oldClip = g.getClip();
            g.clipRect(selRect.x + selRect.width - 1, y, w, 14);
            g.drawLine(selRect.x + selRect.width, y + 2, w - 10, y + 2);
            g.setClip(oldClip);
        }
    }

    private boolean isOnlyTopSegmentPainted() {
        if (this.tabPane == null) {
            return false;
        }
        boolean borderPainted = ClientPropertyUtil.booleanValue(this.tabPane, "contentBorderPainted", true);
        if (!borderPainted) {
            return false;
        }
        int[] segment = (int[])this.tabPane.getClientProperty("OrangeTouch.paintedContentBorderSegments");
        if (segment == null) {
            return false;
        }
        return NetTabbedPaneUI.contains(segment, 1);
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(UIManager.getColor("TabbedPane.borderOutline"));
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            if (h > ROUNDING) {
                g.drawLine(x + w - 3, y + ROUNDING / 2 + 3, x + w - 3, y + h - ROUNDING + 1);
            }
        } else {
            g.drawLine(x + w - 1, y + 3, x + w - 1, selRect.y);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x + w - 1, selRect.y + selRect.height - 1, x + w - 1, y + h - 2);
            }
        }
        if (tabPlacement == 1 || tabPlacement == 3) {
            g.setColor(UIManager.getColor("FloatingPane.bottomHighlight"));
            g.drawLine(x + w - 4, y + ROUNDING / 2 + 1, x + w - 4, y + h - ROUNDING + 2);
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        int bottom = y + h - 1;
        int right = x + w - 1;
        Rectangle selectedTabRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(UIManager.getColor("TabbedPane.borderOutline"));
        if (tabPlacement != 3 || selectedTabRect == null || selectedIndex < 0 || selectedTabRect.y - 1 > h || selectedTabRect.x < x || selectedTabRect.x > x + w) {
            Shape oldClip = g.getClip();
            RectangularShape borderShape = null;
            if (tabPlacement == 1) {
                g.clipRect(x, y + h - 1 - ROUNDING / 2 - 2, w + 2, ROUNDING / 2 + 1);
                borderShape = h < ROUNDING ? null : NetUtils.getRoundedRect(this.tabPane, x + 1, y, w - 3, h - 2, ROUNDING);
            } else if (tabPlacement == 2) {
                g.clipRect(x, y + h - 1 - ROUNDING / 2 - 1, w, ROUNDING / 2 + 1);
                borderShape = NetUtils.getRoundedRect(this.tabPane, x + 2 - ROUNDING, y, w + ROUNDING - 4, h - 3, ROUNDING);
            } else if (tabPlacement == 4) {
                g.clipRect(x, y + h - 1 - ROUNDING / 2 - 1, w - 1, ROUNDING / 2 + 1);
                borderShape = NetUtils.getRoundedRect(this.tabPane, x, y, w - 4 + ROUNDING, h - 3, ROUNDING);
            }
            if (borderShape != null) {
                ((Graphics2D)g).draw(borderShape);
            }
            g.setClip(oldClip);
        } else {
            g.drawLine(x + 2, bottom, selectedTabRect.x, bottom);
            if (selectedTabRect != null && selectedTabRect.x + selectedTabRect.width < right - 1 && this.myIsMouseDown && this.myRolloverTabIndex >= 0) {
                g.drawLine(selectedTabRect.x + 1, bottom, selectedTabRect.x + selectedTabRect.width - 1, bottom);
            }
        }
        if (selectedTabRect != null && h > ROUNDING) {
            if (tabPlacement == 1) {
                this.paintContentBorderShadowForTopTabs(g, x, y, w, h, selectedTabRect);
                g.setColor(UIManager.getColor("FloatingPane.bottomHighlight"));
                ((Graphics2D)g).draw(NetUtils.getRoundedPath(this.tabPane, x + 2, y + h - 8, x + w - 5, 5, ROUNDING, 1, true));
                g.setColor(UIManager.getColor("FloatingPane.bottomShadow"));
                g.drawLine(x + 6, y + h - 5, x + w - 10, y + h - 5);
            } else if (tabPlacement == 3) {
                this.paintContentBorderShadowForBottomTabs(g, x, y, w, h, selectedTabRect);
            }
        }
    }

    public void paintContentBorderShadowForTopTabs(Graphics g, int x, int y, int w, int h, Rectangle selRect) {
        Color[] colors = (Color[])UIManager.get("TabbedPane.borderShadow");
        Shape oldClip = g.getClip();
        Insets insets = this.tabPane.getInsets();
        g.clipRect(0, 0, insets.left + this.contentBorderInsets.left + ROUNDING / 2, this.tabPane.getHeight());
        NetUtils.drawDropShadow((Graphics2D)g, colors, new Insets(1, 1, 2, 1), x, y - selRect.height + 2, w, h + selRect.height - 2, ROUNDING + 1);
        g.setClip(oldClip);
        int lastTabTrailingEdge = this.getLastTabTrailingEdge();
        g.clipRect(insets.left + this.contentBorderInsets.left + ROUNDING / 2, selRect.y + selRect.height + ROUNDING / 2, lastTabTrailingEdge - (insets.left + this.contentBorderInsets.left + ROUNDING / 2), this.tabPane.getHeight());
        NetUtils.drawDropShadow((Graphics2D)g, colors, new Insets(1, 2, 2, 2), x, y - selRect.height, w, h + selRect.height, ROUNDING + 1);
        g.setClip(oldClip);
        g.clipRect(lastTabTrailingEdge, y - 1 - selRect.height, w, h + selRect.height + 1);
        NetUtils.drawDropShadow((Graphics2D)g, colors, new Insets(1, 2, 2, 2), x, y - 1, w, h + 1, ROUNDING + 1);
        g.setClip(oldClip);
    }

    public void paintContentBorderShadowForBottomTabs(Graphics g, int x, int y, int w, int h, Rectangle selRect) {
        Color[] colors = (Color[])UIManager.get("TabbedPane.borderShadow");
        int rounding = 18;
        Shape oldClip = g.getClip();
        Insets insets = this.tabPane.getInsets();
        g.clipRect(0, 0, insets.left + this.contentBorderInsets.left + ROUNDING / 2, this.tabPane.getHeight());
        NetUtils.drawRoundedRect((Graphics2D)g, colors, new Insets(1, 2, 0, 0), x, y, w - 1, h - 1 + selRect.height, rounding);
        g.setClip(oldClip);
        int lastTabTrailingEdge = this.getLastTabTrailingEdge();
        g.clipRect(insets.left + this.contentBorderInsets.left + ROUNDING / 2, 0, lastTabTrailingEdge - (insets.left + this.contentBorderInsets.left + ROUNDING / 2), this.tabPane.getHeight());
        NetUtils.drawRoundedRect((Graphics2D)g, colors, new Insets(1, 2, 0, 2), x, y - selRect.height, w - 1, h - 1 + selRect.height, rounding);
        g.setClip(oldClip);
        g.clipRect(lastTabTrailingEdge, 0, w, this.tabPane.getHeight());
        NetUtils.drawRoundedRect((Graphics2D)g, colors, new Insets(1, 0, 3, 2), x, y - 1, w - 1, h - 1 + 4, rounding);
        g.setClip(oldClip);
    }

    private int getLastTabTrailingEdge() {
        if (this.myOverflowSupport.hasOverflow()) {
            Rectangle overflowTabRect = this.myOverflowSupport.getOverflowRectangle();
            return overflowTabRect.x + overflowTabRect.width;
        }
        if (this.rects.length > 0) {
            Rectangle lastTab = this.rects[this.tabPane.getTabCount() - 1];
            return lastTab.x + lastTab.width;
        }
        return 0;
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(UIManager.getColor("TabbedPane.borderOutline"));
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            if (tabPlacement == 1) {
                g.setColor(UIManager.getColor("FloatingPane.bottomHighlight"));
                g.drawLine(x + 2, y + 1, x + 2, y + h - 1 - ROUNDING / 2 - 3);
                g.setColor(UIManager.getColor("TabbedPane.borderOutline"));
                if (h > ROUNDING) {
                    g.drawLine(x + 1, y, x + 1, y + h - 1 - ROUNDING / 2 - 3);
                }
            } else if (tabPlacement == 3 && h > ROUNDING) {
                g.drawLine(x + 2, y + ROUNDING / 2, x + 2, y + h);
            } else if (tabPlacement == 4) {
                g.drawLine(x, y + ROUNDING / 2, x, y + h - ROUNDING / 2 - 2);
            }
        } else {
            g.drawLine(x, y + 3, x, selRect.y);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x, selRect.y + selRect.height - 1, x, y + h - 2);
            }
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rectangles, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    private boolean isStandalone() {
        return ClientPropertyUtil.booleanValue(this.tabPane, "OrangeTouch.isStandalone", true);
    }

    protected int getRolloverIndex() {
        return this.myRolloverTabIndex;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new TabPaneMouseHandler();
    }

    @Override
    protected void navigateSelectedTab(int direction) {
        this.myOverflowSupport.navigateSelectedTab(direction);
        super.navigateSelectedTab(direction);
    }

    @Override
    public int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        FontMetrics tempMetrics = metrics;
        if (this.tabPane.getFont() instanceof UIResource && theSelectedFont != null) {
            tempMetrics = this.tabPane.getFontMetrics(theSelectedFont);
        }
        int result = super.calculateTabWidth(tabPlacement, tabIndex, tempMetrics);
        int maxWidth = ClientPropertyUtil.integerValue(this.tabPane, "OrangeTouch.maxTabWidth");
        if (maxWidth > -1) {
            return Math.min(result, maxWidth);
        }
        return result;
    }

    protected void requestFocusForVisibleComponent(Component component) {
        if (component == null || this.tabPane == null || this.tabPane.hasFocus()) {
            return;
        }
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        FocusTraversalPolicy policy = focusManager.getDefaultFocusTraversalPolicy();
        Container root = this.tabPane;
        if (!root.isFocusCycleRoot()) {
            root = this.tabPane.getFocusCycleRootAncestor();
        }
        if (root == null) {
            return;
        }
        Component comp = policy.getComponentAfter(root, component);
        if (comp == null) {
            return;
        }
        if (comp.isFocusable() && SwingUtilities.isDescendingFrom(comp, this.tabPane)) {
            comp.requestFocusInWindow();
        } else {
            Component focusOwner = focusManager.getPermanentFocusOwner();
            if (focusOwner == null || SwingUtilities.isDescendingFrom(focusOwner, this.tabPane)) {
                policy.getDefaultComponent(root).requestFocusInWindow();
            }
        }
    }

    private void ensureCurrentLayout() {
        if (this.tabPane == null) {
            return;
        }
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            MetalTabbedPaneUI.TabbedPaneLayout layout = (MetalTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected int getTabAtLocation(int x, int y) {
        if (this.tabPane == null) {
            return -1;
        }
        this.ensureCurrentLayout();
        int tabCount = this.tabPane.getTabCount();
        int idx = 0;
        while (idx < tabCount) {
            if (this.rects[idx].contains(x, y)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Override
    protected void setVisibleComponent(Component component) {
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        if (component != this.getVisibleComponent() && this.getVisibleComponent() != null && !this.tabPane.hasFocus()) {
            this.requestFocusForVisibleComponent(component);
        }
        if (this.getVisibleComponent() != null && this.getVisibleComponent() != component && this.getVisibleComponent().getParent() == this.tabPane && this.getVisibleComponent().isVisible()) {
            this.getVisibleComponent().setVisible(false);
        }
        super.setVisibleComponent(component);
    }

    private boolean isHorizontalRun(int tabPlacement) {
        return tabPlacement == 3 || tabPlacement == 1;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Rectangle tabBounds;
        if (this.tabPane != null && this.tabPane.getSelectedIndex() != -1 && (tabBounds = this.getTabBounds(this.tabPane, this.tabPane.getSelectedIndex())) != null) {
            this.tabPane.repaint(tabBounds);
        }
    }

    private boolean isClosable(JTabbedPane tabbedPane) {
        return ClientPropertyUtil.booleanValue(tabbedPane, "OrangeTouch.closableTabs");
    }

    private boolean isClosableByKeyboard(JTabbedPane tabbedPane) {
        return ClientPropertyUtil.booleanValue(tabbedPane, "OrangeTouch.closeTabByKeyboard");
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NetTabbedPaneUI.this.tabPane != null && NetTabbedPaneUI.this.isClosableByKeyboard(NetTabbedPaneUI.this.tabPane)) {
                NetTabbedPaneUI.this.myCloseListenerSupport.closeTab(NetTabbedPaneUI.this.tabPane.getSelectedIndex());
            }
        }
    }

    public static class NetTabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
        }
    }

    private class NetTabbedPaneScrollLayout
    extends MetalTabbedPaneUI.TabbedPaneLayout {
        private NetTabbedPaneScrollLayout() {
            super(NetTabbedPaneUI.this);
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return NetTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return NetTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void layoutContainer(Container parent) {
            int tabPlacement = NetTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = NetTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = NetTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = NetTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    NetTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component selectedComponent = NetTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                if (selectedComponent != null) {
                    NetTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Insets contentInsets = NetTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Rectangle bounds = NetTabbedPaneUI.this.tabPane.getBounds();
                int numChildren = NetTabbedPaneUI.this.tabPane.getComponentCount();
                if (numChildren > 0) {
                    int ch;
                    int cw;
                    int cy;
                    int cx;
                    switch (tabPlacement) {
                        case 2: {
                            int tw = NetTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, NetTabbedPaneUI.this.runCount, NetTabbedPaneUI.this.maxTabWidth);
                            int th = bounds.height - insets.top - insets.bottom;
                            int tx = insets.left;
                            int ty = insets.top;
                            cx = tx + tw + contentInsets.left;
                            cy = ty + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 4: {
                            int tw = NetTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, NetTabbedPaneUI.this.runCount, NetTabbedPaneUI.this.maxTabWidth);
                            int th = bounds.height - insets.top - insets.bottom;
                            int tx = bounds.width - insets.right - tw;
                            int ty = insets.top;
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 3: {
                            int tw = bounds.width - insets.left - insets.right;
                            int th = NetTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, NetTabbedPaneUI.this.runCount, NetTabbedPaneUI.this.maxTabHeight);
                            int tx = insets.left;
                            int ty = bounds.height - insets.bottom - th;
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        default: {
                            int tw = bounds.width - insets.left - insets.right;
                            int th = NetTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, NetTabbedPaneUI.this.runCount, NetTabbedPaneUI.this.maxTabHeight);
                            int tx = insets.left;
                            int ty = insets.top;
                            cx = tx + contentInsets.left;
                            cy = ty + th + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        }
                    }
                    int i = 0;
                    while (i < numChildren) {
                        Component child = NetTabbedPaneUI.this.tabPane.getComponent(i);
                        child.setBounds(cx, cy, cw, ch);
                        ++i;
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics metrics = NetTabbedPaneUI.this.getFontMetrics();
            Dimension size = NetTabbedPaneUI.this.tabPane.getSize();
            Insets insets = NetTabbedPaneUI.this.tabPane.getInsets();
            int tabAreaWidth = size.width - insets.left - insets.right;
            Insets areaInsets = NetTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = ComponentUtils.isLeftToRight(NetTabbedPaneUI.this.tabPane);
            int x = areaInsets.left;
            int y = areaInsets.top;
            switch (tabPlacement) {
                case 2: {
                    NetTabbedPaneUI.this.maxTabWidth = NetTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + areaInsets.left;
                    y = insets.top + areaInsets.top;
                    break;
                }
                case 4: {
                    NetTabbedPaneUI.this.maxTabWidth = NetTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - areaInsets.right - NetTabbedPaneUI.this.maxTabWidth;
                    y = insets.top + areaInsets.top;
                    break;
                }
                case 3: {
                    NetTabbedPaneUI.this.maxTabHeight = NetTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + areaInsets.left;
                    y = size.height - insets.bottom - areaInsets.bottom - NetTabbedPaneUI.this.maxTabHeight;
                    break;
                }
                default: {
                    NetTabbedPaneUI.this.maxTabHeight = NetTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + areaInsets.left;
                    y = insets.top + areaInsets.top;
                }
            }
            NetTabbedPaneUI.this.runCount = 0;
            NetTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            NetTabbedPaneUI.this.selectedRun = 0;
            NetTabbedPaneUI.this.runCount = 1;
            NetTabbedPaneUI.this.myOverflowSupport.updateCachedValues(tabAreaWidth, x, NetTabbedPaneUI.this.rects);
            int i = 0;
            while (i < tabCount) {
                Rectangle rect = NetTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((NetTabbedPaneUI)NetTabbedPaneUI.this).rects[i - 1].x + ((NetTabbedPaneUI)NetTabbedPaneUI.this).rects[i - 1].width;
                    } else {
                        ((NetTabbedPaneUI)NetTabbedPaneUI.this).tabRuns[0] = 0;
                        NetTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = NetTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    if (NetTabbedPaneUI.this.myOverflowSupport.isInOverflow(i)) {
                        rect.width = 0;
                    }
                    NetTabbedPaneUI.this.maxTabWidth = Math.max(NetTabbedPaneUI.this.maxTabWidth, rect.width);
                    rect.y = y;
                    rect.height = NetTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = ((NetTabbedPaneUI)NetTabbedPaneUI.this).rects[i - 1].y + ((NetTabbedPaneUI)NetTabbedPaneUI.this).rects[i - 1].height;
                    } else {
                        ((NetTabbedPaneUI)NetTabbedPaneUI.this).tabRuns[0] = 0;
                        NetTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = NetTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    NetTabbedPaneUI.this.maxTabHeight = Math.max(NetTabbedPaneUI.this.maxTabHeight, rect.height);
                    rect.x = x;
                    rect.width = NetTabbedPaneUI.this.maxTabWidth;
                }
                ++i;
            }
            this.padSelectedTab(tabPlacement, NetTabbedPaneUI.this.tabPane.getSelectedIndex());
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + areaInsets.right);
                i = 0;
                while (i < tabCount) {
                    ((NetTabbedPaneUI)NetTabbedPaneUI.this).rects[i].x = rightMargin - ((NetTabbedPaneUI)NetTabbedPaneUI.this).rects[i].x - ((NetTabbedPaneUI)NetTabbedPaneUI.this).rects[i].width;
                    ++i;
                }
            }
        }

        @Override
        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            if (selectedIndex >= 0) {
                Rectangle selRect = NetTabbedPaneUI.this.rects[selectedIndex];
                Insets padInsets = NetTabbedPaneUI.this.getSelectedTabPadInsets(tabPlacement);
                selRect.x -= padInsets.left;
                selRect.width += padInsets.left + padInsets.right;
                selRect.y -= padInsets.top;
                selRect.height += padInsets.top + padInsets.bottom;
                Dimension size = NetTabbedPaneUI.this.tabPane.getSize();
                Insets insets = NetTabbedPaneUI.this.tabPane.getInsets();
                if (tabPlacement == 2 || tabPlacement == 4) {
                    int bottom;
                    int top = insets.top - selRect.y;
                    if (top > 0) {
                        selRect.y += top;
                        selRect.height -= top;
                    }
                    if ((bottom = selRect.y + selRect.height + insets.bottom - size.height) > 0) {
                        selRect.height -= bottom;
                    }
                } else {
                    int right;
                    int left = insets.left - selRect.x;
                    if (left > 0) {
                        selRect.x += left;
                        selRect.width -= left;
                    }
                    if ((right = selRect.x + selRect.width + insets.right - size.width) > 0) {
                        selRect.width -= right;
                    }
                }
            }
        }
    }

    public class TabPaneMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public TabPaneMouseHandler() {
            super(NetTabbedPaneUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int tabIndex;
            NetTabbedPaneUI.this.myIsMouseDown = false;
            if (NetTabbedPaneUI.this.myIsMouseDownOnCloseIcon && NetTabbedPaneUI.this.isMouseOnCloseIcon(e) && (tabIndex = NetTabbedPaneUI.this.tabForCoordinate(NetTabbedPaneUI.this.tabPane, e.getX(), e.getY())) >= 0 && NetTabbedPaneUI.this.tabPane.isEnabled() && NetTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                NetTabbedPaneUI.this.myCloseListenerSupport.closeTab(tabIndex);
            }
            if (NetTabbedPaneUI.this.tabPane.getSelectedIndex() >= 0 && NetTabbedPaneUI.this.tabPane.getSelectedIndex() < NetTabbedPaneUI.this.tabPane.getTabCount()) {
                Rectangle tabRect = new Rectangle(NetTabbedPaneUI.this.rects[NetTabbedPaneUI.this.tabPane.getSelectedIndex()]);
                ++tabRect.height;
                ++tabRect.width;
                NetTabbedPaneUI.this.tabPane.repaint(tabRect);
            }
            super.mouseReleased(e);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            NetTabbedPaneUI.this.myIsMouseDown = false;
            if (ClientPropertyUtil.booleanValue(NetTabbedPaneUI.this.tabPane, "OrangeTouch.closableTabs")) {
                if (NetTabbedPaneUI.this.myPreviousSelectedTab != NetTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    return;
                }
                if (NetTabbedPaneUI.this.isMouseOnCloseIcon(evt)) {
                    NetTabbedPaneUI.this.myIsMouseDownOnCloseIcon = true;
                    return;
                }
                NetTabbedPaneUI.this.myIsMouseDownOnCloseIcon = false;
            }
            super.mouseClicked(evt);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            NetTabbedPaneUI.this.myIsMouseDown = true;
            if (ClientPropertyUtil.booleanValue(NetTabbedPaneUI.this.tabPane, "OrangeTouch.closableTabs")) {
                NetTabbedPaneUI.this.myPreviousSelectedTab = NetTabbedPaneUI.this.tabPane.getSelectedIndex();
                if (NetTabbedPaneUI.this.isMouseOnCloseIcon(e)) {
                    NetTabbedPaneUI.this.myIsMouseDownOnCloseIcon = true;
                    return;
                }
                NetTabbedPaneUI.this.myIsMouseDownOnCloseIcon = false;
            }
            if (NetTabbedPaneUI.this.tabPane.getSelectedIndex() < 0) {
                NetTabbedPaneUI.this.tabPane.repaint();
            } else {
                Rectangle tabRect = new Rectangle(NetTabbedPaneUI.this.rects[NetTabbedPaneUI.this.tabPane.getSelectedIndex()]);
                ++tabRect.height;
                ++tabRect.width;
                NetTabbedPaneUI.this.tabPane.repaint(tabRect);
            }
            super.mousePressed(e);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            if (NetTabbedPaneUI.this.myRolloverTabIndex != -1 && NetTabbedPaneUI.this.myRolloverTabIndex < NetTabbedPaneUI.this.tabPane.getTabCount()) {
                NetTabbedPaneUI.this.tabPane.repaint(NetTabbedPaneUI.this.getTabBounds(NetTabbedPaneUI.this.tabPane, NetTabbedPaneUI.this.myRolloverTabIndex));
                if (NetTabbedPaneUI.this.myRolloverTabIndex != NetTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    NetTabbedPaneUI.this.tabPane.repaint(NetTabbedPaneUI.this.getTabBounds(NetTabbedPaneUI.this.tabPane, NetTabbedPaneUI.this.tabPane.getSelectedIndex()));
                }
                NetTabbedPaneUI.this.myRolloverTabIndex = -1;
            }
            NetTabbedPaneUI.this.tabPane.repaint(NetTabbedPaneUI.this.myOverflowSupport.getOverflowRectangle());
            NetUtils.setInactiveCursor(NetTabbedPaneUI.this.tabPane);
        }
    }

    public class TabPaneMouseMotionHandler
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent evt) {
            if (NetTabbedPaneUI.this.tabPane == null) {
                return;
            }
            if (!NetTabbedPaneUI.this.tabPane.isEnabled()) {
                NetUtils.setInactiveCursor(NetTabbedPaneUI.this.tabPane);
                return;
            }
            boolean previousValue = NetTabbedPaneUI.this.myIsMouseOnCloseIcon;
            NetTabbedPaneUI.this.myIsMouseOnCloseIcon = NetTabbedPaneUI.this.isMouseOnCloseIcon(evt);
            int tabIndex = NetTabbedPaneUI.this.tabForCoordinate(NetTabbedPaneUI.this.tabPane, evt.getX(), evt.getY());
            if (tabIndex != NetTabbedPaneUI.this.myRolloverTabIndex && NetTabbedPaneUI.this.myRolloverTabIndex != -1) {
                if (NetTabbedPaneUI.this.myRolloverTabIndex >= 0 && NetTabbedPaneUI.this.myRolloverTabIndex < NetTabbedPaneUI.this.tabPane.getTabCount()) {
                    NetTabbedPaneUI.this.tabPane.repaint(NetTabbedPaneUI.this.getTabBounds(NetTabbedPaneUI.this.tabPane, NetTabbedPaneUI.this.myRolloverTabIndex));
                    if (NetTabbedPaneUI.this.myRolloverTabIndex != NetTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                        NetTabbedPaneUI.this.tabPane.repaint(NetTabbedPaneUI.this.getTabBounds(NetTabbedPaneUI.this.tabPane, NetTabbedPaneUI.this.myRolloverTabIndex));
                    }
                }
                if (tabIndex == -1) {
                    NetTabbedPaneUI.this.myRolloverTabIndex = -1;
                }
            }
            if (tabIndex >= 0 && tabIndex < NetTabbedPaneUI.this.tabPane.getTabCount()) {
                if (tabIndex != NetTabbedPaneUI.this.myRolloverTabIndex) {
                    NetTabbedPaneUI.this.tabPane.repaint(NetTabbedPaneUI.this.getTabBounds(NetTabbedPaneUI.this.tabPane, tabIndex));
                    NetTabbedPaneUI.this.myRolloverTabIndex = tabIndex;
                    if (NetTabbedPaneUI.this.tabPane.isEnabled() && NetTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                        NetUtils.setActiveCursor(NetTabbedPaneUI.this.tabPane);
                    } else {
                        NetUtils.setInactiveCursor(NetTabbedPaneUI.this.tabPane);
                    }
                    if (NetTabbedPaneUI.this.myRolloverTabIndex != NetTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                        NetTabbedPaneUI.this.tabPane.repaint(NetTabbedPaneUI.this.getTabBounds(NetTabbedPaneUI.this.tabPane, NetTabbedPaneUI.this.tabPane.getSelectedIndex()));
                    }
                }
                if (NetTabbedPaneUI.this.myIsMouseOnCloseIcon != previousValue) {
                    NetTabbedPaneUI.this.tabPane.repaint(NetTabbedPaneUI.this.getTabBounds(NetTabbedPaneUI.this.tabPane, tabIndex));
                }
            } else {
                NetUtils.setInactiveCursor(NetTabbedPaneUI.this.tabPane);
            }
        }
    }
}

