/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.LAFCursors;
import com.nokia.laf.NetInfoRowRenderer;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTableHeaderRenderer;
import com.nokia.laf.table.DefaultHeaderPopupMenu;
import com.nokia.laf.table.FilterCombo;
import com.nokia.laf.table.NetTrailingCornerComponent;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.table.CompoundFilter;
import com.nokia.widgets.table.FilterConfiguration;
import com.nokia.widgets.table.PComboBoxRenderer;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.table.PTableHeaderRenderer;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.table.PValidatableTableModel;
import com.nokia.widgets.table.TableSortEvent;
import com.nokia.widgets.table.TableSortListener;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class NetTableHeaderUI
extends BasicTableHeaderUI
implements PropertyChangeListener,
TableSortListener,
TableModelListener {
    protected TableCellRenderer myOriginalHeaderRenderer;
    protected Object[] myCurrentInfoRow = null;
    protected int myInfoRowHeight = 0;
    protected boolean myInfoRowVisible = false;
    protected TableCellRenderer myDefaultRenderer = new NetTableHeaderRenderer.UIResource();
    protected TableCellRenderer myInfoRowRenderer;
    protected TableCellRenderer myHeaderGroupRenderer;
    private int myHeaderGroupHeight;
    private static final Rectangle theTempCellRect = new Rectangle();
    private InputMap myMnemonicInputMap;
    private Map myMnemonicToColumnMap = new HashMap();
    private DefaultHeaderPopupMenu myDefaultPopupMenu;
    private int myFilterHeight;
    private Map<Integer, FilterCombo> myFilterCombos = new HashMap<Integer, FilterCombo>();
    private CompoundFilter myFilter = new CompoundFilter();
    private Cursor mySwapCursor;
    private int selectedColumnIndex = 0;
    private int[] myRowSelection;
    private int myRowLead = -1;
    private int[] myColumnSelection;
    private int myColumnLead = -1;
    private MouseInputAdapter myRolloverHandler = new RolloverHandler();

    public static ComponentUI createUI(JComponent comp) {
        return new NetTableHeaderUI();
    }

    @Override
    public void installUI(JComponent comp) {
        super.installUI(comp);
        comp.putClientProperty("clearOppositeBorder", Boolean.TRUE);
        comp.setOpaque(false);
        this.header.putClientProperty("BlueTouch.rolloveredCell", new Point(-1, -1));
        this.myOriginalHeaderRenderer = this.header.getDefaultRenderer();
        this.myInfoRowRenderer = this.createInfoRowRenderer();
        this.myHeaderGroupRenderer = this.createHeaderGroupRenderer();
        JTable table = this.header.getTable();
        ActionMap actionMap = this.createActionMap();
        SwingUtilities.replaceUIActionMap(this.header, actionMap);
        if (this.myOriginalHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(this.myDefaultRenderer);
        }
        if (table != null) {
            this.myCurrentInfoRow = (Object[])table.getClientProperty("infoRow");
            this.myInfoRowVisible = Boolean.TRUE.equals(table.getClientProperty("infoRowVisible"));
            if (table.getModel() instanceof PSortableTableModel) {
                this.updateMnemonics((PSortableTableModel)table.getModel());
                if (ClientPropertyUtil.booleanValue(table, "OrangeTouch.simpleFilteringEnabled")) {
                    this.installInlineFilters((PSortableTableModel)table.getModel());
                }
            }
        }
        if (this.getSortableModel() != null && (this.header.getComponentPopupMenu() == null || this.header.getComponentPopupMenu() instanceof UIResource)) {
            this.myDefaultPopupMenu = new DefaultHeaderPopupMenu(this.header);
            this.header.setComponentPopupMenu(this.myDefaultPopupMenu);
        }
        this.header.putClientProperty("OrangeTouch.headerRolloverLocation", new Point(-1, -1));
        this.installCursor();
        this.mySwapCursor = Cursor.getPredefinedCursor(11);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        Dimension dim = this.createHeaderSize(width);
        Insets insets = this.header.getInsets();
        dim.width += insets.left + insets.right;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension dim = super.getMinimumSize(c);
        Insets insets = this.header.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top;
        return dim;
    }

    public Map<Integer, FilterCombo> getInlineFilters() {
        return new HashMap<Integer, FilterCombo>(this.myFilterCombos);
    }

    public void clearInlineFilters() {
        for (FilterCombo combo : this.getInlineFilters().values()) {
            combo.clear();
        }
    }

    public int getFilterAreaHeight() {
        return this.myFilterHeight;
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof UIResource) {
            this.header.setDefaultRenderer(this.myOriginalHeaderRenderer);
        }
        if (this.myDefaultPopupMenu != null && this.header.getComponentPopupMenu() == this.myDefaultPopupMenu) {
            this.myDefaultPopupMenu.uninstallUI();
            this.header.setComponentPopupMenu(null);
        }
        this.myCurrentInfoRow = null;
        this.resetMnemonics();
        JTable table = this.header.getTable();
        if (table != null && table.getModel() instanceof PSortableTableModel) {
            this.uninstallInlineFilters((PSortableTableModel)table.getModel());
        }
        SwingUtilities.replaceUIActionMap(c, null);
        SwingUtilities.replaceUIInputMap(c, 2, null);
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int column;
        NetLookAndFeel.toggleTextAntialiasing(g);
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        int columnMargin = cm.getColumnMargin();
        Rectangle cellRect = this.header.getHeaderRect(cMin);
        boolean inViewport = this.header.getParent() instanceof JViewport;
        Container parent = this.header.getParent().getParent();
        boolean cornerVisible = inViewport && parent instanceof JScrollPane && ((JScrollPane)parent).getCorner("UPPER_TRAILING_CORNER") != null && ((JScrollPane)parent).getCorner("UPPER_TRAILING_CORNER").getWidth() > 0;
        Insets insets = this.header.getInsets();
        if (ltr) {
            column = cMin;
            while (column <= cMax) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                theTempCellRect.setBounds(cellRect);
                NetTableHeaderUI.theTempCellRect.y += insets.top;
                NetTableHeaderUI.theTempCellRect.x += insets.left;
                NetTableHeaderUI.theTempCellRect.width = this.header.getTable().getCellRect((int)0, (int)column, (boolean)false).width;
                boolean isPTable = this.header.getTable() instanceof PTable;
                boolean isInScrollPane = this.header.getTable().getParent() instanceof JViewport;
                if (column == this.header.getTable().getColumnCount() - 1 && isPTable && isInScrollPane) {
                    --NetTableHeaderUI.theTempCellRect.width;
                }
                NetTableHeaderUI.theTempCellRect.height -= insets.top + insets.bottom;
                if (isInScrollPane || isPTable) {
                    NetTableHeaderUI.theTempCellRect.width += 2;
                } else {
                    ++NetTableHeaderUI.theTempCellRect.width;
                    NetTableHeaderUI.theTempCellRect.x -= 3;
                    if (column == 0) {
                        NetTableHeaderUI.theTempCellRect.x += 3;
                        NetTableHeaderUI.theTempCellRect.width -= 2;
                    } else {
                        ++NetTableHeaderUI.theTempCellRect.width;
                    }
                }
                if (!ComponentUtils.isStandalone(this.header.getTable()) && column > 0) {
                    if (column > 0) {
                        --NetTableHeaderUI.theTempCellRect.x;
                    }
                    if (column == this.header.getColumnModel().getColumnCount() - 1 && !cornerVisible) {
                        --NetTableHeaderUI.theTempCellRect.width;
                    }
                }
                if (column == cm.getColumnCount() - 1) {
                    if (NetTableHeaderUI.theTempCellRect.x + NetTableHeaderUI.theTempCellRect.width < this.header.getVisibleRect().width && inViewport || cornerVisible) {
                        ++NetTableHeaderUI.theTempCellRect.width;
                    } else if (!inViewport) {
                        --NetTableHeaderUI.theTempCellRect.width;
                        if (this.header.getTable().getRowCount() == 0) {
                            --NetTableHeaderUI.theTempCellRect.width;
                        }
                    }
                }
                if (!inViewport && column == cm.getColumnCount() - 1) {
                    ++NetTableHeaderUI.theTempCellRect.width;
                }
                if (aColumn != draggedColumn) {
                    this.paintCell(g, theTempCellRect, column);
                }
                cellRect.x += columnWidth;
                ++column;
            }
            if (this.myFilterHeight > 0) {
                g.setColor(this.header.getTable().getGridColor());
                g.drawLine(0, this.header.getHeight() - 1, this.header.getWidth() - 1, this.header.getHeight() - 1);
            }
        } else {
            int columnWidth;
            TableColumn aColumn = cm.getColumn(cMin);
            if (aColumn != draggedColumn) {
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x += columnMargin;
                theTempCellRect.setBounds(cellRect);
                NetTableHeaderUI.theTempCellRect.width += 2;
                this.paintCell(g, theTempCellRect, cMin);
            }
            column = cMin + 1;
            while (column <= cMax) {
                aColumn = cm.getColumn(column);
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x -= columnWidth;
                if (aColumn != draggedColumn) {
                    theTempCellRect.setBounds(cellRect);
                    NetTableHeaderUI.theTempCellRect.width += 2;
                    this.paintCell(g, theTempCellRect, column);
                }
                ++column;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y + this.myHeaderGroupHeight, draggedCellRect.width - 1, draggedCellRect.height - this.myHeaderGroupHeight);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y + this.myHeaderGroupHeight, draggedCellRect.width, draggedCellRect.height - this.myHeaderGroupHeight);
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
            FilterCombo filterCombo = this.myFilterCombos.get(this.header.getTable().convertColumnIndexToModel(draggedColumnIndex));
            if (filterCombo != null) {
                Rectangle filterRect = this.header.getHeaderRect(draggedColumnIndex);
                filterRect.y = filterRect.height - this.myFilterHeight;
                filterRect.height = this.myFilterHeight;
                ++filterRect.width;
                filterRect.x = draggedCellRect.x;
                filterCombo.setBounds(filterRect);
                filterCombo.doLayout();
            }
        }
        this.rendererPane.removeAll();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (c.getBackground() instanceof UIResource) {
                GradientUtils.drawVerticalBackgroundGradient(c, g);
            } else {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
        this.paintFilterAreaBackground(g, c);
        this.paint(g, c);
    }

    private void paintFilterAreaBackground(Graphics g, JComponent c) {
        if (this.myFilterHeight > 0) {
            g.setColor(UIManager.getColor("Table.filterAreaBackground"));
            g.fillRect(0, this.myFilterHeight - 4, c.getWidth(), c.getHeight());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        TableModel newModel = null;
        if ("enabled".equals(propertyName) && this.header != null) {
            this.header.repaint();
        }
        if ("OrangeTouch.simpleFilteringEnabled".equals(propertyName)) {
            if (this.header.getTable() == null || !(this.header.getTable().getModel() instanceof PSortableTableModel)) {
                return;
            }
            PSortableTableModel sortModel = (PSortableTableModel)this.header.getTable().getModel();
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                this.installInlineFilters(sortModel);
            } else {
                this.uninstallInlineFilters(sortModel);
            }
            return;
        }
        if ("OrangeTouch.inlineFilterConfiguration".equals(propertyName)) {
            if (this.header.getTable() == null || !(this.header.getTable().getModel() instanceof PSortableTableModel)) {
                return;
            }
            this.updateFilterConfiguration();
            return;
        }
        if ("ancestor".equals(propertyName) && this.header != null) {
            boolean filtersInUse = ClientPropertyUtil.booleanValue(this.header.getTable(), "OrangeTouch.simpleFilteringEnabled");
            this.setClearAllFiltersButtonVisible(filtersInUse);
        }
        if ("OrangeTouch.tableSortableLook".equals(propertyName)) {
            this.installCursor();
            return;
        }
        if (!("table".equals(propertyName) || "model".equals(propertyName) || "infoRow".equals(propertyName) || "infoRowVisible".equals(propertyName))) {
            return;
        }
        if ("infoRow".equals(propertyName)) {
            this.myCurrentInfoRow = (Object[])evt.getNewValue();
            return;
        }
        if ("infoRowVisible".equals(propertyName)) {
            this.myInfoRowVisible = Boolean.TRUE.equals(evt.getNewValue());
            this.header.revalidate();
            return;
        }
        if ("table".equals(propertyName)) {
            this.installCursor();
            JTable newTable = (JTable)evt.getNewValue();
            JTable oldTable = (JTable)evt.getOldValue();
            if (newTable != null) {
                newTable.addPropertyChangeListener(this);
                newModel = newTable.getModel();
                this.installSortListener(newTable);
            }
            if (oldTable != null) {
                oldTable.removePropertyChangeListener(this);
                this.uninstallSortListener(oldTable);
            }
        } else if ("model".equals(propertyName)) {
            this.installCursor();
            newModel = (TableModel)evt.getNewValue();
            TableModel oldModel = (TableModel)evt.getOldValue();
            if (this.header != null && this.header.getTable() != null) {
                if (oldModel != null) {
                    this.uninstallSortListener(this.header.getTable());
                }
                if (newModel != null) {
                    this.installSortListener(this.header.getTable());
                }
            }
            if (oldModel instanceof PValidatableTableModel) {
                oldModel.removeTableModelListener(this);
            }
            if (newModel instanceof PValidatableTableModel) {
                newModel.addTableModelListener(this);
            }
        }
        if (this.header != null && this.header.getDefaultRenderer() instanceof UIResource) {
            if (newModel instanceof PSortableTableModel) {
                this.updateMnemonics((PSortableTableModel)newModel);
            } else {
                this.resetMnemonics();
            }
            this.header.repaint();
        }
    }

    private void updateFilterConfiguration() {
        if (this.header == null || this.header.getTable() == null) {
            return;
        }
        FilterConfiguration filterConfig = (FilterConfiguration)this.header.getTable().getClientProperty("OrangeTouch.inlineFilterConfiguration");
        if (filterConfig != null) {
            for (FilterCombo filter : this.myFilterCombos.values()) {
                this.updateFilterComboBox(filter, filterConfig);
            }
        }
    }

    private void updateFilterComboBox(FilterCombo filter, FilterConfiguration filterConfig) {
        ListCellRenderer renderer;
        int columnIndex = filter.getColumnIndex();
        filter.setVisible(filterConfig.isFilteringEnabled(columnIndex));
        boolean comboVisible = filterConfig.isFilterComboBoxVisible(columnIndex);
        filter.setComboBoxButtonVisible(comboVisible);
        JComponent editorComponent = (JComponent)filter.getEditorComponent();
        if (editorComponent != null) {
            editorComponent.putClientProperty("OrangeTouch.openRightEdge", comboVisible);
        }
        if ((renderer = filterConfig.getFilterComboBoxRenderer(columnIndex)) != null) {
            filter.setRenderer(renderer);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new SorterMouseHandler();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.header.addMouseMotionListener(this.myRolloverHandler);
        this.header.addMouseListener(this.myRolloverHandler);
        this.header.addPropertyChangeListener("table", this);
        this.header.addPropertyChangeListener("ancestor", this);
        JTable table = this.header.getTable();
        if (table != null) {
            table.addPropertyChangeListener(this);
            this.installSortListener(table);
            if (table.getModel() instanceof PValidatableTableModel) {
                table.getModel().addTableModelListener(this);
            }
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.header.removeMouseMotionListener(this.myRolloverHandler);
        this.header.removeMouseListener(this.myRolloverHandler);
        this.header.removePropertyChangeListener("table", this);
        this.header.removePropertyChangeListener("ancestor", this);
        JTable table = this.header.getTable();
        if (table != null) {
            table.removePropertyChangeListener(this);
            this.uninstallSortListener(table);
        }
    }

    private void installSortListener(JTable table) {
        if (table.getModel() instanceof PTableModelSorter) {
            PTableModelSorter sorter = (PTableModelSorter)table.getModel();
            sorter.addTableSortListener(this);
        }
    }

    private void installCursor() {
        if (this.header == null) {
            return;
        }
        JTable table = this.header.getTable();
        if (table == null) {
            if (this.header.getCursor() == LAFCursors.getCursor(12)) {
                this.header.setCursor(null);
            }
            return;
        }
        boolean sortableLook = ClientPropertyUtil.booleanValue(table, "OrangeTouch.tableSortableLook");
        if (table.getModel() instanceof PTableModelSorter || sortableLook) {
            if (this.header.getCursor() == Cursor.getPredefinedCursor(0)) {
                this.header.setCursor(LAFCursors.getCursor(12));
            }
        } else if (this.header.getCursor() == LAFCursors.getCursor(12)) {
            this.header.setCursor(null);
        }
    }

    private void uninstallSortListener(JTable table) {
        if (table.getModel() instanceof PTableModelSorter) {
            PTableModelSorter sorter = (PTableModelSorter)table.getModel();
            sorter.removeTableSortListener(this);
        }
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("sort", new SortAction());
        return map;
    }

    protected TableCellRenderer createInfoRowRenderer() {
        return new NetInfoRowRenderer();
    }

    protected TableCellRenderer createFilterRenderer() {
        return new PComboBoxRenderer(true);
    }

    protected TableCellRenderer createHeaderGroupRenderer() {
        PTableHeaderRenderer renderer = new PTableHeaderRenderer();
        renderer.setGroupHeaderRenderer();
        return renderer;
    }

    protected Component getInfoRowRenderer(int column) {
        Object value = null;
        int modelIndex = this.header.getTable().convertColumnIndexToModel(column);
        if (modelIndex < this.myCurrentInfoRow.length) {
            value = this.myCurrentInfoRow[modelIndex];
        }
        return this.myInfoRowRenderer.getTableCellRendererComponent(this.header.getTable(), value, false, false, -1, column);
    }

    protected Component getHeaderGroupRenderer(int groupIndex) {
        Map<Integer, Object> headerGroups = this.getHeaderGroups();
        if (headerGroups == null || !headerGroups.containsKey(groupIndex)) {
            return null;
        }
        Object headerGroupSameAsHeader = this.header.getClientProperty("OrangeTouch.headerGroupSameAsHeader");
        if (headerGroupSameAsHeader != null && headerGroupSameAsHeader instanceof Boolean && ((Boolean)headerGroupSameAsHeader).booleanValue()) {
            return this.header.getDefaultRenderer().getTableCellRendererComponent(this.header.getTable(), headerGroups.get(groupIndex), false, false, -2, groupIndex);
        }
        return this.myHeaderGroupRenderer.getTableCellRendererComponent(this.header.getTable(), headerGroups.get(groupIndex), false, false, -1, groupIndex);
    }

    private PSortableTableModel getSortableModel() {
        if (this.header == null || this.header.getTable() == null || !(this.header.getTable().getModel() instanceof PSortableTableModel)) {
            return null;
        }
        return (PSortableTableModel)this.header.getTable().getModel();
    }

    private static boolean canResizeColumn(TableColumn column, JTableHeader header) {
        return column != null && header.getResizingAllowed() && column.getResizable();
    }

    private ListCellRenderer getInlineFilterRenderer(int column) {
        FilterConfiguration filterConfig = (FilterConfiguration)this.header.getTable().getClientProperty("OrangeTouch.inlineFilterConfiguration");
        return filterConfig == null ? null : filterConfig.getFilterComboBoxRenderer(column);
    }

    private int changeColumnWidth(TableColumn resizingColumn, JTableHeader th, int oldWidth, int newWidth) {
        JTable table;
        Container container;
        resizingColumn.setWidth(newWidth);
        if (th.getParent() == null || (container = th.getParent().getParent()) == null || !(container instanceof JScrollPane) || (table = th.getTable()) == null) {
            return 0;
        }
        if (!container.getComponentOrientation().isLeftToRight() && !th.getComponentOrientation().isLeftToRight()) {
            JViewport viewport = ((JScrollPane)container).getViewport();
            int viewportWidth = viewport.getWidth();
            int diff = newWidth - oldWidth;
            int newHeaderWidth = table.getWidth() + diff;
            Dimension tableSize = table.getSize();
            tableSize.width += diff;
            table.setSize(tableSize);
            if (newHeaderWidth >= viewportWidth && table.getAutoResizeMode() == 0) {
                Point p = viewport.getViewPosition();
                p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                viewport.setViewPosition(p);
                return diff;
            }
        }
        return 0;
    }

    private int getSelectedColumnIndex() {
        int numCols = this.header.getColumnModel().getColumnCount();
        if (this.selectedColumnIndex >= numCols && numCols > 0) {
            this.selectedColumnIndex = numCols - 1;
        }
        return this.selectedColumnIndex;
    }

    private void resize(boolean leftArrow, JTableHeader th, NetTableHeaderUI ui) {
        int oldWidth;
        int columnIndex = ui.getSelectedColumnIndex();
        TableColumn resizingColumn = th.getColumnModel().getColumn(columnIndex);
        th.setResizingColumn(resizingColumn);
        int newWidth = oldWidth = resizingColumn.getWidth();
        newWidth = th.getComponentOrientation().isLeftToRight() ? (newWidth += leftArrow ? -1 : 1) : (newWidth += leftArrow ? 1 : -1);
        ui.changeColumnWidth(resizingColumn, th, oldWidth, newWidth);
    }

    private void installInlineFilters(PSortableTableModel sortModel) {
        this.myFilter = new CompoundFilter();
        int column = 0;
        while (column < this.header.getTable().getColumnCount()) {
            int columnIndex = this.header.getTable().convertColumnIndexToModel(column);
            FilterCombo filterCombo = this.createFilter(columnIndex);
            this.header.add(filterCombo);
            this.myFilterCombos.put(columnIndex, filterCombo);
            ListCellRenderer renderer = this.getInlineFilterRenderer(columnIndex);
            if (renderer != null) {
                filterCombo.setRenderer(renderer);
            }
            this.myFilter.addFilter(filterCombo.getFilter());
            ++column;
        }
        sortModel.setRowFilter(this.myFilter);
        this.setClearAllFiltersButtonVisible(true);
    }

    private void setClearAllFiltersButtonVisible(boolean visible) {
        if (this.header == null) {
            return;
        }
        NetTrailingCornerComponent corner = this.getTrailingCorner();
        if (corner != null) {
            corner.setClearFilterButtonShown(visible);
        }
    }

    private NetTrailingCornerComponent getTrailingCorner() {
        JScrollPane scroll = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.header);
        if (scroll != null && scroll.getCorner("UPPER_TRAILING_CORNER") instanceof NetTrailingCornerComponent) {
            return (NetTrailingCornerComponent)scroll.getCorner("UPPER_TRAILING_CORNER");
        }
        return null;
    }

    private void uninstallInlineFilters(PSortableTableModel sortModel) {
        if (this.myFilter == null) {
            return;
        }
        for (Component component : this.myFilterCombos.values()) {
            this.header.remove(component);
        }
        this.myFilterCombos.clear();
        this.myFilter.removeAllFilters();
        this.myFilter = null;
        sortModel.setRowFilter(null);
        this.setClearAllFiltersButtonVisible(false);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int column) {
        Component component = this.getHeaderRenderer(column);
        if (component instanceof JComponent) {
            this.setupRendererProperties(cellRect, column, component);
        }
        if (this.myFilterHeight > 0) {
            this.layoutFilter(g, column, component);
            this.paintFilterAreaGrid(g, cellRect, column);
        }
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y + this.myHeaderGroupHeight, cellRect.width, cellRect.height - this.myInfoRowHeight - this.myHeaderGroupHeight - this.myFilterHeight, true);
        if (this.myCurrentInfoRow != null && this.myInfoRowVisible) {
            this.paintInfoRow(g, cellRect, column);
        }
        if (this.myHeaderGroupHeight > 0) {
            this.paintHeaderGroup(g, cellRect, column);
        }
    }

    private void setupRendererProperties(Rectangle cellRect, int column, Component component) {
        JComponent jComp = (JComponent)component;
        jComp.putClientProperty("Table.isHeaderRenderer", true);
        jComp.putClientProperty("Table.isLeftEnd", cellRect.x < 4 && this.myHeaderGroupHeight <= 0);
        jComp.putClientProperty("Table.isBelowHeaderGroup", this.myHeaderGroupHeight > 0 && cellRect.x < 4);
        JTable table = this.header.getTable();
        if (table != null) {
            jComp.putClientProperty("OrangeTouch.rootPane", table.getClientProperty("OrangeTouch.rootPane"));
            jComp.putClientProperty("TableHeader.isEnabled", table.isEnabled());
            jComp.putClientProperty("Table.isEmpty", table.getRowCount() == 0);
            jComp.putClientProperty("Table.isFocused", table.isFocusOwner() && table.getSelectedRowCount() == 0 && table.getSelectedColumnCount() == 0);
            jComp.putClientProperty("OrangeTouch.isStandalone", table.getClientProperty("OrangeTouch.isStandalone"));
            jComp.putClientProperty("OrangeTouch.isInLightContainer", table.getClientProperty("OrangeTouch.isInLightContainer"));
            jComp.putClientProperty("OceanTouch.isHovered", ComponentUtils.isRolloveredColumn(this.header, column));
            jComp.putClientProperty("OceanTouch.isHeaderGroupRenderer", false);
        }
        if (this.header.getParent().getParent() instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)this.header.getParent().getParent();
            jComp.putClientProperty("TableHeader.isInScrollPane", true);
            jComp.putClientProperty("OrangeTouch.rootPane", scroll.getClientProperty("OrangeTouch.rootPane"));
        }
        jComp.putClientProperty("Table.isRightEnd", column >= this.header.getColumnModel().getColumnCount() - 1 && !this.isTopTrailingCornerShown() && this.myHeaderGroupHeight <= 0);
    }

    private boolean isTopTrailingCornerShown() {
        JScrollPane scroll;
        Container headerParentsParent = this.header.getParent().getParent();
        return headerParentsParent instanceof JScrollPane && (scroll = (JScrollPane)headerParentsParent).getVerticalScrollBar().isVisible();
    }

    private void paintInfoRow(Graphics g, Rectangle cellRect, int column) {
        Component infoRowRenderer = this.getInfoRowRenderer(column);
        this.rendererPane.paintComponent(g, infoRowRenderer, this.header, cellRect.x, cellRect.y + cellRect.height - this.myInfoRowHeight - this.myFilterHeight, cellRect.width, this.myInfoRowHeight, true);
    }

    private void paintHeaderGroup(Graphics g, Rectangle cellRect, int column) {
        Component headerGroupRenderer = this.getHeaderGroupRenderer(column);
        if (headerGroupRenderer != null) {
            int headerGroupWidth = this.getHeaderGroupWidth(column);
            if (headerGroupRenderer instanceof JComponent) {
                JComponent jComp = (JComponent)headerGroupRenderer;
                jComp.putClientProperty("Table.isLeftEnd", cellRect.x < 4);
                jComp.putClientProperty("Table.isRightEnd", !this.isTopTrailingCornerShown() && cellRect.x + headerGroupWidth > this.header.getWidth() - 4);
                jComp.putClientProperty("OceanTouch.isHeaderGroupRenderer", true);
            }
            if (headerGroupWidth > 0) {
                int xOffset = 0;
                if (this.header.getDraggedColumn() != null && this.header.getTable().convertColumnIndexToView(this.header.getDraggedColumn().getModelIndex()) == column) {
                    xOffset = this.header.getDraggedDistance();
                }
                this.rendererPane.paintComponent(g, headerGroupRenderer, this.header, cellRect.x - xOffset, cellRect.y, headerGroupWidth + 1, this.myHeaderGroupHeight + 1, true);
            }
        }
    }

    private void paintFilterAreaGrid(Graphics g, Rectangle cellRect, int column) {
        g.setColor(NetUtils.getTableOutlineColor(this.header.getTable()));
        g.drawLine(cellRect.x, cellRect.y + cellRect.height - this.myFilterHeight, cellRect.x, cellRect.y + cellRect.height + this.myFilterHeight);
        if (column == this.header.getColumnModel().getColumnCount() - 1) {
            g.drawLine(cellRect.x + cellRect.width - 1, cellRect.y + cellRect.height - this.myFilterHeight, cellRect.x + cellRect.width - 1, cellRect.y + cellRect.height + this.myFilterHeight);
        }
    }

    private void layoutFilter(Graphics g, int column, Component component) {
        Rectangle currentBounds;
        Rectangle filterRect;
        FilterCombo filterComboBox;
        FilterConfiguration filterConfig = (FilterConfiguration)this.header.getTable().getClientProperty("OrangeTouch.inlineFilterConfiguration");
        int modelIndex = this.header.getTable().convertColumnIndexToModel(column);
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("OrangeTouch.isFiltered", false);
        }
        if ((filterComboBox = this.myFilterCombos.get(modelIndex)) == null) {
            filterComboBox = this.createFilter(column);
        }
        if (filterConfig != null) {
            filterComboBox.setHorizontalAlignment();
            this.updateFilterConfiguration();
        }
        if (!(filterRect = this.getFilterBounds(column)).equals(currentBounds = filterComboBox.getBounds())) {
            filterComboBox.setBounds(filterRect);
            filterComboBox.doLayout();
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("OrangeTouch.isFiltered", filterComboBox.getFilter().isActive());
        }
        this.paintRulesAroundFilters(g, filterRect);
    }

    private Rectangle getFilterBounds(int column) {
        Rectangle filterRect = this.header.getHeaderRect(column);
        filterRect.y = filterRect.height - this.myFilterHeight + 2;
        filterRect.height = this.myFilterHeight - 2;
        filterRect.width -= 2;
        filterRect.x += 2;
        if (column == this.header.getColumnModel().getColumnCount() - 1) {
            ++filterRect.width;
        }
        return filterRect;
    }

    private void paintRulesAroundFilters(Graphics g, Rectangle filterRect) {
        int ruleYLocation = filterRect.y - 2;
        g.setColor(NetLookAndFeel.getWhite());
        g.drawLine(filterRect.x, ruleYLocation, filterRect.x + filterRect.width, ruleYLocation);
        g.setColor(this.header.getTable().getGridColor());
        g.drawLine(filterRect.x, filterRect.y + filterRect.height - 1, filterRect.x + filterRect.width, filterRect.y + filterRect.height - 1);
    }

    protected FilterCombo createFilter(int columnIndex) {
        return new FilterCombo(this.header.getTable(), columnIndex);
    }

    private int getHeaderGroupWidth(int columnIndex) {
        int width = -1;
        Map<Integer, Object> headerGroups = this.getHeaderGroups();
        if (headerGroups == null || headerGroups.get(columnIndex) == null) {
            return -1;
        }
        int column = columnIndex;
        while (column < this.header.getColumnModel().getColumnCount()) {
            width += this.header.getTable().getCellRect((int)0, (int)column, (boolean)true).width;
            if (headerGroups.get(column + 1) != null) {
                return width + 2;
            }
            ++column;
        }
        return width + 1;
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    private Component getHeaderRenderer(int columnIndex) {
        FilterCombo filterCombo;
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        boolean isFilterActive = (filterCombo = this.myFilterCombos.get(columnIndex)) == null ? false : filterCombo.getFilter().isActive();
        this.header.putClientProperty("OrangeTouch.isFiltered", isFilterActive);
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private void updateMnemonics(PSortableTableModel model) {
        this.resetMnemonics();
        int column = this.header.getColumnModel().getColumnCount() - 1;
        while (column >= 0) {
            int mnemonic = model.getSortMnemonicAt(column);
            if (mnemonic > 0) {
                this.addMnemonic(column, mnemonic);
            }
            --column;
        }
    }

    private void addMnemonic(int column, int mnemonic) {
        if (this.myMnemonicInputMap == null) {
            this.initMnemonics();
        }
        this.myMnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "sort");
        this.myMnemonicToColumnMap.put(mnemonic, column);
    }

    private void initMnemonics() {
        this.myMnemonicInputMap = new ComponentInputMapUIResource(this.header);
        this.myMnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.header, 2));
        SwingUtilities.replaceUIInputMap(this.header, 2, this.myMnemonicInputMap);
    }

    private void resetMnemonics() {
        if (this.myMnemonicInputMap != null) {
            this.myMnemonicToColumnMap.clear();
            this.myMnemonicInputMap.clear();
        }
    }

    private Dimension createHeaderSize(long width) {
        long tempWidth = width;
        if (tempWidth > Integer.MAX_VALUE) {
            tempWidth = Integer.MAX_VALUE;
        }
        return new Dimension((int)tempWidth, this.getHeaderHeight());
    }

    private int getHeaderHeight() {
        int column;
        int height = 0;
        if (this.header == null || this.header.getTable() == null) {
            return height;
        }
        boolean accomodatedDefault = false;
        TableColumnModel columnModel = this.header.getColumnModel();
        this.myInfoRowHeight = 0;
        this.myFilterHeight = 0;
        this.myHeaderGroupHeight = 0;
        Map<Integer, Object> headerGroups = this.getHeaderGroups();
        if (headerGroups != null) {
            column = 0;
            while (column < columnModel.getColumnCount()) {
                Component headerGroupRenderer = this.getHeaderGroupRenderer(column);
                if (headerGroupRenderer != null) {
                    if (this.myHeaderGroupHeight <= 0) {
                        this.myHeaderGroupHeight = ScaleUtils.scale(21);
                    }
                    this.myHeaderGroupHeight = Math.max(this.myHeaderGroupHeight, headerGroupRenderer.getPreferredSize().height);
                }
                ++column;
            }
        }
        if (ClientPropertyUtil.booleanValue(this.header.getTable(), "OrangeTouch.simpleFilteringEnabled")) {
            this.myFilterHeight = ScaleUtils.scale(this.header.getTable().getRowHeight() + 3);
        }
        column = 0;
        while (column < columnModel.getColumnCount()) {
            boolean useAllColumns;
            if (this.myCurrentInfoRow != null && this.myInfoRowVisible) {
                Component infoRowRenderer = this.getInfoRowRenderer(column);
                int infoRowHeight = infoRowRenderer.getPreferredSize().height;
                this.myInfoRowHeight = Math.max(this.myInfoRowHeight, infoRowHeight);
            }
            TableColumn aColumn = columnModel.getColumn(column);
            boolean bl = useAllColumns = this.header.getTable() != null && Boolean.TRUE.equals(this.header.getTable().getClientProperty("OrangeTouch.calculateHeaderHeightFromRendererHeights"));
            if (aColumn.getHeaderRenderer() != null || useAllColumns || !accomodatedDefault) {
                Insets insets;
                Component comp = this.getHeaderRenderer(column);
                int emptyRendererHeight = 0;
                if (comp instanceof JComponent && (insets = ((JComponent)comp).getInsets()) != null) {
                    emptyRendererHeight = insets.top + insets.bottom;
                }
                int rendererHeight = comp.getPreferredSize().height;
                height = Math.max(height, rendererHeight);
                if (rendererHeight > emptyRendererHeight) {
                    accomodatedDefault = true;
                }
            }
            ++column;
        }
        Insets insets = this.header.getInsets();
        return (height += insets.top + insets.bottom) + this.myInfoRowHeight + this.myHeaderGroupHeight + this.myFilterHeight;
    }

    private void sortColumn(JTableHeader tableHeader, PSortableTableModel sortableModel, int column, boolean multisort) {
        JTable table = tableHeader.getTable();
        if (table == null || !table.isEnabled() || column < 0 || !sortableModel.isColumnSortable(column)) {
            return;
        }
        if (table.isEditing() && table.getCellEditor() != null && !table.getCellEditor().stopCellEditing()) {
            table.getCellEditor().cancelCellEditing();
        }
        int[] rowSel = table.getSelectedRows();
        int i = 0;
        while (i < rowSel.length) {
            rowSel[i] = sortableModel.getOriginalIndex(rowSel[i]);
            ++i;
        }
        int rowLead = table.getSelectionModel().getLeadSelectionIndex();
        if (rowLead > -1) {
            rowLead = sortableModel.getOriginalIndex(rowLead);
        }
        int[] columnSel = table.getSelectedColumns();
        int columnLead = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        tableHeader.repaint();
        if (multisort) {
            sortableModel.subsort(true, column);
        } else {
            sortableModel.sort(true, column);
        }
        tableHeader.getTable().clearSelection();
        int i2 = 0;
        while (i2 < rowSel.length) {
            rowSel[i2] = sortableModel.getSortedIndex(rowSel[i2]);
            ++i2;
        }
        if (rowLead > -1) {
            rowLead = sortableModel.getSortedIndex(rowLead);
        }
        if (this.checkContinuity(rowSel) && this.checkContinuity(columnSel)) {
            if (rowSel.length > 0 && rowSel[0] > -1 && rowSel[rowSel.length - 1] > -1 && columnSel.length > 0 && columnSel[0] > -1 && columnSel[columnSel.length - 1] > -1 && rowSel[rowSel.length - 1] < table.getRowCount() && rowSel[0] < table.getRowCount()) {
                if (rowSel[0] == rowLead) {
                    table.addRowSelectionInterval(rowSel[rowSel.length - 1], rowSel[0]);
                } else {
                    table.addRowSelectionInterval(rowSel[0], rowSel[rowSel.length - 1]);
                }
                if (columnSel[0] == columnLead) {
                    table.addColumnSelectionInterval(columnSel[columnSel.length - 1], columnSel[0]);
                } else {
                    table.addColumnSelectionInterval(columnSel[0], columnSel[columnSel.length - 1]);
                }
            }
        } else {
            if (table.getSelectionModel().getSelectionMode() == 1) {
                return;
            }
            i2 = 0;
            while (i2 < rowSel.length) {
                if (rowSel[i2] > -1 && rowSel[i2] != rowLead && rowSel[i2] < table.getRowCount()) {
                    table.addRowSelectionInterval(rowSel[i2], rowSel[i2]);
                }
                ++i2;
            }
            if (rowLead > -1 && rowSel.length > 0 && rowLead < table.getRowCount()) {
                table.addRowSelectionInterval(rowLead, rowLead);
            }
            i2 = 0;
            while (i2 < columnSel.length) {
                if (columnSel[i2] > -1 && columnSel[i2] != columnLead) {
                    table.addColumnSelectionInterval(columnSel[i2], columnSel[i2]);
                }
                ++i2;
            }
            if (columnLead > -1 && columnSel.length > 0) {
                table.addColumnSelectionInterval(columnLead, columnLead);
            }
        }
    }

    private boolean checkContinuity(int[] selections) {
        int i = 0;
        while (i < selections.length) {
            int deduction;
            if (i > 0 && (deduction = Math.abs(selections[i - 1] - selections[i])) != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    int getRolloverColumnIndex() {
        Point rolloverColumn = (Point)this.header.getClientProperty("BlueTouch.rolloveredCell");
        if (rolloverColumn != null) {
            return (int)rolloverColumn.getX();
        }
        return -1;
    }

    void setRolloverColumnIndex(int rolloverColumnIndex) {
        Point rolloverColumn = (Point)this.header.getClientProperty("BlueTouch.rolloveredCell");
        if (rolloverColumn != null) {
            rolloverColumn.setLocation(rolloverColumnIndex, 0);
        }
    }

    @Override
    public void tableSorted(TableSortEvent event) {
        if (this.myRowSelection == null || this.myColumnSelection == null) {
            return;
        }
        JTable table = this.header.getTable();
        if (!ClientPropertyUtil.booleanValue(table, "OrangeTouch.shouldAdjustSelection", true)) {
            return;
        }
        table.clearSelection();
        PSortableTableModel sortModel = (PSortableTableModel)this.header.getTable().getModel();
        int i = 0;
        while (i < this.myRowSelection.length) {
            this.myRowSelection[i] = sortModel.getSortedIndex(this.myRowSelection[i]);
            ++i;
        }
        if (event.getEventType() == TableSortEvent.TYPE_FILTERED) {
            NetTrailingCornerComponent corner = this.getTrailingCorner();
            if (corner != null && this.getSortableModel() != null && this.getSortableModel().getRowFilter() != null) {
                corner.setClearAllButtonActive(this.getSortableModel().getRowFilter().isActive());
                corner.repaint();
            }
            ArrayList<Integer> visibleSelections = new ArrayList<Integer>();
            int[] nArray = this.myRowSelection;
            int n = this.myRowSelection.length;
            int n2 = 0;
            while (n2 < n) {
                int selection = nArray[n2];
                if (selection >= 0) {
                    visibleSelections.add(selection);
                }
                ++n2;
            }
            if (visibleSelections.size() == 0) {
                table.repaint();
                return;
            }
            this.myRowSelection = new int[visibleSelections.size()];
            int idx = 0;
            Iterator iterator = visibleSelections.iterator();
            while (iterator.hasNext()) {
                int visibleSelection = (Integer)iterator.next();
                this.myRowSelection[idx++] = visibleSelection;
            }
        }
        if (this.myRowLead > -1) {
            this.myRowLead = sortModel.getSortedIndex(this.myRowLead);
        }
        if (this.checkContinuity(this.myRowSelection) && this.checkContinuity(this.myColumnSelection)) {
            if (this.myRowSelection.length > 0 && this.myRowSelection[0] > -1 && this.myRowSelection[this.myRowSelection.length - 1] > -1 && this.myColumnSelection.length > 0 && this.myColumnSelection[0] > -1 && this.myColumnSelection[this.myColumnSelection.length - 1] > -1) {
                if (this.myRowSelection[0] == this.myRowLead) {
                    table.addRowSelectionInterval(this.myRowSelection[this.myRowSelection.length - 1], this.myRowSelection[0]);
                } else {
                    table.addRowSelectionInterval(this.myRowSelection[0], this.myRowSelection[this.myRowSelection.length - 1]);
                }
                if (this.myColumnSelection[0] == this.myColumnLead) {
                    table.addColumnSelectionInterval(this.myColumnSelection[this.myColumnSelection.length - 1], this.myColumnSelection[0]);
                } else {
                    table.addColumnSelectionInterval(this.myColumnSelection[0], this.myColumnSelection[this.myColumnSelection.length - 1]);
                }
            }
        } else {
            if (table.getSelectionModel().getSelectionMode() == 1) {
                return;
            }
            i = 0;
            while (i < this.myRowSelection.length) {
                if (this.myRowSelection[i] > -1 && this.myRowSelection[i] != this.myRowLead) {
                    table.addRowSelectionInterval(this.myRowSelection[i], this.myRowSelection[i]);
                }
                ++i;
            }
            if (this.myRowLead > -1 && this.myRowSelection.length > 0) {
                table.addRowSelectionInterval(this.myRowLead, this.myRowLead);
            }
            i = 0;
            while (i < this.myColumnSelection.length) {
                if (this.myColumnSelection[i] > -1 && this.myColumnSelection[i] != this.myColumnLead) {
                    table.addColumnSelectionInterval(this.myColumnSelection[i], this.myColumnSelection[i]);
                }
                ++i;
            }
            if (this.myColumnLead > -1 && this.myColumnSelection.length > 0) {
                table.addColumnSelectionInterval(this.myColumnLead, this.myColumnLead);
            }
        }
        table.scrollRectToVisible(table.getCellRect(this.myRowLead, this.myColumnLead, true));
        table.repaint();
    }

    @Override
    public void tableWillBeSorted(TableSortEvent event) {
        try {
            JTable table = this.header.getTable();
            if (!ClientPropertyUtil.booleanValue(table, "OrangeTouch.shouldAdjustSelection", true)) {
                return;
            }
            PSortableTableModel sortModel = (PSortableTableModel)this.header.getTable().getModel();
            this.myRowSelection = table.getSelectedRows();
            int i = 0;
            while (i < this.myRowSelection.length) {
                this.myRowSelection[i] = sortModel.getOriginalIndex(this.myRowSelection[i]);
                ++i;
            }
            this.myRowLead = table.getSelectionModel().getLeadSelectionIndex();
            if (this.myRowLead > -1) {
                this.myRowLead = sortModel.getOriginalIndex(this.myRowLead);
            }
            this.myColumnSelection = table.getSelectedColumns();
            this.myColumnLead = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        }
        catch (Exception e) {
            this.myRowSelection = null;
            this.myRowLead = -1;
        }
    }

    private Map<Integer, Object> getHeaderGroups() {
        return (Map)this.header.getTable().getClientProperty("OrangeTouch.headerGroups");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.header != null) {
            this.header.repaint();
        }
    }

    public class RolloverHandler
    extends MouseInputAdapter {
        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Point point = (Point)NetTableHeaderUI.this.header.getClientProperty("OrangeTouch.headerRolloverLocation");
            Point oldPoint = (Point)point.clone();
            point.move(-1, -1);
            int oldColumn = NetTableHeaderUI.this.header.columnAtPoint(oldPoint);
            NetTableHeaderUI.this.header.repaint(NetTableHeaderUI.this.header.getHeaderRect(oldColumn));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point = (Point)NetTableHeaderUI.this.header.getClientProperty("OrangeTouch.headerRolloverLocation");
            int oldColumn = NetTableHeaderUI.this.header.columnAtPoint(point);
            Point newPoint = e.getPoint();
            boolean mouseOnChild = ClientPropertyUtil.booleanValue(NetTableHeaderUI.this.header, "OrangeTouch.isMouseOnChild");
            if (NetTableHeaderUI.this.myHeaderGroupHeight > 0) {
                if (e.getY() < NetTableHeaderUI.this.myHeaderGroupHeight) {
                    NetUtils.setInactiveCursor(NetTableHeaderUI.this.header);
                } else if (NetTableHeaderUI.this.header.getTable().getModel() instanceof PSortableTableModel) {
                    NetUtils.setActiveCursor(NetTableHeaderUI.this.header);
                }
            }
            if (mouseOnChild) {
                NetUtils.setActiveCursor(NetTableHeaderUI.this.header);
            } else if (NetTableHeaderUI.this.header.getTable() != null && !(NetTableHeaderUI.this.header.getTable().getModel() instanceof PSortableTableModel)) {
                NetUtils.setInactiveCursor(NetTableHeaderUI.this.header);
            }
            point.move((int)newPoint.getX(), (int)newPoint.getY());
            NetTableHeaderUI.this.header.repaint(NetTableHeaderUI.this.header.getHeaderRect(oldColumn));
            NetTableHeaderUI.this.header.repaint();
        }
    }

    private class SortAction
    extends AbstractAction {
        private SortAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JTableHeader)) {
                return;
            }
            JTableHeader tableHeader = (JTableHeader)event.getSource();
            if (!tableHeader.isEnabled()) {
                return;
            }
            TableModel model = tableHeader.getTable().getModel();
            if (!(model instanceof PSortableTableModel)) {
                return;
            }
            PSortableTableModel sortableModel = (PSortableTableModel)model;
            String command = event.getActionCommand();
            int column = -1;
            if (command != null && command.length() > 0) {
                Integer value;
                int mnemonic = command.charAt(0);
                if (mnemonic >= 97 && mnemonic <= 122) {
                    mnemonic -= 32;
                }
                if ((value = (Integer)NetTableHeaderUI.this.myMnemonicToColumnMap.get(mnemonic)) != null) {
                    column = value;
                }
            }
            NetTableHeaderUI.this.sortColumn(tableHeader, sortableModel, column, false);
        }
    }

    public class SorterMouseHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        public SorterMouseHandler() {
            super(NetTableHeaderUI.this);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (NetTableHeaderUI.this.myHeaderGroupHeight > 0) {
                NetTableHeaderUI.this.header.repaint();
                NetTableHeaderUI.this.setRolloverColumnIndex(-1);
                return;
            }
            if (NetTableHeaderUI.this.getRolloverColumnIndex() != -1 && NetTableHeaderUI.this.getRolloverColumnIndex() < NetTableHeaderUI.this.header.getColumnModel().getColumnCount()) {
                NetTableHeaderUI.this.header.repaint();
                NetTableHeaderUI.this.setRolloverColumnIndex(-1);
            }
            if (NetTableHeaderUI.this.header.getCursor() == Cursor.getPredefinedCursor(11)) {
                this.swapCursor();
            }
            super.mouseExited(evt);
        }

        public void swapCursor() {
            Cursor tmp = NetTableHeaderUI.this.header.getCursor();
            NetTableHeaderUI.this.header.setCursor(NetTableHeaderUI.this.mySwapCursor);
            NetTableHeaderUI.this.mySwapCursor = tmp;
        }

        private boolean canResize(TableColumn column, JTableHeader tableHeader) {
            return column != null && tableHeader.getResizingAllowed() && column.getResizable();
        }

        private TableColumn getResizingColumn(Point p, int column) {
            int columnIndex;
            if (column == -1) {
                return null;
            }
            Rectangle r = NetTableHeaderUI.this.header.getHeaderRect(column);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return null;
            }
            int midPoint = r.x + r.width / 2;
            if (NetTableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                columnIndex = p.x < midPoint ? column - 1 : column;
            } else {
                int n = columnIndex = p.x < midPoint ? column : column - 1;
            }
            if (columnIndex == -1) {
                return null;
            }
            return NetTableHeaderUI.this.header.getColumnModel().getColumn(columnIndex);
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            boolean mouseOverFilterArea;
            if (NetTableHeaderUI.this.header == null || !NetTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            if (this.canResize(this.getResizingColumn(evt.getPoint(), NetTableHeaderUI.this.header.columnAtPoint(evt.getPoint())), NetTableHeaderUI.this.header) != (NetTableHeaderUI.this.header.getCursor() == Cursor.getPredefinedCursor(11))) {
                this.swapCursor();
            }
            Rectangle groupRect = this.getHeaderGroupRect(NetTableHeaderUI.this.header.getTable().columnAtPoint(evt.getPoint()));
            groupRect.grow(-3, 0);
            if (!groupRect.contains(evt.getPoint()) || NetTableHeaderUI.this.header.getCursor() == Cursor.getPredefinedCursor(11)) {
                super.mouseMoved(evt);
            }
            if (NetTableHeaderUI.this.myHeaderGroupHeight > 0) {
                NetTableHeaderUI.this.header.repaint();
            }
            int columnIndex = NetTableHeaderUI.this.header.getTable().columnAtPoint(evt.getPoint());
            boolean mouseOverInfoRow = evt.getY() > ((NetTableHeaderUI)NetTableHeaderUI.this).header.getSize().height - NetTableHeaderUI.this.myInfoRowHeight;
            boolean mouseOverHeaderGroup = evt.getY() < NetTableHeaderUI.this.myHeaderGroupHeight;
            boolean bl = mouseOverFilterArea = evt.getY() > NetTableHeaderUI.this.header.getHeight() - NetTableHeaderUI.this.myFilterHeight;
            if (mouseOverInfoRow || mouseOverHeaderGroup || mouseOverFilterArea) {
                NetTableHeaderUI.this.setRolloverColumnIndex(-1);
                NetTableHeaderUI.this.header.repaint();
                return;
            }
            if (columnIndex != NetTableHeaderUI.this.getRolloverColumnIndex() && NetTableHeaderUI.this.getRolloverColumnIndex() != -1) {
                if (NetTableHeaderUI.this.getRolloverColumnIndex() >= 0 && NetTableHeaderUI.this.getRolloverColumnIndex() < NetTableHeaderUI.this.header.getColumnModel().getColumnCount()) {
                    Rectangle rect = NetTableHeaderUI.this.header.getHeaderRect(NetTableHeaderUI.this.getRolloverColumnIndex());
                    NetTableHeaderUI.this.header.repaint(rect.x, rect.y, rect.width + 2, rect.height);
                }
                if (columnIndex == -1) {
                    NetTableHeaderUI.this.setRolloverColumnIndex(-1);
                }
            }
            if (columnIndex >= 0 && columnIndex < NetTableHeaderUI.this.header.getColumnModel().getColumnCount() && columnIndex != NetTableHeaderUI.this.getRolloverColumnIndex()) {
                NetTableHeaderUI.this.setRolloverColumnIndex(columnIndex);
                NetTableHeaderUI.this.header.repaint();
            }
        }

        public int getPreferredColumnWidth(int columnIndex) {
            JTable table = NetTableHeaderUI.this.header.getTable();
            int result = 10;
            if (table != null && table.getModel() != null) {
                int rowIndex = 0;
                while (rowIndex < table.getRowCount()) {
                    Component renderer = table.prepareRenderer(table.getCellRenderer(rowIndex, columnIndex), rowIndex, columnIndex);
                    if (renderer instanceof JLabel && ClientPropertyUtil.booleanValue((JLabel)renderer, "OrangeTouch.isFileChooserRenderer")) {
                        JLabel label = (JLabel)renderer;
                        if (label.getUI().getPreferredSize(label) != null) {
                            result = Math.max(result, label.getUI().getPreferredSize((JComponent)label).width);
                        }
                    } else {
                        result = Math.max(result, renderer.getPreferredSize().width);
                    }
                    ++rowIndex;
                }
                result = Math.max(result, this.getHeaderRenderer((int)columnIndex).getPreferredSize().width);
                result += table.getIntercellSpacing().width;
                if (columnIndex == NetTableHeaderUI.this.header.getColumnModel().getColumnCount() - 1) {
                    result += table.getIntercellSpacing().width + 1;
                }
            }
            return result + 1;
        }

        public int getAvailableWidthForSubsequentColumns(int resizedColumn, boolean wantsToGrow) {
            int result = 0;
            if (resizedColumn == NetTableHeaderUI.this.header.getColumnModel().getColumnCount() - 1) {
                return 0;
            }
            int columnIndex = resizedColumn + 1;
            while (columnIndex < NetTableHeaderUI.this.header.getColumnModel().getColumnCount()) {
                TableColumn column = NetTableHeaderUI.this.header.getColumnModel().getColumn(columnIndex);
                int diff = 0;
                if (wantsToGrow) {
                    diff = column.getWidth() - column.getMinWidth();
                } else {
                    if (column.getMaxWidth() == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    diff = column.getMaxWidth() - column.getWidth();
                }
                result += diff;
                ++columnIndex;
            }
            return result;
        }

        private int getResizedColumnIndex(MouseEvent event) {
            TableColumn column;
            Point point = event.getPoint();
            int columnIndex = NetTableHeaderUI.this.header.columnAtPoint(point);
            if (columnIndex < 0) {
                return -1;
            }
            Rectangle headerRect = NetTableHeaderUI.this.header.getHeaderRect(columnIndex);
            headerRect.grow(-3, 0);
            if (headerRect.contains(point)) {
                return -1;
            }
            if (point.getX() < headerRect.getX() + headerRect.getWidth() / 2.0) {
                if (columnIndex <= 0) {
                    return -1;
                }
                --columnIndex;
            }
            if (!NetTableHeaderUI.canResizeColumn(column = NetTableHeaderUI.this.header.getColumnModel().getColumn(columnIndex), NetTableHeaderUI.this.header)) {
                return -1;
            }
            return columnIndex;
        }

        private Component getHeaderRenderer(int columnIndex) {
            TableColumn aColumn = NetTableHeaderUI.this.header.getColumnModel().getColumn(columnIndex);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = NetTableHeaderUI.this.header.getDefaultRenderer();
            }
            return renderer.getTableCellRendererComponent(NetTableHeaderUI.this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            boolean infoRowClicked;
            boolean headerGroupClicked;
            int resizedColumnIndex = this.getResizedColumnIndex(evt);
            if (resizedColumnIndex < 0) {
                super.mouseClicked(evt);
            }
            if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt)) {
                this.resizeColumnToPreferredWidth(resizedColumnIndex);
                if (resizedColumnIndex >= 0 && NetTableHeaderUI.this.myFilterHeight > 0) {
                    NetTableHeaderUI.this.resize(true, NetTableHeaderUI.this.header, NetTableHeaderUI.this);
                    NetTableHeaderUI.this.header.revalidate();
                    NetTableHeaderUI.this.header.doLayout();
                    NetTableHeaderUI.this.header.repaint();
                }
                return;
            }
            TableModel model = NetTableHeaderUI.this.header.getTable().getModel();
            int viewColumn = NetTableHeaderUI.this.header.columnAtPoint(evt.getPoint());
            boolean bl = headerGroupClicked = evt.getY() < NetTableHeaderUI.this.myHeaderGroupHeight;
            if (!headerGroupClicked) {
                Rectangle headerRect = NetTableHeaderUI.this.header.getHeaderRect(viewColumn);
                headerRect.y += NetTableHeaderUI.this.myHeaderGroupHeight;
                headerRect.height -= NetTableHeaderUI.this.myHeaderGroupHeight;
                headerRect.x -= 2;
                headerRect.width += 2;
                NetTableHeaderUI.this.header.paintImmediately(headerRect);
            }
            boolean mouseOnChild = ClientPropertyUtil.booleanValue(NetTableHeaderUI.this.header, "OrangeTouch.isMouseOnChild");
            if (!(model instanceof PSortableTableModel) || resizedColumnIndex >= 0) {
                if (mouseOnChild) {
                    this.clickHeaderButton(viewColumn);
                }
                return;
            }
            PSortableTableModel sortableModel = (PSortableTableModel)model;
            JTableHeader tableHeader = (JTableHeader)evt.getSource();
            if (!tableHeader.isEnabled() || SwingUtilities.isRightMouseButton(evt)) {
                return;
            }
            int column = tableHeader.getTable().convertColumnIndexToModel(viewColumn);
            boolean bl2 = infoRowClicked = evt.getY() > tableHeader.getSize().height - NetTableHeaderUI.this.myInfoRowHeight;
            if (!(infoRowClicked || headerGroupClicked || mouseOnChild || evt.getY() >= tableHeader.getSize().height - NetTableHeaderUI.this.myFilterHeight)) {
                NetTableHeaderUI.this.sortColumn(tableHeader, sortableModel, column, evt.isControlDown());
            } else if (mouseOnChild) {
                this.clickHeaderButton(viewColumn);
            }
        }

        private void clickHeaderButton(int viewColumn) {
            Container container;
            Component renderer = this.getHeaderRenderer(viewColumn);
            if (renderer instanceof Container && (container = (Container)renderer).getComponentCount() > 0 && container.getComponent(0) instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)container.getComponent(0);
                button.doClick();
                NetTableHeaderUI.this.header.repaint(NetTableHeaderUI.this.header.getHeaderRect(viewColumn));
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Point point = evt.getPoint();
            int tableColumn = NetTableHeaderUI.this.header.columnAtPoint(point);
            Rectangle headerGroupRect = this.getHeaderGroupRect(tableColumn);
            headerGroupRect.grow(-3, 0);
            if (headerGroupRect.contains(point)) {
                return;
            }
            super.mousePressed(evt);
        }

        private int getHeaderGroupIndex(int columnIndex) {
            Map headerGroups = NetTableHeaderUI.this.getHeaderGroups();
            if (headerGroups == null) {
                return -1;
            }
            int currentGroup = 0;
            for (Integer groupIndex : headerGroups.keySet()) {
                if (groupIndex <= columnIndex) {
                    currentGroup = groupIndex;
                    continue;
                }
                return currentGroup;
            }
            return currentGroup;
        }

        private Rectangle getHeaderGroupRect(int columnIndex) {
            int groupIndex = this.getHeaderGroupIndex(columnIndex);
            Rectangle result = NetTableHeaderUI.this.header.getHeaderRect(groupIndex);
            result.width = NetTableHeaderUI.this.getHeaderGroupWidth(groupIndex);
            result.height = NetTableHeaderUI.this.myHeaderGroupHeight;
            return result;
        }

        protected void resizeColumnToPreferredWidth(int resizedColumnIndex) {
            if (resizedColumnIndex < 0) {
                return;
            }
            TableColumn column = NetTableHeaderUI.this.header.getColumnModel().getColumn(resizedColumnIndex);
            int preferredColumnWidth = this.getPreferredColumnWidth(resizedColumnIndex);
            int diff = preferredColumnWidth - column.getWidth();
            if (diff == 0) {
                return;
            }
            if (NetTableHeaderUI.this.header.getTable().getAutoResizeMode() == 0) {
                NetTableHeaderUI.this.header.setResizingColumn(column);
                column.setWidth(preferredColumnWidth);
                Dimension tableSize = NetTableHeaderUI.this.header.getTable().getSize();
                tableSize.width += diff;
                NetTableHeaderUI.this.header.getTable().setSize(tableSize);
                NetTableHeaderUI.this.header.setResizingColumn(null);
                NetTableHeaderUI.this.header.revalidate();
                NetTableHeaderUI.this.header.getTable().repaint();
                NetTableHeaderUI.this.header.repaint();
                return;
            }
            boolean wantsToGrow = diff > 0;
            int oldMode = -1;
            int availableWidth = this.getAvailableWidthForSubsequentColumns(resizedColumnIndex, wantsToGrow);
            if (Math.abs(availableWidth) < Math.abs(diff)) {
                oldMode = NetTableHeaderUI.this.header.getTable().getAutoResizeMode();
                NetTableHeaderUI.this.header.getTable().setAutoResizeMode(4);
            }
            NetTableHeaderUI.this.header.setResizingColumn(column);
            int idx = 0;
            while (idx < 10) {
                column.setWidth(preferredColumnWidth);
                column.setPreferredWidth(preferredColumnWidth);
                NetTableHeaderUI.this.header.getTable().doLayout();
                ++idx;
            }
            NetTableHeaderUI.this.header.revalidate();
            NetTableHeaderUI.this.header.getTable().repaint();
            NetTableHeaderUI.this.header.repaint();
            NetTableHeaderUI.this.header.setResizingColumn(null);
            if (oldMode != -1) {
                NetTableHeaderUI.this.header.getTable().setAutoResizeMode(oldMode);
            }
        }
    }
}

