/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.borders.TablePanelBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.table.PCellStatusTableModel;
import com.nokia.widgets.table.PDefaultCellEditor;
import com.nokia.widgets.table.PDisabledTableModel;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.table.PValidatableTableModel;
import com.nokia.widgets.table.TableHighlight;
import com.nokia.widgets.table.TristateCheckBoxRenderer;
import com.nokia.widgets.table.TristateValue;
import com.nokia.widgets.text.DecimalDocument;
import com.nokia.widgets.text.IntegerDocument;
import com.nokia.widgets.text.LongDocument;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.NSNColors;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;

public class NetTableUI
extends BasicTableUI {
    private static Color theUnEditableRowBackground1 = UIManager.getColor("Table.UnEditableRowBackground1");
    private static Color theUnEditableRowBackground2 = UIManager.getColor("Table.UnEditableRowBackground2");
    private static Color theUnEditableGridHorizontal1 = UIManager.getColor("Table.UnEditableGridHorizontal1");
    private static Color theUnEditableGridHorizontal2 = UIManager.getColor("Table.UnEditableGridHorizontal2");
    private static Color theUnEditableGridVertical = UIManager.getColor("Table.UnEditableGridVertical");
    private static Color theUneditableForeground = UIManager.getColor("Table.UneditableForeground");
    private static Color theSelectedAndFocusedCellBackground;
    private static Color theDisabledForeground;
    private static Color theDisabledDialogBackground;
    private static Icon theModifiedIcon;
    private static Icon theWarnedIcon;
    private PropertyChangeListener myBorderHandler = new BorderHandler();
    private MouseInputAdapter myRolloverHandler = new RolloverHandler();
    private ContainerListener myEditorHandler = new EditorBoundsHandler();
    private FocusListener myFocusHandler = new FocusHandler();
    private Insets myInsets = new Insets(0, 0, 0, 0);
    private boolean myReadOnly = false;
    private Object myRowSorter;
    private Method myConverterMethod;
    private int myLeftMostColumn = -1;
    private PValidatableTableModel myValidatableTableModel;
    private PDisabledTableModel myDisabledTableModel;
    private ListSelectionListener mySelectionHandler = new ListSelectionHandler();

    static {
        theDisabledForeground = UIManager.getColor("Label.disabledForeground");
        theSelectedAndFocusedCellBackground = UIManager.getColor("Table.SelectedFocusedBackground");
        theDisabledDialogBackground = UIManager.getColor("Table.disabledDialogBackground");
        theModifiedIcon = CommonIcons.getEditIcon();
        theWarnedIcon = CommonIcons.getWarningIcon();
    }

    public static ComponentUI createUI(JComponent c) {
        return new NetTableUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.table.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.table.setSurrendersFocusOnKeystroke(true);
        Object value = UIManager.get("OrangeTouch.terminateEditOnFocusLost");
        if (value == null || Boolean.TRUE.equals(value)) {
            this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }
        this.installDefaultRenderers();
        this.installDefaultEditors();
        this.installRowHeight();
        this.table.putClientProperty("BlueTouch.rolloveredCell", new Point(-1, -1));
        this.setInterCellSpacing();
        if (this.table.getParent() instanceof JViewport && this.table.getParent().getParent() instanceof JScrollPane) {
            LookAndFeel.uninstallBorder(this.table);
            if (this.table.getTableHeader() != null) {
                LookAndFeel.uninstallBorder(this.table.getTableHeader());
            }
        } else {
            LookAndFeel.installBorder(this.table, "Table.border");
            if (this.table.getTableHeader() != null) {
                LookAndFeel.installBorder(this.table.getTableHeader(), "Table.border");
            }
        }
        if (SystemUtils.isAfterJava15()) {
            try {
                this.myRowSorter = this.table.getClass().getMethod("getRowSorter", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setInterCellSpacing() {
        if (!this.isAlternate() && this.table.getShowHorizontalLines()) {
            this.table.setIntercellSpacing(new DimensionUIResource(1, 1));
        } else {
            this.table.setIntercellSpacing(new DimensionUIResource(1, 0));
        }
        this.installRowHeight();
    }

    private void installRowHeight() {
        int increment = NetLookAndFeel.getFontSizeIncrement();
        int defaultHeight = ComponentUtils.isSmall(this.table) ? 20 : 26;
        float defaultFontSize = 14.0f;
        this.table.setRowHeight((int)((float)defaultHeight + (float)defaultHeight / 14.0f * (float)increment));
    }

    private void installDefaultEditors() {
        this.table.setDefaultEditor(Boolean.class, new BooleanEditor());
        this.table.setDefaultEditor(Object.class, new GenericEditor());
        this.table.setDefaultEditor(Number.class, new NumberEditor());
    }

    private void installDefaultRenderers() {
        this.table.setDefaultRenderer(Number.class, new NumberRenderer());
        this.table.setDefaultRenderer(Integer.class, new NumberRenderer());
        this.table.setDefaultRenderer(Double.class, new DoubleRenderer());
        this.table.setDefaultRenderer(Float.class, new DoubleRenderer());
        this.table.setDefaultRenderer(Object.class, new PTableCellRenderer());
        this.table.setDefaultRenderer(Icon.class, new IconRenderer());
        this.table.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.table.setDefaultRenderer(Date.class, new DateRenderer());
        this.table.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        TristateCheckBoxRenderer renderer = new TristateCheckBoxRenderer();
        renderer.setSizeVariant("small");
        this.table.setDefaultRenderer(TristateValue.class, renderer);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        InputMap inputMap = this.table.getInputMap(1);
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        this.table.getActionMap().put(inputMap.get(enter), new EnterAction());
    }

    @Override
    protected void uninstallKeyboardActions() {
        InputMap inputMap = this.table.getInputMap(1);
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        this.table.getActionMap().remove(inputMap.get(enter));
        super.uninstallKeyboardActions();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.table.addPropertyChangeListener(this.myBorderHandler);
        this.table.addMouseMotionListener(this.myRolloverHandler);
        this.table.addMouseListener(this.myRolloverHandler);
        this.table.addContainerListener(this.myEditorHandler);
        this.table.addFocusListener(this.myFocusHandler);
        if (this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().addListSelectionListener(this.mySelectionHandler);
        }
        ReadOnlyHandler.getInstance().installTo(this.table);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removePropertyChangeListener(this.myBorderHandler);
        this.table.removeMouseMotionListener(this.myRolloverHandler);
        this.table.removeMouseListener(this.myRolloverHandler);
        this.table.removeContainerListener(this.myEditorHandler);
        this.table.removeFocusListener(this.myFocusHandler);
        if (this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.mySelectionHandler);
        }
        ReadOnlyHandler.getInstance().uninstallFrom(this.table);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.initCustomModels();
        if (c.isOpaque()) {
            Color oldColor = g.getColor();
            GradientUtils.drawVerticalBackgroundGradient((Container)c, g, c.getParent() instanceof JViewport ? 1 : 0);
            int contentSize = this.table.getRowCount() * this.table.getRowHeight();
            if (c.getParent() instanceof JViewport && contentSize < c.getParent().getHeight()) {
                Shape oldClip = g.getClip();
                g.clipRect(0, contentSize, this.table.getWidth(), this.table.getHeight());
                NetUtils.paintTableBackgroundFilter(g, this.table, SwingUtilities.getLocalBounds(c));
                g.setClip(oldClip);
            }
            if (!(c.getBackground() instanceof UIResource)) {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, this.table.getWidth(), this.table.getHeight());
            }
            g.setColor(oldColor);
            this.paint(g, c);
            return;
        }
        super.update(g, c);
    }

    protected void initCustomModels() {
        TableModel model = this.table.getModel();
        this.myValidatableTableModel = model instanceof PValidatableTableModel ? (PValidatableTableModel)model : null;
        this.myDisabledTableModel = model instanceof PDisabledTableModel ? (PDisabledTableModel)((Object)model) : null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        NetLookAndFeel.toggleTextAntialiasing(g);
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            this.paintEmptyText(g);
            return;
        }
        this.myLeftMostColumn = -1;
        this.myReadOnly = ComponentUtils.isReadOnly(this.table);
        Rectangle clip = g.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
    }

    protected void paintEmptyText(Graphics g) {
        String emptyText = this.getEmptyText();
        if (emptyText == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        Insets insets = this.table.getInsets();
        if (this.table.getBorder() instanceof TablePanelBorder && this.table.isEnabled()) {
            g.setColor(NetLookAndFeel.getWhite());
            g.fillRect(insets.left, 0, this.table.getWidth() - 1 - (insets.left + insets.right), this.table.getHeight() - 1 - insets.bottom);
        }
        if (this.table.isFocusOwner()) {
            Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            focusBorder.paintBorder(this.table, g, insets.left, insets.top, this.table.getWidth() - (insets.left + insets.right), fm.getHeight() + 1);
        }
        g.setColor(this.table.isEnabled() ? UIManager.getColor("Table.emptyText") : UIManager.getColor("Label.disabledForeground"));
        g.drawString(emptyText, 10, fm.getMaxAscent() + 1);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension result = super.getPreferredSize(c);
        if (this.table.getRowCount() <= 0 && this.getEmptyText() != null) {
            FontMetrics fm = this.table.getFontMetrics(this.table.getFont());
            result.height += fm.getHeight() + 1;
        }
        Insets insets = this.table.getInsets();
        if (this.table.getParent() instanceof JViewport) {
            ++result.height;
        }
        result.height += insets.top + insets.bottom;
        if (!ClientPropertyUtil.booleanValue(this.table, "OrangeTouch.inDoLayout")) {
            result.width += insets.left + insets.right;
        }
        return result;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension result = super.getMinimumSize(c);
        Insets insets = this.table.getInsets();
        if (this.table.getParent() instanceof JViewport) {
            ++result.height;
        }
        result.height += insets.top + insets.bottom;
        result.width += insets.left + insets.right;
        return result;
    }

    protected String getEmptyText() {
        Object emptyText = this.table.getClientProperty("OrangeTouch.emptyText");
        if (emptyText == null) {
            emptyText = UIManager.get("Table.defaultEmptyText");
        }
        return emptyText == null ? null : emptyText.toString();
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        boolean useCustomGridColor = !(this.table.getGridColor() instanceof UIResource);
        boolean alternate = this.isAlternate();
        if (this.table.getShowHorizontalLines() && !alternate) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            int row = rMin;
            while (row <= rMax) {
                Color horizontalGridColor = useCustomGridColor ? this.table.getGridColor() : ((row % 2 == 0 || this.table.getColumnCount() > 1 && this.table.isCellEditable(row, 1)) && this.table.isEnabled() ? theUnEditableGridHorizontal1 : theUnEditableGridHorizontal2);
                g.setColor(horizontalGridColor);
                g.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                ++row;
            }
        }
        if (this.table.getShowVerticalLines()) {
            int column;
            if (useCustomGridColor) {
                g.setColor(this.table.getGridColor());
            } else {
                g.setColor(this.table.isEnabled() ? theUnEditableGridVertical : UIManager.getColor("Table.bottomRuleColor"));
            }
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int x = damagedArea.x;
                column = cMin;
                while (column <= cMax) {
                    if (column != this.table.getColumnCount() - 1) {
                        int w = cm.getColumn(column).getWidth();
                        int height = column < this.table.getColumnCount() - 1 ? tableHeight - 1 : tableHeight - 4;
                        g.drawLine((x += w) - 1, 0, x - 1, height);
                    }
                    ++column;
                }
            } else {
                int x = damagedArea.x + damagedArea.width;
                column = cMin;
                while (column < cMax) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x -= w) - 1, 0, x - 1, tableHeight - 1);
                    ++column;
                }
                g.drawLine(x -= cm.getColumn(cMax).getWidth(), 0, x, tableHeight - 1);
            }
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JScrollPane scroll;
        int row;
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        Rectangle cellRect = null;
        int cellRectOffset = 0;
        if (!(this.table instanceof PTable)) {
            this.table.getInsets(this.myInsets);
            cellRectOffset = this.myInsets.left;
        }
        String highlightedText = (String)this.table.getClientProperty("OrangeTouch.highlightText");
        if (this.table.getComponentOrientation().isLeftToRight()) {
            row = rMin;
            while (row <= rMax) {
                cellRect = this.table.getCellRect(row, cMin, false);
                int column = cMin;
                while (column <= cMax) {
                    boolean firstColumn;
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (column == this.table.getColumnCount() - 1 && this.table instanceof PTable && this.table.getParent() instanceof JViewport) {
                        ++cellRect.width;
                    }
                    boolean bl = firstColumn = column == 0;
                    if (firstColumn) {
                        cellRect.x += cellRectOffset;
                        cellRect.width -= cellRectOffset;
                    }
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, highlightedText, row, column);
                    }
                    if (firstColumn) {
                        cellRect.x -= cellRectOffset;
                        cellRect.width += cellRectOffset;
                    }
                    cellRect.x += columnWidth;
                    ++column;
                }
                ++row;
            }
        } else {
            row = rMin;
            while (row <= rMax) {
                int columnWidth;
                cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, highlightedText, row, cMin);
                }
                int column = cMin + 1;
                while (column <= cMax) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, highlightedText, row, column);
                    }
                    ++column;
                }
                ++row;
            }
        }
        if (this.table.getShowHorizontalLines()) {
            this.paintBottomRule(g, rMax, cellRect);
        }
        if (!ComponentUtils.isStandalone(this.table) && this.table.getParent() instanceof JViewport && this.table.getParent().getParent() instanceof JScrollPane && !(scroll = (JScrollPane)this.table.getParent().getParent()).getVerticalScrollBar().isVisible() && this.table.getShowHorizontalLines()) {
            g.setColor(UIManager.getColor("Table.bottomRuleColor"));
            g.drawLine(0, 0, 0, this.table.getHeight() - 2);
            g.drawLine(this.table.getWidth() - 1, 0, this.table.getWidth() - 1, this.table.getHeight() - 2);
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintBottomRule(Graphics g, int rMax, Rectangle cellRect) {
        if (this.table.getRowCount() == 0) {
            return;
        }
        if (cellRect != null && rMax == this.table.getRowCount() - 1) {
            Insets insets = this.table.getInsets();
            g.setColor(UIManager.getColor("Table.bottomRuleColor"));
            g.drawLine(insets.left, cellRect.y + cellRect.height, this.table.getWidth() - 1 - insets.right, cellRect.y + cellRect.height);
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, String highlightedText, int row, int column) {
        boolean hasFocus;
        if (this.myLeftMostColumn < 0 && cellRect.x < 4) {
            this.myLeftMostColumn = column;
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        TableColumnModel columnModel = this.table.getColumnModel();
        boolean rowIsLead = selectionModel.getLeadSelectionIndex() == row;
        boolean colIsLead = columnModel.getSelectionModel().getLeadSelectionIndex() == column;
        boolean bl = hasFocus = rowIsLead && colIsLead && this.table.isFocusOwner();
        if (this.table.isFocusOwner() && (selectionModel.getLeadSelectionIndex() < 0 || columnModel.getSelectionModel().getLeadSelectionIndex() < 0)) {
            boolean bl2 = hasFocus = row == 0 && column == 0;
        }
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.prepareRenderer(renderer, row, column, hasFocus);
            boolean disabled = this.table != null && !this.table.isEnabled() || component != null && !component.isEnabled();
            this.paintInvalidIndicator(g, cellRect, row, column, component);
            JLabel label = null;
            if (highlightedText != null && component instanceof JLabel) {
                label = (JLabel)component;
                NetUtils.highlight(label, highlightedText);
                this.addSingleHighlight(label, row, column);
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            if (this.table.isEnabled() && disabled && row > 0 && !hasFocus && !this.table.isCellSelected(row, column) && row % 2 == 1) {
                g.setColor(UIManager.getColor("Table.disabledGridColor"));
                g.drawLine(cellRect.x, cellRect.y, cellRect.x + cellRect.width - 1, cellRect.y);
                if (row < this.table.getRowCount() - 1) {
                    g.drawLine(cellRect.x, cellRect.y + cellRect.height - 1, cellRect.x + cellRect.width - 1, cellRect.y + cellRect.height - 1);
                }
            }
            if (component != null) {
                this.paintMandatoryIndicator(g, cellRect, row, column, component, hasFocus);
                this.paintStatusIcon(g, cellRect, row, column, component, hasFocus);
                if (label != null) {
                    NetUtils.clearHighlights(label);
                }
            }
        }
    }

    protected void addSingleHighlight(JLabel label, int row, int column) {
        TableHighlight singleHighlight = (TableHighlight)this.table.getClientProperty("OrangeTouch.tableEmphasizedHighlight");
        if (singleHighlight == null) {
            return;
        }
        int highlightedRow = singleHighlight.getRow();
        if (this.table.getModel() instanceof PSortableTableModel) {
            highlightedRow = ((PSortableTableModel)this.table.getModel()).getSortedIndex(highlightedRow);
        }
        if (row == highlightedRow && column == this.table.convertColumnIndexToView(singleHighlight.getColumn())) {
            this.singleHighlight(label, singleHighlight);
        }
    }

    protected void paintStatusIcon(Graphics g, Rectangle cellRect, int row, int column, Component component, boolean hasFocus) {
        PCellStatusTableModel statusModel = null;
        if (this.table.isEnabled() && this.table.getModel() instanceof PCellStatusTableModel) {
            statusModel = (PCellStatusTableModel)((Object)this.table.getModel());
        }
        int modelColumn = this.table.convertColumnIndexToModel(column);
        int modelRow = this.convertRowIndexToModelUsingRowSorter(row);
        boolean modified = statusModel != null && statusModel.isCellModified(modelRow, modelColumn);
        boolean warned = statusModel != null && statusModel.isCellWarned(modelRow, modelColumn);
        int iconXPos = cellRect.x + cellRect.width - theModifiedIcon.getIconWidth() - 5;
        int xOffset = 0;
        if (component instanceof JComponent && ClientPropertyUtil.hasProperty((JComponent)component, "OrangeTouch.mandatoryAsteriskXOffset")) {
            xOffset = ClientPropertyUtil.intValue((JComponent)component, "OrangeTouch.mandatoryAsteriskXOffset");
        }
        if (warned) {
            Shape oldClip = g.getClip();
            g.setClip(cellRect);
            theWarnedIcon.paintIcon(this.table, g, iconXPos + xOffset, cellRect.y + cellRect.height / 2 - theWarnedIcon.getIconHeight() / 2);
            g.setClip(oldClip);
        } else if (modified) {
            Shape oldClip = g.getClip();
            g.setClip(cellRect);
            theModifiedIcon.paintIcon(this.table, g, iconXPos + xOffset + 3, cellRect.y + cellRect.height / 2 - theModifiedIcon.getIconHeight() / 2);
            g.setClip(oldClip);
        }
    }

    protected void paintMandatoryIndicator(Graphics g, Rectangle cellRect, int row, int column, Component component, boolean hasFocus) {
        if (!this.table.isEnabled() || this.myValidatableTableModel == null || !this.table.isCellEditable(row, column)) {
            return;
        }
        int modelColumn = this.table.convertColumnIndexToModel(column);
        int modelRow = this.convertRowIndexToModelUsingRowSorter(row);
        if (this.myValidatableTableModel.isMandatory(modelRow, modelColumn) && this.myValidatableTableModel.isMissing(modelRow, modelColumn)) {
            int xOffset = 0;
            if (component instanceof JComponent && ClientPropertyUtil.hasProperty((JComponent)component, "OrangeTouch.mandatoryAsteriskXOffset")) {
                xOffset = ClientPropertyUtil.intValue((JComponent)component, "OrangeTouch.mandatoryAsteriskXOffset");
            }
            NetUtils.paintMandatoryAsterisk(g, (JComponent)component, cellRect.x + cellRect.width + 5 + xOffset, cellRect.y + cellRect.height / 2 + 1, 8);
        }
    }

    protected void paintInvalidIndicator(Graphics g, Rectangle cellRect, int row, int column, Component component) {
        Color cellForeground;
        if (this.myValidatableTableModel == null) {
            return;
        }
        int modelColumn = this.table.convertColumnIndexToModel(column);
        int modelRow = this.convertRowIndexToModelUsingRowSorter(row);
        if (!this.myValidatableTableModel.isValid(modelRow, modelColumn) && this.table.isEnabled() && ((cellForeground = component.getForeground()) == null || cellForeground instanceof UIResource)) {
            component.setForeground(UIManager.getColor("TextField.invalidForeground"));
            component.setFont(UIManager.getFont("TextField.invalidFont"));
        }
    }

    protected int convertRowIndexToModelUsingRowSorter(int rowIndex) {
        if (SystemUtils.isAfterJava15() && this.myRowSorter != null) {
            try {
                if (this.myConverterMethod == null) {
                    this.myConverterMethod = this.table.getClass().getMethod("convertRowIndexToModel", Integer.TYPE);
                }
                Integer result = (Integer)this.myConverterMethod.invoke((Object)this.table, rowIndex);
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rowIndex;
    }

    protected Component prepareRenderer(TableCellRenderer renderer, int row, int column, boolean hasFocus) {
        Component component = this.table.prepareRenderer(renderer, row, column);
        if (component == null) {
            return null;
        }
        boolean editable = this.isCellDisplaydAsEditable(this.table, row, column) && this.table.isEnabled();
        boolean disabled = !this.table.isEnabled() || this.myDisabledTableModel != null && this.myDisabledTableModel.isCellDisabled(row, column);
        boolean paintEditRect = this.table.isCellEditable(row, column) && this.table.isEnabled() && ClientPropertyUtil.booleanValue(this.table, "OrangeTouch.paintEditRectOnTableCell", true);
        boolean disabledInDialog = false;
        if (component instanceof JComponent) {
            JComponent jComp = (JComponent)component;
            jComp.putClientProperty("Table.isSelected", this.table.isCellSelected(row, column));
            jComp.putClientProperty("Table.isEditable", paintEditRect);
            jComp.putClientProperty("Table.isLeftEnd", this.myLeftMostColumn == column || !this.table.isCellSelected(row, column - 1));
            jComp.putClientProperty("Table.isRightEnd", column >= this.table.getColumnCount() - 1 || !this.table.isCellSelected(row, column + 1));
            jComp.putClientProperty("Table.isEvenRow", row % 2 == 0);
            jComp.putClientProperty("Table.isRollovered", ComponentUtils.isRolloveredCell(this.table, row, column));
            jComp.putClientProperty("Table.hasFocus", hasFocus);
            jComp.putClientProperty("Table.isEnabled", this.table.isEnabled());
            jComp.putClientProperty("OrangeTouch.isInLightContainer", this.table.getClientProperty("OrangeTouch.isInLightContainer"));
            disabledInDialog = !this.table.isEnabled() && NetUtils.isInDialog(this.table);
        }
        this.setRendererBackground(row, column, hasFocus, component, editable, disabled);
        this.setRendererForeground(row, column, component, editable, disabled, paintEditRect);
        component.setEnabled(!disabled);
        if (disabledInDialog && component.getBackground() instanceof UIResource) {
            component.setBackground(theDisabledDialogBackground);
        }
        return component;
    }

    protected void setRendererForeground(int row, int column, Component component, boolean editable, boolean disabled, boolean paintEditRect) {
        Color cellForeground = component.getForeground();
        if (cellForeground == null || cellForeground instanceof UIResource) {
            cellForeground = !this.table.isCellSelected(row, column) ? (editable ? NetLookAndFeel.getControlInfo() : (disabled ? theDisabledForeground : theUneditableForeground)) : (editable && paintEditRect ? theUneditableForeground : this.table.getSelectionForeground());
            component.setForeground(cellForeground);
        }
    }

    protected void setRendererBackground(int row, int column, boolean hasFocus, Component component, boolean editable, boolean disabled) {
        Color cellBackground = component.getBackground();
        if (cellBackground == null || cellBackground instanceof UIResource) {
            boolean paintRollovered;
            boolean alternate = this.isAlternate();
            boolean bl = paintRollovered = ComponentUtils.isRolloveredCell(this.table, row, column) || this.table.getRowSelectionAllowed() && !this.table.getCellSelectionEnabled() && ComponentUtils.isRolloveredRow(this.table, row);
            cellBackground = !this.table.isCellSelected(row, column) ? (!alternate ? (this.myReadOnly ? theUnEditableRowBackground2 : (paintRollovered ? UIManager.getColor("Table.evenHoverBackground") : NetLookAndFeel.getWhite())) : (disabled ? theUnEditableRowBackground2 : (row % 2 == 0 ? (paintRollovered ? UIManager.getColor("Table.evenHoverBackground") : theUnEditableRowBackground1) : (paintRollovered ? UIManager.getColor("Table.oddHoverBackground") : theUnEditableRowBackground2)))) : (hasFocus && editable && this.table.getColumnCount() > 1 && !this.myReadOnly ? theSelectedAndFocusedCellBackground : this.table.getSelectionBackground());
            component.setBackground(cellBackground);
        }
    }

    protected boolean isAlternate() {
        Object property = this.table.getClientProperty("OrangeTouch.alternate");
        return property == null || Boolean.TRUE.equals(property);
    }

    protected boolean isCellDisplaydAsEditable(JTable jTable, int row, int column) {
        return jTable.isCellEditable(row, column);
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        String highlightedText = (String)this.table.getClientProperty("OrangeTouch.highlightText");
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        int row = rMin;
        while (row <= rMax) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, highlightedText, row, draggedColumnIndex);
            if (this.table.getShowHorizontalLines()) {
                g.setColor(this.table.getGridColor());
                Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
                rcr.x += distance;
                int x1 = rcr.x;
                int y1 = rcr.y;
                int x2 = x1 + rcr.width - 1;
                int y2 = y1 + rcr.height - 1;
                g.drawLine(x1, y2, x2, y2);
            }
            ++row;
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    private void singleHighlight(JLabel label, TableHighlight singleHighlight) {
        NetUtils.addHighlight(label, singleHighlight.getIndex(), singleHighlight.getIndex() + singleHighlight.getText().length(), NSNColors.getPurple());
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
            checkBox.putClientProperty("JComponent.sizeVariant", "small");
            checkBox.setFocusPainted(false);
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.putClientProperty("JComponent.sizeVariant", "small");
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean editable = table.isCellEditable(row, column) && table.isEnabled();
            this.setEnabled(editable);
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            this.getModel().setRollover(ComponentUtils.isRolloveredCell(table, row, column));
            this.getModel().setEnabled(editable);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    public class BorderHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (NetTableUI.this.table == null) {
                return;
            }
            if ("ancestor".equals(evt.getPropertyName())) {
                Point point;
                Component newParent = (Component)evt.getNewValue();
                if (newParent instanceof JViewport && newParent.getParent() instanceof JScrollPane) {
                    LookAndFeel.uninstallBorder(NetTableUI.this.table);
                    if (NetTableUI.this.table.getTableHeader() != null) {
                        LookAndFeel.uninstallBorder(NetTableUI.this.table.getTableHeader());
                    }
                } else {
                    LookAndFeel.installBorder(NetTableUI.this.table, "Table.border");
                    if (NetTableUI.this.table.getTableHeader() != null) {
                        LookAndFeel.installBorder(NetTableUI.this.table.getTableHeader(), "Table.border");
                    }
                }
                if (evt.getNewValue() == null && NetTableUI.this.table != null && (point = (Point)NetTableUI.this.table.getClientProperty("BlueTouch.rolloveredCell")) != null) {
                    point.move(-1, -1);
                }
            }
            if ("rowSorter".equals(evt.getPropertyName())) {
                if (evt.getNewValue() != null) {
                    NetTableUI.this.table.putClientProperty("OrangeTouch.tableSortableLook", evt.getNewValue() != null);
                    NetTableUI.this.myRowSorter = evt.getNewValue();
                    NetTableUI.this.myConverterMethod = null;
                }
            } else if ("OrangeTouch.headerGroups".equals(evt.getPropertyName())) {
                NetTableUI.this.table.revalidate();
                NetTableUI.this.table.repaint();
            } else if ("JComponent.sizeVariant".equals(evt.getPropertyName())) {
                NetTableUI.this.installRowHeight();
                NetTableUI.this.table.revalidate();
                NetTableUI.this.table.repaint();
            } else if ("OrangeTouch.alternate".equals(evt.getPropertyName()) || "showHorizontalLines".equals(evt.getPropertyName())) {
                NetTableUI.this.setInterCellSpacing();
                NetTableUI.this.table.revalidate();
                NetTableUI.this.table.repaint();
            } else if ("enabled".equals(evt.getPropertyName())) {
                if (NetTableUI.this.table.getParent() != null && NetTableUI.this.table.getParent().getParent() instanceof JScrollPane) {
                    NetTableUI.this.table.getParent().getParent().repaint();
                }
            } else if ("selectionModel".equals(evt.getPropertyName())) {
                Object newValue;
                Object oldValue = evt.getOldValue();
                if (oldValue instanceof ListSelectionModel) {
                    ((ListSelectionModel)oldValue).removeListSelectionListener(NetTableUI.this.mySelectionHandler);
                }
                if ((newValue = evt.getNewValue()) instanceof ListSelectionModel) {
                    ((ListSelectionModel)newValue).addListSelectionListener(NetTableUI.this.mySelectionHandler);
                }
            }
        }
    }

    static class DateRenderer
    extends PTableCellRenderer.UIResource {
        DateFormat formatter;

        DateRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat myFormatter;

        DoubleRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (this.myFormatter == null) {
                this.myFormatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.myFormatter.format(value));
        }
    }

    public class EditorBoundsHandler
    extends ContainerAdapter {
        @Override
        public void componentAdded(ContainerEvent e) {
            JTextField textField;
            Document doc;
            if (NetTableUI.this.table == null) {
                return;
            }
            Component editorComp = NetTableUI.this.table.getEditorComponent();
            Insets insets = NetTableUI.this.table.getInsets();
            if (editorComp instanceof JComponent) {
                ((JComponent)editorComp).putClientProperty("JComponent.sizeVariant", "small");
            }
            if (editorComp instanceof JTextField && ((doc = (textField = (JTextField)editorComp).getDocument()) instanceof IntegerDocument || doc instanceof LongDocument || doc instanceof DecimalDocument)) {
                textField.setHorizontalAlignment(4);
            }
            if (editorComp == null || editorComp != e.getChild() || insets == null || insets.left <= 0) {
                return;
            }
            Rectangle bounds = editorComp.getBounds();
            if (bounds.x < insets.left) {
                bounds.x += insets.left;
                bounds.width -= insets.left;
                editorComp.setBounds(bounds);
            }
        }
    }

    private class EnterAction
    extends AbstractAction {
        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NetTableUI.this.table == null) {
                return;
            }
            if (NetTableUI.this.table.isEditing()) {
                NetTableUI.this.table.getCellEditor().stopCellEditing();
            } else {
                JRootPane root = NetTableUI.this.table.getRootPane();
                if (root != null) {
                    Action action;
                    Object obj;
                    InputMap im = root.getInputMap(2);
                    ActionMap am = root.getActionMap();
                    if (im != null && am != null && (obj = im.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = am.get(obj)) != null) {
                        action.actionPerformed(new ActionEvent(root, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                    }
                }
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            Rectangle firstCell;
            int leadRowIndex = NetTableUI.this.table.getSelectionModel().getLeadSelectionIndex();
            int leadColumnIndex = NetTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if ((leadRowIndex < 0 || leadColumnIndex < 0) && (firstCell = NetTableUI.this.table.getCellRect(0, 0, true)) != null) {
                NetTableUI.this.table.repaint(firstCell);
            }
            if (NetTableUI.this.table.getRowCount() <= 0) {
                NetTableUI.this.table.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusGained(e);
        }
    }

    static class GenericEditor
    extends PDefaultCellEditor {
        private Class<?>[] argTypes = new Class[]{String.class};
        private Constructor<?> myConstructor;
        Object myValue;

        public GenericEditor() {
            super(new JTextField());
            this.getComponent().setName("Table.editor");
        }

        @Override
        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            if ("".equals(s)) {
                if (this.myConstructor.getDeclaringClass() == String.class) {
                    this.myValue = s;
                }
                super.stopCellEditing();
            }
            try {
                this.myValue = this.myConstructor.newInstance(s);
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setForeground(UIManager.getColor("TextField.invalidForeground"));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myValue = null;
            ((JComponent)this.getComponent()).setForeground(UIManager.getColor("TextField.foreground"));
            ((JComponent)this.getComponent()).setBorder(TEXTFIELD_BORDER);
            try {
                Class<Object> type = table.getColumnClass(column);
                if (type == Object.class) {
                    type = String.class;
                }
                this.myConstructor = type.getConstructor(this.argTypes);
            }
            catch (Exception e) {
                return null;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    static class IconRenderer
    extends PTableCellRenderer.UIResource {
        IconRenderer() {
        }

        @Override
        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Rectangle firstCell = NetTableUI.this.table.getCellRect(0, 0, true);
            if (firstCell != null) {
                NetTableUI.this.table.repaint(firstCell);
            }
        }
    }

    static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    static class NumberRenderer
    extends PTableCellRenderer.UIResource {
        public NumberRenderer() {
            super(4);
        }
    }

    public class RolloverHandler
    extends MouseInputAdapter {
        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Point point = (Point)NetTableUI.this.table.getClientProperty("BlueTouch.rolloveredCell");
            Point oldPoint = (Point)point.clone();
            point.move(-1, -1);
            int oldRow = NetTableUI.this.table.rowAtPoint(oldPoint);
            int oldColumn = NetTableUI.this.table.columnAtPoint(oldPoint);
            Rectangle oldRowRect = NetTableUI.this.table.getCellRect(oldRow, oldColumn, true);
            oldRowRect.setFrame(0.0, oldRowRect.getY(), NetTableUI.this.table.getWidth(), oldRowRect.getHeight());
            NetTableUI.this.table.repaint(oldRowRect);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point = (Point)NetTableUI.this.table.getClientProperty("BlueTouch.rolloveredCell");
            int oldRow = NetTableUI.this.table.rowAtPoint(point);
            int oldColumn = NetTableUI.this.table.columnAtPoint(point);
            Point newPoint = e.getPoint();
            int row = NetTableUI.this.table.rowAtPoint(newPoint);
            int column = NetTableUI.this.table.columnAtPoint(newPoint);
            if (row >= 0 && column >= 0) {
                if (NetTableUI.this.table.isCellEditable(row, column) && !Boolean.FALSE.equals(NetTableUI.this.table.getClientProperty("OrangeTouch.paintEditRectOnTableCell"))) {
                    NetUtils.setActiveCursor(NetTableUI.this.table);
                } else {
                    NetUtils.setInactiveCursor(NetTableUI.this.table);
                }
            }
            point.move((int)newPoint.getX(), (int)newPoint.getY());
            Rectangle oldRowRect = NetTableUI.this.table.getCellRect(oldRow, oldColumn, true);
            oldRowRect.setFrame(0.0, oldRowRect.getY(), NetTableUI.this.table.getWidth(), oldRowRect.getHeight());
            NetTableUI.this.table.repaint(oldRowRect);
            Rectangle newRowRect = NetTableUI.this.table.getCellRect(row, column, true);
            newRowRect.setFrame(0.0, newRowRect.getY(), NetTableUI.this.table.getWidth(), newRowRect.getHeight());
            NetTableUI.this.table.repaint(newRowRect);
        }
    }
}

