/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.laf;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetMultiLineLabelUI;
import com.nokia.laf.painters.BackgroundPainter;
import com.nokia.laf.text.NetBasicCaret;
import com.nokia.laf.text.NetTextComponentHandler;
import com.nokia.laf.text.ReadOnlyKeymap;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.laf.util.ReadOnlyHandler;
import com.nokia.widgets.labels.PMultiLineLabel;
import com.nokia.widgets.text.status.ModifiedStatusHandler;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class NetTextAreaUI
extends BasicTextAreaUI {
    protected NetTextComponentHandler myHandler;
    private ModifiedStatusHandler myModifiedValueHandler;

    public static ComponentUI createUI(JComponent comp) {
        if (comp instanceof PMultiLineLabel) {
            return NetMultiLineLabelUI.createUI(comp);
        }
        return new NetTextAreaUI();
    }

    @Override
    protected Caret createCaret() {
        return new NetBasicCaret.UIResource();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        NetUtils.installDefaultPopupMenu(this.getComponent());
        if (this.getComponent() != null) {
            this.myModifiedValueHandler = ModifiedStatusHandler.create(this.getComponent());
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.getComponent().getComponentPopupMenu() instanceof UIResource) {
            this.getComponent().setComponentPopupMenu(null);
        }
        if (this.myModifiedValueHandler != null) {
            this.myModifiedValueHandler.uninstallFrom(this.getComponent());
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.myHandler = new NetTextComponentHandler(this.getPropertyPrefix(), this.getComponent());
        ReadOnlyHandler.getInstance().installTo(this.getComponent());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.myHandler.uninstallFrom(this.getComponent());
        ReadOnlyHandler.getInstance().uninstallFrom(this.getComponent());
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        NetUtils.installReadOnlyFocusInputMap(this.getComponent());
    }

    @Override
    protected Keymap createKeymap() {
        Keymap keyMap = super.createKeymap();
        if (ComponentUtils.isReadOnly(this.getComponent())) {
            keyMap = new ReadOnlyKeymap(keyMap);
        }
        return keyMap;
    }

    @Override
    protected void paintSafely(Graphics g) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        super.paintSafely(g);
        NetUtils.paintPrompt(g, this.getComponent());
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent comp = this.getComponent();
        Boolean isCellEditor = (Boolean)comp.getClientProperty("TextArea.isTableCellEditor");
        isCellEditor = isCellEditor != null ? isCellEditor : false;
        if (comp.getBackground() instanceof UIResource && !(comp.getParent() instanceof JViewport) && (!comp.isEnabled() || !comp.isEditable() && !isCellEditor.booleanValue() || ComponentUtils.isReadOnly(comp))) {
            GradientUtils.drawVerticalBackgroundGradient(comp, g);
        } else if (comp.getBackground() instanceof BackgroundPainter) {
            BackgroundPainter painter = (BackgroundPainter)((Object)comp.getBackground());
            painter.paintBackground(g, comp);
            painter.paintBorderContour(g, comp, comp.getWidth(), comp.getHeight());
        } else {
            g.setColor(comp.getBackground());
            g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
        }
    }
}

